/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.acp;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AcpTextRecord {
    protected static final int STRING_INDEX_ACP_INFO = 0;
    protected static final int STRING_INDEX_ACP_INFO_COMPANION = 1;
    protected static final int STRING_INDEX_NAME = 2;
    protected static final int STRING_INDEX_NAME_COMPANION = 3;
    protected static final String ACP_PROPERTY_ERROR = "errr";
    protected Map properties = new HashMap();
    protected Map companionProperties = new HashMap();

    public AcpTextRecord(byte[] byArray) throws UnsupportedEncodingException {
        this.setTextRecord(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextRecord(byte[] byArray) throws UnsupportedEncodingException {
        Map map = this.properties;
        synchronized (map) {
            this.properties.clear();
            Map map2 = this.companionProperties;
            synchronized (map2) {
                this.companionProperties.clear();
                this.parseTextRecord(byArray);
            }
        }
    }

    public String getPropertyString(String string) {
        return this.getPropertyString(this.properties, string);
    }

    public String getCompanionPropertyString(String string) {
        return this.getPropertyString(this.companionProperties, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPropertyString(Map map, String string) {
        Map map2 = map;
        synchronized (map2) {
            return (String)map.get(string);
        }
    }

    public int getPropertyInteger(String string, int n) throws NumberFormatException {
        return this.getPropertyInteger(this.properties, string, n);
    }

    public int getCompanionPropertyInteger(String string, int n) throws NumberFormatException {
        return this.getPropertyInteger(this.companionProperties, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPropertyInteger(Map map, String string, int n) throws NumberFormatException {
        Map map2 = map;
        synchronized (map2) {
            String string2 = this.getPropertyString(map, string);
            int n2 = string2 != null ? Integer.decode(string2) : n;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map properties() {
        Map map = this.properties;
        synchronized (map) {
            return Collections.unmodifiableMap(Collections.synchronizedMap(this.properties));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map companionProperties() {
        Map map = this.companionProperties;
        synchronized (map) {
            return Collections.unmodifiableMap(Collections.synchronizedMap(this.companionProperties));
        }
    }

    protected void parseTextRecord(byte[] byArray) throws UnsupportedEncodingException {
        byte by;
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; i += 1 + by) {
            boolean bl;
            by = byArray[i];
            if (by <= 0) continue;
            String string = new String(byArray, i + 1, (int)by, "UTF-8");
            switch (n) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            this.parseAcpEntry(string, n, bl);
            ++n;
        }
    }

    protected void parseAcpEntry(String string, int n, boolean bl) {
        Map map = n % 2 == 0 ? this.properties : this.companionProperties;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = string.indexOf(61, n2);
            if (n4 < 0) {
                if (string.equals(ACP_PROPERTY_ERROR)) break;
                throw new IllegalArgumentException("bad name/value pair...missing \"=\" separator");
            }
            String string2 = string.substring(n2, n4);
            if (string2.length() != 4) {
                throw new IllegalArgumentException("property code must be exactly 4 bytes (\"" + string2 + "\")");
            }
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer();
                for (n2 = n4 + 1; n2 < n3; ++n2) {
                    char c = string.charAt(n2);
                    if (c == ',') {
                        ++n2;
                        break;
                    }
                    if (c == '\\' && (c = string.charAt(++n2)) != '\\' && c != ',') {
                        throw new IllegalArgumentException("escape sequence for non-comma, non-backslash (\"\\" + String.valueOf(c) + "\")");
                    }
                    stringBuffer.append(c);
                }
                map.put(string2, stringBuffer.toString());
                continue;
            }
            map.put(string2, string.substring(n4 + 1, n3));
            break;
        }
    }
}

