/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.acp;

import java.io.UnsupportedEncodingException;

public class AcpPropertyCode {
    private static final int NONE = 0;
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int ACP_TEXT = 0;
    private static final int ACP_BOOLEAN = 1;
    private static final int ACP_UINT32 = 2;
    private static final int ACP_CONFIGURATION = 3;
    private static final int ACP_INTERFACE = 4;
    private static final int ACP_MAC_ADDRESS = 5;
    private static final int ACP_SNMP_ACCESS_FLAGS = 6;
    private static final int ACP_SNMP_IP_LIST = 7;
    private static final int ACP_DEBUG_FLAGS = 8;
    private static final int ACP_SERVER_MODE = 9;
    private static final int ACP_INTERFACE_STATE = 10;
    private static final int ACP_XML_PLIST_DICTIONARY = 11;
    private static final int ACP_APPLE_PRODUCT_ID = 12;
    private static final int ACP_SMART_ACTIONS = 13;
    private static final int ACP_SMART_FLAGS = 14;
    private static final int ACP_UPS_FLAGS = 15;
    private static final int ACP_NO_DATA = 16;
    private static final int ACP_EFFECT_FLAGS = 17;
    public static final String CHARACTER_ENCODING = "US-ASCII";
    private final int code;
    private final int permissions;
    private final int type;
    public static AcpPropertyCode SYS_NAME = new AcpPropertyCode(1937329773, 3, 0);
    public static AcpPropertyCode SYS_DNS_NAME = new AcpPropertyCode(1937327182, 3, 0);
    public static AcpPropertyCode SYS_PRESENTATION_NAME = new AcpPropertyCode(1937330254, 3, 0);
    public static AcpPropertyCode SYS_PASSWORD_RW = new AcpPropertyCode(1937330263, 3, 0);
    public static AcpPropertyCode SYS_PASSWORD_RO = new AcpPropertyCode(1937330258, 1, 0);
    public static AcpPropertyCode SYS_GUEST_PASSWORD = new AcpPropertyCode(1937327952, 3, 0);
    public static AcpPropertyCode SYS_CONTACT = new AcpPropertyCode(1937326964, 3, 0);
    public static AcpPropertyCode SYS_LOCATION = new AcpPropertyCode(1937329263, 3, 0);
    public static AcpPropertyCode SYS_DESCRIPTION = new AcpPropertyCode(1937327219, 3, 0);
    public static AcpPropertyCode SYS_VERSION = new AcpPropertyCode(1937331827, 1, 0);
    public static AcpPropertyCode SYS_INFO = new AcpPropertyCode(1937328494, 1, 0);
    public static AcpPropertyCode SYS_FLAGS = new AcpPropertyCode(1937327724, 1, 0);
    public static AcpPropertyCode SYS_APPLE_PRODUCT_ID = new AcpPropertyCode(1937326416, 1, 12);
    public static AcpPropertyCode SYS_APPLE_SERIAL_NUMBER = new AcpPropertyCode(1937331022, 1, 0);
    public static AcpPropertyCode SYS_UP_TIME = new AcpPropertyCode(1937331540, 1, 2);
    public static AcpPropertyCode WAN_CONFIGURE_VIA = new AcpPropertyCode(2002862934, 3, 3);
    public static AcpPropertyCode WAN_INTERFACE = new AcpPropertyCode(2002864494, 3, 4);
    public static AcpPropertyCode WAN_DNS_1 = new AcpPropertyCode(2002863153, 3, 2);
    public static AcpPropertyCode WAN_DNS_2 = new AcpPropertyCode(2002863154, 3, 2);
    public static AcpPropertyCode WAN_DNS_3 = new AcpPropertyCode(2002863155, 3, 2);
    public static AcpPropertyCode WAN_CURRENT_DNS_1 = new AcpPropertyCode(2002862897, 3, 2);
    public static AcpPropertyCode WAN_CURRENT_DNS_2 = new AcpPropertyCode(2002862898, 3, 2);
    public static AcpPropertyCode WAN_CURRENT_DNS_3 = new AcpPropertyCode(2002862899, 3, 2);
    public static AcpPropertyCode WAN_IP_ADDRESS = new AcpPropertyCode(2002864464, 3, 2);
    public static AcpPropertyCode WAN_SUBNET_MASK = new AcpPropertyCode(2002867021, 3, 2);
    public static AcpPropertyCode WAN_ROUTER_ADDRESS = new AcpPropertyCode(2002866753, 3, 2);
    public static AcpPropertyCode WAN_DHCP_CLIENT_ID = new AcpPropertyCode(2002863171, 1, 0);
    public static AcpPropertyCode WAN_DHCP_SERVER = new AcpPropertyCode(2002863187, 3, 1);
    public static AcpPropertyCode WAN_MAC_ADDRESS = new AcpPropertyCode(2002865473, 1, 5);
    public static AcpPropertyCode WAN_DOMAIN_NAME = new AcpPropertyCode(2002863182, 3, 0);
    public static AcpPropertyCode LAN_CONFIGURE_VIA = new AcpPropertyCode(1818313558, 3, 3);
    public static AcpPropertyCode LAN_IP_ADDRESS = new AcpPropertyCode(1818315088, 3, 2);
    public static AcpPropertyCode LAN_SUBNET_MASK = new AcpPropertyCode(1818317645, 3, 2);
    public static AcpPropertyCode LAN_ROUTER_ADDRESS = new AcpPropertyCode(1818317377, 3, 2);
    public static AcpPropertyCode LAN_DHCP_CLIENT_ID = new AcpPropertyCode(1818313795, 3, 0);
    public static AcpPropertyCode LAN_DHCP_SERVER = new AcpPropertyCode(1818313811, 3, 1);
    public static AcpPropertyCode LAN_NAT = new AcpPropertyCode(1818316353, 3, 1);
    public static AcpPropertyCode LAN_MAC_ADDRESS = new AcpPropertyCode(1818316097, 1, 5);
    public static AcpPropertyCode LAN_INTERFACE_STATE = new AcpPropertyCode(1818315091, 1, 10);
    public static AcpPropertyCode DRIVE_CACHE_FLAGS = new AcpPropertyCode(1685209928, 3, 2);
    public static AcpPropertyCode NTP_CONFIG = new AcpPropertyCode(1853124675, 3, 0);
    public static AcpPropertyCode SMTP_SERVER = new AcpPropertyCode(1936553072, 3, 0);
    public static AcpPropertyCode SYS_LOG_CONFIG = new AcpPropertyCode(1936484163, 3, 0);
    public static AcpPropertyCode SNMP_ACCESS_FLAGS = new AcpPropertyCode(1936605510, 3, 6);
    public static AcpPropertyCode SNMP_ACCESS_IP_LIST_WAN = new AcpPropertyCode(1936608343, 3, 7);
    public static AcpPropertyCode SNMP_ACCESS_IP_LIST_LAN = new AcpPropertyCode(1936608332, 3, 7);
    public static AcpPropertyCode SNMP_READ_PASSWORD_WAN = new AcpPropertyCode(1936609879, 3, 0);
    public static AcpPropertyCode SNMP_WRITE_PASSWORD_WAN = new AcpPropertyCode(1936611159, 3, 0);
    public static AcpPropertyCode SNMP_READ_PASSWORD_LAN = new AcpPropertyCode(1936609868, 3, 0);
    public static AcpPropertyCode SNMP_WRITE_PASSWORD_LAN = new AcpPropertyCode(1936611148, 3, 0);
    public static AcpPropertyCode SMART_ACTIONS = new AcpPropertyCode(1936880705, 3, 13);
    public static AcpPropertyCode SMART_FLAGS = new AcpPropertyCode(1936880710, 3, 14);
    public static AcpPropertyCode UPS_FLAGS = new AcpPropertyCode(1970303814, 3, 15);
    public static AcpPropertyCode NVRAM_VERSION = new AcpPropertyCode(1853249139, 1, 2);
    public static AcpPropertyCode DEBUG_FLAGS = new AcpPropertyCode(1684174183, 3, 8);
    public static AcpPropertyCode CONFIGURATION_VERSION = new AcpPropertyCode(1668703602, 1, 2);
    public static AcpPropertyCode SERVER_MODE = new AcpPropertyCode(1937132900, 3, 9);
    public static AcpPropertyCode EMAIL_NOTIFICATION = new AcpPropertyCode(1701662319, 3, 11);
    public static AcpPropertyCode EFFECT_FLAGS = new AcpPropertyCode(0x65666646, 3, 17);
    public static AcpPropertyCode FEATURES = new AcpPropertyCode(1717907505, 1, 2);
    public static AcpPropertyCode ACTION_FLUSH_NVRAM = new AcpPropertyCode(1633896014, 2, 16);

    protected AcpPropertyCode(int n, int n2, int n3) {
        this.code = n;
        this.permissions = n2;
        this.type = n3;
    }

    public int code() {
        return this.code;
    }

    public String fourCharCode() {
        return AcpPropertyCode.toFourCharCode(this.code);
    }

    public static String toFourCharCode(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        String string = "";
        try {
            string = new String(byArray, CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException);
        }
        return string;
    }

    public String toString() {
        return AcpPropertyCode.toFourCharCode(this.code);
    }

    public boolean isWriteable() {
        return (this.permissions & 2) != 0;
    }

    private static class Codes {
        public static final int NULL = 0;
        public static final int ALL = -1;
        public static final int SYS_NAME = 1937329773;
        public static final int SYS_DNS_NAME = 1937327182;
        public static final int SYS_PRESENTATION_NAME = 1937330254;
        public static final int SYS_PASSWORD_RW = 1937330263;
        public static final int SYS_PASSWORD_RO = 1937330258;
        public static final int SYS_GUEST_PASSWORD = 1937327952;
        public static final int SYS_CONTACT = 1937326964;
        public static final int SYS_LOCATION = 1937329263;
        public static final int SYS_DESCRIPTION = 1937327219;
        public static final int SYS_VERSION = 1937331827;
        public static final int SYS_INFO = 1937328494;
        public static final int SYS_FLAGS = 1937327724;
        public static final int SYS_APPLE_PRODUCT_ID = 1937326416;
        public static final int SYS_APPLE_SERIAL_NUMBER = 1937331022;
        public static final int SYS_UP_TIME = 1937331540;
        public static final int PATCH_FORCED_RELOAD = 1885423186;
        public static final int RADIO_NAME = 1918979693;
        public static final int RADIO_CLOSED = 1918976876;
        public static final int RADIO_WEP_MODE = 1918981965;
        public static final int RADIO_WEP = 1918981957;
        public static final int RADIO_ROBUST = 1918980719;
        public static final int RADIO_CHANNEL = 1918976872;
        public static final int RADIO_DENSITY = 1918977125;
        public static final int RADIO_MULTICAST = 1918979445;
        public static final int RADIO_LEGAL_CHANNELS = 1918979139;
        public static final int RADIO_12_8_CAPABLE = 1918972227;
        public static final int RADIO_VERSION = 1918981747;
        public static final int RADIO_MAC_ADDRESS = 1918979393;
        public static final int RADIO_DHCP_SERVER = 1918977107;
        public static final int RADIO_NAT = 1918979649;
        public static final int RADIO_WAN_BRIDGE = 1918981954;
        public static final int WIRELESS_BRIDGE_MODE = 2002931055;
        public static final int WIRELESS_BRIDGE_NETWORK_NAME = 2002931278;
        public static final int WIRELESS_BRIDGE_NETWORK_PASSWORD = 2002931280;
        public static final int MODEM_PHONE_NUMBER = 1836011598;
        public static final int MODEM_ALTERNATE_PHONE_NUMBER = 1836007760;
        public static final int MODEM_USERNAME = 1836012878;
        public static final int MODEM_PASSWORD = 1836011607;
        public static final int MODEM_INIT_STRING = 1836009811;
        public static final int MODEM_LOGIN_SCRIPT = 1836010579;
        public static final int MODEM_LOGIN_SCRIPT_INDEX = 1836010569;
        public static final int MODEM_IDLE_DISCONNECT = 1836009796;
        public static final int MODEM_IGNORE_DIAL_TONE = 1836008532;
        public static final int MODEM_USE_PULSE_DIAL = 1836011588;
        public static final int MODEM_AUTO_DIAL = 1836007748;
        public static final int MODEM_COUNTRY_CODE = 1836008259;
        public static final int MODEM_COUNTRY_CODE_READ_ONLY = 1836008274;
        public static final int MODEM_COUNTRY_INDEX = 1836008265;
        public static final int MODEM_INDEX = 7171917;
        public static final int MODEM_APPLE_FW_VERSION = 1836013171;
        public static final int MODEM_PROTOCOL = 1836010832;
        public static final int MODEM_FLAGS = 1836010822;
        public static final int MODEM_VENDOR_FW_VERSION = 1836009046;
        public static final int REMOTE_DIAL_IN_FLAGS = 1885619820;
        public static final int REMOTE_DIAL_IN_USERNAME = 1885623630;
        public static final int REMOTE_DIAL_IN_PASSWORD = 1885622359;
        public static final int REMOTE_DIAL_IN_ANSWER_ON_RING_COUNT = 1885618514;
        public static final int REMOTE_DIAL_IN_IDLE_DISCONNECT_SECONDS = 1885620548;
        public static final int REMOTE_DIAL_IN_MAX_CONNECTION_SECONDS = 1885621571;
        public static final int PPPOE_SERVICE_NAME = 1885688654;
        public static final int PPPOE_USER_NAME = 1885689166;
        public static final int PPPOE_PASSWORD = 1885687895;
        public static final int PPPOE_STAY_CONNECTED = 1885688643;
        public static final int PPPOE_AUTO_CONNECT = 1885684035;
        public static final int PPPOE_IDLE_DISCONNECT = 1885686084;
        public static final int PPPOE_AOL = 1885684047;
        public static final int WAN_CONFIGURE_VIA = 2002862934;
        public static final int WAN_INTERFACE = 2002864494;
        public static final int WAN_DNS_1 = 2002863153;
        public static final int WAN_DNS_2 = 2002863154;
        public static final int WAN_DNS_3 = 2002863155;
        public static final int WAN_CURRENT_DNS_1 = 2002862897;
        public static final int WAN_CURRENT_DNS_2 = 2002862898;
        public static final int WAN_CURRENT_DNS_3 = 2002862899;
        public static final int WAN_IP_ADDRESS = 2002864464;
        public static final int WAN_SUBNET_MASK = 2002867021;
        public static final int WAN_ROUTER_ADDRESS = 2002866753;
        public static final int WAN_DHCP_CLIENT_ID = 2002863171;
        public static final int WAN_DHCP_SERVER = 2002863187;
        public static final int WAN_MAC_ADDRESS = 2002865473;
        public static final int WAN_DOMAIN_NAME = 2002863182;
        public static final int WAN_INTERFACE_STATE = 2002864467;
        public static final int LAN_CONFIGURE_VIA = 1818313558;
        public static final int LAN_IP_ADDRESS = 1818315088;
        public static final int LAN_SUBNET_MASK = 1818317645;
        public static final int LAN_ROUTER_ADDRESS = 1818317377;
        public static final int LAN_DHCP_CLIENT_ID = 1818313795;
        public static final int LAN_DHCP_SERVER = 1818313811;
        public static final int LAN_NAT = 1818316353;
        public static final int LAN_MAC_ADDRESS = 1818316097;
        public static final int LAN_INTERFACE_STATE = 1818315091;
        public static final int DHCP_FLAGS = 1684555372;
        public static final int DHCP_BEGIN = 1684554343;
        public static final int DHCP_END = 1684555118;
        public static final int DHCP_SUBNET = 1684558670;
        public static final int DHCP_ROUTER = 1684558447;
        public static final int DHCP_LEASE = 1684556901;
        public static final int DHCP_MSG_STRING = 1684557159;
        public static final int DHCP_OPT95_STRING = 1684551989;
        public static final int DEFAULT_DHCP_SERVER_SUBNET = 1684554835;
        public static final int DEFAULT_DHCP_SERVER_BEGIN = 1684554818;
        public static final int DEFAULT_DHCP_SERVER_END = 1684554821;
        public static final int DEFAULT_DHCP_SERVER_LEASE = 1684554828;
        public static final int DRIVE_CACHE_FLAGS = 1685209928;
        public static final int NAT_FLAGS = 1851868780;
        public static final int NAT_BEGIN = 1851867751;
        public static final int NAT_END = 1851868526;
        public static final int NAT_SUBNET = 1851872078;
        public static final int NAT_ROUTER = 1851871855;
        public static final int NAT_AOL_FLAGS = 1851867462;
        public static final int PORT_MAPPING_PUBLIC_IP = 1886212169;
        public static final int PORT_MAPPING_PUBLIC_SUBNET = 1886212179;
        public static final int PORT_MAPPING_PUBLIC_ROUTER = 1886212178;
        public static final int PORT_MAPPING_TABLE = 1886213217;
        public static final int ACCESS_CONTROL_ENABLE = 1633895790;
        public static final int ACCESS_CONTROL_TABLE = 1633899617;
        public static final int RADIUS_FLAGS_1 = 1918977644;
        public static final int RADIUS_SERVER_IP_1 = 1918978353;
        public static final int RADIUS_TIMER_1 = 1918981229;
        public static final int RADIUS_AUTHENTICATION_PORT_1 = 1918976373;
        public static final int RADIUS_ACCOUNTING_PORT_1 = 1918976355;
        public static final int RADIUS_SECRET_1 = 1918980965;
        public static final int RADIUS_RETRY_COUNT_1 = 1918980709;
        public static final int RADIUS_FLAGS_2 = 1918977586;
        public static final int RADIUS_SERVER_IP_2 = 1918978354;
        public static final int RADIUS_TIMER_2 = 1918981170;
        public static final int RADIUS_AUTHENTICATION_PORT_2 = 1918981426;
        public static final int RADIUS_ACCOUNTING_PORT_2 = 1918976818;
        public static final int RADIUS_SECRET_2 = 1918980914;
        public static final int RADIUS_RETRY_COUNT_2 = 1918980658;
        public static final int RADIUS_CISCO = 1918976873;
        public static final int NTP_CONFIG = 1853124675;
        public static final int SMTP_SERVER = 1936553072;
        public static final int SYS_LOG_CONFIG = 1936484163;
        public static final int SNMP_ACCESS_FLAGS = 1936605510;
        public static final int SNMP_ACCESS_IP_LIST_WAN = 1936608343;
        public static final int SNMP_ACCESS_IP_LIST_LAN = 1936608332;
        public static final int SNMP_READ_PASSWORD_WAN = 1936609879;
        public static final int SNMP_WRITE_PASSWORD_WAN = 1936611159;
        public static final int SNMP_READ_PASSWORD_LAN = 1936609868;
        public static final int SNMP_WRITE_PASSWORD_LAN = 1936611148;
        public static final int SMART_ACTIONS = 1936880705;
        public static final int SMART_FLAGS = 1936880710;
        public static final int UPS_FLAGS = 1970303814;
        public static final int NVRAM_VERSION = 1853249139;
        public static final int DEBUG_FLAGS = 1684174183;
        public static final int CONFIGURATION_VERSION = 1668703602;
        public static final int SERVER_MODE = 1937132900;
        public static final int EMAIL_NOTIFICATION = 1701662319;
        public static final int EFFECT_FLAGS = 0x65666646;
        public static final int ACTION_REBOOT = 1633899074;
        public static final int ACTION_REBOOT_IF_NEEDED = 1633899081;
        public static final int ACTION_PPP_CONNECT = 1633898563;
        public static final int ACTION_PPP_DISCONNECT = 1633895492;
        public static final int ACTION_DIAL_IN_DISCONNECT = 1633898564;
        public static final int ACTION_PPP_GET_STATUS = 1633898567;
        public static final int ACTION_DIAL_IN_GET_STATUS = 1633895507;
        public static final int ACTION_FLUSH_NVRAM = 1633896014;
        public static final int ACTION_RESET_NVRAM = 1633899086;
        public static final int FEATURES = 1717907505;

        private Codes() {
        }
    }
}

