/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketUtilities {
    public static final boolean DEBUG = false;
    public static final boolean JAVA_HAS_TIMEOUT = System.getProperty("java.version").compareTo("1.4") >= 0;

    public static Socket connect(String string, int n, int n2) throws InterruptedIOException, IOException, InterruptedException, Exception {
        return SocketUtilities.connect(InetAddress.getByName(string), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Socket connect(InetAddress inetAddress, int n, int n2) throws InterruptedIOException, IOException, InterruptedException, Exception {
        Socket socket;
        if (JAVA_HAS_TIMEOUT) {
            socket = new Socket();
            socket.connect(new InetSocketAddress(inetAddress, n), n2);
        } else {
            SocketThread socketThread;
            Object object;
            Object object2 = object = new Object();
            synchronized (object2) {
                socketThread = new SocketThread(object, inetAddress, n);
                socketThread.start();
                object.wait(n2);
            }
            object2 = socketThread.getException();
            if (object2 != null) {
                throw object2;
            }
            socket = socketThread.getSocket();
            if (socket == null) {
                throw new InterruptedIOException("Connection timeout after " + n2 + " milliseconds");
            }
        }
        return socket;
    }

    public static void main(String[] stringArray) {
    }

    static class SocketThread
    extends Thread {
        protected Object object;
        protected Socket socket = null;
        protected String host = null;
        protected InetAddress addr = null;
        protected int port;
        protected Exception exception = null;

        public SocketThread(Object object, String string, int n) {
            this.object = object;
            this.host = string;
            this.port = n;
        }

        public SocketThread(Object object, InetAddress inetAddress, int n) {
            this.object = object;
            this.addr = inetAddress;
            this.port = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.host != null) {
                    this.socket = new Socket(this.host, this.port);
                } else if (this.addr != null) {
                    this.socket = new Socket(this.addr, this.port);
                } else {
                    this.exception = new IllegalArgumentException("no host name or address specified");
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
            Object object = this.object;
            synchronized (object) {
                this.object.notify();
            }
        }

        public Socket getSocket() {
            return this.socket;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

