/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class TextPane
extends JTextPane {
    private static final String REGULAR = "regular";
    private int minimumLines = 0;

    TextPane() {
    }

    TextPane(String string) {
        this.setText(string);
    }

    TextPane(String string, int n) {
        this.setText(string);
        this.setMinimumLines(n);
    }

    public void setFont(Font font) {
        StyledDocument styledDocument = this.getStyledDocument();
        if (styledDocument != null) {
            if (styledDocument.getStyle(REGULAR) != null) {
                styledDocument.removeStyle(REGULAR);
            }
            Style style = StyleContext.getDefaultStyleContext().getStyle("default");
            StyleConstants.setFontFamily(style, font.getFamily());
            StyleConstants.setFontSize(style, font.getSize());
            StyleConstants.setBold(style, font.isBold());
            StyleConstants.setItalic(style, font.isItalic());
            styledDocument.addStyle(REGULAR, style);
            this.setText(this.getText());
        }
    }

    public void setText(String string) {
        try {
            StyledDocument styledDocument = this.getStyledDocument();
            styledDocument.remove(0, styledDocument.getLength());
            styledDocument.insertString(0, string, styledDocument.getStyle(REGULAR));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setMinimumLines(int n) {
        this.minimumLines = n;
    }

    public Dimension getMinimumSize() {
        Font font;
        StyledDocument styledDocument;
        Dimension dimension = super.getMinimumSize();
        if (this.minimumLines > 0 && (styledDocument = this.getStyledDocument()) != null && (font = styledDocument.getFont(styledDocument.getStyle(REGULAR))) != null) {
            dimension = new Dimension(dimension.width, this.getFontMetrics(font).getHeight() * this.minimumLines);
        }
        return dimension;
    }
}

