/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class HyperTextPane
extends JTextPane
implements MouseListener,
MouseMotionListener {
    static final int LINK_STYLE_NORMAL = 0;
    static final int LINK_STYLE_ENTERED = 1;
    static final int LINK_STYLE_ACTIVATED = 2;
    static final int LINK_STYLE_VISITED = 3;
    final Cursor NORMAL_CURSOR = Cursor.getDefaultCursor();
    final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    static final Color DEFAULT_LINK_COLOR = Color.blue;
    static final Color DEFAULT_ACTIVE_LINK_COLOR = Color.red;
    static final Color DEFAULT_VISITED_LINK_COLOR = DEFAULT_LINK_COLOR;
    protected DefaultStyledDocument document = new DefaultStyledDocument();
    protected List links = new ArrayList();
    protected EventListenerList listenerList = new EventListenerList();
    protected Link activeLink = null;
    protected Link previousLink = null;
    protected final SimpleAttributeSet normalLinkAttribs;
    protected final SimpleAttributeSet activeLinkAttribs;
    protected final SimpleAttributeSet visitedLinkAttribs;
    static /* synthetic */ Class class$javax$swing$event$HyperlinkListener;

    public HyperTextPane(String string) {
        this.setDocument(this.document);
        this.setBackground(null);
        this.setEditable(false);
        this.normalLinkAttribs = new SimpleAttributeSet();
        StyleConstants.setUnderline(this.normalLinkAttribs, true);
        StyleConstants.setForeground(this.normalLinkAttribs, DEFAULT_LINK_COLOR);
        this.activeLinkAttribs = new SimpleAttributeSet();
        StyleConstants.setUnderline(this.activeLinkAttribs, true);
        StyleConstants.setForeground(this.activeLinkAttribs, DEFAULT_ACTIVE_LINK_COLOR);
        this.visitedLinkAttribs = new SimpleAttributeSet();
        StyleConstants.setUnderline(this.visitedLinkAttribs, true);
        StyleConstants.setForeground(this.visitedLinkAttribs, DEFAULT_VISITED_LINK_COLOR);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        HyperTextPane hyperTextPane = this;
        synchronized (hyperTextPane) {
            this.links.clear();
        }
        super.setText(string);
        this.parseText(string);
    }

    public void addLink(String string, String string2) throws ParseException {
        this.addLink(string, 0, string2);
    }

    public void addLink(String string, int n, String string2) throws ParseException {
        int n2 = this.getText().indexOf(string, n);
        if (n2 == -1) {
            throw new ParseException("Text not found \"" + string + "\"", -1);
        }
        this.addLink(n2, string.length(), string2);
    }

    public synchronized void addLink(int n, int n2, String string) {
        if (this.getText() == null) {
            throw new IllegalArgumentException("No text inserted");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Illegal start (" + n + ")");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Illegal length (" + n2 + ")");
        }
        if (n + n2 > this.getText().length()) {
            throw new IllegalArgumentException("Illegal start (" + n + ") or length (" + n2 + ")");
        }
        Link link = new Link(n, n2, string);
        this.links.add(link);
        this.setLinkStyle(link, 0);
    }

    public synchronized void removeAllLinks() {
        Style style = this.document.getStyle("default");
        Iterator iterator = this.links.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            if (style == null) continue;
            this.document.setCharacterAttributes(link.start, link.length, style, true);
        }
        this.links.clear();
    }

    public synchronized void setLinkColor(Color color) {
        if (color == null) {
            throw new NullPointerException("color cannot be null");
        }
        StyleConstants.setForeground(this.normalLinkAttribs, color);
        if (this.links.size() != 0) {
            Iterator iterator = this.links.iterator();
            while (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                if (link == this.activeLink) continue;
                this.setLinkStyle(link, 0);
            }
        }
    }

    public synchronized void setActiveLinkColor(Color color) {
        if (color == null) {
            throw new NullPointerException("color cannot be null");
        }
        StyleConstants.setForeground(this.activeLinkAttribs, color);
        if (this.activeLink != null) {
            this.setLinkStyle(this.activeLink, 2);
        }
    }

    public synchronized void setVisitedLinkColor(Color color) {
        if (color == null) {
            throw new NullPointerException("color cannot be null");
        }
        StyleConstants.setForeground(this.visitedLinkAttribs, color);
        if (this.links.size() != 0) {
            Iterator iterator = this.links.iterator();
            while (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                if (link == this.activeLink) continue;
                this.setLinkStyle(link, 0);
            }
        }
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(class$javax$swing$event$HyperlinkListener == null ? (class$javax$swing$event$HyperlinkListener = HyperTextPane.class$("javax.swing.event.HyperlinkListener")) : class$javax$swing$event$HyperlinkListener, hyperlinkListener);
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(class$javax$swing$event$HyperlinkListener == null ? (class$javax$swing$event$HyperlinkListener = HyperTextPane.class$("javax.swing.event.HyperlinkListener")) : class$javax$swing$event$HyperlinkListener, hyperlinkListener);
    }

    protected void fireHyperlinkEvent(HyperlinkEvent.EventType eventType, Link link) {
        URL uRL = null;
        try {
            uRL = new URL(link.url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.fireHyperlinkEvent(new HyperlinkEvent(this, eventType, uRL, link.url));
    }

    protected void fireHyperlinkEvent(final HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent == null) {
            throw new NullPointerException("event cannot be null");
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            final HyperlinkListener hyperlinkListener = (HyperlinkListener)objectArray[i + 1];
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    hyperlinkListener.hyperlinkUpdate(hyperlinkEvent);
                }
            });
        }
    }

    protected void setLinkStyle(Link link, int n) {
        if (n == 0) {
            SimpleAttributeSet simpleAttributeSet = link.visited ? this.visitedLinkAttribs : this.normalLinkAttribs;
            this.document.setCharacterAttributes(link.start, link.length, simpleAttributeSet, false);
        } else if (n != 1) {
            if (n == 2) {
                this.document.setCharacterAttributes(link.start, link.length, this.activeLinkAttribs, false);
            } else if (n == 3) {
                this.document.setCharacterAttributes(link.start, link.length, this.visitedLinkAttribs, false);
            }
        }
    }

    protected void parseText(String string) {
        this.parseHyperlinks(string);
    }

    private synchronized void parseHyperlinks(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.indexOf("http://", n2);
            if (n3 == -1) {
                n3 = string.indexOf("HTTP://", n2);
            }
            if (n3 == -1) break;
            for (n2 = n3 + 7; n2 < n && (Character.isLetterOrDigit(string.charAt(n2)) || string.charAt(n2) == '.' || string.charAt(n2) == '/' || string.charAt(n2) == '@' || string.charAt(n2) == '-'); ++n2) {
            }
            if (n2 == n3) continue;
            int n4 = n2 - 1;
            if (string.charAt(n4) == '.' || string.charAt(n4) == '@' || string.charAt(n4) == '-') {
                --n4;
            }
            this.addLink(n3, n4 - n3 + 1, string.substring(n3, n4));
        }
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        Link link = null;
        if (this.links.size() != 0) {
            Point point = mouseEvent.getPoint();
            Iterator iterator = this.links.iterator();
            while (iterator.hasNext()) {
                Link link2 = (Link)iterator.next();
                if (!link2.contains(point)) continue;
                link = link2;
                break;
            }
        }
        if (this.activeLink != null && (link == null || link != this.activeLink)) {
            this.previousLink = this.activeLink;
            this.activeLink = null;
        }
    }

    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        Link link = null;
        if (this.links.size() != 0) {
            Point point = mouseEvent.getPoint();
            Iterator iterator = this.links.iterator();
            while (iterator.hasNext()) {
                Link link2 = (Link)iterator.next();
                if (!link2.contains(point)) continue;
                link = link2;
                break;
            }
        }
        if (link == null && this.activeLink != null) {
            this.setLinkStyle(this.activeLink, 0);
            this.setCursor(this.NORMAL_CURSOR);
            this.fireHyperlinkEvent(HyperlinkEvent.EventType.EXITED, this.activeLink);
            this.activeLink = null;
        } else if (link != this.activeLink) {
            if (this.activeLink != null) {
                this.setLinkStyle(this.activeLink, 0);
                this.fireHyperlinkEvent(HyperlinkEvent.EventType.EXITED, this.activeLink);
            }
            this.activeLink = link;
            this.setLinkStyle(this.activeLink, 1);
            this.setCursor(this.HAND_CURSOR);
            this.fireHyperlinkEvent(HyperlinkEvent.EventType.ENTERED, this.activeLink);
        }
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        if (this.activeLink != null) {
            this.setLinkStyle(this.activeLink, 2);
        }
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
        if (this.activeLink != null) {
            this.fireHyperlinkEvent(HyperlinkEvent.EventType.ACTIVATED, this.activeLink);
            this.activeLink.visited = true;
            this.setLinkStyle(this.activeLink, 0);
        } else if (this.previousLink != null) {
            this.setLinkStyle(this.previousLink, 0);
            this.previousLink = null;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Link {
        int start;
        int length;
        String url;
        boolean visited = false;
        Rectangle[] regions;

        public Link(int n, int n2, String string) {
            this.start = n;
            this.length = n2;
            this.url = string;
        }

        public boolean contains(Point point) {
            if (this.regions == null || this.regions.length == 0) {
                this.regions = this.calcRegions();
            }
            for (int i = 0; i < this.regions.length; ++i) {
                if (!this.regions[i].contains(point)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Link)) {
                return false;
            }
            Link link = (Link)object;
            return link.start == this.start && link.length == this.length;
        }

        public int hashCode() {
            int n = 13;
            n = 37 * n + this.start;
            n = 37 * n + this.length;
            return n;
        }

        private Rectangle[] calcRegions() {
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            Rectangle rectangle = null;
            double d = 0.0;
            for (int i = this.start; i <= this.start + this.length; ++i) {
                try {
                    Rectangle rectangle2 = HyperTextPane.this.modelToView(i);
                    if (rectangle2.getY() == d) {
                        rectangle.add(rectangle2);
                        continue;
                    }
                    if (rectangle != null) {
                        arrayList.add(rectangle);
                    }
                    rectangle = new Rectangle(rectangle2);
                    d = rectangle.getY();
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (rectangle != null) {
                arrayList.add(rectangle);
            }
            return arrayList.toArray(new Rectangle[0]);
        }
    }
}

