/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import com.apple.gui.AlternatingTable;
import com.apple.gui.PasswordField;
import com.apple.gui.RestrictedTextField;
import com.apple.gui.TextField;
import com.apple.gui.TextPane;
import com.apple.gui.menu.Menu;
import com.apple.gui.menu.MenuBar;
import com.apple.gui.menu.MenuItem;
import com.apple.util.Gestalt;
import com.apple.xsr.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.table.TableModel;

public class GUIFactory {
    public static final Font FONT_NORMAL = new JLabel().getFont();
    public static final Font FONT_NORMAL_BOLD = FONT_NORMAL.deriveFont(1);
    public static final Font FONT_SMALL = FONT_NORMAL.deriveFont(11.0f);
    public static final Font FONT_LABEL = FONT_NORMAL.deriveFont(10.0f);
    public static final Font FONT_TINY = FONT_NORMAL.deriveFont(9.0f);
    public static final Font FONT_BADGE = FONT_NORMAL.deriveFont(9.0f);
    public static final Font FONT_PRINT = new Font(Resources.getString("eventLog.print.fontFaceName"), 0, 9);
    public static final Border TEXT_FIELD_BORDER_FIELD = new JTextField().getBorder();
    public static final Border TEXT_FIELD_BORDER_LABEL = BorderFactory.createEmptyBorder(2, 5, 2, 0);

    public static JPanel newPanel() {
        return (JPanel)GUIFactory.configureComponentForPlatform(new JPanel());
    }

    public static JPanel newPanel(LayoutManager layoutManager) {
        return (JPanel)GUIFactory.configureComponentForPlatform(new JPanel(layoutManager));
    }

    public static JCheckBox newCheckBox() {
        return (JCheckBox)GUIFactory.configureComponentForPlatform(new JCheckBox());
    }

    public static JCheckBox newCheckBox(String string) {
        return (JCheckBox)GUIFactory.configureComponentForPlatform(new JCheckBox(string));
    }

    public static JCheckBox newCheckBox(String string, boolean bl) {
        return (JCheckBox)GUIFactory.configureComponentForPlatform(new JCheckBox(string, bl));
    }

    public static JRadioButton newRadioButton() {
        return (JRadioButton)GUIFactory.configureComponentForPlatform(new JRadioButton());
    }

    public static JRadioButton newRadioButton(String string) {
        return (JRadioButton)GUIFactory.configureComponentForPlatform(new JRadioButton(string));
    }

    public static JRadioButton newRadioButton(String string, boolean bl) {
        return (JRadioButton)GUIFactory.configureComponentForPlatform(new JRadioButton(string, bl));
    }

    public static JButton newButton() {
        return (JButton)GUIFactory.configureComponentForPlatform(new JButton());
    }

    public static JButton newButton(String string) {
        return (JButton)GUIFactory.configureComponentForPlatform(new JButton(string));
    }

    public static JButton newButton(ImageIcon imageIcon) {
        return (JButton)GUIFactory.configureComponentForPlatform(new JButton(imageIcon));
    }

    public static JComboBox newComboBox() {
        return (JComboBox)GUIFactory.configureComponentForPlatform(new JComboBox());
    }

    public static JTextField newTextField() {
        return new TextField();
    }

    public static JTextField newTextField(String string) {
        return new TextField(string);
    }

    public static JTextField newTextField(int n) {
        return new TextField(n);
    }

    public static JTextField newTextField(String string, int n) {
        return new TextField(string, n);
    }

    public static RestrictedTextField newRestrictedTextField() {
        return new RestrictedTextField();
    }

    public static RestrictedTextField newRestrictedTextField(String string) {
        return new RestrictedTextField(string);
    }

    public static RestrictedTextField newRestrictedTextField(int n) {
        return new RestrictedTextField(n);
    }

    public static RestrictedTextField newRestrictedTextField(String string, int n) {
        return new RestrictedTextField(string, n);
    }

    public static JPasswordField newPasswordField() {
        return new PasswordField();
    }

    public static JPasswordField newPasswordField(int n) {
        return new PasswordField(n);
    }

    public static JTextPane newTextPane() {
        return new TextPane();
    }

    public static JTextPane newTextPane(String string) {
        return new TextPane(string);
    }

    public static JTextPane newTextPane(String string, int n) {
        return new TextPane(string, n);
    }

    public static JTable newTable() {
        return (JTable)GUIFactory.configureComponentForPlatform(new AlternatingTable());
    }

    public static JTable newTable(TableModel tableModel) {
        return (JTable)GUIFactory.configureComponentForPlatform(new AlternatingTable(tableModel));
    }

    public static JButton newOKButton() {
        return GUIFactory.newButton(Resources.getString("ok"));
    }

    public static JButton newCancelButton() {
        return GUIFactory.newButton(Resources.getString("cancel"));
    }

    public static JButton newContinueButton() {
        return GUIFactory.newButton(Resources.getString("continue"));
    }

    public static JButton newGoBackButton() {
        return GUIFactory.newButton(Resources.getString("goBack"));
    }

    public static JMenuBar newMenuBar() {
        return new MenuBar();
    }

    public static JMenu newMenu() {
        return new Menu();
    }

    public static JMenuItem newMenuItem() {
        return new MenuItem();
    }

    public static JTextField configureTextFieldAsLabel(JTextField jTextField) {
        if (jTextField != null) {
            jTextField.setEditable(false);
            jTextField.setOpaque(false);
            jTextField.setBorder(TEXT_FIELD_BORDER_LABEL);
        }
        return jTextField;
    }

    public static JTextField configureTextFieldAsField(JTextField jTextField) {
        if (jTextField != null) {
            jTextField.setEditable(true);
            jTextField.setOpaque(true);
            jTextField.setBorder(TEXT_FIELD_BORDER_FIELD);
        }
        return jTextField;
    }

    public static Component configureComponentForPlatform(Component component) {
        if (component instanceof JTextField && !(component instanceof TextField) && !(component instanceof PasswordField)) {
            new TextField.TextSelector((JTextField)component);
        } else if (component instanceof Frame) {
            GUIFactory.imposeMinimumSize(component);
        }
        if (Gestalt.isAquaLookAndFeel) {
            if (component instanceof JButton || component instanceof JCheckBox || component instanceof JRadioButton) {
                ((AbstractButton)component).setFocusPainted(Gestalt.showFocusRings);
                ((AbstractButton)component).setContentAreaFilled(false);
            } else if (component instanceof JPanel) {
                ((JPanel)component).setOpaque(false);
            } else if (component instanceof JComboBox) {
                ((JComboBox)component).setOpaque(false);
            }
        }
        return component;
    }

    private static void imposeMinimumSize(Component component) {
        component.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                this.componentResized(componentEvent);
            }

            public void componentResized(ComponentEvent componentEvent) {
                int n;
                Component component = componentEvent.getComponent();
                Dimension dimension = component.getMinimumSize();
                boolean bl = false;
                int n2 = component.getWidth();
                if (n2 < dimension.width) {
                    n2 = dimension.width;
                    bl = true;
                }
                if ((n = component.getHeight()) < dimension.height) {
                    n = dimension.height;
                    bl = true;
                }
                if (bl) {
                    int n3 = n2;
                    int n4 = n;
                    EventQueue.invokeLater(new Runnable(this, component, n3, n4){
                        private final /* synthetic */ Component val$c;
                        private final /* synthetic */ int val$newWidth;
                        private final /* synthetic */ int val$newHeight;
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = var1_1;
                            this.val$c = component;
                            this.val$newWidth = n;
                            this.val$newHeight = n2;
                        }

                        public void run() {
                            this.val$c.setSize(this.val$newWidth, this.val$newHeight);
                        }
                    });
                }
            }
        });
    }
}

