/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;
import org.apache.xerces.impl.validation.ValidationContext;

public class MonthDV
extends AbstractDateTimeDV {
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content, null);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gMonth"});
        }
    }

    protected int[] parse(String str, int[] date) throws SchemaDateTimeException {
        this.resetBuffer(str);
        if (date == null) {
            date = new int[8];
        }
        this.resetDateObj(date);
        date[0] = 2001;
        date[2] = 15;
        if (this.fBuffer.charAt(0) != '-' || this.fBuffer.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonth: " + str);
        }
        int stop = this.fStart + 4;
        date[1] = this.parseInt(this.fStart + 2, stop);
        if (this.fBuffer.charAt(stop++) != '-' || this.fBuffer.charAt(stop) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonth: " + str);
        }
        if (6 < this.fEnd) {
            int sign = this.findUTCSign(6, this.fEnd);
            if (sign < 0) {
                throw new SchemaDateTimeException("Error in month parsing: " + str);
            }
            this.getTimeZone(date, sign);
        }
        this.validateDateTime(date);
        if (date[7] != 0 && date[7] != 90) {
            this.normalize(date);
        }
        return date;
    }

    protected short compareDates(int[] date1, int[] date2) {
        if (date1[7] == date2[7]) {
            return date1[1] >= date2[1] ? (date1[1] > date2[1] ? (short)1 : 0) : (short)-1;
        }
        if (date1[7] == 90 || date2[7] == 90) {
            if (date1[1] == date2[1]) {
                return 2;
            }
            if (date1[1] + 1 == date2[1] || date1[1] - 1 == date2[1]) {
                return 2;
            }
        }
        if (date1[1] < date2[1]) {
            return -1;
        }
        return 1;
    }

    protected String dateToString(int[] date) {
        this.message.setLength(0);
        this.message.append('-');
        this.message.append('-');
        this.message.append(date[1]);
        this.message.append('-');
        this.message.append('-');
        this.message.append((char)date[7]);
        return this.message.toString();
    }
}

