/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.trax.TransformerImpl;

public final class TemplatesImpl
implements Templates,
Serializable {
    private String _name = null;
    private byte[][] _bytecodes = null;
    private Class[] _class = null;
    private int _transletIndex = -1;

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._name);
        out.writeObject(this._bytecodes);
        out.flush();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._name = (String)in.readObject();
        this._bytecodes = (byte[][])in.readObject();
        this._class = null;
    }

    protected TemplatesImpl(byte[][] bytecodes, String transletName) {
        this._bytecodes = bytecodes;
        this._name = transletName;
    }

    protected void setTransletBytecodes(byte[][] bytecodes) {
        this._bytecodes = bytecodes;
    }

    protected byte[][] getTransletBytecodes() {
        return this._bytecodes;
    }

    protected void setTransletName(String name) {
        this._name = name;
    }

    protected String getTransletName() {
        return this._name;
    }

    private void defineTransletClasses() throws TransformerConfigurationException {
        if (this._bytecodes == null) {
            ErrorMsg err = new ErrorMsg(55);
            throw new TransformerConfigurationException(err.toString());
        }
        TransletClassLoader loader = (TransletClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new TransletClassLoader(Thread.currentThread().getContextClassLoader());
            }
        });
        try {
            int classCount = this._bytecodes.length;
            this._class = new Class[classCount];
            int i = 0;
            while (i < classCount) {
                this._class[i] = loader.defineClass(this._bytecodes[i]);
                if (this._class[i].getName().equals(this._name)) {
                    this._transletIndex = i;
                }
                ++i;
            }
            if (this._transletIndex < 0) {
                ErrorMsg err = new ErrorMsg(56, this._name);
                throw new TransformerConfigurationException(err.toString());
            }
        }
        catch (ClassFormatError e) {
            ErrorMsg err = new ErrorMsg(57 + this._name);
            throw new TransformerConfigurationException(err.toString());
        }
        catch (LinkageError e) {
            ErrorMsg err = new ErrorMsg(58 + this._name);
            throw new TransformerConfigurationException(err.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Translet getTransletInstance() throws TransformerConfigurationException {
        try {
            void e;
            if (this._name == null) {
                return null;
            }
            if (this._class == null) {
                this.defineTransletClasses();
            }
            Translet translet = (Translet)this._class[this._transletIndex].newInstance();
            int classCount = this._bytecodes.length;
            int i = 0;
            while (i < classCount) {
                if (i != this._transletIndex) {
                    translet.addAuxiliaryClass(this._class[i]);
                }
                ++i;
            }
            return e;
        }
        catch (InstantiationException e) {
            ErrorMsg err = new ErrorMsg(58 + this._name);
            throw new TransformerConfigurationException(err.toString());
        }
        catch (IllegalAccessException e) {
            ErrorMsg err = new ErrorMsg(58 + this._name);
            throw new TransformerConfigurationException(err.toString());
        }
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerImpl(this.getTransletInstance());
    }

    public Properties getOutputProperties() {
        try {
            Transformer transformer = this.newTransformer();
            return transformer.getOutputProperties();
        }
        catch (TransformerConfigurationException e) {
            return null;
        }
    }

    private class TransletClassLoader
    extends ClassLoader {
        protected TransletClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(byte[] b) {
            return super.defineClass(null, b, 0, b.length);
        }
    }
}

