/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime;

import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.runtime.AttributeList;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class SAXAdapter
implements TransletOutputHandler {
    private final ContentHandler _saxHandler;
    private final LexicalHandler _lexHandler;
    private final AttributeList _attributes = new AttributeList();
    private String _openElementName;

    public SAXAdapter(ContentHandler saxHandler) {
        this._saxHandler = saxHandler;
        this._lexHandler = null;
    }

    public SAXAdapter(ContentHandler saxHandler, LexicalHandler lexHandler) {
        this._saxHandler = saxHandler;
        this._lexHandler = lexHandler;
    }

    private void maybeEmitStartElement() throws SAXException {
        if (this._openElementName != null) {
            this._saxHandler.startElement(null, null, this._openElementName, this._attributes);
            this._openElementName = null;
        }
    }

    public void startDocument() throws TransletException {
        try {
            this._saxHandler.startDocument();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void endDocument() throws TransletException {
        try {
            this._saxHandler.endDocument();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void characters(char[] characters, int offset, int length) throws TransletException {
        try {
            this.maybeEmitStartElement();
            this._saxHandler.characters(characters, offset, length);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void startElement(String elementName) throws TransletException {
        try {
            this.maybeEmitStartElement();
            this._openElementName = elementName;
            this._attributes.clear();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void endElement(String elementName) throws TransletException {
        try {
            this.maybeEmitStartElement();
            this._saxHandler.endElement(null, null, elementName);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void attribute(String name, String value) throws TransletException {
        if (this._openElementName != null) {
            this._attributes.add(name, value);
        } else {
            BasisLibrary.runTimeError(10, name);
        }
    }

    public void namespace(String prefix, String uri) throws TransletException {
    }

    public void comment(String comment) throws TransletException {
        try {
            this.maybeEmitStartElement();
            if (this._lexHandler != null) {
                char[] chars = comment.toCharArray();
                this._lexHandler.comment(chars, 0, chars.length);
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void processingInstruction(String target, String data) throws TransletException {
        try {
            this.maybeEmitStartElement();
            this._saxHandler.processingInstruction(target, data);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void setType(int type) {
    }

    public void setHeader(String header) {
    }

    public void setIndent(boolean indent) {
    }

    public void omitHeader(boolean value) {
    }

    public void setCdataElements(Hashtable elements) {
    }

    public void close() {
    }

    public boolean setEscaping(boolean escape) throws TransletException {
        return true;
    }

    public String getPrefix(String uri) {
        return "";
    }
}

