/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.dom.DOMImpl;
import org.apache.xalan.xsltc.dom.DTDMonitor;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xalan.xsltc.runtime.Parameter;
import org.apache.xalan.xsltc.runtime.TextOutput;
import org.apache.xalan.xsltc.runtime.TransletOutputBase;
import org.xml.sax.XMLReader;

public final class DefaultRun {
    private TransletOutputHandler _handler;
    private String _fileName;
    private String _className;
    private String _jarFileSrc;
    private boolean _isJarFileSpecified = false;
    private Vector _params = null;
    private boolean _uri;
    private boolean _debug;
    AbstractTranslet _translet;
    protected static boolean allowSystemExit = true;
    private static final String USAGE_STRING = "Usage: \n     xslt [-j <jarfile>] {-u <document_url> | <document>} <class>\n          [<name1>=<value1> ...]\n\n           <document> is the xml document to be transformed, or\n           <document_url> is a url for the xml document,\n           <class> is the translet class which is either in\n           user's CLASSPATH or in the <jarfile> specified \n           with the -j option.\n          also: [-x] (debug), [-s] (don't allow System.exit)";

    public DefaultRun(String className, String fileName, boolean uri, boolean debug) {
        this._fileName = fileName;
        this._className = className;
        this._uri = uri;
        this._debug = debug;
    }

    public void setParameters(Vector params) {
        this._params = params;
    }

    private void setJarFileInputSrc(boolean flag, String jarFile) {
        this._isJarFileSpecified = flag;
        this._jarFileSrc = jarFile;
    }

    private void doTransform() {
        try {
            Class<?> clazz = Class.forName(this._className);
            Translet translet = (Translet)clazz.newInstance();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                factory.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (Exception e) {
                factory.setNamespaceAware(true);
            }
            SAXParser parser2 = factory.newSAXParser();
            XMLReader reader = parser2.getXMLReader();
            DOMImpl dom = new DOMImpl();
            reader.setContentHandler(dom.getBuilder());
            DTDMonitor dtdMonitor = new DTDMonitor();
            dtdMonitor.handleDTD(reader);
            this._translet = (AbstractTranslet)translet;
            dom.setDocumentURI(this._fileName);
            if (this._uri) {
                reader.parse(this._fileName);
            } else {
                reader.parse(new File(this._fileName).toURL().toExternalForm());
            }
            this._translet.setIndexSize(dom.getSize());
            dtdMonitor.buildIdIndex(dom, 0, this._translet);
            this._translet.setDTDMonitor(dtdMonitor);
            int n = this._params.size();
            int i = 0;
            while (i < n) {
                Parameter param = (Parameter)this._params.elementAt(i);
                translet.addParameter(param._name, param._value);
                ++i;
            }
            String encoding = this._translet._encoding;
            DefaultSAXOutputHandler saxHandler = new DefaultSAXOutputHandler(System.out, encoding);
            TextOutput textOutput = new TextOutput(saxHandler, saxHandler, encoding);
            translet.transform((DOM)dom, textOutput);
            if (this._debug) {
                TransletOutputBase handler = new TransletOutputBase();
                long start = System.currentTimeMillis();
                int nTimes = 100;
                int i2 = 0;
                while (i2 < 100) {
                    translet.transform(dom, dom.getIterator(), handler);
                    ++i2;
                }
                long end = System.currentTimeMillis();
                System.out.println("total " + (end - start) + " msec for " + 100 + " transformations");
                System.out.println(((double)end - (double)start) / 100.0 + " msec avg");
            }
        }
        catch (TransletException e) {
            System.err.println("\nTranslet Error: " + e.getMessage());
            if (this._debug) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
            DefaultRun.doSystemExit(1);
        }
        catch (RuntimeException e) {
            System.err.println("\nRuntime Error: " + e.getMessage());
            if (this._debug) {
                System.err.println(e.toString());
                e.printStackTrace();
            }
            DefaultRun.doSystemExit(1);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: File or URI '" + this._fileName + "' not found.");
            DefaultRun.doSystemExit(1);
        }
        catch (MalformedURLException e) {
            System.err.println("Error: Invalid URI '" + this._fileName + "'.");
            DefaultRun.doSystemExit(1);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error: Cannot find class '" + this._className + "'.");
            DefaultRun.doSystemExit(1);
        }
        catch (UnknownHostException e) {
            System.err.println("Error: Can't resolve URI specification '" + this._fileName + "'.");
            DefaultRun.doSystemExit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error: internal error.");
            DefaultRun.doSystemExit(1);
        }
    }

    protected static void doSystemExit(int retVal) {
        if (allowSystemExit) {
            System.exit(retVal);
        }
    }

    public static void printUsage() {
        System.err.println(USAGE_STRING);
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                boolean uri = false;
                boolean debug = false;
                boolean isJarFileSpecified = false;
                String jarFile = null;
                int i = 0;
                while (i < args.length && args[i].charAt(0) == '-') {
                    if (args[i].equals("-u")) {
                        uri = true;
                    } else if (args[i].equals("-s")) {
                        allowSystemExit = false;
                    } else if (args[i].equals("-x")) {
                        debug = true;
                    } else if (args[i].equals("-j")) {
                        isJarFileSpecified = true;
                        jarFile = args[++i];
                    } else {
                        DefaultRun.printUsage();
                    }
                    ++i;
                }
                if (args.length - i < 2) {
                    DefaultRun.printUsage();
                }
                DefaultRun handler = new DefaultRun(args[i + 1], args[i], uri, debug);
                handler.setJarFileInputSrc(isJarFileSpecified, jarFile);
                Vector<Parameter> params = new Vector<Parameter>();
                i += 2;
                while (i < args.length) {
                    int equal = args[i].indexOf(61);
                    if (equal > 0) {
                        Parameter param = new Parameter(args[i].substring(0, equal), args[i].substring(equal + 1, args[i].length()));
                        params.addElement(param);
                    } else {
                        DefaultRun.printUsage();
                    }
                    ++i;
                }
                if (i == args.length) {
                    handler.setParameters(params);
                    handler.doTransform();
                    DefaultRun.doSystemExit(0);
                }
            } else {
                DefaultRun.printUsage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

