/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.dom.CurrentNodeListFilter;
import org.apache.xalan.xsltc.dom.NodeIteratorBase;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.util.IntegerArray;

public final class CurrentNodeListIterator
extends NodeIteratorBase {
    private NodeIterator _source;
    private boolean _docOrder;
    private final CurrentNodeListFilter _filter;
    private IntegerArray _nodes = new IntegerArray();
    private int _current;
    private AbstractTranslet _translet;
    private final int _currentNode;
    private int _last;

    public CurrentNodeListIterator(NodeIterator source, CurrentNodeListFilter filter, int currentNode, AbstractTranslet translet) {
        this(source, !source.isReverse(), filter, currentNode, translet);
    }

    public CurrentNodeListIterator(NodeIterator source, boolean docOrder, CurrentNodeListFilter filter, int currentNode, AbstractTranslet translet) {
        this._source = source;
        this._filter = filter;
        this._translet = translet;
        this._docOrder = docOrder;
        this._currentNode = currentNode;
    }

    public NodeIterator forceNaturalOrder() {
        this._docOrder = true;
        return this;
    }

    public void setRestartable(boolean isRestartable) {
        this._isRestartable = isRestartable;
        this._source.setRestartable(isRestartable);
    }

    public boolean isReverse() {
        return !this._docOrder;
    }

    public NodeIterator cloneIterator() {
        try {
            CurrentNodeListIterator clone = (CurrentNodeListIterator)super.clone();
            clone._nodes = (IntegerArray)this._nodes.clone();
            clone.setRestartable(false);
            return clone.reset();
        }
        catch (CloneNotSupportedException e) {
            BasisLibrary.runTimeError(7, e.toString());
            return null;
        }
    }

    public NodeIterator reset() {
        this._current = 0;
        return this.resetPosition();
    }

    public int next() {
        boolean docOrder = this._docOrder;
        int last = this._nodes.cardinality();
        int currentNode = this._currentNode;
        int index = this._current;
        while (index < last) {
            int position;
            int node = this._nodes.at(index++);
            int n = position = docOrder ? index : last - index + 1;
            if (!this._filter.test(node, position, last, currentNode, this._translet, this)) continue;
            this._current = index;
            return this.returnNode(node);
        }
        return 0;
    }

    private int computePositionOfLast() {
        int lastPosition = 0;
        boolean docOrder = this._docOrder;
        int last = this._nodes.cardinality();
        int currNode = this._currentNode;
        int index = this._current;
        while (index < last) {
            int pos;
            int nodeIndex = this._nodes.at(index++);
            int n = pos = docOrder ? index : last - index + 1;
            if (!this._filter.test(nodeIndex, pos, last, currNode, this._translet, this)) continue;
            ++lastPosition;
        }
        return lastPosition;
    }

    public NodeIterator setStartNode(int node) {
        NodeIterator retval = this;
        if (this._isRestartable) {
            this._startNode = node;
            this._source.setStartNode(this._startNode);
            this._nodes.clear();
            while ((node = this._source.next()) != 0) {
                this._nodes.add(node);
            }
            this._current = 0;
            retval = this.resetPosition();
        }
        this._last = this.computePositionOfLast();
        return retval;
    }

    public int getLast() {
        return this._last == -1 ? this.computePositionOfLast() : this._last;
    }

    public void setMark() {
        this._source.setMark();
        this._markedNode = this._current;
    }

    public void gotoMark() {
        this._source.gotoMark();
        this._current = this._markedNode;
    }
}

