/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.AttributeValue;
import org.apache.xalan.xsltc.compiler.AttributeValueTemplate;
import org.apache.xalan.xsltc.compiler.Choose;
import org.apache.xalan.xsltc.compiler.CopyOf;
import org.apache.xalan.xsltc.compiler.If;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.LiteralAttribute;
import org.apache.xalan.xsltc.compiler.LiteralElement;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.Text;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.VariableBase;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class XslAttribute
extends Instruction {
    private AttributeValue _name;
    private AttributeValueTemplate _namespace = null;
    private String _prefix;
    private boolean _ignore = false;

    XslAttribute() {
    }

    public AttributeValue getName() {
        return this._name;
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("Attribute " + this._name);
        this.displayContents(indent + 4);
    }

    public void parseContents(Parser parser2) {
        SymbolTable stable = parser2.getSymbolTable();
        String namespace = this.getAttribute("namespace");
        String name = this.getAttribute("name");
        QName qname = parser2.getQName(name);
        String prefix = qname.getPrefix();
        boolean generated = false;
        if (prefix != null && prefix.equals("xmlns")) {
            this.reportError(this, parser2, 37, name);
            return;
        }
        SyntaxTreeNode parent = this.getParent();
        Vector siblings = parent.getContents();
        int i = 0;
        while (i < parent.elementCount()) {
            SyntaxTreeNode item = (SyntaxTreeNode)siblings.elementAt(i);
            if (item == this) break;
            if (!(item instanceof XslAttribute || item instanceof UseAttributeSets || item instanceof LiteralAttribute || item instanceof Text || item instanceof If || item instanceof Choose || item instanceof CopyOf || item instanceof VariableBase)) {
                this.reportWarning(this, parser2, 19, name);
                this._ignore = true;
            }
            ++i;
        }
        if (namespace != null && namespace != "") {
            this._prefix = this.lookupPrefix(namespace);
            this._namespace = new AttributeValueTemplate(namespace, parser2);
        } else if (prefix != null && prefix != "") {
            this._prefix = prefix;
            namespace = this.lookupNamespace(prefix);
            if (namespace != null) {
                this._namespace = new AttributeValueTemplate(namespace, parser2);
            }
        }
        if (this._namespace != null) {
            if (this._prefix == null) {
                if (prefix != null) {
                    this._prefix = prefix;
                } else {
                    this._prefix = stable.generateNamespacePrefix();
                    generated = true;
                }
            }
            if (this._prefix == "") {
                name = qname.getLocalPart();
            } else {
                name = this._prefix + ":" + qname.getLocalPart();
                if (parent instanceof LiteralElement && !generated) {
                    ((LiteralElement)parent).registerNamespace(this._prefix, namespace, stable, false);
                }
            }
        }
        if (name.equals("xmlns")) {
            this.reportError(this, parser2, 37, name);
            return;
        }
        if (parent instanceof LiteralElement) {
            ((LiteralElement)parent).addAttribute(this);
        }
        this._name = AttributeValue.create(this, name, parser2);
        this.parseChildren(parser2);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._ignore) {
            return Type.Void;
        }
        this._name.typeCheck(stable);
        if (this._namespace != null) {
            this._namespace.typeCheck(stable);
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (this._ignore) {
            return;
        }
        this._ignore = true;
        if (this._namespace != null) {
            il.append(methodGen.loadHandler());
            il.append(new PUSH(cpg, this._prefix));
            this._namespace.translate(classGen, methodGen);
            il.append(methodGen.namespace());
        }
        il.append(methodGen.loadHandler());
        il.append(InstructionConstants.DUP);
        this._name.translate(classGen, methodGen);
        if (this.elementCount() == 1 && this.elementAt(0) instanceof Text) {
            il.append(new PUSH(cpg, ((Text)this.elementAt(0)).getText()));
        } else {
            il.append(classGen.loadTranslet());
            il.append(new GETFIELD(cpg.addFieldref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "stringValueHandler", "Lorg/apache/xalan/xsltc/runtime/StringValueHandler;")));
            il.append(InstructionConstants.DUP);
            il.append(methodGen.storeHandler());
            this.translateContents(classGen, methodGen);
            il.append(new INVOKEVIRTUAL(cpg.addMethodref("org.apache.xalan.xsltc.runtime.StringValueHandler", "getValue", "()Ljava/lang/String;")));
        }
        il.append(methodGen.attribute());
        il.append(methodGen.storeHandler());
    }
}

