/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.SWITCH;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.InstructionFinder;
import org.apache.xalan.xsltc.compiler.AlternativePattern;
import org.apache.xalan.xsltc.compiler.Constants;
import org.apache.xalan.xsltc.compiler.IdKeyPattern;
import org.apache.xalan.xsltc.compiler.LocationPathPattern;
import org.apache.xalan.xsltc.compiler.Pattern;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.StepPattern;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.Template;
import org.apache.xalan.xsltc.compiler.TestSeq;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NamedMethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Mode
implements Constants {
    private final QName _name;
    private final Stylesheet _stylesheet;
    private final String _methodName;
    private Vector _templates;
    private Vector _nodeGroup = null;
    private TestSeq _nodeTestSeq = null;
    private Vector _idxGroup = null;
    private TestSeq _idxTestSeq = null;
    private Vector[] _patternGroups;
    private TestSeq[] _testSeq;
    private Hashtable _neededTemplates = new Hashtable();
    private Hashtable _namedTemplates = new Hashtable();
    private Hashtable _templateIHs = new Hashtable();
    private Hashtable _templateILs = new Hashtable();
    private LocationPathPattern _rootPattern = null;
    private Hashtable _importLevels = null;
    private Hashtable _keys = null;
    private int _currentIndex;

    public Mode(QName name, Stylesheet stylesheet, String suffix) {
        this._name = name;
        this._stylesheet = stylesheet;
        this._methodName = "applyTemplates" + suffix;
        this._templates = new Vector();
        this._patternGroups = new Vector[32];
    }

    public String functionName() {
        return this._methodName;
    }

    public String functionName(int min, int max) {
        if (this._importLevels == null) {
            this._importLevels = new Hashtable();
        }
        this._importLevels.put(new Integer(max), new Integer(min));
        return this._methodName + '_' + max;
    }

    private String getClassName() {
        return this._stylesheet.getClassName();
    }

    public void addTemplate(Template template) {
        this._templates.addElement(template);
    }

    public void processPatterns(Hashtable keys) {
        this._keys = keys;
        Enumeration templates = this._templates.elements();
        while (templates.hasMoreElements()) {
            Pattern pattern;
            Template template = (Template)templates.nextElement();
            if (template.isNamed() && !template.disabled()) {
                this._namedTemplates.put(template, this);
            }
            if ((pattern = template.getPattern()) == null) continue;
            this.flattenAlternative(pattern, template, keys);
        }
        this.prepareTestSequences();
    }

    private void flattenAlternative(Pattern pattern, Template template, Hashtable keys) {
        if (pattern instanceof IdKeyPattern) {
            IdKeyPattern idkey = (IdKeyPattern)pattern;
            idkey.setTemplate(template);
            if (this._idxGroup == null) {
                this._idxGroup = new Vector();
            }
            this._idxGroup.add(pattern);
        } else if (pattern instanceof AlternativePattern) {
            AlternativePattern alt = (AlternativePattern)pattern;
            this.flattenAlternative(alt.getLeft(), template, keys);
            this.flattenAlternative(alt.getRight(), template, keys);
        } else if (pattern instanceof LocationPathPattern) {
            LocationPathPattern lpp = (LocationPathPattern)pattern;
            lpp.setTemplate(template);
            this.addPatternToGroup(lpp);
        }
    }

    private void addPattern(int kernelType, LocationPathPattern pattern) {
        Vector<LocationPathPattern> patterns;
        int oldLength = this._patternGroups.length;
        if (kernelType >= oldLength) {
            Vector[] newGroups = new Vector[kernelType * 2];
            System.arraycopy(this._patternGroups, 0, newGroups, 0, oldLength);
            this._patternGroups = newGroups;
        }
        if ((patterns = kernelType == -1 ? this._nodeGroup : this._patternGroups[kernelType]) == null) {
            patterns = new Vector<LocationPathPattern>(2);
            patterns.addElement(pattern);
            if (kernelType == -1) {
                this._nodeGroup = patterns;
            } else {
                this._patternGroups[kernelType] = patterns;
            }
        } else {
            boolean inserted = false;
            int i = 0;
            while (i < patterns.size()) {
                LocationPathPattern lppToCompare = (LocationPathPattern)patterns.elementAt(i);
                if (pattern.noSmallerThan(lppToCompare)) {
                    inserted = true;
                    patterns.insertElementAt(pattern, i);
                    break;
                }
                ++i;
            }
            if (!inserted) {
                patterns.addElement(pattern);
            }
        }
    }

    private void addPatternToGroup(LocationPathPattern lpp) {
        if (lpp instanceof IdKeyPattern) {
            this.addPattern(-1, lpp);
        } else {
            StepPattern kernel = lpp.getKernelPattern();
            if (kernel != null) {
                this.addPattern(kernel.getNodeType(), lpp);
            } else if (this._rootPattern == null || lpp.noSmallerThan(this._rootPattern)) {
                this._rootPattern = lpp;
            }
        }
    }

    private void prepareTestSequences() {
        Vector names = this._stylesheet.getXSLTC().getNamesIndex();
        this._testSeq = new TestSeq[7 + names.size()];
        int n = this._patternGroups.length;
        int i = 0;
        while (i < n) {
            Vector patterns = this._patternGroups[i];
            if (patterns != null) {
                TestSeq testSeq = new TestSeq(patterns, this);
                testSeq.reduce();
                this._testSeq[i] = testSeq;
                testSeq.findTemplates(this._neededTemplates);
            }
            ++i;
        }
        if (this._nodeGroup != null && this._nodeGroup.size() > 0) {
            this._nodeTestSeq = new TestSeq(this._nodeGroup, this);
            this._nodeTestSeq.reduce();
            this._nodeTestSeq.findTemplates(this._neededTemplates);
        }
        if (this._idxGroup != null && this._idxGroup.size() > 0) {
            this._idxTestSeq = new TestSeq(this._idxGroup, this);
            this._idxTestSeq.reduce();
            this._idxTestSeq.findTemplates(this._neededTemplates);
        }
        if (this._rootPattern != null) {
            this._neededTemplates.put(this._rootPattern.getTemplate(), this);
        }
    }

    private void compileNamedTemplate(Template template, ClassGenerator classGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = new InstructionList();
        String methodName = Util.escape(template.getName().toString());
        NamedMethodGenerator methodGen = new NamedMethodGenerator(1, Type.VOID, new Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/NodeIterator;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/TransletOutputHandler;"), Type.INT}, new String[]{"document", "iterator", "handler", "node"}, methodName, this.getClassName(), il, cpg);
        il.append(template.compile(classGen, methodGen));
        il.append(InstructionConstants.RETURN);
        methodGen.stripAttributes(true);
        methodGen.setMaxLocals();
        methodGen.setMaxStack();
        methodGen.removeNOPs();
        classGen.addMethod(methodGen.getMethod());
    }

    private void compileTemplates(ClassGenerator classGen, MethodGenerator methodGen, InstructionHandle next) {
        Template template;
        Enumeration templates = this._namedTemplates.keys();
        while (templates.hasMoreElements()) {
            template = (Template)templates.nextElement();
            this.compileNamedTemplate(template, classGen);
        }
        templates = this._neededTemplates.keys();
        while (templates.hasMoreElements()) {
            template = (Template)templates.nextElement();
            if (template.hasContents()) {
                InstructionList til = template.compile(classGen, methodGen);
                til.append(new GOTO_W(next));
                this._templateILs.put(template, til);
                this._templateIHs.put(template, til.getStart());
                continue;
            }
            this._templateIHs.put(template, next);
        }
    }

    private void appendTemplateCode(InstructionList body) {
        Enumeration templates = this._neededTemplates.keys();
        while (templates.hasMoreElements()) {
            Object iList = this._templateILs.get(templates.nextElement());
            if (iList == null) continue;
            body.append((InstructionList)iList);
        }
    }

    private void appendTestSequences(InstructionList body) {
        int n = this._testSeq.length;
        int i = 0;
        while (i < n) {
            InstructionList il;
            TestSeq testSeq = this._testSeq[i];
            if (testSeq != null && (il = testSeq.getInstructionList()) != null) {
                body.append(il);
            }
            ++i;
        }
    }

    public static void compileGetChildren(ClassGenerator classGen, MethodGenerator methodGen, int node) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        int git = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getChildren", "(I)Lorg/apache/xalan/xsltc/NodeIterator;");
        il.append(methodGen.loadDOM());
        il.append(new ILOAD(node));
        il.append(new INVOKEINTERFACE(git, 2));
    }

    private InstructionList compileDefaultRecursion(ClassGenerator classGen, MethodGenerator methodGen, InstructionHandle next) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = new InstructionList();
        String applyTemplatesSig = classGen.getApplyTemplatesSig();
        int git = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getChildren", "(I)Lorg/apache/xalan/xsltc/NodeIterator;");
        int applyTemplates = cpg.addMethodref(this.getClassName(), this.functionName(), applyTemplatesSig);
        il.append(classGen.loadTranslet());
        il.append(methodGen.loadDOM());
        il.append(methodGen.loadDOM());
        il.append(new ILOAD(this._currentIndex));
        il.append(new INVOKEINTERFACE(git, 2));
        il.append(methodGen.loadHandler());
        il.append(new INVOKEVIRTUAL(applyTemplates));
        il.append(new GOTO_W(next));
        return il;
    }

    private InstructionList compileDefaultText(ClassGenerator classGen, MethodGenerator methodGen, InstructionHandle next) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = new InstructionList();
        int chars = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "characters", "(ILorg/apache/xalan/xsltc/TransletOutputHandler;)V");
        il.append(methodGen.loadDOM());
        il.append(new ILOAD(this._currentIndex));
        il.append(methodGen.loadHandler());
        il.append(new INVOKEINTERFACE(chars, 3));
        il.append(new GOTO_W(next));
        return il;
    }

    private InstructionList compileNamespaces(ClassGenerator classGen, MethodGenerator methodGen, boolean[] isNamespace, boolean[] isAttribute, boolean attrFlag, InstructionHandle defaultTarget) {
        XSLTC xsltc = classGen.getParser().getXSLTC();
        ConstantPoolGen cpg = classGen.getConstantPool();
        Vector namespaces = xsltc.getNamespaceIndex();
        Vector names = xsltc.getNamesIndex();
        int namespaceCount = namespaces.size() + 1;
        int namesCount = names.size();
        InstructionList il = new InstructionList();
        int[] types = new int[namespaceCount];
        InstructionHandle[] targets = new InstructionHandle[types.length];
        if (namespaceCount > 0) {
            boolean compiled = false;
            int i = 0;
            while (i < namespaceCount) {
                targets[i] = defaultTarget;
                types[i] = i;
                ++i;
            }
            int i2 = 7;
            while (i2 < 7 + namesCount) {
                if (isNamespace[i2] && isAttribute[i2] == attrFlag) {
                    String name = (String)names.elementAt(i2 - 7);
                    String namespace = name.substring(0, name.lastIndexOf(58));
                    int type = xsltc.registerNamespace(namespace);
                    if (i2 < this._testSeq.length && this._testSeq[i2] != null) {
                        targets[type] = this._testSeq[i2].compile(classGen, methodGen, defaultTarget);
                        compiled = true;
                    }
                }
                ++i2;
            }
            if (!compiled) {
                return null;
            }
            int getNS = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getNamespaceType", "(I)I");
            il.append(methodGen.loadDOM());
            il.append(new ILOAD(this._currentIndex));
            il.append(new INVOKEINTERFACE(getNS, 2));
            il.append(new SWITCH(types, targets, defaultTarget));
            return il;
        }
        return null;
    }

    private static boolean isAttributeName(String qname) {
        int col = qname.lastIndexOf(58) + 1;
        return qname.charAt(col) == '@';
    }

    private static boolean isNamespaceName(String qname) {
        int col = qname.lastIndexOf(58);
        return col > -1 && qname.charAt(qname.length() - 1) == '*';
    }

    public void compileApplyTemplates(ClassGenerator classGen) {
        XSLTC xsltc = classGen.getParser().getXSLTC();
        ConstantPoolGen cpg = classGen.getConstantPool();
        Vector names = xsltc.getNamesIndex();
        Type[] argTypes = new Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/NodeIterator;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/TransletOutputHandler;")};
        String[] argNames = new String[]{"document", "iterator", "handler"};
        InstructionList mainIL = new InstructionList();
        MethodGenerator methodGen = new MethodGenerator(17, Type.VOID, argTypes, argNames, this.functionName(), this.getClassName(), mainIL, classGen.getConstantPool());
        methodGen.addException("org.apache.xalan.xsltc.TransletException");
        LocalVariableGen current = methodGen.addLocalVariable2("current", Type.INT, mainIL.getEnd());
        this._currentIndex = current.getIndex();
        InstructionList body = new InstructionList();
        body.append(InstructionConstants.NOP);
        InstructionList ilLoop = new InstructionList();
        ilLoop.append(methodGen.loadIterator());
        ilLoop.append(methodGen.nextNode());
        ilLoop.append(InstructionConstants.DUP);
        ilLoop.append(new ISTORE(this._currentIndex));
        BranchHandle ifeq = ilLoop.append(new IFEQ(null));
        BranchHandle loop = ilLoop.append(new GOTO_W(null));
        ifeq.setTarget(ilLoop.append(InstructionConstants.RETURN));
        InstructionHandle ihLoop = ilLoop.getStart();
        InstructionList ilRecurse = this.compileDefaultRecursion(classGen, methodGen, ihLoop);
        InstructionHandle ihRecurse = ilRecurse.getStart();
        InstructionList ilText = this.compileDefaultText(classGen, methodGen, ihLoop);
        InstructionHandle ihText = ilText.getStart();
        int[] types = new int[7 + names.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = i;
            ++i;
        }
        boolean[] isAttribute = new boolean[types.length];
        boolean[] isNamespace = new boolean[types.length];
        int i2 = 0;
        while (i2 < names.size()) {
            String name = (String)names.elementAt(i2);
            isAttribute[i2 + 7] = Mode.isAttributeName(name);
            isNamespace[i2 + 7] = Mode.isNamespaceName(name);
            ++i2;
        }
        this.compileTemplates(classGen, methodGen, ihLoop);
        TestSeq elemTest = this._testSeq[3];
        InstructionHandle ihElem = ihRecurse;
        if (elemTest != null) {
            ihElem = elemTest.compile(classGen, methodGen, ihRecurse);
        }
        TestSeq attrTest = this._testSeq[4];
        InstructionHandle ihAttr = ihText;
        if (attrTest != null) {
            ihAttr = attrTest.compile(classGen, methodGen, ihAttr);
        }
        InstructionList ilKey = null;
        if (this._idxTestSeq != null) {
            loop.setTarget(this._idxTestSeq.compile(classGen, methodGen, body.getStart()));
            ilKey = this._idxTestSeq.getInstructionList();
        } else {
            loop.setTarget(body.getStart());
        }
        if (this._nodeTestSeq != null) {
            double nodePrio = -0.5;
            int nodePos = this._nodeTestSeq.getPosition();
            double elemPrio = -1.7976931348623157E308;
            int elemPos = Integer.MIN_VALUE;
            if (elemTest != null) {
                elemPrio = elemTest.getPriority();
                elemPos = elemTest.getPosition();
            }
            if (elemPrio == Double.NaN || elemPrio < nodePrio || elemPrio == nodePrio && elemPos < nodePos) {
                ihText = ihElem = this._nodeTestSeq.compile(classGen, methodGen, ihLoop);
            }
        }
        InstructionHandle elemNamespaceHandle = ihElem;
        InstructionList nsElem = this.compileNamespaces(classGen, methodGen, isNamespace, isAttribute, false, ihElem);
        if (nsElem != null) {
            elemNamespaceHandle = nsElem.getStart();
        }
        InstructionHandle attrNamespaceHandle = ihAttr;
        InstructionList nsAttr = this.compileNamespaces(classGen, methodGen, isNamespace, isAttribute, true, ihAttr);
        if (nsAttr != null) {
            attrNamespaceHandle = nsAttr.getStart();
        }
        InstructionHandle[] targets = new InstructionHandle[types.length];
        int i3 = 7;
        while (i3 < targets.length) {
            TestSeq testSeq = this._testSeq[i3];
            targets[i3] = isNamespace[i3] ? (isAttribute[i3] ? attrNamespaceHandle : elemNamespaceHandle) : (testSeq != null ? (isAttribute[i3] ? testSeq.compile(classGen, methodGen, attrNamespaceHandle) : testSeq.compile(classGen, methodGen, elemNamespaceHandle)) : ihLoop);
            ++i3;
        }
        targets[0] = this._rootPattern != null ? this.getTemplateInstructionHandle(this._rootPattern.getTemplate()) : ihRecurse;
        targets[1] = this._testSeq[1] != null ? this._testSeq[1].compile(classGen, methodGen, ihText) : ihText;
        targets[2] = ihLoop;
        targets[3] = elemNamespaceHandle;
        targets[4] = attrNamespaceHandle;
        InstructionHandle ihPI = ihLoop;
        if (this._nodeTestSeq != null) {
            ihPI = ihElem;
        }
        targets[5] = this._testSeq[5] != null ? this._testSeq[5].compile(classGen, methodGen, ihPI) : ihPI;
        InstructionHandle ihComment = ihLoop;
        if (this._nodeTestSeq != null) {
            ihComment = ihElem;
        }
        targets[6] = this._testSeq[6] != null ? this._testSeq[6].compile(classGen, methodGen, ihComment) : ihComment;
        int i4 = 7;
        while (i4 < targets.length) {
            TestSeq testSeq = this._testSeq[i4];
            targets[i4] = testSeq == null || isNamespace[i4] ? (isAttribute[i4] ? attrNamespaceHandle : elemNamespaceHandle) : (isAttribute[i4] ? testSeq.compile(classGen, methodGen, attrNamespaceHandle) : testSeq.compile(classGen, methodGen, elemNamespaceHandle));
            ++i4;
        }
        if (ilKey != null) {
            body.insert(ilKey);
        }
        int getType = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getType", "(I)I");
        body.append(methodGen.loadDOM());
        body.append(new ILOAD(this._currentIndex));
        body.append(new INVOKEINTERFACE(getType, 2));
        InstructionHandle disp = body.append(new SWITCH(types, targets, ihLoop));
        this.appendTestSequences(body);
        this.appendTemplateCode(body);
        if (nsElem != null) {
            body.append(nsElem);
        }
        if (nsAttr != null) {
            body.append(nsAttr);
        }
        body.append(ilRecurse);
        body.append(ilText);
        mainIL.append(new GOTO_W(ihLoop));
        mainIL.append(body);
        mainIL.append(ilLoop);
        this.peepHoleOptimization(methodGen);
        methodGen.stripAttributes(true);
        methodGen.setMaxLocals();
        methodGen.setMaxStack();
        methodGen.removeNOPs();
        classGen.addMethod(methodGen.getMethod());
        if (this._importLevels != null) {
            Enumeration levels = this._importLevels.keys();
            while (levels.hasMoreElements()) {
                Integer max = (Integer)levels.nextElement();
                Integer min = (Integer)this._importLevels.get(max);
                this.compileApplyImports(classGen, min, max);
            }
        }
    }

    private void compileTemplateCalls(ClassGenerator classGen, MethodGenerator methodGen, InstructionHandle next, int min, int max) {
        Enumeration templates = this._neededTemplates.keys();
        while (templates.hasMoreElements()) {
            Template template = (Template)templates.nextElement();
            int prec = template.getImportPrecedence();
            if (prec < min || prec >= max) continue;
            if (template.hasContents()) {
                InstructionList til = template.compile(classGen, methodGen);
                til.append(new GOTO_W(next));
                this._templateILs.put(template, til);
                this._templateIHs.put(template, til.getStart());
                continue;
            }
            this._templateIHs.put(template, next);
        }
    }

    public void compileApplyImports(ClassGenerator classGen, int min, int max) {
        XSLTC xsltc = classGen.getParser().getXSLTC();
        ConstantPoolGen cpg = classGen.getConstantPool();
        Vector names = xsltc.getNamesIndex();
        this._namedTemplates = new Hashtable();
        this._neededTemplates = new Hashtable();
        this._templateIHs = new Hashtable();
        this._templateILs = new Hashtable();
        this._patternGroups = new Vector[32];
        this._rootPattern = null;
        Vector oldTemplates = this._templates;
        this._templates = new Vector();
        Enumeration templates = oldTemplates.elements();
        while (templates.hasMoreElements()) {
            Template template = (Template)templates.nextElement();
            int prec = template.getImportPrecedence();
            if (prec < min || prec >= max) continue;
            this.addTemplate(template);
        }
        this.processPatterns(this._keys);
        Type[] argTypes = new Type[]{Util.getJCRefType("Lorg/apache/xalan/xsltc/DOM;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/NodeIterator;"), Util.getJCRefType("Lorg/apache/xalan/xsltc/TransletOutputHandler;")};
        String[] argNames = new String[]{"document", "iterator", "handler"};
        InstructionList mainIL = new InstructionList();
        MethodGenerator methodGen = new MethodGenerator(17, Type.VOID, argTypes, argNames, this.functionName() + '_' + max, this.getClassName(), mainIL, classGen.getConstantPool());
        methodGen.addException("org.apache.xalan.xsltc.TransletException");
        if (this._neededTemplates.size() == 0) {
            mainIL.append(new RETURN());
            methodGen.stripAttributes(true);
            methodGen.setMaxLocals();
            methodGen.setMaxStack();
            methodGen.removeNOPs();
            classGen.addMethod(methodGen.getMethod());
            this._templates = oldTemplates;
            return;
        }
        LocalVariableGen current = methodGen.addLocalVariable2("current", Type.INT, mainIL.getEnd());
        this._currentIndex = current.getIndex();
        InstructionList body = new InstructionList();
        body.append(InstructionConstants.NOP);
        InstructionList ilLoop = new InstructionList();
        ilLoop.append(methodGen.loadIterator());
        ilLoop.append(methodGen.nextNode());
        ilLoop.append(InstructionConstants.DUP);
        ilLoop.append(new ISTORE(this._currentIndex));
        BranchHandle ifeq = ilLoop.append(new IFEQ(null));
        BranchHandle loop = ilLoop.append(new GOTO_W(null));
        ifeq.setTarget(ilLoop.append(InstructionConstants.RETURN));
        InstructionHandle ihLoop = ilLoop.getStart();
        int[] types = new int[7 + names.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = i;
            ++i;
        }
        boolean[] isAttribute = new boolean[types.length];
        boolean[] isNamespace = new boolean[types.length];
        int i2 = 0;
        while (i2 < names.size()) {
            String name = (String)names.elementAt(i2);
            isAttribute[i2 + 7] = Mode.isAttributeName(name);
            isNamespace[i2 + 7] = Mode.isNamespaceName(name);
            ++i2;
        }
        this.compileTemplateCalls(classGen, methodGen, ihLoop, min, max);
        TestSeq elemTest = this._testSeq[3];
        InstructionHandle ihElem = ihLoop;
        if (elemTest != null) {
            ihElem = elemTest.compile(classGen, methodGen, ihLoop);
        }
        TestSeq attrTest = this._testSeq[4];
        InstructionHandle ihAttr = ihLoop;
        if (attrTest != null) {
            ihAttr = attrTest.compile(classGen, methodGen, ihAttr);
        }
        InstructionList ilKey = null;
        if (this._idxTestSeq != null) {
            loop.setTarget(this._idxTestSeq.compile(classGen, methodGen, body.getStart()));
            ilKey = this._idxTestSeq.getInstructionList();
        } else {
            loop.setTarget(body.getStart());
        }
        InstructionHandle ihText = ihLoop;
        if (this._nodeTestSeq != null) {
            double nodePrio = -0.5;
            int nodePos = this._nodeTestSeq.getPosition();
            double elemPrio = -1.7976931348623157E308;
            int elemPos = Integer.MIN_VALUE;
            if (elemTest != null) {
                elemPrio = elemTest.getPriority();
                elemPos = elemTest.getPosition();
            }
            if (elemPrio == Double.NaN || elemPrio < nodePrio || elemPrio == nodePrio && elemPos < nodePos) {
                ihText = ihElem = this._nodeTestSeq.compile(classGen, methodGen, ihLoop);
            }
        }
        InstructionHandle elemNamespaceHandle = ihElem;
        InstructionList nsElem = this.compileNamespaces(classGen, methodGen, isNamespace, isAttribute, false, ihElem);
        if (nsElem != null) {
            elemNamespaceHandle = nsElem.getStart();
        }
        InstructionList nsAttr = this.compileNamespaces(classGen, methodGen, isNamespace, isAttribute, true, ihAttr);
        InstructionHandle attrNamespaceHandle = ihAttr;
        if (nsAttr != null) {
            attrNamespaceHandle = nsAttr.getStart();
        }
        InstructionHandle[] targets = new InstructionHandle[types.length];
        int i3 = 7;
        while (i3 < targets.length) {
            TestSeq testSeq = this._testSeq[i3];
            targets[i3] = isNamespace[i3] ? (isAttribute[i3] ? attrNamespaceHandle : elemNamespaceHandle) : (testSeq != null ? (isAttribute[i3] ? testSeq.compile(classGen, methodGen, attrNamespaceHandle) : testSeq.compile(classGen, methodGen, elemNamespaceHandle)) : ihLoop);
            ++i3;
        }
        targets[0] = this._rootPattern != null ? this.getTemplateInstructionHandle(this._rootPattern.getTemplate()) : ihLoop;
        targets[1] = this._testSeq[1] != null ? this._testSeq[1].compile(classGen, methodGen, ihText) : ihText;
        targets[2] = ihLoop;
        targets[3] = elemNamespaceHandle;
        targets[4] = attrNamespaceHandle;
        InstructionHandle ihPI = ihLoop;
        if (this._nodeTestSeq != null) {
            ihPI = ihElem;
        }
        targets[5] = this._testSeq[5] != null ? this._testSeq[5].compile(classGen, methodGen, ihPI) : ihPI;
        InstructionHandle ihComment = ihLoop;
        if (this._nodeTestSeq != null) {
            ihComment = ihElem;
        }
        targets[6] = this._testSeq[6] != null ? this._testSeq[6].compile(classGen, methodGen, ihComment) : ihComment;
        int i4 = 7;
        while (i4 < targets.length) {
            TestSeq testSeq = this._testSeq[i4];
            targets[i4] = testSeq == null || isNamespace[i4] ? (isAttribute[i4] ? attrNamespaceHandle : elemNamespaceHandle) : (isAttribute[i4] ? testSeq.compile(classGen, methodGen, attrNamespaceHandle) : testSeq.compile(classGen, methodGen, elemNamespaceHandle));
            ++i4;
        }
        if (ilKey != null) {
            body.insert(ilKey);
        }
        int getType = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "getType", "(I)I");
        body.append(methodGen.loadDOM());
        body.append(new ILOAD(this._currentIndex));
        body.append(new INVOKEINTERFACE(getType, 2));
        InstructionHandle disp = body.append(new SWITCH(types, targets, ihLoop));
        this.appendTestSequences(body);
        this.appendTemplateCode(body);
        if (nsElem != null) {
            body.append(nsElem);
        }
        if (nsAttr != null) {
            body.append(nsAttr);
        }
        mainIL.append(new GOTO_W(ihLoop));
        mainIL.append(body);
        mainIL.append(ilLoop);
        this.peepHoleOptimization(methodGen);
        methodGen.stripAttributes(true);
        methodGen.setMaxLocals();
        methodGen.setMaxStack();
        methodGen.removeNOPs();
        classGen.addMethod(methodGen.getMethod());
        this._templates = oldTemplates;
    }

    private void peepHoleOptimization(MethodGenerator methodGen) {
        InstructionList il = methodGen.getInstructionList();
        InstructionFinder find = new InstructionFinder(il);
        String pattern = "`ALOAD'`POP'`Instruction'";
        Iterator iter = find.search(pattern);
        while (iter.hasNext()) {
            InstructionHandle[] match = (InstructionHandle[])iter.next();
            try {
                if (match[0].hasTargeters() || match[1].hasTargeters()) continue;
                il.delete(match[0], match[1]);
            }
            catch (TargetLostException e) {
                // empty catch block
            }
        }
        pattern = "`ILOAD'`ALOAD'`SWAP'`Instruction'";
        Iterator iter2 = find.search(pattern);
        while (iter2.hasNext()) {
            InstructionHandle[] match = (InstructionHandle[])iter2.next();
            try {
                if (match[0].hasTargeters() || match[1].hasTargeters() || match[2].hasTargeters()) continue;
                Instruction iload = match[0].getInstruction();
                Instruction aload = match[1].getInstruction();
                il.insert(match[0], aload);
                il.insert(match[0], iload);
                il.delete(match[0], match[2]);
            }
            catch (TargetLostException e) {
                // empty catch block
            }
        }
        pattern = "`ALOAD_1'`ALOAD_1'`Instruction'";
        Iterator iter3 = find.search(pattern);
        while (iter3.hasNext()) {
            InstructionHandle[] match = (InstructionHandle[])iter3.next();
            try {
                if (match[0].hasTargeters() || match[1].hasTargeters()) continue;
                il.insert(match[1], (Instruction)new DUP());
                il.delete(match[1]);
            }
            catch (TargetLostException e) {
                // empty catch block
            }
        }
    }

    public InstructionHandle getTemplateInstructionHandle(Template template) {
        return (InstructionHandle)this._templateIHs.get(template);
    }
}

