/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.CharInfo;
import org.apache.xalan.serialize.DOMSerializer;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.WriterToASCI;
import org.apache.xalan.serialize.WriterToUTF8;
import org.apache.xalan.serialize.WriterToUTF8Buffered;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.DOM2Helper;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class SerializerToXML
implements ContentHandler,
LexicalHandler,
DeclHandler,
Serializer,
DOMSerializer {
    protected Writer m_writer = null;
    boolean m_shouldFlush = true;
    protected String m_encoding = null;
    static boolean javaEncodingIsISO = false;
    public boolean m_shouldNotWriteXMLHeader = false;
    public String m_version = null;
    protected BoolStack m_elemStack = new BoolStack();
    protected BoolStack m_disableOutputEscapingStates = new BoolStack();
    protected BoolStack m_cdataSectionStates = new BoolStack();
    protected Vector m_cdataSectionNames = null;
    protected boolean m_inCData = false;
    protected final char[] m_lineSep = System.getProperty("line.separator").toCharArray();
    protected final int m_lineSepLen = this.m_lineSep.length;
    protected boolean m_ispreserve = false;
    protected BoolStack m_preserves = new BoolStack();
    protected boolean m_isprevtext = false;
    protected boolean m_doIndent = false;
    protected int m_currentIndent = 0;
    public int m_indentAmount = 0;
    protected int level = 0;
    boolean m_startNewLine;
    boolean m_needToOutputDocTypeDecl = true;
    String m_doctypeSystem;
    String m_doctypePublic;
    boolean m_standalone = false;
    boolean m_standaloneWasSpecified = false;
    String m_mediatype;
    protected boolean m_inEntityRef = false;
    private boolean m_inDoctype = false;
    protected static CharInfo m_xmlcharInfo = new CharInfo(CharInfo.XML_ENTITIES_RESOURCE);
    protected CharInfo m_charInfo;
    private static Hashtable m_charInfos = null;
    boolean m_isUTF8 = false;
    protected int m_maxCharacter = Encodings.getLastPrintable();
    public boolean m_spaceBeforeClose = false;
    protected Properties m_format;
    private static final boolean DEBUG = false;
    protected int m_pos = 0;
    private String m_elemName = "";
    Object m_charToByteConverter = null;
    Method m_canConvertMeth;
    boolean m_triedToGetConverter = false;

    protected boolean isEscapingDisabled() {
        return this.m_disableOutputEscapingStates.peekOrFalse();
    }

    protected boolean isCDataSection() {
        return this.m_inCData || this.m_cdataSectionStates.peekOrFalse();
    }

    protected final void outputLineSep() throws SAXException {
        try {
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public SerializerToXML() {
        this.m_charInfo = m_xmlcharInfo;
    }

    public void CopyFrom(SerializerToXML xmlListener) {
        this.m_writer = xmlListener.m_writer;
        this.m_encoding = xmlListener.m_encoding;
        this.m_shouldNotWriteXMLHeader = xmlListener.m_shouldNotWriteXMLHeader;
        this.m_elemStack = xmlListener.m_elemStack;
        this.m_ispreserve = xmlListener.m_ispreserve;
        this.m_preserves = xmlListener.m_preserves;
        this.m_isprevtext = xmlListener.m_isprevtext;
        this.m_doIndent = xmlListener.m_doIndent;
        this.m_currentIndent = xmlListener.m_currentIndent;
        this.m_indentAmount = xmlListener.m_indentAmount;
        this.level = xmlListener.level;
        this.m_startNewLine = xmlListener.m_startNewLine;
        this.m_needToOutputDocTypeDecl = xmlListener.m_needToOutputDocTypeDecl;
        this.m_doctypeSystem = xmlListener.m_doctypeSystem;
        this.m_doctypePublic = xmlListener.m_doctypePublic;
        this.m_standalone = xmlListener.m_standalone;
        this.m_mediatype = xmlListener.m_mediatype;
        this.m_maxCharacter = xmlListener.m_maxCharacter;
        this.m_spaceBeforeClose = xmlListener.m_spaceBeforeClose;
        this.m_inCData = xmlListener.m_inCData;
        this.m_pos = 0;
    }

    public synchronized void init(Writer writer, Properties format) {
        this.init(writer, format, false);
    }

    private synchronized void init(Writer writer, Properties format, boolean shouldFlush) {
        this.m_shouldFlush = shouldFlush;
        this.m_writer = writer;
        this.m_format = format;
        this.m_cdataSectionNames = OutputProperties.getQNameProperties("cdata-section-elements", format);
        this.m_indentAmount = OutputProperties.getIntProperty(OutputProperties.S_KEY_INDENT_AMOUNT, format);
        this.m_doIndent = OutputProperties.getBooleanProperty("indent", format);
        this.m_shouldNotWriteXMLHeader = OutputProperties.getBooleanProperty("omit-xml-declaration", format);
        this.m_doctypeSystem = format.getProperty("doctype-system");
        this.m_doctypePublic = format.getProperty("doctype-public");
        this.m_standaloneWasSpecified = null != ((Hashtable)format).get("standalone");
        this.m_standalone = OutputProperties.getBooleanProperty("standalone", format);
        this.m_mediatype = format.getProperty("media-type");
        if (null != this.m_doctypePublic && this.m_doctypePublic.startsWith("-//W3C//DTD XHTML")) {
            this.m_spaceBeforeClose = true;
        }
        if (null == this.m_encoding) {
            this.m_encoding = Encodings.getMimeEncoding(format.getProperty("encoding"));
        }
        this.m_isUTF8 = this.m_encoding.equals("UTF-8");
        this.m_maxCharacter = Encodings.getLastPrintable(this.m_encoding);
        String entitiesFileName = (String)((Hashtable)format).get(OutputProperties.S_KEY_ENTITIES);
        if (null != entitiesFileName) {
            try {
                this.m_charInfo = null;
                if (null == m_charInfos) {
                    CharInfo charInfo = m_xmlcharInfo;
                    synchronized (charInfo) {
                        if (null == m_charInfos) {
                            m_charInfos = new Hashtable();
                        }
                    }
                } else {
                    this.m_charInfo = (CharInfo)m_charInfos.get(entitiesFileName);
                }
                if (null == this.m_charInfo) {
                    this.m_charInfo = new CharInfo(entitiesFileName);
                }
                if (null == this.m_charInfo) {
                    String absoluteEntitiesFileName = entitiesFileName.indexOf(58) < 0 ? SystemIDResolver.getAbsoluteURIFromRelative(entitiesFileName) : SystemIDResolver.getAbsoluteURI(entitiesFileName, null);
                    this.m_charInfo = new CharInfo(absoluteEntitiesFileName);
                    m_charInfos.put(entitiesFileName, this.m_charInfo);
                }
            }
            catch (TransformerException te) {
                throw new WrappedRuntimeException(te);
            }
        }
    }

    public synchronized void init(OutputStream output, Properties format) throws UnsupportedEncodingException {
        if (null == format) {
            OutputProperties op = new OutputProperties("xml");
            format = op.getProperties();
        }
        this.m_encoding = Encodings.getMimeEncoding(format.getProperty("encoding"));
        if (this.m_encoding.equalsIgnoreCase("UTF-8")) {
            this.m_isUTF8 = true;
            if (output instanceof BufferedOutputStream) {
                this.init(new WriterToUTF8(output), format, true);
            } else if (output instanceof FileOutputStream) {
                this.init(new WriterToUTF8Buffered(output), format, true);
            } else {
                this.init(new WriterToUTF8(output), format, true);
            }
        } else if (this.m_encoding.equals("WINDOWS-1250") || this.m_encoding.equals("US-ASCII") || this.m_encoding.equals("ASCII")) {
            this.init(new WriterToASCI(output), format, true);
        } else {
            Writer osw;
            try {
                osw = Encodings.getWriter(output, this.m_encoding);
            }
            catch (UnsupportedEncodingException uee) {
                System.out.println("Warning: encoding \"" + this.m_encoding + "\" not supported" + ", using " + "UTF-8");
                this.m_encoding = "UTF-8";
                osw = Encodings.getWriter(output, this.m_encoding);
            }
            this.m_maxCharacter = Encodings.getLastPrintable(this.m_encoding);
            this.init(osw, format, true);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    void outputDocTypeDecl(String name, boolean closeDecl) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write("<!DOCTYPE ");
            writer.write(name);
            if (null != this.m_doctypePublic) {
                writer.write(" PUBLIC \"");
                writer.write(this.m_doctypePublic);
                writer.write(34);
            }
            if (null != this.m_doctypeSystem) {
                if (null == this.m_doctypePublic) {
                    writer.write(" SYSTEM \"");
                } else {
                    writer.write(" \"");
                }
                writer.write(this.m_doctypeSystem);
                if (closeDecl) {
                    writer.write("\">");
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                } else {
                    writer.write(34);
                }
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    void outputEntityDecl(String name, String value) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write("<!ENTITY ");
            writer.write(name);
            writer.write(" \"");
            writer.write(value);
            writer.write("\">");
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void startDocument() throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_needToOutputDocTypeDecl = true;
        this.m_startNewLine = false;
        if (!this.m_shouldNotWriteXMLHeader) {
            String version2;
            String encoding = Encodings.getMimeEncoding(this.m_encoding);
            String string = version2 = null == this.m_version ? "1.0" : this.m_version;
            String standalone = this.m_standaloneWasSpecified ? " standalone=\"" + (this.m_standalone ? "yes" : "no") + "\"" : "";
            try {
                Writer writer = this.m_writer;
                writer.write("<?xml version=\"");
                writer.write(version2);
                writer.write("\" encoding=\"");
                writer.write(encoding);
                writer.write(34);
                writer.write(standalone);
                writer.write("?>");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }

    public void endDocument() throws SAXException {
        if (this.m_doIndent && !this.m_isprevtext) {
            this.outputLineSep();
        }
        this.flushWriter();
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.m_doctypeSystem = systemId;
        this.m_doctypePublic = publicId;
        if (this.m_needToOutputDocTypeDecl) {
            this.outputDocTypeDecl(name, false);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.m_inDoctype = true;
    }

    public void endDTD() throws SAXException {
        try {
            if (!this.m_inDoctype) {
                this.m_writer.write("]>");
            } else {
                this.m_writer.write(62);
            }
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    protected static final boolean subPartMatch(String p, String t) {
        return p == t || null != p && p.equals(t);
    }

    protected void pushState(String namespaceURI, String localName, Vector qnames, BoolStack state) {
        boolean b;
        if (null != qnames) {
            b = false;
            if (null != namespaceURI && namespaceURI.length() == 0) {
                namespaceURI = null;
            }
            int nElems = qnames.size();
            int i = 0;
            while (i < nElems) {
                QName q = (QName)qnames.elementAt(i);
                if (q.getLocalName().equals(localName) && SerializerToXML.subPartMatch(namespaceURI, q.getNamespaceURI())) {
                    b = true;
                    break;
                }
                ++i;
            }
        } else {
            b = state.peekOrFalse();
        }
        state.push(b);
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToOutputDocTypeDecl && null != this.m_doctypeSystem) {
            this.outputDocTypeDecl(name, true);
        }
        this.m_needToOutputDocTypeDecl = false;
        this.writeParentTagEnd();
        this.pushState(namespaceURI, localName, this.m_cdataSectionNames, this.m_cdataSectionStates);
        this.m_ispreserve = false;
        if (this.shouldIndent() && this.m_startNewLine) {
            this.indent(this.m_currentIndent);
        }
        this.m_startNewLine = true;
        try {
            this.m_writer.write(60);
            this.m_writer.write(name);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        int nAttrs = atts.getLength();
        int i = 0;
        while (i < nAttrs) {
            this.processAttribute(atts.getQName(i), atts.getValue(i));
            ++i;
        }
        this.openElementForChildren();
        this.m_currentIndent += this.m_indentAmount;
        this.m_isprevtext = false;
    }

    protected void writeParentTagEnd() throws SAXException {
        if (!this.m_elemStack.peekOrTrue()) {
            try {
                this.m_writer.write(62);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
            this.m_isprevtext = false;
            this.m_elemStack.setTop(true);
            this.m_preserves.push(this.m_ispreserve);
        }
    }

    protected void openElementForChildren() {
        this.m_elemStack.push(false);
    }

    protected boolean childNodesWereAdded() {
        return this.m_elemStack.isEmpty() ? false : this.m_elemStack.pop();
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_currentIndent -= this.m_indentAmount;
        boolean hasChildNodes = this.childNodesWereAdded();
        try {
            Writer writer = this.m_writer;
            if (hasChildNodes) {
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                writer.write(60);
                writer.write(47);
                writer.write(name);
                writer.write(62);
            } else if (this.m_spaceBeforeClose) {
                writer.write(" />");
            } else {
                writer.write("/>");
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        if (hasChildNodes) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        this.m_cdataSectionStates.pop();
    }

    protected void processAttribute(String name, String value) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write(32);
            writer.write(name);
            writer.write("=\"");
            this.writeAttrString(value, this.m_encoding);
            writer.write(34);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void startNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.push(true);
    }

    public void endNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.pop();
    }

    public void startPreserving() throws SAXException {
        this.m_preserves.push(true);
        this.m_ispreserve = true;
    }

    public void endPreserving() throws SAXException {
        this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (target.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                int indexOfQLT;
                Writer writer = this.m_writer;
                this.writeParentTagEnd();
                if (this.shouldIndent()) {
                    this.indent(this.m_currentIndent);
                }
                writer.write(60);
                writer.write(63);
                writer.write(target);
                if (data.length() > 0 && !Character.isSpaceChar(data.charAt(0))) {
                    writer.write(32);
                }
                if ((indexOfQLT = data.indexOf("?>")) >= 0) {
                    if (indexOfQLT > 0) {
                        writer.write(data.substring(0, indexOfQLT));
                    }
                    writer.write("? >");
                    if (indexOfQLT + 2 < data.length()) {
                        writer.write(data.substring(indexOfQLT + 2));
                    }
                } else {
                    writer.write(data);
                }
                writer.write(63);
                writer.write(62);
                if (this.m_elemStack.isEmpty()) {
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                }
                this.m_startNewLine = true;
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        try {
            Writer writer = this.m_writer;
            writer.write("<!--");
            writer.write(ch, start, length);
            writer.write("-->");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.m_startNewLine = true;
    }

    public void startCDATA() throws SAXException {
        this.m_inCData = true;
    }

    public void endCDATA() throws SAXException {
        this.m_inCData = false;
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        try {
            boolean writeCDataBrackets;
            this.writeParentTagEnd();
            this.m_ispreserve = true;
            if (this.shouldIndent()) {
                this.indent(this.m_currentIndent);
            }
            boolean bl = writeCDataBrackets = length >= 1 && this.canConvert(ch[start]);
            if (writeCDataBrackets) {
                this.m_writer.write("<![CDATA[");
            }
            if (this.isEscapingDisabled()) {
                this.charactersRaw(ch, start, length);
            } else {
                this.writeNormalizedChars(ch, start, length, true);
            }
            if (writeCDataBrackets) {
                this.m_writer.write("]]>");
            }
        }
        catch (IOException ioe) {
            throw new SAXException(XSLMessages.createXPATHMessage(66, null), ioe);
        }
    }

    protected final void accum(char b) throws SAXException {
        try {
            this.m_writer.write(b);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected final void accum(char[] chars, int start, int length) throws SAXException {
        try {
            this.m_writer.write(chars, start, length);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected final void accum(String s) throws SAXException {
        try {
            this.m_writer.write(s);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public final void flushWriter() throws SAXException {
        if (null != this.m_writer) {
            try {
                if (this.m_writer instanceof WriterToUTF8Buffered) {
                    if (this.m_shouldFlush) {
                        ((WriterToUTF8Buffered)this.m_writer).flush();
                    } else {
                        ((WriterToUTF8Buffered)this.m_writer).flushBuffer();
                    }
                }
                if (this.m_writer instanceof WriterToUTF8) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else if (this.m_writer instanceof WriterToASCI) {
                    if (this.m_shouldFlush) {
                        this.m_writer.flush();
                    }
                } else {
                    this.m_writer.flush();
                }
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (0 == length) {
            return;
        }
        if (this.m_inCData || this.m_cdataSectionStates.peekOrFalse()) {
            this.cdata(chars, start, length);
            return;
        }
        try {
            if (this.m_disableOutputEscapingStates.peekOrFalse()) {
                this.charactersRaw(chars, start, length);
                return;
            }
            Writer writer = this.m_writer;
            if (!this.m_elemStack.peekOrTrue()) {
                writer.write(62);
                this.m_isprevtext = false;
                this.m_elemStack.setTop(true);
                this.m_preserves.push(this.m_ispreserve);
            }
            int startClean = start;
            int lengthClean = 0;
            int end = start + length;
            boolean checkWhite = true;
            int maxCharacter = this.m_maxCharacter;
            BitSet specialsMap = this.m_charInfo.m_specialsMap;
            int i = start;
            while (i < end) {
                char ch = chars[i];
                if (checkWhite && (ch > ' ' || ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n')) {
                    this.m_ispreserve = true;
                    checkWhite = false;
                }
                if (this.canConvert(ch) && !specialsMap.get(ch) || '\"' == ch) {
                    ++lengthClean;
                } else {
                    if (lengthClean > 0) {
                        writer.write(chars, startClean, lengthClean);
                        lengthClean = 0;
                    }
                    if (CharInfo.S_LINEFEED == ch) {
                        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                        startClean = i + 1;
                    } else {
                        startClean = this.accumDefaultEscape(ch, i, chars, end, false);
                        i = startClean - 1;
                    }
                }
                ++i;
            }
            if (lengthClean > 0) {
                writer.write(chars, startClean, lengthClean);
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.m_isprevtext = true;
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.m_inEntityRef) {
                return;
            }
            this.writeParentTagEnd();
            this.m_ispreserve = true;
            this.m_writer.write(ch, start, length);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    static final boolean isUTF16Surrogate(char c) {
        return (c & 0xFC00) == 55296;
    }

    int getURF16SurrogateValue(char c, char[] ch, int i, int end) throws SAXException {
        int next;
        if (i + 1 >= end) {
            throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c)}));
        }
        if (56320 > (next = ch[++i]) || next >= 57344) {
            throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(c) + " " + Integer.toHexString(next)}));
        }
        next = (c - 55296 << 10) + next - 56320 + 65536;
        return next;
    }

    protected int writeUTF16Surrogate(char c, char[] ch, int i, int end) throws IOException, SAXException {
        int surrogateValue = this.getURF16SurrogateValue(c, ch, i, end);
        this.m_writer.write(38);
        this.m_writer.write(35);
        this.m_writer.write(Integer.toString(surrogateValue));
        this.m_writer.write(59);
        return ++i;
    }

    void writeNormalizedChars(char[] ch, int start, int length, boolean isCData) throws IOException, SAXException {
        int end = start + length;
        int i = start;
        while (i < end) {
            String intStr;
            char c = ch[i];
            if (CharInfo.S_LINEFEED == c) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            } else if (isCData && !this.canConvert(c)) {
                if (i != 0) {
                    this.m_writer.write("]]>");
                }
                if (SerializerToXML.isUTF16Surrogate(c)) {
                    i = this.writeUTF16Surrogate(c, ch, i, end);
                } else {
                    this.m_writer.write("&#");
                    intStr = Integer.toString(c);
                    this.m_writer.write(intStr);
                    this.m_writer.write(59);
                }
                if (i != 0 && i < end - 1) {
                    this.m_writer.write("<![CDATA[");
                }
            } else if (isCData && i < end - 2 && ']' == c && ']' == ch[i + 1] && '>' == ch[i + 2]) {
                this.m_writer.write("]]]]><![CDATA[>");
                i += 2;
            } else if (this.canConvert(c)) {
                this.m_writer.write(c);
            } else if (SerializerToXML.isUTF16Surrogate(c)) {
                i = this.writeUTF16Surrogate(c, ch, i, end);
            } else {
                this.m_writer.write("&#");
                intStr = Integer.toString(c);
                this.m_writer.write(intStr);
                this.m_writer.write(59);
            }
            ++i;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (0 == length) {
            return;
        }
        this.characters(ch, start, length);
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
        this.m_inEntityRef = true;
    }

    public void endEntity(String name) throws SAXException {
        this.m_inEntityRef = false;
    }

    public void entityReference(String name) throws SAXException {
        this.writeParentTagEnd();
        if (this.shouldIndent()) {
            this.indent(this.m_currentIndent);
        }
        try {
            Writer writer = this.m_writer;
            writer.write("&");
            writer.write(name);
            writer.write(";");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        try {
            Writer writer = this.m_writer;
            if (this.m_inDoctype) {
                writer.write(" [");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            writer.write("<!ELEMENT ");
            writer.write(name);
            writer.write(32);
            writer.write(model);
            writer.write(62);
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        try {
            Writer writer = this.m_writer;
            if (this.m_inDoctype) {
                writer.write(" [");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            if (!eName.equals(this.m_elemName)) {
                writer.write("<!ATTLIST ");
                writer.write(eName);
                writer.write(" ");
                this.m_elemName = eName;
            } else {
                this.m_pos -= 3;
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
            writer.write(aName);
            writer.write(" ");
            writer.write(type);
            writer.write(" ");
            writer.write(valueDefault);
            writer.write(">");
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        try {
            if (this.m_inDoctype) {
                this.m_writer.write(" [");
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.outputEntityDecl(name, value);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int accumDefaultEntity(char ch, int i, char[] chars, int len, boolean escLF) throws SAXException {
        try {
            if (!escLF && CharInfo.S_LINEFEED == ch) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                return i + 1;
            } else {
                if (!this.m_charInfo.isSpecial(ch)) return i;
                String entityRef = this.m_charInfo.getEntityNameForChar(ch);
                if (null == entityRef) return i;
                Writer writer = this.m_writer;
                writer.write(38);
                writer.write(entityRef);
                writer.write(59);
            }
            return i + 1;
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected int accumDefaultEscape(char ch, int i, char[] chars, int len, boolean escLF) throws SAXException {
        int pos = this.accumDefaultEntity(ch, i, chars, len, escLF);
        if (i == pos) {
            ++pos;
            try {
                if ('\ud800' <= ch && ch < '\udc00') {
                    int next;
                    if (i + 1 >= len) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(ch)}));
                    }
                    if (56320 > (next = chars[++i]) || next >= 57344) {
                        throw new SAXException(XSLMessages.createXPATHMessage(65, new Object[]{Integer.toHexString(ch) + " " + Integer.toHexString(next)}));
                    }
                    next = (ch - 55296 << 10) + next - 56320 + 65536;
                    this.m_writer.write("&#");
                    this.m_writer.write(Integer.toString(next));
                    this.m_writer.write(";");
                } else if (!this.canConvert(ch) || this.m_charInfo.isSpecial(ch)) {
                    this.m_writer.write("&#");
                    this.m_writer.write(Integer.toString(ch));
                    this.m_writer.write(";");
                } else {
                    this.m_writer.write(ch);
                }
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
        return pos;
    }

    public boolean canConvert(char ch) {
        if (ch < '\u007f') {
            return ch >= ' ' || '\n' == ch || '\r' == ch || '\t' == ch;
        }
        if (null == this.m_charToByteConverter && !this.m_triedToGetConverter) {
            this.m_triedToGetConverter = true;
            try {
                this.m_charToByteConverter = Encodings.getCharToByteConverter(this.m_encoding);
                if (null != this.m_charToByteConverter) {
                    Class[] argsTypes = new Class[]{Character.TYPE};
                    Class<?> convClass = this.m_charToByteConverter.getClass();
                    this.m_canConvertMeth = convClass.getMethod("canConvert", argsTypes);
                }
            }
            catch (Exception e) {
                System.err.println("Warning: " + e.getMessage());
            }
        }
        if (null != this.m_charToByteConverter) {
            try {
                Object[] args = new Object[]{new Character(ch)};
                Boolean bool = (Boolean)this.m_canConvertMeth.invoke(this.m_charToByteConverter, args);
                return bool.booleanValue() ? !Character.isISOControl(ch) : false;
            }
            catch (InvocationTargetException ite) {
                System.err.println("Warning: InvocationTargetException in canConvert!");
            }
            catch (IllegalAccessException iae) {
                System.err.println("Warning: IllegalAccessException in canConvert!");
            }
        }
        return ch <= this.m_maxCharacter;
    }

    public void writeAttrString(String string, String encoding) throws SAXException {
        try {
            char[] stringChars = string.toCharArray();
            int len = stringChars.length;
            Writer writer = this.m_writer;
            int i = 0;
            while (i < len) {
                char ch = stringChars[i];
                if (this.canConvert(ch) && !this.m_charInfo.isSpecial(ch)) {
                    writer.write(ch);
                } else {
                    if (CharInfo.S_CARRIAGERETURN == ch && i + 1 < len && CharInfo.S_LINEFEED == stringChars[i + 1]) {
                        ++i;
                        ch = CharInfo.S_LINEFEED;
                    }
                    this.accumDefaultEscape(ch, i, stringChars, len, true);
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext;
    }

    public void printSpace(int n) throws SAXException {
        try {
            int i = 0;
            while (i < n) {
                this.m_writer.write(32);
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void indent(int n) throws SAXException {
        if (this.m_startNewLine) {
            this.outputLineSep();
        }
        if (this.m_doIndent) {
            this.printSpace(n);
        }
    }

    public void setOutputStream(OutputStream output) {
        try {
            this.init(output, this.m_format);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public OutputStream getOutputStream() {
        if (this.m_writer instanceof WriterToUTF8Buffered) {
            return ((WriterToUTF8Buffered)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToUTF8) {
            return ((WriterToUTF8)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToASCI) {
            return ((WriterToASCI)this.m_writer).getOutputStream();
        }
        return null;
    }

    public void setWriter(Writer writer) {
        this.m_writer = writer;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public void setOutputFormat(Properties format) {
        boolean shouldFlush = this.m_shouldFlush;
        this.init(this.m_writer, format, false);
        this.m_shouldFlush = shouldFlush;
    }

    public Properties getOutputFormat() {
        return this.m_format;
    }

    public ContentHandler asContentHandler() throws IOException {
        return this;
    }

    public DOMSerializer asDOMSerializer() throws IOException {
        return this;
    }

    public boolean reset() {
        return false;
    }

    public void serialize(Node node) throws IOException {
        try {
            TreeWalker walker = new TreeWalker(this, new DOM2Helper());
            walker.traverse(node);
        }
        catch (SAXException se) {
            throw new WrappedRuntimeException(se);
        }
    }
}

