/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.Enumeration;
import java.util.Vector;
import javax.jmdns.DNSConstants;
import javax.jmdns.DNSQuestion;
import javax.jmdns.DNSRecord;

final class DNSIncoming
extends DNSConstants {
    static final Vector EMPTY = new Vector();
    DatagramPacket packet;
    int off;
    int len;
    byte[] data;
    int id;
    int flags;
    int numQuestions;
    int numAnswers;
    int numAuthorities;
    int numAdditionals;
    Vector questions;
    Vector answers;

    DNSIncoming(DatagramPacket datagramPacket) throws IOException {
        this.packet = datagramPacket;
        this.data = datagramPacket.getData();
        this.len = datagramPacket.getLength();
        this.off = datagramPacket.getOffset();
        this.questions = EMPTY;
        this.answers = EMPTY;
        try {
            int n;
            this.id = this.readUnsignedShort();
            this.flags = this.readUnsignedShort();
            this.numQuestions = this.readUnsignedShort();
            this.numAnswers = this.readUnsignedShort();
            this.numAuthorities = this.readUnsignedShort();
            this.numAdditionals = this.readUnsignedShort();
            if (this.numQuestions > 0) {
                this.questions = new Vector(this.numQuestions);
                for (n = 0; n < this.numQuestions; ++n) {
                    DNSQuestion dNSQuestion = new DNSQuestion(this.readName(), this.readUnsignedShort(), this.readUnsignedShort());
                    this.questions.add(dNSQuestion);
                }
            }
            if ((n = this.numAnswers + this.numAuthorities + this.numAdditionals) > 0) {
                this.answers = new Vector(n);
                for (int i = 0; i < n; ++i) {
                    String string = this.readName();
                    int n2 = this.readUnsignedShort();
                    int n3 = this.readUnsignedShort();
                    int n4 = this.readInt();
                    int n5 = this.readUnsignedShort();
                    int n6 = this.off + n5;
                    DNSRecord dNSRecord = null;
                    switch (n2) {
                        case 1: {
                            dNSRecord = new DNSRecord.Address(string, n2, n3, n4, this.readInt());
                            break;
                        }
                        case 5: 
                        case 12: {
                            dNSRecord = new DNSRecord.Pointer(string, n2, n3, n4, this.readName());
                            break;
                        }
                        case 16: {
                            dNSRecord = new DNSRecord.Text(string, n2, n3, n4, this.readBytes(this.off, n5));
                            break;
                        }
                        case 33: {
                            dNSRecord = new DNSRecord.Service(string, n2, n3, n4, this.readUnsignedShort(), this.readUnsignedShort(), this.readUnsignedShort(), this.readName());
                        }
                    }
                    if (dNSRecord != null) {
                        this.answers.add(dNSRecord);
                    }
                    this.off = n6;
                }
            }
        }
        catch (IOException iOException) {
            this.print(true);
            throw iOException;
        }
    }

    boolean isQuery() {
        return (this.flags & 0x8000) == 0;
    }

    boolean isResponse() {
        return (this.flags & 0x8000) == 32768;
    }

    int get(int n) throws IOException {
        if (n < 0 || n >= this.len) {
            throw new IOException("parser error: offset=" + n);
        }
        return this.data[n] & 0xFF;
    }

    int readUnsignedShort() throws IOException {
        return (this.get(this.off++) << 8) + this.get(this.off++);
    }

    int readInt() throws IOException {
        return (this.readUnsignedShort() << 16) + this.readUnsignedShort();
    }

    byte[] readBytes(int n, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, n, byArray, 0, n2);
        return byArray;
    }

    void readUTF(StringBuffer stringBuffer, int n, int n2) throws IOException {
        int n3 = n + n2;
        while (n < n3) {
            int n4 = this.get(n++);
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    n4 = (n4 & 0x1F) << 6 | this.get(n++) & 0x3F;
                    break;
                }
                case 14: {
                    n4 = (n4 & 0xF) << 12 | (this.get(n++) & 0x3F) << 6 | this.get(n++) & 0x3F;
                    break;
                }
                default: {
                    n4 = (n4 & 0x3F) << 4 | this.get(n++) & 0xF;
                }
            }
            stringBuffer.append((char)n4);
        }
    }

    String readName() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.off;
        int n3 = -1;
        int n4 = n2;
        block4: while ((n = this.get(n2++)) != 0) {
            switch (n & 0xC0) {
                case 0: {
                    this.readUTF(stringBuffer, n2, n);
                    n2 += n;
                    stringBuffer.append('.');
                    continue block4;
                }
                case 192: {
                    if (n3 < 0) {
                        n3 = n2 + 1;
                    }
                    if ((n2 = (n & 0x3F) << 8 | this.get(n2++)) >= n4) {
                        throw new IOException("bad domain name: possible circular name detected");
                    }
                    n4 = n2;
                    continue block4;
                }
            }
            throw new IOException("bad domain name: '" + stringBuffer + "' at " + n2);
        }
        this.off = n3 >= 0 ? n3 : n2;
        return stringBuffer.toString();
    }

    void print(boolean bl) {
        System.out.println(this.toString());
        Enumeration enumeration = this.questions.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("    " + enumeration.nextElement());
        }
        enumeration = this.answers.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("    " + enumeration.nextElement());
        }
        if (bl) {
            int n = this.packet.getLength();
            for (int i = 0; i < n; i += 32) {
                int n2;
                int n3 = Math.min(32, n - i);
                if (i < 10) {
                    System.out.print(' ');
                }
                if (i < 100) {
                    System.out.print(' ');
                }
                System.out.print(i);
                System.out.print(':');
                for (n2 = 0; n2 < n3; ++n2) {
                    if (n2 % 8 == 0) {
                        System.out.print(' ');
                    }
                    System.out.print(Integer.toHexString((this.data[i + n2] & 0xF0) >> 4));
                    System.out.print(Integer.toHexString((this.data[i + n2] & 0xF) >> 0));
                }
                System.out.println();
                System.out.print("    ");
                for (n2 = 0; n2 < n3; ++n2) {
                    if (n2 % 8 == 0) {
                        System.out.print(' ');
                    }
                    System.out.print(' ');
                    int n4 = this.data[i + n2] & 0xFF;
                    System.out.print(n4 > 32 && n4 < 127 ? (char)n4 : (char)'.');
                }
                System.out.println();
                if (i + 32 < 256) continue;
                System.out.println("....");
                break;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.isQuery() ? "dns[query," : "dns[response,");
        stringBuffer.append(this.packet.getAddress().getHostAddress());
        stringBuffer.append(':');
        stringBuffer.append(this.packet.getPort());
        stringBuffer.append(",len=" + this.packet.getLength());
        stringBuffer.append(",id=0x" + Integer.toHexString(this.id));
        if (this.flags != 0) {
            stringBuffer.append(",flags=0x" + Integer.toHexString(this.flags));
            if ((this.flags & 0x8000) != 0) {
                stringBuffer.append(":r");
            }
            if ((this.flags & 0x400) != 0) {
                stringBuffer.append(":aa");
            }
            if ((this.flags & 0x200) != 0) {
                stringBuffer.append(":tc");
            }
        }
        if (this.numQuestions > 0) {
            stringBuffer.append(",questions=" + this.numQuestions);
        }
        if (this.numAnswers > 0) {
            stringBuffer.append(",answers=" + this.numAnswers);
        }
        if (this.numAuthorities > 0) {
            stringBuffer.append(",authorities=" + this.numAuthorities);
        }
        if (this.numAdditionals > 0) {
            stringBuffer.append(",additionals=" + this.numAdditionals);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

