/*
 * Decompiled with CFR 0.152.
 */
package com.chaotic.rendezvous;

import com.chaotic.rendezvous.BrowserListener;
import java.io.IOException;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;

public class Browser {
    public static final String DOMAIN_LOCAL = "local.";
    protected static JmDNS rendezvous = null;
    protected BrowserListener browserListener;
    protected Listener serviceListener = new Listener();

    public static synchronized JmDNS getRendezvous() throws IOException {
        if (rendezvous == null) {
            rendezvous = new JmDNS();
        }
        return rendezvous;
    }

    public Browser(BrowserListener browserListener) {
        this.browserListener = browserListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServiceSearch(String string, String string2) throws IOException {
        Browser browser = this;
        synchronized (browser) {
            this.stopServiceSearch();
            if (string2 == null) {
                string2 = DOMAIN_LOCAL;
            }
            Browser.getRendezvous().addServiceListener(string + "." + string2, this.serviceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServiceSearch() throws IOException {
        Browser browser = this;
        synchronized (browser) {
            Browser.getRendezvous().removeServiceListener(this.serviceListener);
        }
    }

    protected final class Listener
    implements ServiceListener {
        protected Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addService(JmDNS jmDNS, String string, String string2) {
            Listener listener = this;
            synchronized (listener) {
                ServiceInfo serviceInfo = new ServiceInfo(string, string2, 0, "");
                Browser.this.browserListener.serviceAdded(Browser.this, serviceInfo);
                serviceInfo = jmDNS.getServiceInfo(string, string2);
                if (serviceInfo != null) {
                    Browser.this.browserListener.serviceResolved(Browser.this, serviceInfo);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeService(JmDNS jmDNS, String string, String string2) {
            Listener listener = this;
            synchronized (listener) {
                ServiceInfo serviceInfo = new ServiceInfo(string, string2, 0, "");
                Browser.this.browserListener.serviceRemoved(Browser.this, serviceInfo);
            }
        }

        public void resolveService(JmDNS jmDNS, String string, String string2, ServiceInfo serviceInfo) {
            Browser.this.browserListener.serviceResolved(Browser.this, serviceInfo);
        }
    }
}

