/*
 * Decompiled with CFR 0.152.
 */
package com.chaotic;

import com.chaotic.PropertyList;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Preferences {
    protected static String filename = "preferences.plist";
    protected static final Object singletonLock = new Object();
    protected static Preferences userPreferences;
    public final Object lock = new Object();
    protected Map dictionary;
    protected Map defaults = new HashMap();
    protected int changeCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Preferences getPreferences() {
        Object object = singletonLock;
        synchronized (object) {
            if (userPreferences == null) {
                userPreferences = new Preferences(null);
            }
            return userPreferences;
        }
    }

    protected Preferences(String string) {
        if (string != null) {
            filename = string;
        }
        this.load();
    }

    public ArrayList getArray(String string, ArrayList arrayList) {
        return (ArrayList)this.get(string, arrayList);
    }

    public void setArray(String string, ArrayList arrayList) {
        this.set(string, arrayList);
    }

    public boolean getBoolean(String string, boolean bl) {
        Boolean bl2 = (Boolean)this.get(string, null);
        return bl2 != null ? bl2 : bl;
    }

    public void setBoolean(String string, boolean bl) {
        this.set(string, new Boolean(bl));
    }

    public byte[] getData(String string, byte[] byArray) {
        return (byte[])this.get(string, byArray);
    }

    public void setData(String string, byte[] byArray) {
        this.set(string, byArray);
    }

    public Date getDate(String string, Date date) {
        return (Date)this.get(string, date);
    }

    public void setDate(String string, Date date) {
        this.set(string, date);
    }

    public Map getDictionary(String string, Map map) {
        return (Map)this.get(string, map);
    }

    public void setDictionary(String string, Map map) {
        this.set(string, map);
    }

    public int getInteger(String string, int n) {
        Number number = (Number)this.get(string, null);
        return number != null ? number.intValue() : n;
    }

    public void setInteger(String string, int n) {
        this.set(string, new Long(n));
    }

    public double getReal(String string, double d) {
        Double d2 = (Double)this.get(string, null);
        return d2 != null ? d2 : d;
    }

    public void setReal(String string, double d) {
        this.set(string, new Double(d));
    }

    public String getString(String string, String string2) {
        return (String)this.get(string, string2);
    }

    public void setString(String string, String string2) {
        this.set(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String string) {
        Object object = this.lock;
        synchronized (object) {
            return this.dictionary.get(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String string, Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object object3 = this.dictionary.get(string);
            if (object3 == null && (object3 = this.defaults.get(string)) == null) {
                object3 = object;
            }
            if (object3 != null) {
                object3 = PropertyList.deepCopy(object3);
            }
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(String string, Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            Object object3;
            if (object != null) {
                if (!PropertyList.isCompatibleObject(object)) {
                    throw new IllegalArgumentException("object is not compatible (" + object.getClass().toString() + ")");
                }
                object3 = this.dictionary.put(string, PropertyList.deepCopy(object));
            } else {
                object3 = this.dictionary.remove(string);
            }
            ++this.changeCount;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String string) {
        Object object = this.lock;
        synchronized (object) {
            Object v = this.dictionary.remove(string);
            if (v != null) {
                ++this.changeCount;
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.changeCount > 0) {
                this.store();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(Map map) {
        Object object = this.lock;
        synchronized (object) {
            this.defaults = (Map)PropertyList.deepCopy(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.lock;
        synchronized (object) {
            try {
                File file = new File(filename);
                if (file.exists()) {
                    this.dictionary = (Map)PropertyList.readXML(new FileReader(file));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.dictionary == null) {
                this.dictionary = new HashMap();
            }
            this.changeCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        Object object = this.lock;
        synchronized (object) {
            try {
                FileWriter fileWriter = new FileWriter(new File(filename));
                PropertyList.writeXML(this.dictionary, fileWriter);
                fileWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

