/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.update;

import com.apple.gui.GUIFactory;
import com.apple.gui.IndeterminateProgressBar;
import com.apple.util.VersionNumber;
import com.apple.xsr.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class FirmwareUpdatePane
extends JPanel {
    private static final boolean DEBUG = false;
    public static final String MODE_CONFIRM = "CONFIRM";
    public static final String MODE_UPDATE = "UPDATE";
    public static final String MODE_COMPLETE = "COMPLETE";
    public static final String ACTION_CMD_UPDATE = "ACTION_CMD_UPDATE";
    public static final String ACTION_CMD_CANCEL = "ACTION_CMD_CANCEL";
    public static final String ACTION_CMD_OK = "ACTION_CMD_OK";
    private static final int MIN_WIDTH = 350;
    private static final int MAX_NAME_DISPLAY_CHARS = 50;
    private static final String UNKNOWN = Resources.getString("componentStatus.unknown");
    private static final String STRING_UP_TO_DATE = Resources.getString("fwUpdate.upToDate");
    private static final String STRING_NEEDS_UPDATE = Resources.getString("fwUpdate.needsUpdate");
    private static final String STRING_VERSION_SEPARATOR = Resources.getString("fwUpdate.versionSeparator");
    private static final String STRING_MISMATCH = Resources.getString("fwUpdate.mismatch");
    private final int DYNAMIC_CONTENT_GRID_Y_OFFSET = 4;
    private JPanel updatePanel;
    private JPanel progressPanel;
    private JPanel completePanel;
    private JButton updateButton = GUIFactory.newButton(Resources.getString("fwUpdate.updateButton"));
    private JButton cancelButton = GUIFactory.newButton(Resources.getString("fwUpdate.cancelButton"));
    private JButton okButton = GUIFactory.newButton(Resources.getString("fwUpdate.dismissButton"));
    private JCheckBox updateAllCheckBox = GUIFactory.newCheckBox(Resources.getString("fwUpdate.updateAllCheckbox"));
    private JLabel nameLabel = new JLabel();
    private JLabel coprocessorVersionLabel = new JLabel();
    private JLabel raidControllerVersionLabel = new JLabel();
    private JLabel newCoprocessorVersionLabel = new JLabel();
    private JLabel newRaidControllerVersionLabel = new JLabel();
    private JLabel statusLabel = new JLabel();
    private JLabel completionLabel = new JLabel();
    private JTextPane errorMessage = GUIFactory.newTextPane();
    private boolean confirmCompsInitialized = false;
    private JLabel updateLabel;
    private JLabel newCoprocessorVersionTitle;
    private JLabel newRaidControllerVersionTitle;
    private Box buttonPanel;
    private JPanel restartRequiredPanel;
    private String mode = "CONFIRM";
    private String statusMessage = "";
    private boolean coprocessorNeedsUpdate;
    private boolean raidControllerNeedsUpdate;
    private static final int RT_MARGIN = 0;
    private static final int LT_MARGIN = 0;
    private static final int ICON_SIZE = 64;

    public FirmwareUpdatePane(String string) {
        ImageIcon imageIcon = new ImageIcon(Resources.getImage("fwUpdate.icon"));
        if (imageIcon.getIconWidth() != 64) {
            imageIcon.setImage(imageIcon.getImage().getScaledInstance(64, 64, 4));
        }
        this.init(imageIcon, string);
    }

    public FirmwareUpdatePane(Icon icon, String string) {
        this.init(icon, string);
    }

    public void setMode(String string) {
        if (this.mode == string) {
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        if (this.mode.equals(MODE_CONFIRM)) {
            this.updatePanel.remove(this.updateLabel);
            this.updatePanel.remove(this.newCoprocessorVersionTitle);
            this.updatePanel.remove(this.newCoprocessorVersionLabel);
            this.updatePanel.remove(this.newRaidControllerVersionTitle);
            this.updatePanel.remove(this.newRaidControllerVersionLabel);
            this.updatePanel.remove(this.updateAllCheckBox);
            this.updatePanel.remove(this.restartRequiredPanel);
            this.updatePanel.remove(this.buttonPanel);
        } else if (this.mode.equals(MODE_UPDATE)) {
            this.updatePanel.remove(this.progressPanel);
        } else if (this.mode.equals(MODE_COMPLETE)) {
            this.updatePanel.remove(this.completePanel);
        }
        if (string.equals(MODE_CONFIRM)) {
            this.addConfirmModeComponents(this.updatePanel, 4, 10, 3, 5);
        } else if (string.equals(MODE_UPDATE)) {
            if (this.progressPanel == null) {
                this.progressPanel = this.createProgressPanel();
            }
            this.updatePanel.add((Component)this.progressPanel, gridBagConstraints);
        } else if (string.equals(MODE_COMPLETE)) {
            if (this.completePanel == null) {
                this.completePanel = this.createCompletePanel();
            }
            this.updatePanel.add((Component)this.completePanel, gridBagConstraints);
        }
        this.mode = string;
        this.updateStatusLabel();
        this.validate();
    }

    public String getMode() {
        return this.mode;
    }

    public void setSystemName(String string) {
        this.nameLabel.setText(string);
    }

    public void setCurrentCoprocessorVersions(String string, String string2) {
        if (string == null && string2 == null) {
            this.coprocessorVersionLabel.setText(UNKNOWN);
        } else if (string == null) {
            this.coprocessorVersionLabel.setText(UNKNOWN + STRING_VERSION_SEPARATOR + string2);
        } else if (string2 == null) {
            this.coprocessorVersionLabel.setText(string + STRING_VERSION_SEPARATOR + UNKNOWN);
        } else if (string.equals(string2)) {
            this.coprocessorVersionLabel.setText(string);
        } else {
            this.coprocessorVersionLabel.setText(string + STRING_VERSION_SEPARATOR + string2);
        }
    }

    public void setCurrentCoprocessorVersions(VersionNumber versionNumber, VersionNumber versionNumber2) {
        if (versionNumber == null && versionNumber2 == null) {
            this.coprocessorVersionLabel.setText(UNKNOWN);
        } else if (versionNumber == null) {
            this.coprocessorVersionLabel.setText(UNKNOWN + STRING_VERSION_SEPARATOR + versionNumber2);
        } else if (versionNumber2 == null) {
            this.coprocessorVersionLabel.setText(versionNumber + STRING_VERSION_SEPARATOR + UNKNOWN);
        } else if (versionNumber.equals(versionNumber2)) {
            this.coprocessorVersionLabel.setText(versionNumber + "");
        } else {
            this.coprocessorVersionLabel.setText(versionNumber + STRING_VERSION_SEPARATOR + versionNumber2);
        }
    }

    public void setCurrentRaidControllerVersions(String string, String string2) {
        if (string == null && string2 == null) {
            this.raidControllerVersionLabel.setText(UNKNOWN);
        } else if (string == null) {
            this.raidControllerVersionLabel.setText(UNKNOWN + STRING_VERSION_SEPARATOR + string2);
        } else if (string2 == null) {
            this.raidControllerVersionLabel.setText(string + STRING_VERSION_SEPARATOR + UNKNOWN);
        } else if (string.equals(string2)) {
            this.raidControllerVersionLabel.setText(string);
        } else {
            this.raidControllerVersionLabel.setText(string + STRING_VERSION_SEPARATOR + string2);
        }
    }

    public void setCurrentRaidControllerVersions(VersionNumber versionNumber, VersionNumber versionNumber2) {
        if (versionNumber == null && versionNumber2 == null) {
            this.raidControllerVersionLabel.setText(UNKNOWN);
        } else if (versionNumber == null) {
            this.raidControllerVersionLabel.setText(UNKNOWN + STRING_VERSION_SEPARATOR + versionNumber2);
        } else if (versionNumber2 == null) {
            this.raidControllerVersionLabel.setText(versionNumber + STRING_VERSION_SEPARATOR + UNKNOWN);
        } else if (versionNumber.equals(versionNumber2)) {
            this.raidControllerVersionLabel.setText(versionNumber + "");
        } else {
            this.raidControllerVersionLabel.setText(versionNumber + STRING_VERSION_SEPARATOR + versionNumber2);
        }
    }

    public void setNewCoprocessorVersion(String string) {
        this.newCoprocessorVersionLabel.setText(string);
    }

    public void setNewRaidControllerVersion(String string) {
        this.newRaidControllerVersionLabel.setText(string);
    }

    public void setCoprocessorNeedsUpdate(boolean bl) {
        this.coprocessorNeedsUpdate = bl;
        this.validateUI();
    }

    public void setRaidControllerNeedsUpdate(boolean bl) {
        this.raidControllerNeedsUpdate = bl;
        this.validateUI();
    }

    public void setStatusMessage(String string) {
        this.statusMessage = string;
        this.updateStatusLabel();
    }

    private void updateStatusLabel() {
        if (this.statusMessage == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.updateStatusLabelImpl();
        } else {
            try {
                EventQueue.invokeAndWait(new Thread(){

                    public void run() {
                        FirmwareUpdatePane.this.updateStatusLabelImpl();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateStatusLabelImpl() {
        if (this.mode.equals(MODE_CONFIRM) || this.mode.equals(MODE_UPDATE)) {
            this.statusLabel.setText(this.statusMessage);
        } else if (this.mode.equals(MODE_COMPLETE)) {
            this.completionLabel.setText(this.statusMessage);
        }
    }

    public void setErrorMessage(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.setErrorMessageImpl(string);
        } else {
            try {
                EventQueue.invokeAndWait(new Thread(){

                    public void run() {
                        FirmwareUpdatePane.this.setErrorMessageImpl(string);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setErrorMessageImpl(String string) {
        this.errorMessage.setVisible(string.length() > 0);
        this.errorMessage.setText(string);
    }

    public boolean isUpdateAllSelected() {
        return this.updateAllCheckBox.isSelected();
    }

    public JButton getUpdateButton() {
        return this.updateButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getDismissButton() {
        return this.okButton;
    }

    public JButton getDefaultButton() {
        if (this.mode.equals(MODE_CONFIRM)) {
            if (this.coprocessorNeedsUpdate || this.raidControllerNeedsUpdate) {
                return this.updateButton;
            }
            return this.cancelButton;
        }
        if (this.mode.equals(MODE_COMPLETE)) {
            return this.okButton;
        }
        return null;
    }

    public void addActionListener(ActionListener actionListener) {
        this.updateButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener);
        this.okButton.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.updateButton.removeActionListener(actionListener);
        this.cancelButton.removeActionListener(actionListener);
        this.okButton.removeActionListener(actionListener);
    }

    private void validateUI() {
        if (!(this.coprocessorNeedsUpdate || this.raidControllerNeedsUpdate || this.updateAllCheckBox.isSelected())) {
            this.updateButton.setEnabled(false);
        } else {
            this.updateButton.setEnabled(true);
        }
    }

    private void init(Icon icon, String string) {
        this.setLayout(new BorderLayout(0, 0));
        this.updatePanel = this.createUpdatePanel(icon);
        this.add((Component)this.updatePanel, "North");
        if (string != null) {
            if (string.length() <= 50) {
                this.nameLabel.setText(string);
            } else {
                this.nameLabel.setText(string.substring(0, 50) + Resources.getString("ellipsis"));
            }
        }
    }

    private JPanel createUpdatePanel(Icon icon) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = GUIFactory.newPanel(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(Box.createHorizontalStrut(350), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        JLabel jLabel = new JLabel();
        if (icon != null) {
            jLabel.setIcon(icon);
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Resources.getString("fwUpdate.systemNameTitle"));
        jLabel2.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 5, 3, 5);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.nameLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 3, 0);
        jPanel.add((Component)this.nameLabel, gridBagConstraints);
        JLabel jLabel3 = new JLabel(Resources.getString("fwUpdate.coprocessorVersionTitle"), 4);
        jLabel3.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.coprocessorVersionLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 3, 0);
        jPanel.add((Component)this.coprocessorVersionLabel, gridBagConstraints);
        JLabel jLabel4 = new JLabel(Resources.getString("fwUpdate.raidControllerVersionTitle"), 4);
        jLabel4.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        this.raidControllerVersionLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 3, 0);
        jPanel.add((Component)this.raidControllerVersionLabel, gridBagConstraints);
        this.addConfirmModeComponents(jPanel, gridBagConstraints.gridy, 10, 3, 5);
        return jPanel;
    }

    private void addConfirmModeComponents(JPanel jPanel, int n, int n2, int n3, int n4) {
        if (!this.confirmCompsInitialized) {
            this.updateLabel = new JLabel(Resources.getString("fwUpdate.updateLabel"));
            this.updateLabel.setFont(GUIFactory.FONT_SMALL);
            this.newCoprocessorVersionTitle = new JLabel(Resources.getString("fwUpdate.newCoprocessorVersionTitle"), 4);
            this.newCoprocessorVersionTitle.setFont(GUIFactory.FONT_SMALL);
            this.newCoprocessorVersionLabel.setFont(GUIFactory.FONT_SMALL);
            this.newRaidControllerVersionTitle = new JLabel(Resources.getString("fwUpdate.newRaidControllerVersionTitle"), 4);
            this.newRaidControllerVersionTitle.setFont(GUIFactory.FONT_SMALL);
            this.newRaidControllerVersionLabel.setFont(GUIFactory.FONT_SMALL);
            this.updateAllCheckBox.setFont(GUIFactory.FONT_SMALL);
            this.updateAllCheckBox.setHorizontalAlignment(2);
            this.updateAllCheckBox.setHorizontalTextPosition(4);
            this.updateAllCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FirmwareUpdatePane.this.validateUI();
                }
            });
            this.restartRequiredPanel = this.createRestartRequiredPanel();
            this.buttonPanel = Box.createHorizontalBox();
            this.cancelButton.setActionCommand(ACTION_CMD_CANCEL);
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(Box.createHorizontalStrut(12));
            this.updateButton.setActionCommand(ACTION_CMD_UPDATE);
            this.buttonPanel.add(this.updateButton);
            this.confirmCompsInitialized = true;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(n2, 0, n3, 0);
        jPanel.add((Component)this.updateLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(n3, 0, n3, n4);
        jPanel.add((Component)this.newCoprocessorVersionTitle, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(n3, n4, n3, 0);
        jPanel.add((Component)this.newCoprocessorVersionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(n3, 0, n3, n4);
        jPanel.add((Component)this.newRaidControllerVersionTitle, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(n3, n4, n3, 0);
        jPanel.add((Component)this.newRaidControllerVersionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(n2, 0, n3, 0);
        jPanel.add((Component)this.updateAllCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(n2, 4, 0, 0);
        jPanel.add((Component)this.restartRequiredPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(n2, 0, 0, 0);
        jPanel.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private JPanel createProgressPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = GUIFactory.newPanel(gridBagLayout);
        IndeterminateProgressBar indeterminateProgressBar = new IndeterminateProgressBar();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 25, 4, 25);
        jPanel.add((Component)indeterminateProgressBar, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this.statusLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 25, 10, 25);
        jPanel.add((Component)this.statusLabel, gridBagConstraints);
        return jPanel;
    }

    private JPanel createCompletePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = GUIFactory.newPanel(gridBagLayout);
        this.completionLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)this.completionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.fill = 3;
        this.errorMessage.setFont(GUIFactory.FONT_SMALL);
        this.errorMessage.setOpaque(false);
        this.errorMessage.setEditable(false);
        jPanel.add((Component)this.errorMessage, gridBagConstraints);
        this.errorMessage.setVisible(this.errorMessage.getText() != null && this.errorMessage.getText().length() > 0);
        gridBagConstraints.fill = 0;
        this.okButton.setActionCommand(ACTION_CMD_OK);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)this.okButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel createRestartRequiredPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = GUIFactory.newPanel(gridBagLayout);
        JLabel jLabel = new JLabel(new ImageIcon(Resources.getImage("icon.restart")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(Resources.getString("fwUpdate.restartRequired"));
        jLabel2.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel(new ImageIcon(Resources.getImage("icon.validate")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel(Resources.getString("fwUpdate.operationCannotBeStopped"));
        jLabel4.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        return jPanel;
    }

    public static void main(String[] stringArray) {
    }
}

