/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.EmailNotifications;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.RaidSystem;
import java.net.UnknownHostException;

public class SystemController
extends AbstractSystemElement
implements Comparable {
    public static final int AUDIBLE_ALARM_DISABLED = 0;
    public static final int AUDIBLE_ALARM_ENABLED = 1;
    public static final int AUTO_REBOOT_DISABLED = 0;
    public static final int AUTO_REBOOT_ENABLED = 1;
    public static final int SNMP_DISABLED = 0;
    public static final int SNMP_ENABLED = 1;
    public static final String DISABLE_NTP_SERVER = ".";
    private int id;
    private String systemName = "";
    private String systemDnsName = "";
    private String systemPresentationName = "";
    private String systemContact = "";
    private String systemDescription = "";
    private String systemLocation = "";
    private String systemVersion = "";
    private String rendezvousName = "";
    private int uptime = -1;
    private int autoRebootState = -1;
    private int audibleAlarmState = 1;
    private int snmpState = -1;
    private IPAddress smtpServer;
    private String ntpServer;
    private int ambientTemp = -1;
    private int tempStatus = -1;
    private NetworkInterface networkInterface;
    RaidSystem system;
    private EmailNotifications notificationsData;

    public SystemController(int n, RaidSystem raidSystem) {
        this.id = n;
        this.system = raidSystem;
        this.networkInterface = new NetworkInterface(1, this);
    }

    public SystemController(SystemController systemController) {
        this.id = systemController.id;
        this.systemName = systemController.systemName;
        this.systemDnsName = systemController.systemDnsName;
        this.systemPresentationName = systemController.systemPresentationName;
        this.systemContact = systemController.systemContact;
        this.systemDescription = systemController.systemDescription;
        this.systemLocation = systemController.systemLocation;
        this.systemVersion = systemController.systemVersion;
        this.rendezvousName = systemController.rendezvousName;
        this.uptime = systemController.uptime;
        this.autoRebootState = systemController.autoRebootState;
        this.audibleAlarmState = systemController.audibleAlarmState;
        this.snmpState = systemController.snmpState;
        this.smtpServer = systemController.smtpServer;
        this.ntpServer = systemController.ntpServer;
        this.ambientTemp = systemController.ambientTemp;
        this.tempStatus = systemController.tempStatus;
        this.networkInterface = new NetworkInterface(systemController.networkInterface);
        this.notificationsData = systemController.notificationsData;
        this.system = systemController.system;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "System Controller " + this.id;
    }

    public int getStatus() {
        int n = this.tempStatus;
        return n;
    }

    void setSystemName(String string) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.systemName = string;
    }

    public String getSystemName() {
        return this.systemName;
    }

    void setSystemDnsName(String string) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.systemDnsName = string;
    }

    public String getSystemDnsName() {
        return this.systemDnsName;
    }

    void setSystemPresentationName(String string) {
        if (string == null) {
            throw new NullPointerException("presentation name cannot be null");
        }
        this.systemPresentationName = string;
        this.system.setName(string);
    }

    public String getSystemPresentationName() {
        return this.systemPresentationName;
    }

    void setSystemContact(String string) {
        this.systemContact = string;
        this.system.setContact(string);
    }

    public String getSystemContact() {
        return this.systemContact;
    }

    void setSystemDescription(String string) {
        this.systemDescription = string;
        this.system.setDescription(string);
    }

    public String getSystemDescription() {
        return this.systemDescription;
    }

    void setSystemLocation(String string) {
        this.systemLocation = string;
        this.system.setLocation(string);
    }

    public String getSystemLocation() {
        return this.systemLocation;
    }

    void setSystemVersion(String string) {
        this.systemVersion = string;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    void setRendezvousName(String string) {
        this.rendezvousName = string;
    }

    public String getRendezvousName() {
        return this.rendezvousName;
    }

    void setUpTime(int n) {
        this.uptime = n;
    }

    public int getUpTime() {
        return this.uptime;
    }

    void setAutoRebootState(int n) {
        this.autoRebootState = n;
        this.system.setAutoRebootState(n);
    }

    public int getAutoRebootState() {
        return this.autoRebootState;
    }

    void setTemperatureStatus(int n) {
        this.tempStatus = n;
    }

    void setAmbientTemperature(int n) {
        this.ambientTemp = n;
    }

    public int getAmbientTemperature() {
        return this.ambientTemp;
    }

    void setAudibleAlarmState(int n) {
        this.audibleAlarmState = n;
        this.system.setAudibleAlarmState(n);
    }

    public int getAudibleAlarmState() {
        return this.audibleAlarmState;
    }

    void setSnmpState(int n) {
        if (this.snmpState != n) {
            this.snmpState = n;
        }
    }

    public int getSnmpState() {
        return this.snmpState;
    }

    void setSmtpServerAddress(String string) throws UnknownHostException {
        this.smtpServer = new IPAddress(string);
    }

    public IPAddress getSmtpServerAddress() {
        return this.smtpServer;
    }

    void setNtpServerAddress(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("ntp server address must be non-null");
        }
        this.ntpServer = string;
    }

    public String getNtpServerAddress() {
        return this.ntpServer;
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public void setEmailNotificationsData(EmailNotifications emailNotifications) {
        this.notificationsData = emailNotifications;
    }

    public EmailNotifications getEmailNotificationsData() {
        return this.notificationsData;
    }

    public int compareTo(Object object) {
        SystemController systemController = (SystemController)object;
        return this.id - systemController.id;
    }

    public String paramString() {
        String string = "";
        string = string + "id=" + this.id + ",";
        string = string + "systemName=" + this.systemName + ",";
        string = string + "systemDnsName=" + this.systemDnsName + ",";
        string = string + "systemPresentationName=" + this.systemPresentationName + ",";
        string = string + "systemContact=" + this.systemContact + ",";
        string = string + "systemDescription=" + this.systemDescription + ",";
        string = string + "systemLocation=" + this.systemLocation + ",";
        string = string + "systemVersion=" + this.systemVersion + ",";
        string = string + "rendezvousName=" + this.rendezvousName + ",";
        string = string + "uptime=" + this.uptime + ",";
        string = string + "autoRebootState=" + this.autoRebootState + ",";
        string = string + "tempStatus=" + this.tempStatus + ",";
        string = string + "ambientTemp=" + this.ambientTemp + ",";
        string = string + "audibleAlarmState=" + this.audibleAlarmState + ",";
        string = string + "snmpState=" + this.snmpState + ",";
        string = string + "smtpServer=" + this.smtpServer + ",";
        string = string + "ntpServer=" + this.ntpServer;
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }
}

