/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.net.acp.AcpEventLog;
import com.apple.net.acp.AcpPropertyCode;
import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.util.plist.PropertyListUtilities;
import com.apple.xsr.EmailNotifications;
import com.apple.xsr.LunMaskSetting;
import com.apple.xsr.OperationManager;
import com.apple.xsr.net.AcpxCommandException;
import com.apple.xsr.net.AcpxConstants;
import com.apple.xsr.net.AcpxMessageFactory;
import com.apple.xsr.net.CommShutdownException;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.CommunicationsManager;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.Battery;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.Fan;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.HostInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.PowerSupply;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.Slice;
import com.apple.xsr.som.SystemController;
import java.io.IOException;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

class RaidSystemAgent
extends Thread {
    static final long DEFAULT_POLLING_DELAY = 15000L;
    static final RequestMessage.Target TARGET_MASTER = RequestMessage.Target.MASTER;
    static final RequestMessage.Target TARGET_COMPANION = RequestMessage.Target.COMPANION;
    static final RequestMessage.Target TARGET_TOP = RequestMessage.Target.TOP;
    static final RequestMessage.Target TARGET_BOTTOM = RequestMessage.Target.BOTTOM;
    private static final AcpPropertyCode[] properties = new AcpPropertyCode[]{AcpPropertyCode.SYS_NAME, AcpPropertyCode.SYS_DNS_NAME, AcpPropertyCode.SYS_PRESENTATION_NAME, AcpPropertyCode.SYS_CONTACT, AcpPropertyCode.SYS_DESCRIPTION, AcpPropertyCode.SYS_LOCATION, AcpPropertyCode.SYS_VERSION, AcpPropertyCode.SYS_PASSWORD_RO, AcpPropertyCode.SYS_GUEST_PASSWORD, AcpPropertyCode.SYS_UP_TIME, AcpPropertyCode.SYS_FLAGS, AcpPropertyCode.LAN_MAC_ADDRESS, AcpPropertyCode.LAN_CONFIGURE_VIA, AcpPropertyCode.LAN_IP_ADDRESS, AcpPropertyCode.LAN_SUBNET_MASK, AcpPropertyCode.LAN_ROUTER_ADDRESS, AcpPropertyCode.WAN_CURRENT_DNS_1, AcpPropertyCode.WAN_CURRENT_DNS_2, AcpPropertyCode.WAN_CURRENT_DNS_3, AcpPropertyCode.LAN_DHCP_CLIENT_ID, AcpPropertyCode.LAN_INTERFACE_STATE, AcpPropertyCode.SMTP_SERVER, AcpPropertyCode.NTP_CONFIG, AcpPropertyCode.SNMP_ACCESS_FLAGS, AcpPropertyCode.SERVER_MODE, AcpPropertyCode.EFFECT_FLAGS, AcpPropertyCode.EMAIL_NOTIFICATION};
    private RaidSystem system;
    private CommunicationsManager comms;
    private MessageFactory msgFactory;
    private long pollDelay = 15000L;
    private boolean pollingEnabled = true;
    private boolean stopped = false;
    private boolean updateImmediately = false;
    private boolean sleeping = false;
    private final Object POLL_MONITOR = new Object();
    private List page1SlotsArray;
    private List lunList;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$som$RaidSystemAgent == null ? (class$com$apple$xsr$som$RaidSystemAgent = RaidSystemAgent.class$("com.apple.xsr.som.RaidSystemAgent")) : class$com$apple$xsr$som$RaidSystemAgent);
    private final String hostAddress;
    static /* synthetic */ Class class$com$apple$xsr$som$RaidSystemAgent;

    public RaidSystemAgent(RaidSystem raidSystem) {
        this.setName("Agent");
        this.system = raidSystem;
        this.comms = raidSystem.getCommunicationsManager();
        this.hostAddress = this.system.getHostAddress();
        this.msgFactory = new AcpxMessageFactory();
    }

    public synchronized void connect(CommunicationHandler communicationHandler, String string, String string2) {
        ((AcpxMessageFactory)this.msgFactory).setDefaultUser(string);
        ((AcpxMessageFactory)this.msgFactory).setDefaultPassword(string2);
        RequestMessage requestMessage = this.msgFactory.newGetPropertiesRequest(properties);
        requestMessage.setTargetController(null);
        DelegateHandler delegateHandler = new DelegateHandler(communicationHandler){

            public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
                int n = response.getResultCode();
                try {
                    if (n == 0) {
                        RaidSystemAgent.this.updateStandbyProperties((PropertyList)response.getContent());
                        RaidSystemAgent.this.completeClientRequest(this.principal);
                        return;
                    }
                    if (n == -16 || n == -27 || n == -28) {
                        logger.warn("Connect failed due to bad credentials (" + n + ")");
                    } else if (n == -101) {
                        logger.warn("Connection failure (" + n + ")");
                        RaidSystemAgent.this.updateConnectionFailure();
                    } else {
                        logger.warn("Unexpected response (" + n + ") for get-props while connecting");
                    }
                }
                catch (Exception exception) {
                    logger.error(exception);
                    RaidSystemAgent.this.updateCommunicationsError();
                }
                if (this.principal != null) {
                    this.principal.handleResponse(raidSystem, response, object);
                }
            }
        };
        logger.info(this.hostAddress + " -> Sending connect message");
        this.comms.postMessageAsync(delegateHandler, requestMessage);
    }

    public synchronized void authenticate(CommunicationHandler communicationHandler, String string, String string2) {
        RequestMessage requestMessage = this.msgFactory.newGetPropertiesRequest(properties);
        requestMessage.setTargetController(null);
        requestMessage.setUser(string);
        requestMessage.setPassword(string2);
        if (string.equals("guest")) {
            ((AcpxMessageFactory)this.msgFactory).setDefaultUser(string);
            ((AcpxMessageFactory)this.msgFactory).setDefaultPassword(string2);
        }
        DelegateHandler delegateHandler = new DelegateHandler(communicationHandler){

            public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
                int n = response.getResultCode();
                try {
                    if (n == 0) {
                        RaidSystemAgent.this.updateStandbyProperties((PropertyList)response.getContent());
                        RaidSystemAgent.this.completeClientRequest(this.principal);
                        return;
                    }
                    if (n == -16 || n == -27 || n == -28) {
                        logger.warn("Authentication failed due to bad credentials (" + n + ")");
                    } else if (n == -101) {
                        logger.warn("Authentication failure (" + n + ")");
                        RaidSystemAgent.this.updateConnectionFailure();
                    } else {
                        logger.warn("Unexpected response (" + n + ") for get-props while authenticating");
                    }
                }
                catch (Exception exception) {
                    logger.error(exception);
                    RaidSystemAgent.this.updateCommunicationsError();
                }
                if (this.principal != null) {
                    this.principal.handleResponse(raidSystem, response, object);
                }
            }
        };
        logger.info(this.hostAddress + " -> Sending authentication message");
        this.comms.postMessageAsync(delegateHandler, requestMessage);
    }

    private void completeClientRequest(CommunicationHandler communicationHandler) {
        RequestMessage requestMessage = this.msgFactory.newGetPowerStateRequest();
        requestMessage.setTargetController(null);
        DelegateHandler delegateHandler = new DelegateHandler(communicationHandler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
                int n = response.getResultCode();
                try {
                    block11: {
                        try {
                            if (n == 0) {
                                RaidSystemAgent.this.updatePowerState((PropertyList)response.getContent());
                                RaidSystemAgent.this.setPollingEnabled(true);
                                if (RaidSystemAgent.this.isAlive()) break block11;
                                RaidSystemAgent raidSystemAgent = RaidSystemAgent.this;
                                synchronized (raidSystemAgent) {
                                    RaidSystemAgent.this.stopped = false;
                                }
                                RaidSystemAgent.this.start();
                                break block11;
                            }
                            logger.warn("Got error response (" + n + ") for get-power-state " + "while completing connect/authenticate");
                        }
                        catch (Exception exception) {
                            logger.error(exception);
                            Object var8_9 = null;
                            if (this.principal != null) {
                                this.principal.handleResponse(raidSystem, response, object);
                            }
                        }
                    }
                    Object var8_8 = null;
                    if (this.principal != null) {
                        this.principal.handleResponse(raidSystem, response, object);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (this.principal != null) {
                        this.principal.handleResponse(raidSystem, response, object);
                    }
                    throw throwable;
                }
            }
        };
        logger.info(this.hostAddress + " -> Completing connect/authentication request");
        this.comms.postMessageAsync(delegateHandler, requestMessage);
    }

    public synchronized void updateImmediately() {
        if (this.isPollingEnabled() && this.sleeping) {
            this.updateImmediately = true;
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollingEnabled(boolean bl) {
        Object object = this.POLL_MONITOR;
        synchronized (object) {
            if (this.pollingEnabled != bl) {
                this.pollingEnabled = bl;
                this.POLL_MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPollingEnabled() {
        Object object = this.POLL_MONITOR;
        synchronized (object) {
            return this.pollingEnabled;
        }
    }

    public synchronized boolean isPolling() {
        return !this.sleeping;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public void setPollDelay(int n) {
        this.pollDelay = (long)n * 1000L;
        logger.info("Poll delay set to " + this.pollDelay);
    }

    public int getPollDelay() {
        return (int)(this.pollDelay / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int n = 0;
        while (!this.isStopped()) {
            logger.info("**************************************** " + ++n + " ****************************************");
            try {
                RaidSystemAgent raidSystemAgent;
                Object var8_10;
                Object object;
                Object object2 = this.POLL_MONITOR;
                synchronized (object2) {
                    block33: {
                        try {
                            while (!this.pollingEnabled) {
                                this.POLL_MONITOR.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.isStopped()) break block33;
                            logger.error("Interrupted while waiting for polling to be reenabled: " + interruptedException);
                        }
                    }
                    if (this.isStopped()) break;
                }
                this.system.notifyUpdateStarted();
                this.doPowerStateUpdate();
                if (this.system.getPowerState() == 1) {
                    this.doThermalUpdate();
                    this.doSystemControllerUpdate();
                    this.doTimeUpdate();
                    this.doEventLogUpdate();
                    this.doDeviceUpdate();
                    object2 = this.system.getRaidController(1);
                    object = this.system.getRaidController(2);
                    if (((RaidController)object2).getReadyState() == 1 && ((RaidController)object).getReadyState() == 1) {
                        this.system.setUserMessageIndex(0);
                    } else if (((RaidController)object2).getReadyState() == 0 || ((RaidController)object).getReadyState() == 0) {
                        this.system.setUserMessageIndex(10);
                    }
                    if (((RaidController)object2).getReadyState() == 1) {
                        this.doRaidControllerUpdate(1);
                    }
                    if (((RaidController)object).getReadyState() == 1) {
                        this.doRaidControllerUpdate(2);
                    }
                } else {
                    this.system.setUserMessageIndex(6);
                    this.doStandbyUpdate();
                }
                this.system.setChanged();
                this.system.notifyUpdateFinished();
                if (this.isStopped()) break;
                try {
                    try {
                        object2 = this;
                        synchronized (object2) {
                            this.sleeping = true;
                        }
                        RaidSystemAgent.sleep(this.pollDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        object = this;
                        synchronized (object) {
                            if (this.updateImmediately) {
                                this.updateImmediately = false;
                            } else if (!this.isStopped()) {
                                logger.error("Interrupted while sleeping between polls: " + interruptedException);
                            }
                        }
                        var8_10 = null;
                        raidSystemAgent = this;
                        synchronized (raidSystemAgent) {
                            this.sleeping = false;
                            continue;
                        }
                    }
                    var8_10 = null;
                    raidSystemAgent = this;
                }
                catch (Throwable throwable) {
                    var8_10 = null;
                    raidSystemAgent = this;
                    synchronized (raidSystemAgent) {
                        this.sleeping = false;
                        throw throwable;
                    }
                }
                synchronized (raidSystemAgent) {
                    this.sleeping = false;
                }
            }
            catch (AuthenticationException authenticationException) {
                logger.error(authenticationException);
                this.system.notifyUpdateFinished();
                this.setPollingEnabled(false);
                this.system.setUserMessageIndex(11);
                this.system.setPowerState(-1);
                this.system.setChanged();
            }
            catch (ConnectException connectException) {
                logger.error(connectException);
                this.updateConnectionFailure();
                this.system.notifyUpdateFinished();
                this.setPollingEnabled(false);
            }
            catch (CommShutdownException commShutdownException) {
                logger.info("Caught communication shutdown exception");
                this.system.notifyUpdateFinished();
                break;
            }
            catch (Exception exception) {
                logger.error(exception);
                this.system.setUserMessageIndex(5);
                this.system.notifyUpdateFinished();
            }
        }
        logger.info(this.hostAddress + " ->  ** Terminating Updates **");
    }

    public synchronized void terminate() {
        this.shutdown();
    }

    public synchronized void shutdown() {
        this.stopped = true;
        this.setPollingEnabled(true);
    }

    MessageFactory getMessageFactory() {
        return this.msgFactory;
    }

    private void doPowerStateUpdate() throws IOException {
        RequestMessage requestMessage = this.msgFactory.newGetPowerStateRequest();
        requestMessage.setTargetController(null);
        try {
            Response response = this.comms.postMessage(requestMessage);
            if (response.getResultCode() == 0) {
                this.updatePowerState((PropertyList)response.getContent());
            } else if (response.getResultCode() == -16) {
                throw new AuthenticationException("authentication failure attempting to get power state");
            }
        }
        catch (PropertyListException propertyListException) {
            logger.error(propertyListException);
        }
    }

    private void doStandbyUpdate() throws IOException {
        RequestMessage requestMessage = this.msgFactory.newGetPropertiesRequest(properties);
        requestMessage.setTargetController(null);
        try {
            Response response = this.comms.postMessage(requestMessage);
            this.updateStandbyProperties((PropertyList)response.getContent());
        }
        catch (AcpxCommandException acpxCommandException) {
            logger.error(acpxCommandException);
        }
        catch (PropertyListException propertyListException) {
            logger.error(propertyListException);
        }
    }

    private void doSystemControllerUpdate() throws IOException {
        SystemController systemController = this.system.getSystemController(1);
        SystemController systemController2 = this.system.getSystemController(2);
        try {
            RequestMessage requestMessage = this.msgFactory.newGetPropertiesRequest(properties);
            requestMessage.setTargetController(TARGET_TOP);
            Response response = this.comms.postMessage(requestMessage);
            requestMessage.setTargetController(TARGET_BOTTOM);
            Response response2 = this.comms.postMessage(requestMessage);
            requestMessage = this.msgFactory.newGetStatusRequest();
            requestMessage.setTargetController(TARGET_TOP);
            Response response3 = this.comms.postMessage(requestMessage);
            requestMessage.setTargetController(TARGET_BOTTOM);
            Response response4 = this.comms.postMessage(requestMessage);
            this.updateSystemController(systemController, (PropertyList)response.getContent());
            this.updateSystemStatus(systemController, (PropertyList)response3.getContent());
            this.updateSystemController(systemController2, (PropertyList)response2.getContent());
            this.updateSystemStatus(systemController2, (PropertyList)response4.getContent());
            this.updateUpsStatus((PropertyList)response3.getContent(), (PropertyList)response4.getContent());
        }
        catch (AcpxCommandException acpxCommandException) {
            logger.error(acpxCommandException);
        }
        catch (PropertyListException propertyListException) {
            logger.error(propertyListException);
        }
    }

    private void doTimeUpdate() throws IOException {
        RequestMessage requestMessage = this.msgFactory.newGetTimeRequest();
        requestMessage.setTargetController(null);
        try {
            Response response = this.comms.postMessage(requestMessage);
            this.updateSystemTime((PropertyList)response.getContent());
        }
        catch (AcpxCommandException acpxCommandException) {
            logger.error(acpxCommandException);
        }
        catch (PropertyListException propertyListException) {
            logger.error(propertyListException);
        }
    }

    private void doEventLogUpdate() throws IOException {
        PropertyList propertyList;
        Response response;
        Date date;
        AcpEventLog.Event event;
        SimpleDateFormat simpleDateFormat;
        boolean bl;
        boolean bl2;
        RequestMessage requestMessage = null;
        RequestMessage.Target target = null;
        SystemController systemController = this.system.getSystemController(1);
        SystemController systemController2 = this.system.getSystemController(2);
        try {
            bl2 = OperationManager.isSupported(this.system, 1, OperationManager.OP_READ_EVENT_LOG);
        }
        catch (Exception exception) {
            bl2 = true;
            logger.error("Error determining top event log support: " + exception);
        }
        try {
            bl = OperationManager.isSupported(this.system, 1, OperationManager.OP_READ_EVENT_LOG);
        }
        catch (Exception exception) {
            bl = true;
            logger.error("Error determining bottom event log support: " + exception);
        }
        if (logger.isInfoEnabled()) {
            simpleDateFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            simpleDateFormat = null;
        }
        if (systemController != null && bl2) {
            event = null;
            date = null;
            target = RequestMessage.TARGET_TOP;
            event = this.system.getEventLog().getLastEvent(systemController.getId());
            if (event != null) {
                date = event.getTime();
                if (logger.isInfoEnabled()) {
                    logger.info("Getting top events > " + simpleDateFormat.format(date));
                }
            }
            requestMessage = this.msgFactory.newGetEventLogRequest(date);
            requestMessage.setTargetController(target);
            try {
                response = this.comms.postMessage(requestMessage);
                propertyList = (PropertyList)response.getContent();
                this.updateEventLog(systemController, propertyList);
            }
            catch (AcpxCommandException acpxCommandException) {
                logger.error(acpxCommandException);
            }
            catch (PropertyListException propertyListException) {
                logger.error(propertyListException);
            }
        }
        if (systemController2 != null && bl) {
            event = null;
            date = null;
            target = RequestMessage.TARGET_BOTTOM;
            event = this.system.getEventLog().getLastEvent(systemController2.getId());
            if (event != null) {
                date = event.getTime();
                if (logger.isInfoEnabled()) {
                    logger.info("Getting bottom events > " + simpleDateFormat.format(date));
                }
            }
            requestMessage = this.msgFactory.newGetEventLogRequest(date);
            requestMessage.setTargetController(target);
            try {
                response = this.comms.postMessage(requestMessage);
                propertyList = (PropertyList)response.getContent();
                this.updateEventLog(systemController2, propertyList);
            }
            catch (AcpxCommandException acpxCommandException) {
                logger.error(acpxCommandException);
            }
            catch (PropertyListException propertyListException) {
                logger.error(propertyListException);
            }
        }
    }

    private void doDeviceUpdate() throws IOException {
        Response response;
        RequestMessage requestMessage;
        try {
            requestMessage = this.msgFactory.newGetDevicePropertiesRequest("keylock", null);
            requestMessage.setTargetController(TARGET_TOP);
            response = this.comms.postMessage(requestMessage);
            this.updateLockState((PropertyList)response.getContent());
        }
        catch (AcpxCommandException acpxCommandException) {
            logger.error(acpxCommandException);
        }
        catch (PropertyListException propertyListException) {
            logger.error(propertyListException);
        }
        try {
            Integer n = new Integer(1);
            requestMessage = this.msgFactory.newGetDevicePropertiesRequest("power-supply", n);
            response = this.comms.postMessage(requestMessage);
            this.updatePowerSupply(1, (PropertyList)response.getContent());
            n = new Integer(2);
            requestMessage = this.msgFactory.newGetDevicePropertiesRequest("power-supply", n);
            response = this.comms.postMessage(requestMessage);
            this.updatePowerSupply(2, (PropertyList)response.getContent());
        }
        catch (AcpxCommandException acpxCommandException) {
            logger.error(acpxCommandException);
        }
        catch (PropertyListException propertyListException) {
            logger.error(propertyListException);
        }
        try {
            requestMessage = this.msgFactory.newGetDevicePropertiesRequest("battery", null);
            requestMessage.setTargetController(TARGET_TOP);
            response = this.comms.postMessage(requestMessage);
            this.updateBattery(1, (PropertyList)response.getContent());
            requestMessage = this.msgFactory.newGetDevicePropertiesRequest("battery", null);
            requestMessage.setTargetController(TARGET_BOTTOM);
            response = this.comms.postMessage(requestMessage);
            this.updateBattery(2, (PropertyList)response.getContent());
        }
        catch (AcpxCommandException acpxCommandException) {
            logger.error(acpxCommandException);
        }
        catch (PropertyListException propertyListException) {
            logger.error(propertyListException);
        }
        try {
            requestMessage = this.msgFactory.newGetDevicePropertiesRequest("blower", null);
            requestMessage.setTargetController(TARGET_TOP);
            response = this.comms.postMessage(requestMessage);
            this.updateFan(1, (PropertyList)response.getContent());
            requestMessage = this.msgFactory.newGetDevicePropertiesRequest("blower", null);
            requestMessage.setTargetController(TARGET_BOTTOM);
            response = this.comms.postMessage(requestMessage);
            this.updateFan(2, (PropertyList)response.getContent());
        }
        catch (AcpxCommandException acpxCommandException) {
            logger.error(acpxCommandException);
        }
        catch (PropertyListException propertyListException) {
            logger.error(propertyListException);
        }
    }

    private void doRaidControllerUpdate(int n) throws IOException {
        Response response;
        RequestMessage requestMessage;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        this.page1SlotsArray = null;
        this.lunList = null;
        RaidController raidController = this.system.getRaidController(n);
        RequestMessage.Target target = n == 1 ? TARGET_TOP : TARGET_BOTTOM;
        try {
            bl = OperationManager.isSupported(this.system, OperationManager.OP_DELETE_ORPHAN);
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        try {
            requestMessage = this.msgFactory.newGetControllerPageRequest(AcpxConstants.CONTROLLER_INFO);
            requestMessage.setTargetController(target);
            response = this.comms.postMessage(requestMessage);
            this.processPage0(raidController, (PropertyList)response.getContent());
            bl2 = true;
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        try {
            requestMessage = this.msgFactory.newGetControllerPageRequest(AcpxConstants.RAID_INFO);
            requestMessage.setTargetController(target);
            response = this.comms.postMessage(requestMessage);
            this.processPage1(raidController, (PropertyList)response.getContent());
            bl3 = true;
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        try {
            requestMessage = this.msgFactory.newGetControllerPageRequest(AcpxConstants.CONTROLLER_SLOT_PAGE_1);
            requestMessage.setTargetController(target);
            response = this.comms.postMessage(requestMessage);
            this.updateDisks(raidController, (PropertyList)response.getContent());
            bl5 = true;
        }
        catch (Exception exception) {
            logger.error(exception);
        }
        if (bl) {
            try {
                requestMessage = this.msgFactory.newGetControllerPageRequest(new Integer(32));
                requestMessage.setTargetController(target);
                response = this.comms.postMessage(requestMessage);
                this.processPage32(raidController, (PropertyList)response.getContent());
                bl4 = true;
            }
            catch (Exception exception) {
                logger.error(exception);
            }
        } else {
            logger.info("Skipping page 32. Coprocessor below minimum version (" + OperationManager.OP_DELETE_ORPHAN + ").");
        }
        if (this.page1SlotsArray != null) {
            try {
                this.updatePage1Slots(raidController, this.page1SlotsArray);
            }
            catch (PropertyListException propertyListException) {
                logger.error(propertyListException);
            }
        }
        if (this.lunList != null) {
            try {
                this.updateLunMap(raidController, this.lunList);
            }
            catch (PropertyListException propertyListException) {
                logger.error(propertyListException);
            }
        }
    }

    private void doThermalUpdate() throws IOException {
        SystemController systemController = this.system.getSystemController(1);
        SystemController systemController2 = this.system.getSystemController(2);
        RequestMessage requestMessage = this.msgFactory.newGetTemperatureRequest("ambient");
        try {
            requestMessage.setTargetController(TARGET_TOP);
            Response response = this.comms.postMessage(requestMessage);
            this.updateThermal(systemController, (PropertyList)response.getContent());
            requestMessage.setTargetController(TARGET_BOTTOM);
            response = this.comms.postMessage(requestMessage);
            this.updateThermal(systemController2, (PropertyList)response.getContent());
        }
        catch (AcpxCommandException acpxCommandException) {
            logger.error(acpxCommandException);
        }
        catch (PropertyListException propertyListException) {
            logger.error(propertyListException);
        }
    }

    private int updatePowerState(PropertyList propertyList) throws PropertyListException {
        logger.info(this.hostAddress + " -> Updating power state");
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "power-state-get root dict");
        Map map2 = PListUtils.toDictionary(map.get("power-state-get"), "power-state-get command dict");
        int n = PListUtils.toInteger(map2.get("power-state"), "power-state").intValue();
        if (n == 1) {
            this.system.setPowerState(1);
        } else if (n == 0) {
            this.system.setPowerState(0);
        } else {
            String string = "Unknown power state \"" + n + "\"";
            logger.error(string);
        }
        return n;
    }

    private int updateStandbyProperties(PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        logger.info(this.hostAddress + " -> Updating standby ACP properties");
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "get-properties root dict");
        Object v = map.get("status");
        if (v != null) {
            int n = PListUtils.toInteger(v, "get-properties status").intValue();
            if (n == -16) {
                return n;
            }
            if (n == -28) {
                return n;
            }
            String string = "ACP error for \"get-properties\" command (status = " + n + ")";
            logger.error(string);
            throw new AcpxCommandException(string);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Map map2 = PListUtils.toDictionary(entry.getValue(), "get-properties property dict");
            int n = this.getCommandStatus(map2);
            if (n != 0) {
                if (n == -10) {
                    logger.warn("Unknown ACP property \"" + string + "\" (status = " + n + ")");
                    continue;
                }
                object = "ACP error for property \"" + string + "\" (status = " + n + ")";
                logger.error(object);
            }
            if ((object = map2.get("data")) == null) {
                logger.warn("ACP property \"" + string + "\" has no data");
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_PRESENTATION_NAME + "")) {
                this.system.setName(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_CONTACT + "")) {
                this.system.setContact(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_DESCRIPTION + "")) {
                this.system.setDescription(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_LOCATION + "")) {
                this.system.setLocation(PListUtils.toString(object, string));
                continue;
            }
            if (!string.equals(AcpPropertyCode.SYS_UP_TIME + "")) continue;
            this.system.setUpTime(PListUtils.toInteger(object, string).intValue());
        }
        return 0;
    }

    private void updateSystemController(SystemController systemController, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        int n;
        logger.info(this.hostAddress + " -> Updating ACP properties for " + systemController.getName());
        NetworkInterface networkInterface = systemController.getNetworkInterface();
        String[] stringArray = new String[3];
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "get-properties root dict");
        Object v = map.get("status");
        if (v != null && (n = PListUtils.toInteger(v, "get-properties status").intValue()) != 0) {
            String string = "ACP error for \"get-properties\" command (status = " + n + ")";
            logger.error(string);
            throw new AcpxCommandException(string);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Map map2 = PListUtils.toDictionary(entry.getValue(), "get-properties property dict");
            int n2 = this.getCommandStatus(map2);
            if (n2 != 0) {
                if (n2 == -10) {
                    logger.warn("Unknown ACP property \"" + string + "\" (status = " + n2 + ")");
                    continue;
                }
                object = "ACP error for property \"" + string + "\" (status = " + n2 + ")";
                logger.error(object);
            }
            if ((object = map2.get("data")) == null) {
                logger.warn("ACP property \"" + string + "\" has no data");
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_NAME + "")) {
                systemController.setSystemName(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_DNS_NAME + "")) {
                systemController.setSystemDnsName(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_PRESENTATION_NAME + "")) {
                systemController.setSystemPresentationName(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_CONTACT + "")) {
                systemController.setSystemContact(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_DESCRIPTION + "")) {
                systemController.setSystemDescription(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_LOCATION + "")) {
                systemController.setSystemLocation(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_VERSION + "")) {
                systemController.setSystemVersion(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_PASSWORD_RO + "") || string.equals(AcpPropertyCode.SYS_GUEST_PASSWORD + "")) continue;
            if (string.equals(AcpPropertyCode.SYS_UP_TIME + "")) {
                systemController.setUpTime(PListUtils.toInteger(object, string).intValue());
                continue;
            }
            if (string.equals(AcpPropertyCode.SYS_FLAGS + "")) {
                int n3 = PListUtils.toInteger(object, string).intValue();
                boolean bl = (n3 & 0x4000) != 0;
                boolean bl2 = (n3 & 0x2000) != 0;
                boolean bl3 = (n3 & 0x1000) != 0;
                continue;
            }
            if (string.equals(AcpPropertyCode.LAN_MAC_ADDRESS + "")) {
                networkInterface.setMacAddress(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.LAN_CONFIGURE_VIA + "")) {
                int n4 = PListUtils.toInteger(object, string).intValue();
                if ((n4 & 0x200) != 0) {
                    networkInterface.setConfigurationMethod(512);
                    continue;
                }
                if ((n4 & 0x400) != 0) {
                    networkInterface.setConfigurationMethod(1024);
                    continue;
                }
                if ((n4 & 0x2000) != 0) {
                    networkInterface.setConfigurationMethod(8192);
                    continue;
                }
                networkInterface.setConfigurationMethod(-1);
                logger.warn("Unknown network interface configuration method \"" + n4 + "\"");
                continue;
            }
            if (string.equals(AcpPropertyCode.LAN_IP_ADDRESS + "")) {
                String string2 = PListUtils.toString(object, string);
                try {
                    logger.info(this.hostAddress + " setting " + networkInterface.getName() + " to " + string2);
                    networkInterface.setAddress(string2);
                    logger.info(this.hostAddress + " -> Comparing primary address " + this.system.getPrimaryHostAddress() + " to " + string2);
                    if (new IPAddress(string2).equals(new IPAddress(this.system.getPrimaryHostAddress()))) continue;
                    logger.info(this.hostAddress + " -> Setting secondary host address " + string2);
                    this.system.setSecondaryHostAddress(string2);
                }
                catch (UnknownHostException unknownHostException) {
                    logger.error("Failed to set LAN IP address : " + unknownHostException);
                }
                continue;
            }
            if (string.equals(AcpPropertyCode.LAN_SUBNET_MASK + "")) {
                try {
                    networkInterface.setSubnetMask(PListUtils.toString(object, string));
                }
                catch (UnknownHostException unknownHostException) {
                    logger.error("Failed to set LAN subnet mask : " + unknownHostException);
                }
                continue;
            }
            if (string.equals(AcpPropertyCode.LAN_ROUTER_ADDRESS + "")) {
                try {
                    networkInterface.setGateway(PListUtils.toString(object, string));
                }
                catch (UnknownHostException unknownHostException) {
                    logger.error("Failed to set LAN router address : " + unknownHostException);
                }
                continue;
            }
            if (string.equals(AcpPropertyCode.WAN_CURRENT_DNS_1 + "")) {
                stringArray[0] = PListUtils.toString(object, string);
                continue;
            }
            if (string.equals(AcpPropertyCode.WAN_CURRENT_DNS_2 + "")) {
                stringArray[1] = PListUtils.toString(object, string);
                continue;
            }
            if (string.equals(AcpPropertyCode.WAN_CURRENT_DNS_3 + "")) {
                stringArray[2] = PListUtils.toString(object, string);
                continue;
            }
            if (string.equals(AcpPropertyCode.LAN_DHCP_CLIENT_ID + "")) {
                networkInterface.setDhcpClientId(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.LAN_INTERFACE_STATE + "")) {
                int n5 = PListUtils.toInteger(object, string).intValue();
                int n6 = n5 & 0xFF;
                if (n6 == 1) {
                    networkInterface.setSpeed(0);
                } else if (n6 == 2) {
                    networkInterface.setSpeed(1);
                } else if (n6 == 3) {
                    networkInterface.setSpeed(2);
                } else if (n6 == 0) {
                    networkInterface.setSpeed(-1);
                } else {
                    networkInterface.setSpeed(-1);
                    logger.warn("Unknown network interface speed \"" + n6 + "\"");
                }
                int n7 = n5 & 0x100;
                networkInterface.setLinkState(n7 != 0 ? 1 : 0);
                int n8 = n5 & 0x200;
                networkInterface.setDuplex(n8 != 0 ? 1 : 0);
                continue;
            }
            if (string.equals(AcpPropertyCode.SMTP_SERVER + "")) {
                try {
                    systemController.setSmtpServerAddress(PListUtils.toString(object, string));
                }
                catch (UnknownHostException unknownHostException) {
                    logger.error("Failed to set SMTP server address : " + unknownHostException);
                }
                continue;
            }
            if (string.equals(AcpPropertyCode.NTP_CONFIG + "")) {
                systemController.setNtpServerAddress(PListUtils.toString(object, string));
                continue;
            }
            if (string.equals(AcpPropertyCode.SNMP_ACCESS_FLAGS + "")) {
                int n9 = PListUtils.toInteger(object, string).intValue();
                int n10 = (n9 & 2) != 0 ? 0 : 1;
                systemController.setSnmpState(n10);
                continue;
            }
            if (string.equals(AcpPropertyCode.SERVER_MODE + "")) {
                int n11 = PListUtils.toInteger(object, string).intValue();
                systemController.setAutoRebootState(n11 == 1 ? 1 : 0);
                continue;
            }
            if (string.equals(AcpPropertyCode.EFFECT_FLAGS + "")) {
                int n12 = PListUtils.toInteger(object, string).intValue();
                systemController.setAudibleAlarmState((n12 & 1) != 0 ? 0 : 1);
                continue;
            }
            if (string.equals(AcpPropertyCode.EMAIL_NOTIFICATION + "")) {
                StringReader stringReader = new StringReader(PListUtils.toString(object, string));
                Object object2 = null;
                try {
                    object2 = PropertyListUtilities.readXML(stringReader);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object2 == null || !(object2 instanceof List)) continue;
                List list = (List)object2;
                Map map3 = PListUtils.toDictionary(list.get(0));
                EmailNotifications emailNotifications = EmailNotifications.fromMap(map3);
                systemController.setEmailNotificationsData(emailNotifications);
                continue;
            }
            logger.warn("unrecognized ACP property \"" + string + "\" = \"" + object + "\"");
        }
        try {
            networkInterface.setDns(stringArray);
        }
        catch (UnknownHostException unknownHostException) {
            logger.error("Failed to DNS addresses : " + unknownHostException);
        }
    }

    private void updateSystemStatus(SystemController systemController, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Object object;
        Object object2;
        int n = systemController.getId();
        RaidController raidController = this.system.getRaidController(n);
        FibreChannelInterface fibreChannelInterface = (FibreChannelInterface)raidController.getHostInterface(1);
        Fan fan = this.system.getFan(n);
        Battery battery = this.system.getBattery(n);
        PowerSupply powerSupply = this.system.getPowerSupply(n);
        logger.info(this.hostAddress + " -> Updating system status for " + systemController.getName());
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "/system/get-system-status root dict");
        List list = PListUtils.toArray(map.get("responses"), "/system/get-system-status response array");
        Map map2 = PListUtils.toDictionary(list.get(0), "/system/get-system-status response dict");
        String string = PListUtils.toString(map2.get("method"), "method");
        if (!"/system/get-system-status".equals(string)) {
            String string2 = "Response method \"" + string + "\" does not match command \"" + "/system/get-system-status" + "\"";
            logger.error(string2);
            throw new AcpxCommandException(string2);
        }
        int n2 = this.getCommandStatus(map2);
        if (n2 != 0) {
            String string3 = "ACP error for \"/system/get-system-status\" command (status = " + n2 + ")";
            logger.error(string3);
            throw new AcpxCommandException(string3);
        }
        Map map3 = PListUtils.toDictionary(map2.get("outputs"), "/system/get-system-status outputs dict");
        Map map4 = PListUtils.toDictionary(map3.get("status"), "status");
        Map map5 = PListUtils.toDictionary(map4.get("raid-controller"), "raid-controller");
        String string4 = PListUtils.toString(map5.get("fibre-link-state"), "fibre-link-state");
        if (string4.equalsIgnoreCase("down")) {
            fibreChannelInterface.setLinkState(0);
        } else if (string4.equalsIgnoreCase("up")) {
            fibreChannelInterface.setLinkState(1);
        } else {
            logger.warn("Unknown power Fibre Channel link state \"" + string4 + "\"");
            fibreChannelInterface.setLinkState(-1);
        }
        string4 = PListUtils.toString(map5.get("state"), "state");
        logger.info(this.hostAddress + " -> RAID controller ready state \"" + string4 + "\"");
        if (string4.equalsIgnoreCase("on")) {
            raidController.setReadyState(1);
        } else if (string4.equalsIgnoreCase("off")) {
            raidController.setReadyState(0);
        } else {
            logger.warn("Unknown RAID controller ready state \"" + string4 + "\"");
        }
        Map map6 = PListUtils.toDictionary(map4.get("enclosure"), "enclosure");
        String string5 = PListUtils.toString(map6.get("xsync-state"), "xsync-state");
        if (string5.equalsIgnoreCase("master")) {
            string4 = PListUtils.toString(map6.get("service-id"), "service-id");
            logger.info(this.hostAddress + " -> Service ID \"" + string4 + "\"");
            if (string4.equalsIgnoreCase("on")) {
                this.system.setServiceIdState(1);
            } else if (string4.equalsIgnoreCase("off")) {
                this.system.setServiceIdState(0);
            } else {
                logger.warn("Unknown service ID state \"" + string4 + "\"");
                this.system.setServiceIdState(-1);
            }
        }
        List list2 = PListUtils.toArray(map4.get("smart"), "smart");
        Object object3 = list2.iterator();
        while (object3.hasNext()) {
            Map map7 = PListUtils.toDictionary(object3.next(), "smart dict");
            int n3 = PListUtils.toInteger(map7.get("drive-id"), "drive-id").intValue();
            string4 = PListUtils.toString(map7.get("state"), "state");
            int n4 = PListUtils.toInteger(map7.get("status"), "status").intValue();
            if (string4.equalsIgnoreCase("slot-is-empty") || n4 != 0) continue;
            object2 = raidController.getDisk(n3);
            if (object2 == null) {
                String string6 = "Failed to retrieve disk ID " + n3 + " from " + raidController.getName() + "while processing SMART.";
                logger.error(string6);
                continue;
            }
            logger.info(this.hostAddress + " -> Updating SMART status for " + ((Disk)object2).getName() + " = " + string4);
            if (string4.equalsIgnoreCase("drive-tested-ok")) {
                ((Disk)object2).setSmartStatus(0);
            } else if (string4.equalsIgnoreCase("threshold-exceeded")) {
                ((Disk)object2).setSmartStatus(2);
            } else if (string4.equalsIgnoreCase("controller-not-ready") || string4.equalsIgnoreCase("slot-state-unknown") || string4.equalsIgnoreCase("slot-failed-error") || string4.equalsIgnoreCase("slot-enabled-smart")) {
                ((Disk)object2).setSmartStatus(-1);
            } else {
                logger.warn("Unrecognized SMART status (" + n4 + ")");
            }
            try {
                object = PListUtils.toData(map7.get("smart-data"), "smart-data");
            }
            catch (PropertyListException propertyListException) {
                logger.warn("Could not retrieve smart data.");
                object = null;
            }
            ((Disk)object2).setSmartData((byte[])object);
        }
        object3 = PListUtils.toDictionary(map4.get("monitor"), "monitor");
        boolean bl = false;
        Iterator iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            int n5;
            Map.Entry entry = iterator.next();
            object2 = (String)entry.getKey();
            object = entry.getValue();
            string4 = PListUtils.toString(object, (String)object2);
            if (string4.equalsIgnoreCase("ok")) {
                n5 = 0;
            } else if (string4.equalsIgnoreCase("bad")) {
                n5 = 2;
                bl = true;
            } else {
                n5 = -1;
                logger.warn("Unknown monitor state \"" + string4 + "\"");
            }
            logger.info(this.hostAddress + " -> Monitored property \"" + (String)object2 + "\" = " + string4);
            if (((String)object2).equalsIgnoreCase("emu-temperature")) {
                systemController.setTemperatureStatus(n5);
                continue;
            }
            if (((String)object2).equalsIgnoreCase("blower-speed")) {
                if (fan == null) continue;
                fan.setSpeedStatus(n5);
                continue;
            }
            if (((String)object2).equalsIgnoreCase("raid-controller-temperature")) {
                if (raidController == null) continue;
                raidController.setTemperatureStatus(n5);
                continue;
            }
            if (((String)object2).equalsIgnoreCase("blower-temperature")) continue;
            if (((String)object2).equalsIgnoreCase("battery")) {
                if (battery == null) continue;
                battery.setStatus(n5);
                continue;
            }
            if (((String)object2).equalsIgnoreCase("ambient-temperature") || ((String)object2).equalsIgnoreCase("drive-temperature") || ((String)object2).equalsIgnoreCase("raid-communication") || ((String)object2).equalsIgnoreCase("smart") || !((String)object2).equalsIgnoreCase("power-supply")) continue;
        }
        if (bl) {
            this.system.setEmailNotificationStatus(1);
        }
    }

    private void updateUpsStatus(PropertyList propertyList, PropertyList propertyList2) throws PropertyListException {
        int[] nArray = new int[2];
        for (int i = 0; i < nArray.length; ++i) {
            PropertyList propertyList3 = i == 0 ? propertyList : propertyList2;
            Map map = PListUtils.toDictionary(propertyList3.getRootElement(), "/system/get-system-status root dict");
            List list = PListUtils.toArray(map.get("responses"), "/system/get-system-status response array");
            Map map2 = PListUtils.toDictionary(list.get(0), "/system/get-system-status response dict");
            Map map3 = PListUtils.toDictionary(map2.get("outputs"), "/system/get-system-status outputs dict");
            Map map4 = PListUtils.toDictionary(map3.get("status"), "status");
            if (map4.containsKey("ups")) {
                Map map5 = PListUtils.toDictionary(map4.get("ups"), "ups");
                boolean bl = PListUtils.toBoolean(map5.get("battery-in-use"), "battery-in-use");
                boolean bl2 = PListUtils.toBoolean(map5.get("battery-is-low"), "battery-is-low");
                boolean bl3 = PListUtils.toBoolean(map5.get("line-power-is-down"), "line-power-is-down");
                nArray[i] = -1;
                if (bl || bl3) {
                    nArray[i] = 0;
                }
                if (!bl2) continue;
                nArray[i] = 1;
                continue;
            }
            logger.error(this.hostAddress + " -> ERROR - no \"ups\" dictionary found in the " + (i == 0 ? "top" : "bottom") + " system status response plist");
        }
        if (nArray[0] == 1 || nArray[1] == 1) {
            this.system.setUpsStatus(1);
            logger.info(this.hostAddress + " -> Setting UPS status to UPS_POWER_FAILURE");
        } else if (nArray[0] == 0 || nArray[1] == 0) {
            this.system.setUpsStatus(0);
            logger.info(this.hostAddress + " -> Setting UPS status to UPS_POWER_FAILURE");
        } else {
            this.system.setUpsStatus(-1);
        }
    }

    private void updateSystemTime(PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "get-rtc root dict");
        Map map2 = PListUtils.toDictionary(map.get("get-rtc"), "get-rtc command dict");
        int n = this.getCommandStatus(map2);
        if (n != 0) {
            String string = "ACP error for \"get-rtc\" command (status = " + n + ")";
            throw new AcpxCommandException(string);
        }
        Date date = PListUtils.toDate(map2.get("rtc"), "rtc");
        this.system.setTimeOffset(new Date().getTime() - date.getTime());
        logger.info(this.hostAddress + " -> Xserve RAID Time " + date);
    }

    private void updateDisks(RaidController raidController, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Object object;
        logger.info(this.hostAddress + " -> Processing slot page 1 for " + raidController.getName());
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "get-page root dict");
        Map map2 = PListUtils.toDictionary(map.get("get-page"), "get-page command dict");
        int n = this.getCommandStatus(map2);
        if (n != 0) {
            String string = "ACP error for \"get-page\" command (status = " + n + ")";
            logger.error(string);
            throw new AcpxCommandException(string);
        }
        List list = PListUtils.toArray(map2.get("slots"), "slots");
        HashSet<Disk> hashSet = new HashSet<Disk>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = PListUtils.toDictionary(iterator.next(), "slot dict");
            int n2 = PListUtils.toInteger(object.get("id"), "id").intValue();
            Disk disk = raidController.getDisk(n2);
            if (disk == null) {
                String string = "Disk ID " + n2 + " not found";
                logger.error(string);
                throw new Error(string);
            }
            this.updateDisk(disk, (Map)object);
            raidController.getDiskSlot(n2).setPopulated(true);
            hashSet.add(disk);
        }
        iterator = raidController.getDisks().iterator();
        while (iterator.hasNext()) {
            object = (Disk)iterator.next();
            DiskSlot diskSlot = raidController.getDiskSlot(((Disk)object).getNativeId());
            if (hashSet.contains(object) || ((Disk)object).getState() == -2) continue;
            ((Disk)object).clear();
            ((Disk)object).setState(-2);
            diskSlot.setPopulated(false);
            logger.info(this.hostAddress + " -> Clearing " + ((Disk)object).getName());
        }
    }

    private void updateDisk(Disk disk, Map map) throws PropertyListException {
        logger.info(this.hostAddress + " -> Updating " + disk.getName());
        disk.setModel(PListUtils.toString(map.get("disk-vendor-id"), "disk-vendor-id"));
        disk.setRevision(PListUtils.toString(map.get("disk-firmware-version"), "disk-firmware-version"));
        disk.setCapacity(PListUtils.toInteger(map.get("disk-sector-capacity"), "disk-sector-capacity").intValue());
        disk.setBadBlockCount(PListUtils.toInteger(map.get("disk-bad-block-count"), "disk-bad-block-count").intValue());
        disk.setRemappedBlockCount(PListUtils.toInteger(map.get("disk-remap-count"), "disk-remap-count").intValue());
    }

    private void updateLockState(PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Map map = this.getCommandDictionary(propertyList, "get-device-properties");
        String string = PListUtils.toString(map.get("state"), "state");
        if (string.equals("locked")) {
            this.system.setLockState(1);
        } else if (string.equals("unlocked")) {
            this.system.setLockState(0);
        } else {
            logger.error("Unrecognized lock state \"" + string + "\"");
        }
    }

    private void updatePowerSupply(int n, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Map map = this.getCommandDictionary(propertyList, "get-device-properties");
        int n2 = PListUtils.toInteger(map.get("id"), "id").intValue();
        if (n != n2) {
            String string = "Power supply ID returned in response (" + n2 + ") does not match requested ID (" + n + ")";
            logger.error(string);
            throw new AcpxCommandException(string);
        }
        PowerSupply powerSupply = this.system.getPowerSupply(n);
        if (powerSupply == null) {
            String string = "Power supply ID " + n + " does not exist";
            logger.error(string);
            throw new Error(string);
        }
        String string = PListUtils.toString(map.get("state"), "state");
        if (string.equalsIgnoreCase("okay")) {
            powerSupply.setStatus(0);
        } else if (string.equalsIgnoreCase("predictive-failure")) {
            powerSupply.setStatus(1);
        } else if (string.equalsIgnoreCase("failed")) {
            powerSupply.setStatus(2);
        } else {
            logger.warn("Unknown power supply state \"" + string + "\"");
            powerSupply.setStatus(-1);
        }
    }

    private void updateBattery(int n, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Battery battery;
        Map map = this.getCommandDictionary(propertyList, "get-device-properties");
        Battery battery2 = this.system.getBattery(n);
        boolean bl = PListUtils.toBoolean(map.get("present"), "present");
        if (bl) {
            int n2;
            boolean bl2 = false;
            if (battery2 == null) {
                battery2 = new Battery(n);
                bl2 = true;
            }
            if (map.containsKey("charging")) {
                n2 = PListUtils.toBoolean(map.get("charging"), "charging").booleanValue();
                battery2.setIsCharging(n2 != 0);
            } else {
                battery2.setIsCharging(true);
            }
            n2 = PListUtils.toInteger(map.get("charge-percentage"), "charge-percentage").intValue();
            battery2.setChargePercent(n2);
            if (bl2) {
                this.system.addBattery(battery2);
            }
        } else if (battery2 != null && (battery = this.system.removeBattery(n)) == null) {
            logger.error("Attempt to remove battery ID " + n + " failed");
        }
    }

    private void updateFan(int n, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Fan fan;
        Map map = this.getCommandDictionary(propertyList, "get-device-properties");
        Fan fan2 = this.system.getFan(n);
        boolean bl = PListUtils.toBoolean(map.get("present"), "present");
        if (bl) {
            boolean bl2 = false;
            if (fan2 == null) {
                fan2 = new Fan(n);
                bl2 = true;
            }
            int n2 = PListUtils.toInteger(map.get("rpm"), "rpm").intValue();
            fan2.setRpm(n2);
            if (bl2) {
                this.system.addFan(fan2);
            }
        } else if (fan2 != null && (fan = this.system.removeFan(n)) == null) {
            logger.error("Attempt to remove fan ID " + n + " failed");
        }
    }

    private void updateSystemControllerLocation(SystemController systemController, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Map map = this.getCommandDictionary(propertyList, "get-device-properties");
        String string = PListUtils.toString(map.get("location"), "location");
        if (!(string.equals("top") || string.equals("bottom") || string.equals("unknown"))) {
            String string2 = "Unrecognized system controller location \"" + string + "\"";
            logger.error(string2);
        }
    }

    private void updateDiskHandle(int n, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Disk disk;
        Map map = this.getCommandDictionary(propertyList, "get-device-properties");
        RaidController raidController = this.system.getRaidControllerForDiskSlot(n);
        if (raidController != null && (disk = raidController.getDisk(n)) != null) {
            String string = PListUtils.toString(map.get("handle-state"), "handle-state");
            if (string.equalsIgnoreCase("open")) {
                disk.setHandleState(0);
            } else if (string.equalsIgnoreCase("closed")) {
                disk.setHandleState(1);
            } else {
                logger.warn("Unknown disk handle state \"" + string + "\"");
            }
        }
    }

    private void processPage0(RaidController raidController, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        List list = null;
        List list2 = null;
        List list3 = null;
        FibreChannelInterface fibreChannelInterface = (FibreChannelInterface)raidController.getHostInterface(1);
        logger.info(this.hostAddress + " -> Processing RAID controller page 0 for " + raidController.getName());
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "get-page root dict");
        Map map2 = PListUtils.toDictionary(map.get("get-page"), "get-page command dict");
        int n = this.getCommandStatus(map2);
        if (n != 0) {
            String string = "ACP error for \"get-page\" command (status = " + n + ")";
            logger.error(string);
            throw new AcpxCommandException(string);
        }
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null) {
                logger.warn("raid controller property \"" + v + "\" has no data");
                continue;
            }
            if (string.equals("id")) continue;
            if (string.equals("production-id")) {
                raidController.setProductId(PListUtils.toString(v, string));
                continue;
            }
            if (string.equals("model-name")) {
                raidController.setModelName(PListUtils.toString(v, string));
                continue;
            }
            if (string.equals("serial-number")) {
                raidController.setSerialNumber(PListUtils.toString(v, string));
                continue;
            }
            if (string.equals("stripe-size")) {
                raidController.setStripeSize(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("write-buffer-enabled")) {
                boolean bl = PListUtils.toBoolean(v, string);
                raidController.setWriteCacheState(bl ? 1 : 0);
                continue;
            }
            if (string.equals("host-interface-count")) {
                raidController.setHostInterfaceCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("drive-channel-count")) {
                raidController.setDiskChannelCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("slot-count")) {
                raidController.setSlotCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("memory-size")) {
                raidController.setMemorySize(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("cache-hit-ratio")) {
                raidController.setCacheHitRatio(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("ready-state")) continue;
            if (string.equals("client-count")) {
                raidController.setClientCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("firmware-version")) {
                raidController.setFirmwareVersion(PListUtils.toString(v, string));
                continue;
            }
            if (string.equals("fibre-channel-mac-address")) {
                fibreChannelInterface.setWorldWidePortName(PListUtils.toString(v, string));
                continue;
            }
            if (string.equals("access-mode")) {
                String string2 = PListUtils.toString(v, string);
                if (string2.equalsIgnoreCase("sequential")) {
                    raidController.setAccessMode(0);
                    continue;
                }
                if (string2.equalsIgnoreCase("random")) {
                    raidController.setAccessMode(1);
                    continue;
                }
                raidController.setAccessMode(-1);
                logger.warn("unknown RAID controller access mode  \"" + string2 + "\"");
                continue;
            }
            if (string.equals("prefetch-size")) {
                raidController.setPrefetchSize(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("auto-rebuild-enabled")) {
                raidController.setAutoRebuildEnabled(PListUtils.toBoolean(v, string));
                continue;
            }
            if (string.equals("rebuild-rate")) {
                raidController.setRebuildRate(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("check-data-generation-enabled")) {
                raidController.setCheckDataGenerationEnabled(PListUtils.toBoolean(v, string));
                continue;
            }
            if (string.equals("lun-mask-enabled")) {
                int n2 = PListUtils.toBoolean(v, string) != false ? 1 : 0;
                raidController.setLunMaskEnabled(n2);
                continue;
            }
            if (string.equals("jbod-mask-enabled")) {
                raidController.setJbodMaskEnabled(PListUtils.toBoolean(v, string));
                continue;
            }
            if (string.equals("jbod-enabled")) {
                raidController.setJbodModeState(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("diagnostic-function-status")) {
                String string3 = PListUtils.toString(v, string);
                if (string3.equalsIgnoreCase("ready")) {
                    raidController.setDiagnosticFunctionStatus(1);
                    continue;
                }
                raidController.setDiagnosticFunctionStatus(-1);
                continue;
            }
            if (string.equals("protocol-error-count")) {
                fibreChannelInterface.setProtocolErrorCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("invalid-transmission-word-count")) {
                fibreChannelInterface.setInvalidTransmissionWordCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("invalid-crc-count")) {
                fibreChannelInterface.setInvalidCyclicRedundancyCodeCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("loss-of-signal-count")) {
                fibreChannelInterface.setLossOfSignalCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("loss-of-sync-count")) {
                fibreChannelInterface.setLossOfSyncCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("link-failure-count")) {
                fibreChannelInterface.setLinkFailureCount(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("bgrw-threshold")) {
                raidController.setBackgroundConditioningPriority(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("slow-read-bypass-mode")) {
                raidController.setSlowReadBypassModeState(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("synchronize-cache-mode")) {
                raidController.setSyncCacheState(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("drive-channels")) {
                list = PListUtils.toArray(v, string);
                continue;
            }
            if (string.equals("host-interfaces")) {
                list2 = PListUtils.toArray(v, string);
                continue;
            }
            if (string.equals("lun-masks")) {
                list3 = PListUtils.toArray(v, string);
                continue;
            }
            logger.warn("unrecognized RAID controller property \"" + string + "\" = \"" + v + "\"");
        }
        if (list != null) {
            this.updateDiskChannels(raidController, list, raidController.getDiskChannelCount());
        } else {
            logger.warn("\"drive-channels\" property was not encountered");
        }
        if (list2 != null) {
            this.updateHostInterfaces(raidController, list2, raidController.getHostInterfaceCount());
        } else {
            logger.warn("\"host-interfaces\" property was not encountered");
        }
        if (list3 != null) {
            this.updateLunMasks(raidController, list3);
        } else {
            logger.warn("\"lun-masks\" property was not encountered");
        }
    }

    private void updateDiskChannels(RaidController raidController, List list, int n) throws PropertyListException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            Map map = PListUtils.toDictionary(iterator.next(), "channel dict");
            int n2 = PListUtils.toInteger(map.get("id"), "id").intValue();
            if (n2 > n) continue;
            DiskSlot diskSlot = raidController.getDiskSlot(n2);
            if (diskSlot == null) {
                object = "disk slot " + n2 + " not found";
                logger.error(object);
                throw new Error((String)object);
            }
            object = map.get("dma-mode");
            if (object != null) {
                diskSlot.setDmaMode(PListUtils.toInteger(object, "dma-mode").intValue());
            }
            if ((object = map.get("ultra-dma-mode")) != null) {
                diskSlot.setUltraDmaMode(PListUtils.toInteger(object, "ultra-dma-mode").intValue());
            }
            logger.info(this.hostAddress + " -> Disk channel " + n2 + " mode = " + object);
        }
    }

    private void updateHostInterfaces(RaidController raidController, List list, int n) throws PropertyListException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map = PListUtils.toDictionary(iterator.next(), "host interface dict");
            int n2 = PListUtils.toInteger(map.get("id"), "id").intValue();
            if (n2 > n) continue;
            HostInterface hostInterface = raidController.getHostInterface(n2);
            if (hostInterface == null) {
                logger.warn("host interface ID " + n2 + " not found");
                continue;
            }
            this.updateHostInterface(hostInterface, map);
        }
    }

    private void updateHostInterface(HostInterface hostInterface, Map map) throws PropertyListException {
        if (hostInterface == null) {
            throw new NullPointerException("host interface cannot be null");
        }
        if (map == null) {
            throw new NullPointerException("interface dictionary cannot be null");
        }
        if (!(hostInterface instanceof FibreChannelInterface)) {
            String string = "Only Fibre Channel host interfaces are supported: " + hostInterface.getClass();
            logger.fatal(string);
            throw new Error(string);
        }
        FibreChannelInterface fibreChannelInterface = (FibreChannelInterface)hostInterface;
        logger.info(this.hostAddress + " -> Updating " + fibreChannelInterface.getName());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (string.equals("id") || string.equals("type")) continue;
            if (string.equals("hard-loop-id")) {
                fibreChannelInterface.setHardLoopId(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("hard-loop-id-enabled")) {
                boolean bl = PListUtils.toBoolean(v, string);
                if (bl) {
                    fibreChannelInterface.setHardLoopIdEnabled(1);
                    continue;
                }
                fibreChannelInterface.setHardLoopIdEnabled(0);
                continue;
            }
            if (string.equals("topology")) {
                String string2 = PListUtils.toString(v, string);
                if (string2.equalsIgnoreCase("arbitrated-loop")) {
                    fibreChannelInterface.setTopology(0);
                    continue;
                }
                if (string2.equalsIgnoreCase("point-to-point")) {
                    fibreChannelInterface.setTopology(1);
                    continue;
                }
                if (string2.equalsIgnoreCase("auto")) {
                    fibreChannelInterface.setTopology(2);
                    continue;
                }
                fibreChannelInterface.setTopology(-1);
                logger.warn("unknown Fibre Channel topology \"" + string2 + "\"");
                continue;
            }
            if (string.equals("actual-topology")) {
                String string3 = PListUtils.toString(v, string);
                if (string3.equalsIgnoreCase("arbitrated-loop")) {
                    fibreChannelInterface.setActualTopology(0);
                    continue;
                }
                if (string3.equalsIgnoreCase("point-to-point")) {
                    fibreChannelInterface.setActualTopology(1);
                    continue;
                }
                fibreChannelInterface.setActualTopology(-1);
                logger.warn("unknown Fibre Channel topology \"" + string3 + "\"");
                continue;
            }
            if (string.equals("speed")) {
                String string4 = PListUtils.toString(v, string);
                if (string4.equalsIgnoreCase("auto-negotiated")) {
                    fibreChannelInterface.setSpeed(0);
                    continue;
                }
                if (string4.equalsIgnoreCase("1Gb/sec")) {
                    fibreChannelInterface.setSpeed(1);
                    continue;
                }
                if (string4.equalsIgnoreCase("2Gb/sec")) {
                    fibreChannelInterface.setSpeed(2);
                    continue;
                }
                fibreChannelInterface.setSpeed(-1);
                logger.warn("unknown Fibre Channel speed \"" + string4 + "\"");
                continue;
            }
            if (string.equals("actual-speed")) {
                String string5 = PListUtils.toString(v, string);
                if (string5.equalsIgnoreCase("1Gb/sec")) {
                    fibreChannelInterface.setActualSpeed(1);
                    continue;
                }
                if (string5.equalsIgnoreCase("2Gb/sec")) {
                    fibreChannelInterface.setActualSpeed(2);
                    continue;
                }
                fibreChannelInterface.setActualSpeed(-1);
                logger.warn("unknown Fibre Channel speed \"" + string5 + "\"");
                continue;
            }
            if (string.equals("max-speed")) {
                String string6 = PListUtils.toString(v, string);
                if (string6.equalsIgnoreCase("1Gb/sec")) {
                    fibreChannelInterface.setMaximumSpeed(1);
                    continue;
                }
                if (string6.equalsIgnoreCase("2Gb/sec")) {
                    fibreChannelInterface.setMaximumSpeed(2);
                    continue;
                }
                fibreChannelInterface.setMaximumSpeed(-1);
                logger.warn("unknown Fibre Channel maximum speed \"" + string6 + "\"");
                continue;
            }
            if (string.equals("lun-map")) {
                this.lunList = PListUtils.toArray(v, string);
                continue;
            }
            logger.warn("Unrecognized host interface property  \"" + string + "\" = \"" + v + "\"");
        }
    }

    private void updateLunMasks(RaidController raidController, List list) throws PropertyListException {
        logger.info(this.hostAddress + " -> Updating LUN masks");
        FibreChannelInterface fibreChannelInterface = (FibreChannelInterface)raidController.getHostInterface(1);
        ArrayList<LunMaskSetting> arrayList = new ArrayList<LunMaskSetting>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map = PListUtils.toDictionary(iterator.next(), "mask dict");
            Integer n = new Integer(PListUtils.toInteger(map.get("id"), "id").intValue());
            String string = PListUtils.toString(map.get("fibre-channel-mac-address"), "fibre-channel-mac-address");
            List list2 = PListUtils.toArray(map.get("lun-ids"), "lun-ids");
            LunMaskSetting lunMaskSetting = new LunMaskSetting(n, string, list2);
            arrayList.add(lunMaskSetting);
            logger.info("    Mask " + n + " wwn=" + string + ", LUN's=" + list2);
        }
        fibreChannelInterface.setLunMaskList(arrayList);
    }

    private void processPage1(RaidController raidController, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        logger.info(this.hostAddress + " -> Processing RAID controller page 1 for " + raidController.getName());
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "get-page root dict");
        Map map2 = PListUtils.toDictionary(map.get("get-page"), "get-page command dict");
        int n = this.getCommandStatus(map2);
        if (n != 0) {
            String string = "ACP error for \"get-page\" command (status = " + n + ")";
            logger.error(string);
            throw new AcpxCommandException(string);
        }
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map map3;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null) {
                logger.warn("raid controller property \"" + v + "\" has no data");
                continue;
            }
            if (string.equals("id")) continue;
            if (string.equals("controller")) {
                map3 = PListUtils.toDictionary(v, string);
                Map map4 = PListUtils.toDictionary(map3.get("status"), "status");
                this.updateRaidControllerStatus(raidController, map4);
                continue;
            }
            if (string.equals("page-status")) {
                map3 = PListUtils.toDictionary(v, string);
                boolean bl = false;
                boolean bl2 = false;
                Object v2 = map3.get("changed");
                if (v2 != null) {
                    bl = PListUtils.toBoolean(v2, "changed");
                }
                if ((v2 = map3.get("checking-array")) == null) continue;
                bl2 = PListUtils.toBoolean(v2, "checking-array");
                continue;
            }
            if (string.equals("battery-status")) continue;
            if (string.equals("cpu-temperature")) {
                raidController.setCpuTemperature(PListUtils.toInteger(v, string).intValue());
                continue;
            }
            if (string.equals("arrays")) {
                this.updateRaidSets(raidController, PListUtils.toArray(v, string));
                continue;
            }
            if (string.equals("slots")) {
                this.page1SlotsArray = PListUtils.toArray(v, string);
                continue;
            }
            logger.warn("Unrecognized RAID info (page 1) property  \"" + string + "\" = \"" + v + "\"");
        }
    }

    private void updateRaidControllerStatus(RaidController raidController, Map map) throws PropertyListException {
        logger.info(this.hostAddress + " -> Updating " + raidController.getName() + " status");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null) {
                logger.warn("raid controller status \"" + v + "\" has no data");
                continue;
            }
            if (string.equals("ups-warning") || string.equals("temperature-warning") || string.equals("fan-warning") || string.equals("power-warning")) continue;
            logger.warn("Unrecognized raid controller status property \"" + string + "\" = \"" + v + "\"");
        }
    }

    private void updateRaidSets(RaidController raidController, List list) throws PropertyListException {
        Object object;
        HashSet<RaidSet> hashSet = new HashSet<RaidSet>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n;
            object = PListUtils.toDictionary(iterator.next(), "array dict");
            int n2 = PListUtils.toInteger(object.get("id"), "id").intValue();
            boolean bl = false;
            RaidSet raidSet = raidController.getRaidSet(n2);
            if (raidSet == null) {
                raidSet = new RaidSet(n2, raidController);
                bl = true;
            }
            this.updateRaidSet(raidController, raidSet, (Map)object);
            if (bl) {
                raidController.addRaidSet(raidSet);
            }
            if ((n = raidSet.getState()) == 0 || n == 2) {
                this.system.notifyRaidSetOnline(raidSet);
            }
            hashSet.add(raidSet);
        }
        iterator = raidController.getRaidSets().iterator();
        while (iterator.hasNext()) {
            object = (RaidSet)iterator.next();
            if (hashSet.contains(object)) continue;
            logger.info(this.hostAddress + " -> Removing " + ((RaidSet)object).getName());
            Object object2 = ((RaidSet)object).getMembers().iterator();
            while (object2.hasNext()) {
                Disk disk = (Disk)object2.next();
                disk.setRaidSet(-2);
            }
            object2 = raidController.removeRaidSet(((RaidSet)object).getNativeId());
            if (object2 != null) continue;
            logger.warn("attempt to remove " + ((RaidSet)object).getName() + " failed");
        }
    }

    private void updateRaidSet(RaidController raidController, RaidSet raidSet, Map map) throws PropertyListException {
        int n = 0;
        logger.info(this.hostAddress + " -> Updating " + raidSet.getName());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null) {
                logger.warn("raid set property \"" + v + "\" has no data");
                continue;
            }
            if (string2.equals("id")) continue;
            if (string2.equals("stripe-size")) {
                raidSet.setStripeSize(PListUtils.toInteger(v, string2).intValue());
                continue;
            }
            if (string2.equals("raid-level")) {
                string = PListUtils.toString(v, string2);
                if (string.equalsIgnoreCase("0")) {
                    raidSet.setRaidLevel(0);
                    continue;
                }
                if (string.equalsIgnoreCase("1")) {
                    raidSet.setRaidLevel(1);
                    continue;
                }
                if (string.equalsIgnoreCase("3")) {
                    raidSet.setRaidLevel(3);
                    continue;
                }
                if (string.equalsIgnoreCase("5")) {
                    raidSet.setRaidLevel(5);
                    continue;
                }
                if (string.equalsIgnoreCase("0+1")) {
                    raidSet.setRaidLevel(6);
                    continue;
                }
                if (string.equalsIgnoreCase("JBOD")) {
                    raidSet.setRaidLevel(255);
                    continue;
                }
                raidSet.setRaidLevel(-1);
                logger.warn("unknown RAID level \"" + string + "\"");
                continue;
            }
            if (string2.equals("member-count")) {
                n = PListUtils.toInteger(v, string2).intValue();
                continue;
            }
            if (string2.equals("raid-type")) {
                string = PListUtils.toString(v, string2);
                if (string.equalsIgnoreCase("regular")) {
                    raidSet.setInitializationMode(0);
                    continue;
                }
                if (string.equalsIgnoreCase("raid-now")) {
                    raidSet.setInitializationMode(1);
                    continue;
                }
                raidSet.setInitializationMode(-1);
                logger.warn("unknown raid set initialization mode \"" + string + "\"");
                continue;
            }
            if (string2.equals("sector-capacity")) {
                raidSet.setCapacity(PListUtils.toInteger(v, string2));
                continue;
            }
            if (string2.equals("slices")) {
                this.updateSlices(raidSet, PListUtils.toArray(v, string2));
                continue;
            }
            if (string2.equals("bgrw-status")) {
                string = PListUtils.toString(v, string2);
                if (string.equalsIgnoreCase("stop")) {
                    raidSet.setBackgroundConditioningState(0);
                    continue;
                }
                if (string.equalsIgnoreCase("pause")) {
                    raidSet.setBackgroundConditioningState(1);
                    continue;
                }
                if (string.equalsIgnoreCase("start")) {
                    raidSet.setBackgroundConditioningState(2);
                    continue;
                }
                raidSet.setBackgroundConditioningState(-1);
                logger.error("unknown bgrw-status \"" + string + "\"");
                continue;
            }
            if (string2.equals("progress")) {
                this.updateRaidSetProgress(raidSet, PListUtils.toDictionary(v, string2));
                continue;
            }
            if (string2.equals("members")) {
                this.updateRaidSetMembers(raidController, raidSet, PListUtils.toArray(v, string2));
                continue;
            }
            if (string2.equals("raid-status")) {
                string = PListUtils.toString(v, string2);
                if (string.equalsIgnoreCase("online")) {
                    raidSet.setState(0);
                    continue;
                }
                if (string.equalsIgnoreCase("offline")) {
                    raidSet.setState(1);
                    logger.warn(this.hostAddress + " -> !!! WARNING: " + raidSet.getName() + " state = " + string);
                    continue;
                }
                if (string.equalsIgnoreCase("degraded")) {
                    raidSet.setState(2);
                    continue;
                }
                if (string.equalsIgnoreCase("<unknown>")) {
                    raidSet.setState(-1);
                    continue;
                }
                raidSet.setState(-1);
                logger.warn("unknown raid set state = " + string);
                continue;
            }
            logger.warn("Unrecognized raid set property \"" + string2 + "\" = \"" + v + "\"");
        }
    }

    private void updateRaidSetProgress(RaidSet raidSet, Map map) throws PropertyListException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        logger.info(this.hostAddress + " -> Updating progress for " + raidSet.getName());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null) {
                logger.warn("raid set progress \"" + string + "\" has no data");
                continue;
            }
            if (string.equals("initialize")) {
                n = PListUtils.toInteger(v, string).intValue();
                continue;
            }
            if (string.equals("add-member")) {
                n2 = PListUtils.toInteger(v, string).intValue();
                continue;
            }
            if (string.equals("verify")) {
                n3 = PListUtils.toInteger(v, string).intValue();
                continue;
            }
            if (string.equals("expand")) {
                n4 = PListUtils.toInteger(v, string).intValue();
                continue;
            }
            if (string.equals("background-read-write")) {
                n5 = PListUtils.toInteger(v, string).intValue();
                continue;
            }
            logger.warn("Unrecognized raid set progress \"" + string + "\" = \"" + v + "\"");
        }
        boolean bl = false;
        if (n >= 0 && n <= 100) {
            raidSet.setOperation(1);
            raidSet.setProgress(n);
            bl = true;
        } else if (n2 >= 0 && n2 <= 100) {
            raidSet.setOperation(2);
            raidSet.setProgress(n2);
            bl = true;
        } else if (n3 >= 0 && n3 <= 100) {
            raidSet.setOperation(3);
            raidSet.setProgress(n3);
            bl = true;
        } else if (n4 >= 0 && n4 <= 100) {
            raidSet.setOperation(4);
            raidSet.setProgress(n4);
            bl = true;
        } else if (n5 >= 0 && n5 <= 100) {
            raidSet.setOperation(5);
            raidSet.setProgress(n5);
            bl = true;
        }
        if (!bl) {
            int n6 = raidSet.getOperation();
            if (n6 == 1 || n6 == 2) {
                raidSet.setState(0);
            }
            raidSet.setOperation(-1);
            raidSet.setProgress(-1);
        }
    }

    private void updateRaidSetMembers(RaidController raidController, RaidSet raidSet, List list) throws PropertyListException {
        logger.info(this.hostAddress + " -> Updating members for " + raidSet.getName());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map = PListUtils.toDictionary(iterator.next(), "member dict");
            int n = PListUtils.toInteger(map.get("slot-id"), "slot-id").intValue();
            if (n <= 0) continue;
            Disk disk = raidController.getDisk(n);
            if (disk == null) {
                String string = "Failed to add disk " + n + " to " + raidSet.getName() + ". Disk does not exist";
                logger.error(string);
                continue;
            }
            boolean bl = raidSet.addMember(disk);
            disk.setRaidSet(raidSet.getNativeId());
            if (!logger.isInfoEnabled()) continue;
            logger.info(this.hostAddress + " -> " + disk.getName() + (bl ? " added to " : " member of ") + raidSet.getName() + " (" + raidSet.getNativeId() + ")");
        }
    }

    private void updateSlices(RaidSet raidSet, List list) throws PropertyListException {
        logger.info(this.hostAddress + " -> Updating slices for " + raidSet.getName() + " (ID " + raidSet.getNativeId() + ")");
        RaidController raidController = raidSet.getController();
        RaidSystem raidSystem = raidController.getRaidSystem();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Map map = PListUtils.toDictionary(listIterator.next(), "slice dict");
            int n = PListUtils.toInteger(map.get("id"), "id").intValue();
            int n2 = raidSystem.translateSliceId(n, raidController.getId(), 1);
            if (n2 < 0 || n2 > 7) {
                logger.error("Error translating slice ID " + n + " (was translated to " + n2 + "). Aborting slice updates.");
                return;
            }
            if (n != n2) {
                logger.info("updateSlices: Translated legacy slice ID " + n + " to " + n2);
            }
            int n3 = PListUtils.toInteger(map.get("size"), "size").intValue();
            logger.info("     Slice " + n2 + ": size = " + n3);
            Slice slice = raidSet.getSlice(n2);
            if (slice != null) {
                slice.setSize(n3);
                continue;
            }
            logger.error("Slice " + n2 + " was null");
        }
    }

    private void updatePage1Slots(RaidController raidController, List list) throws PropertyListException {
        logger.info(this.hostAddress + " -> Updating Page 1 slots for " + raidController.getName());
        boolean bl = false;
        if (raidController.getRaidSets().isEmpty() && !raidController.getJbodMaskEnabled()) {
            bl = true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map = PListUtils.toDictionary(iterator.next(), "slot dict");
            Map map2 = PListUtils.toDictionary(map.get("status"), "status");
            int n = PListUtils.toInteger(map.get("id"), "id").intValue();
            boolean bl2 = PListUtils.toBoolean(map2.get("online"), "online");
            boolean bl3 = PListUtils.toBoolean(map2.get("array-member"), "array-member");
            boolean bl4 = PListUtils.toBoolean(map2.get("rebuilding"), "rebuilding");
            boolean bl5 = PListUtils.toBoolean(map2.get("disk-cache-enabled"), "disk-cache-enabled");
            Disk disk = raidController.getDisk(n);
            if (disk != null) {
                if (raidController.getDiskSlot(n).isPopulated()) {
                    disk.setState(bl2 ? 1 : 0);
                }
                if (!disk.isOrphanRaidMember()) {
                    if (!bl) {
                        if (bl3 || bl4) {
                            disk.setType(1);
                            if (disk.getRaidSet() == null) {
                                logger.warn(disk.getName() + " reported as type RAID_MEMBER with no associated RAID set");
                            }
                        } else {
                            disk.setType(0);
                        }
                    } else {
                        disk.setType(bl2 ? 3 : 0);
                        if (bl3) {
                            logger.error("Slot " + n + " reported as array member in JBOD mode!");
                        }
                    }
                }
                disk.setOperation(bl4 ? 1 : 0);
                disk.setCacheState(bl5 ? 1 : 0);
            } else {
                logger.error("Disk " + n + " was null");
            }
            logger.info("    Slot " + n + ": online=" + bl2 + ", member=" + bl3 + ", rebuilding=" + bl4 + ", cache=" + bl5 + (bl ? ", JBOD=true" : ""));
        }
    }

    private void processPage32(RaidController raidController, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        logger.info(this.hostAddress + " -> Processing RAID controller Page 32 for " + raidController.getName());
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "get-page root dict");
        Map map2 = PListUtils.toDictionary(map.get("get-page"), "get-page command dict");
        int n = this.getCommandStatus(map2);
        if (n != 0) {
            String string = "ACP error for \"get-page\" command (status = " + n + ")";
            logger.error(string);
            throw new AcpxCommandException(string);
        }
        int n2 = PListUtils.toInteger(map2.get("id"), "page id").intValue();
        if (n2 != 32) {
            String string = "Expected page ID 32. Got page ID " + n2;
            logger.error(string);
            throw new AcpxCommandException(string);
        }
        List list = PListUtils.toArray(map2.get("slots"), "page 32 slots");
        if (list == null) {
            logger.error("Page 32 slots array is null");
            throw new AcpxCommandException("Page 32 slots array is null");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map3 = (Map)iterator.next();
            int n3 = PListUtils.toInteger(map3.get("id"), "slot id").intValue();
            int n4 = PListUtils.toInteger(map3.get("reason"), "reason").intValue();
            Disk disk = raidController.getDisk(n3);
            if (n4 != 0) {
                if (disk != null) {
                    Disk.OrphanMemberInfo orphanMemberInfo = new Disk.OrphanMemberInfo();
                    orphanMemberInfo.memberState = n4;
                    orphanMemberInfo.floatingId = PListUtils.toInteger(map3.get("metadata-id-no"), "metadata-id-no");
                    orphanMemberInfo.raidSetId = PListUtils.toInteger(map3.get("raid-no"), "raid-no").intValue();
                    orphanMemberInfo.raidLevel = PListUtils.toInteger(map3.get("raid-level"), "raid-level").intValue();
                    orphanMemberInfo.diskCount = PListUtils.toInteger(map3.get("disk-number"), "disk-number").intValue();
                    orphanMemberInfo.memberIndex = PListUtils.toInteger(map3.get("member-no"), "member-no").intValue();
                    orphanMemberInfo.raidType = PListUtils.toInteger(map3.get("raid-type"), "raid-type").intValue();
                    orphanMemberInfo.serialNumber = PListUtils.toString(map3.get("sn-no"), "sn-no");
                    orphanMemberInfo.metaDataUpdateCount = PListUtils.toInteger(map3.get("metadata-id-no-3"), "metadata-id-no-3");
                    disk.setOrphanRaidMember(orphanMemberInfo);
                    logger.info(this.hostAddress + " -> Page 32 - slotId=" + n3 + "," + orphanMemberInfo);
                    continue;
                }
                logger.error("No disk at reported orphan member slot ID " + n3);
                continue;
            }
            if (disk == null) continue;
            disk.setOrphanRaidMember(null);
        }
    }

    private void updateLunMap(RaidController raidController, List list) throws PropertyListException {
        Object object;
        HashSet<Slice> hashSet = new HashSet<Slice>();
        logger.info(this.hostAddress + " -> Updating LUN mapping");
        if (list == null) {
            throw new NullPointerException("LUN list cannot be null");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RaidSet raidSet;
            object = PListUtils.toDictionary(iterator.next(), "LUN dict");
            int n = PListUtils.toInteger(object.get("id"), "id").intValue();
            int n2 = this.system.translateLunId(n, raidController.getId(), 1);
            if (n2 < 0 || n2 > 7) {
                logger.error("Error translating LUN ID " + n + " (was translated to " + n2 + "). Aborting LUN map update.");
                return;
            }
            if (n2 != n) {
                logger.info("updateLunMap: Translated LUN ID " + n + " to " + n2);
            }
            int n3 = PListUtils.toInteger(object.get("array-id"), "array-id").intValue();
            int n4 = PListUtils.toInteger(object.get("slice-id"), "slice-id").intValue();
            logger.info("     LUN " + n2 + (n3 != 15 ? " mapped to RAID set " + n3 + " slice " + n4 : " not mapped"));
            if (n3 == 15 || (raidSet = raidController.getRaidSet(n3)) == null) continue;
            Slice slice = raidSet.getSlice(n4);
            if (slice != null) {
                slice.setLunId(n2);
                hashSet.add(slice);
                continue;
            }
            logger.error("Null slice attempting to map LUN " + n2 + " to RS " + n3 + ", slice " + n2);
        }
        iterator = raidController.getRaidSets().iterator();
        while (iterator.hasNext()) {
            object = ((RaidSet)iterator.next()).getSlices().iterator();
            while (object.hasNext()) {
                Slice slice = (Slice)object.next();
                if (hashSet.contains(slice) || slice.getLunId() == -1) continue;
                slice.setLunId(-1);
                logger.info("     Unmapping RAID set " + slice.getRaidSet().getNativeId() + " slice " + slice.getId());
            }
        }
    }

    private void updateThermal(SystemController systemController, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "get-temperature root dict");
        Map map2 = PListUtils.toDictionary(map.get("get-temperature"), "get-temperature command dict");
        int n = this.getCommandStatus(map2);
        if (n != 0) {
            String string = "ACP error for \"get-temperature\" command (status = " + n + ")";
            logger.error(string);
            throw new AcpxCommandException(string);
        }
        int n2 = PListUtils.toInteger(map2.get("temperature"), "temperature").intValue();
        systemController.setAmbientTemperature(n2);
    }

    private void updateEventLog(SystemController systemController, PropertyList propertyList) throws PropertyListException, AcpxCommandException {
        Object object;
        logger.info(this.hostAddress + " -> Updating " + systemController.getName() + " event log");
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), "/system/get-event-log root dict");
        List list = PListUtils.toArray(map.get("responses"), "/system/get-event-log response array");
        Map map2 = PListUtils.toDictionary(list.get(0), "/system/get-event-log response dict");
        String string = PListUtils.toString(map2.get("method"), "method");
        if (!"/system/get-event-log".equals(string)) {
            String string2 = "Response method \"" + string + "\" does not match command \"" + "/system/get-event-log" + "\"";
            logger.error(string2);
            throw new AcpxCommandException(string2);
        }
        int n = this.getCommandStatus(map2);
        if (n != 0) {
            object = "ACP error for \"/system/get-event-log\" command (status = " + n + ")";
            logger.error(object);
        }
        object = PListUtils.toDictionary(map2.get("outputs"), "/system/get-event-log outputs dict");
        List list2 = PListUtils.toArray(object.get("entries"), "/system/get-event-log entries dict");
        try {
            if (list2.size() > 0) {
                logger.info(this.hostAddress + " -> Adding " + list2.size() + " events to event log");
                this.system.getEventLog().appendEvents(list2.iterator(), systemController.getId());
            }
        }
        catch (Exception exception) {
            logger.error(exception, exception);
        }
    }

    private void updateConnectionFailure() {
        this.system.setUserMessageIndex(4);
        this.system.setLoggedOn(false);
        Iterator iterator = this.system.getNetworkInterfaces().iterator();
        while (iterator.hasNext()) {
            NetworkInterface networkInterface = (NetworkInterface)iterator.next();
            networkInterface.setLinkState(-1);
            networkInterface.setStatus(-1);
        }
        this.system.setChanged();
    }

    private void updateCommunicationsError() {
        this.system.setUserMessageIndex(5);
        this.system.setChanged();
    }

    private void sendNoOpMessage() throws IOException {
        RequestMessage requestMessage = this.msgFactory.newNoOpRequest();
        requestMessage.setTargetController(null);
        Response response = this.comms.postMessage(requestMessage);
        if (response.getContent() == null) {
            logger.info(this.hostAddress + " -> NO OP message sent successfully");
        } else {
            logger.info(this.hostAddress + " -> NO OP message failed");
        }
    }

    private Map getCommandDictionary(PropertyList propertyList, String string) throws PropertyListException, AcpxCommandException {
        Map map = PListUtils.toDictionary(propertyList.getRootElement(), string + " root dict");
        Map map2 = PListUtils.toDictionary(map.get(string), string + " command dict");
        int n = this.getCommandStatus(map);
        if (n != 0) {
            String string2 = "ACP error for \"" + string + "\" command (status = " + n + ")";
            logger.error(string2);
            throw new AcpxCommandException(string2);
        }
        return map2;
    }

    private int getCommandStatus(Map map) throws PropertyListException {
        int n = 0;
        Object var3_3 = null;
        Object v = map.get("status");
        var3_3 = v;
        if (v != null) {
            n = PListUtils.toInteger(var3_3, "status dict").intValue();
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AuthenticationException
    extends IOException {
        public AuthenticationException() {
        }

        public AuthenticationException(String string) {
            super(string);
        }
    }

    private class DelegateHandler
    implements CommunicationHandler {
        CommunicationHandler principal;

        public DelegateHandler(CommunicationHandler communicationHandler) {
            this.principal = communicationHandler;
        }

        public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
        }
    }
}

