/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class RaidSet
extends AbstractSystemElement
implements Comparable {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int DEGRADED = 2;
    public static final int OP_NONE = 0;
    public static final int OP_CREATING = 1;
    public static final int OP_REBUILDING = 2;
    public static final int OP_VERIFYING = 3;
    public static final int OP_EXPANDING = 4;
    public static final int OP_CONDITIONING = 5;
    public static final int RAID_LEVEL_ZERO = 0;
    public static final int RAID_LEVEL_ONE = 1;
    public static final int RAID_LEVEL_THREE = 3;
    public static final int RAID_LEVEL_FOUR = 4;
    public static final int RAID_LEVEL_FIVE = 5;
    public static final int RAID_LEVEL_ZERO_PLUS_ONE = 6;
    public static final int RAID_LEVEL_JBOD = 255;
    public static final int INIT_MODE_FOREGROUND = 0;
    public static final int INIT_MODE_BACKGROUND = 1;
    public static final int BLOCK_SIZE = 512;
    public static final int BGRW_STOPPED = 0;
    public static final int BGRW_PAUSED = 1;
    public static final int BGRW_STARTED = 2;
    public static final int MAX_SLICES = 8;
    private int nativeId;
    private int id;
    private int status = -1;
    private int state = -1;
    private int operation = -1;
    private int progress = -1;
    private int raidLevel = -1;
    private int stripeSize = -1;
    private long capacity = -1L;
    private int initMode = -1;
    private Date timestamp = new Date();
    private int bgrwConditioningState = -1;
    private TreeSet members = new TreeSet();
    private TreeMap slices = new TreeMap();
    RaidController controller;
    private static int guid = 1;

    public RaidSet(int n, RaidController raidController) {
        if (raidController == null) {
            throw new NullPointerException("controller cannot be null");
        }
        this.nativeId = n;
        this.id = guid++;
        this.controller = raidController;
        for (int i = 0; i <= 7; ++i) {
            this.slices.put(new Integer(i), new Slice(this, i));
        }
    }

    public RaidSet(RaidSet raidSet) {
        this.nativeId = raidSet.nativeId;
        this.id = raidSet.id;
        this.status = raidSet.status;
        this.state = raidSet.state;
        this.operation = raidSet.operation;
        this.progress = raidSet.progress;
        this.raidLevel = raidSet.raidLevel;
        this.stripeSize = raidSet.stripeSize;
        this.capacity = raidSet.capacity;
        this.initMode = raidSet.initMode;
        this.timestamp = raidSet.timestamp;
        this.bgrwConditioningState = raidSet.bgrwConditioningState;
        this.members = (TreeSet)raidSet.members.clone();
        this.controller = raidSet.controller;
        Iterator iterator = raidSet.slices.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            if (v == null) continue;
            Slice slice = new Slice((Slice)v);
            slice.raidSet = this;
            this.slices.put(entry.getKey(), slice);
        }
    }

    public int getNativeId() {
        return this.nativeId;
    }

    void setGlobalId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "RAID set " + this.id;
    }

    public int getStatus() {
        this.status = this.state == 0 ? (this.operation == 2 ? 1 : 0) : (this.state == 1 ? 2 : (this.state == 2 ? 1 : -1));
        return this.status;
    }

    void setState(int n) {
        if (n != 0 && n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("Illegal state (" + n + ")");
        }
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    void setOperation(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 0 && n != -1) {
            throw new IllegalArgumentException("Illegal operation (" + n + ")");
        }
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    void setProgress(int n) {
        this.progress = n;
        if (this.progress < 0) {
            this.progress = 0;
        } else if (this.progress > 100) {
            this.progress = 100;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    void setRaidLevel(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 255: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal RAID Level: " + n);
            }
        }
        this.raidLevel = n;
    }

    public int getRaidLevel() {
        return this.raidLevel;
    }

    void setStripeSize(int n) {
        if (!RaidController.isValidStripeSize(n)) {
            throw new IllegalArgumentException("Illegal Stripe Size: " + n);
        }
        this.stripeSize = n;
    }

    public int getStripeSize() {
        return this.stripeSize;
    }

    void setCapacity(long l) {
        this.capacity = l;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getCapacityBytes() {
        return this.capacity * 512L;
    }

    void setInitializationMode(int n) {
        if (n != 0 && n != 1 && n != -1) {
            throw new IllegalArgumentException("Illegal mode : " + n);
        }
        this.initMode = n;
    }

    public int getInitializationMode() {
        return this.initMode;
    }

    void setTimeStamp(int n, int n2, int n3, int n4, int n5, int n6) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3, n4, n5, n6);
        this.timestamp = gregorianCalendar.getTime();
    }

    public Date getTimeStamp() {
        return this.timestamp;
    }

    void setBackgroundConditioningState(int n) {
        if (n != -1 && n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException("Illegal background conditioning state: " + n);
        }
        this.bgrwConditioningState = n;
    }

    public int getBackgroundConditioningState() {
        return this.bgrwConditioningState;
    }

    public Slice getSlice(int n) {
        return (Slice)this.slices.get(new Integer(n));
    }

    public Collection getSlices() {
        return Collections.unmodifiableCollection(this.slices.values());
    }

    public Collection getLiveSlices() {
        TreeSet<Slice> treeSet = new TreeSet<Slice>();
        Iterator iterator = this.slices.values().iterator();
        while (iterator.hasNext()) {
            Slice slice = (Slice)iterator.next();
            if (slice.getSize() <= 0) continue;
            treeSet.add(slice);
        }
        return treeSet;
    }

    public Collection getMappedSlices() {
        ArrayList<Slice> arrayList = new ArrayList<Slice>();
        Iterator iterator = this.slices.values().iterator();
        while (iterator.hasNext()) {
            Slice slice = (Slice)iterator.next();
            if (!slice.isMapped()) continue;
            arrayList.add(slice);
        }
        return arrayList;
    }

    public Collection getUnmappedSlices() {
        ArrayList<Slice> arrayList = new ArrayList<Slice>();
        Iterator iterator = this.slices.values().iterator();
        while (iterator.hasNext()) {
            Slice slice = (Slice)iterator.next();
            if (slice.isMapped() || slice.getSize() <= 0) continue;
            arrayList.add(slice);
        }
        return arrayList;
    }

    public int getLiveSliceCount() {
        int n = 0;
        Iterator iterator = this.slices.values().iterator();
        while (iterator.hasNext()) {
            Slice slice = (Slice)iterator.next();
            if (slice.getSize() <= 0) continue;
            ++n;
        }
        return n;
    }

    boolean addMember(Disk disk) {
        if (disk == null) {
            throw new NullPointerException("member cannot be null");
        }
        return this.members.add(disk);
    }

    boolean removeMember(Disk disk) {
        if (disk == null) {
            throw new NullPointerException("member cannot be null");
        }
        return this.members.remove(disk);
    }

    public Collection getMembers() {
        TreeSet treeSet = (TreeSet)this.members.clone();
        return Collections.unmodifiableSet(treeSet);
    }

    public boolean isPhantom() {
        boolean bl = true;
        Iterator iterator = this.getMembers().iterator();
        while (iterator.hasNext()) {
            Disk disk = (Disk)iterator.next();
            if (disk.getRaidSet() == null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public RaidController getController() {
        return this.controller;
    }

    public int compareTo(Object object) {
        RaidSet raidSet = (RaidSet)object;
        return this.id - raidSet.id;
    }

    public String paramString() {
        String string = "";
        string = string + "id=" + this.id + ",";
        string = string + "status=" + this.status + ",";
        string = string + "state=" + this.state + ",";
        string = string + "operation=" + this.operation + ",";
        string = string + "progress=" + this.progress + ",";
        string = string + "raidLevel=" + this.raidLevel + ",";
        string = string + "stripeSize=" + this.stripeSize + ",";
        string = string + "capacity=" + this.capacity + ",";
        string = string + "timestamp=" + this.timestamp + ",";
        string = string + "initMode=" + this.initMode + ",";
        string = string + "members={";
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            string = string + ((Disk)iterator.next()).getId();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        string = string + "}";
        string = string + "slices={";
        iterator = this.getSlices().iterator();
        while (iterator.hasNext()) {
            string = string + ((Slice)iterator.next()).getSize();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        string = string + "}";
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }
}

