/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.RaidController;

public abstract class HostInterface
extends AbstractSystemElement
implements Comparable {
    public static final int SPEED_AUTO = 0;
    public static final int SPEED_1GBPS = 1;
    public static final int SPEED_2GBPS = 2;
    protected int nativeId;
    protected int id;
    protected int speed = -1;
    protected int actualSpeed = -1;
    protected int maxSpeed = -1;
    RaidController controller;

    public HostInterface(int n, RaidController raidController) {
        this.nativeId = n;
        this.controller = raidController;
        this.id = raidController.getId();
    }

    public HostInterface(HostInterface hostInterface) {
        this.nativeId = hostInterface.nativeId;
        this.id = hostInterface.id;
        this.speed = hostInterface.speed;
        this.actualSpeed = hostInterface.actualSpeed;
        this.maxSpeed = hostInterface.maxSpeed;
        this.controller = hostInterface.controller;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Host Interface " + this.id;
    }

    public abstract int getStatus();

    void setSpeed(int n) {
        if (n != 0 && n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("illegal speed " + n);
        }
        this.speed = n;
    }

    public int getSpeed() {
        return this.speed;
    }

    void setActualSpeed(int n) {
        if (n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("illegal speed " + n);
        }
        this.actualSpeed = n;
    }

    public int getActualSpeed() {
        return this.actualSpeed;
    }

    void setMaximumSpeed(int n) {
        if (n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("illegal maximum speed " + n);
        }
        this.maxSpeed = n;
    }

    public int getMaximumSpeed() {
        return this.maxSpeed;
    }

    public RaidController getController() {
        return this.controller;
    }

    public int compareTo(Object object) {
        HostInterface hostInterface = (HostInterface)object;
        return this.id - hostInterface.id;
    }

    public String paramString() {
        String string = "";
        string = string + "nativeId=" + this.nativeId + ",";
        string = string + "id=" + this.id + ",";
        string = string + "speed=" + this.speed + ",";
        string = string + "maxSpeed=" + this.maxSpeed;
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }
}

