/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.HostInterface;
import com.apple.xsr.som.RaidController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class FibreChannelInterface
extends HostInterface {
    public static final int LINK_DOWN = 0;
    public static final int LINK_UP = 1;
    public static final int TOPOLOGY_ARBITRATED_LOOP = 0;
    public static final int TOPOLOGY_POINT_TO_POINT = 1;
    public static final int TOPOLOGY_AUTO_DETECT = 2;
    public static final int LUN_MIN_ID = 1;
    public static final int LUN_MAX_ID = 8;
    public static final int HARD_LOOP_DISABLED = 0;
    public static final int HARD_LOOP_ENABLED = 1;
    private int linkState = -1;
    private String wwn = "";
    private String wwpn = "";
    private String wwnn = "";
    private int topology = -1;
    private int actualTopology = -1;
    private int hardLoopId = -1;
    private int hardLoopIdEnabled = -1;
    private int protocolErrorCount = -1;
    private int invalidTransmissionWordCount = -1;
    private int invalidCrcCount = -1;
    private int lossOfSignalCount = -1;
    private int lossOfSyncCount = -1;
    private int linkFailureCount = -1;
    private Map lunMap = new TreeMap();
    private ArrayList lunMaskHostList = new ArrayList();

    public FibreChannelInterface(int n, RaidController raidController) {
        super(n, raidController);
        for (int i = 1; i <= 8; ++i) {
            Lun lun = new Lun(i);
            this.lunMap.put(new Integer(lun.id), lun);
        }
    }

    public FibreChannelInterface(FibreChannelInterface fibreChannelInterface) {
        super(fibreChannelInterface);
        this.linkState = fibreChannelInterface.linkState;
        this.wwn = fibreChannelInterface.wwn;
        this.wwpn = fibreChannelInterface.wwpn;
        this.wwnn = fibreChannelInterface.wwnn;
        this.topology = fibreChannelInterface.topology;
        this.actualTopology = fibreChannelInterface.actualTopology;
        this.hardLoopId = fibreChannelInterface.hardLoopId;
        this.hardLoopIdEnabled = fibreChannelInterface.hardLoopIdEnabled;
        this.protocolErrorCount = fibreChannelInterface.protocolErrorCount;
        this.invalidTransmissionWordCount = fibreChannelInterface.invalidTransmissionWordCount;
        this.invalidCrcCount = fibreChannelInterface.invalidCrcCount;
        this.lossOfSignalCount = fibreChannelInterface.lossOfSignalCount;
        this.lossOfSyncCount = fibreChannelInterface.lossOfSyncCount;
        this.linkFailureCount = fibreChannelInterface.linkFailureCount;
        this.lunMap = (Map)((TreeMap)fibreChannelInterface.lunMap).clone();
        this.lunMaskHostList = (ArrayList)fibreChannelInterface.lunMaskHostList.clone();
    }

    public String getName() {
        return "Fibre Channel Interface " + this.id;
    }

    public int getStatus() {
        Collection collection;
        Collection collection2;
        int n = this.linkState == 1 ? 0 : (this.linkState == -1 ? -1 : ((collection2 = this.controller.getDisks()) == null ? 0 : (collection2.size() > 0 ? ((collection = this.controller.getRaidSets()) == null ? 1 : (collection.size() > 0 ? 2 : 1)) : 0)));
        return n;
    }

    void setLinkState(int n) {
        this.linkState = n;
    }

    public int getLinkState() {
        return this.linkState;
    }

    void setWorldWidePortName(String string) {
        String string2;
        this.wwpn = string;
        int n = string.indexOf(":");
        String string3 = string.substring(0, n);
        int n2 = Integer.parseInt(string3, 16);
        if (!string.startsWith("50")) {
            n2 -= 16;
        }
        this.wwnn = string2 = Integer.toString(n2, 16) + string.substring(n);
    }

    public String getWorldWidePortName() {
        return this.wwpn;
    }

    void setWorldWideNodeName(String string) {
        this.wwnn = string;
    }

    public String getWorldWideNodeName() {
        return this.wwnn;
    }

    void setTopology(int n) {
        if (n != 0 && n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("illegal topology " + n);
        }
        this.topology = n;
    }

    public int getTopology() {
        return this.topology;
    }

    void setActualTopology(int n) {
        if (n != 0 && n != 1 && n != -1) {
            throw new IllegalArgumentException("illegal topology " + n);
        }
        this.actualTopology = n;
    }

    public int getActualTopology() {
        return this.actualTopology;
    }

    void setHardLoopId(int n) {
        this.hardLoopId = n;
    }

    public int getHardLoopId() {
        return this.hardLoopId;
    }

    void setHardLoopIdEnabled(int n) {
        this.hardLoopIdEnabled = n;
    }

    public int getHardLoopIdEnabled() {
        return this.hardLoopIdEnabled;
    }

    void setProtocolErrorCount(int n) {
        this.protocolErrorCount = n;
    }

    public int getProtocolErrorCount(int n) {
        return this.protocolErrorCount;
    }

    void setInvalidTransmissionWordCount(int n) {
        this.invalidTransmissionWordCount = n;
    }

    public int getInvalidTransmissionWordCount() {
        return this.invalidTransmissionWordCount;
    }

    void setInvalidCyclicRedundancyCodeCount(int n) {
        this.invalidCrcCount = n;
    }

    public int getInvalidCyclicRedundancyCodeCount() {
        return this.invalidCrcCount;
    }

    void setLossOfSignalCount(int n) {
        this.lossOfSignalCount = n;
    }

    public int getLossOfSignalCount() {
        return this.lossOfSignalCount;
    }

    void setLossOfSyncCount(int n) {
        this.lossOfSyncCount = n;
    }

    public int getLossOfSyncCount() {
        return this.lossOfSyncCount;
    }

    void setLinkFailureCount(int n) {
        this.linkFailureCount = n;
    }

    public int getLinkFailureCount() {
        return this.linkFailureCount;
    }

    void setLunMaskList(ArrayList arrayList) {
        this.lunMaskHostList = arrayList;
    }

    public ArrayList getLunMaskList() {
        return this.lunMaskHostList;
    }

    public Lun getLun(int n) {
        return (Lun)this.lunMap.get(new Integer(n));
    }

    void mapLun(int n, int n2) {
        Lun lun = this.getLun(n);
        if (lun == null) {
            throw new IllegalArgumentException("Invalid LUN ID " + n);
        }
        lun.raidset = n2;
    }

    public String paramString() {
        String string = super.paramString() + ",";
        string = string + "linkState=" + this.linkState + ",";
        string = string + "wwn=" + this.wwn + ",";
        string = string + "topology=" + this.topology + ",";
        string = string + "hardLoopId=" + this.hardLoopId + ",";
        string = string + "hardLoopIdEnabled=" + this.hardLoopIdEnabled + ",";
        string = string + "protocolErrorCount=" + this.protocolErrorCount + ",";
        string = string + "invalidTransmissionWordCount=" + this.invalidTransmissionWordCount + ",";
        string = string + "invalidCrcCount=" + this.invalidCrcCount + ",";
        string = string + "lossOfSignalCount=" + this.lossOfSignalCount + ",";
        string = string + "lossOfSyncCount=" + this.lossOfSyncCount + ",";
        string = string + "linkFailureCount=" + this.linkFailureCount + ",";
        Iterator iterator = this.lunMap.values().iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public static final class Lun {
        public static final int NOT_MAPPED = -1;
        private int id;
        private int raidset = -1;

        private Lun(int n) {
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public int getRaidSet() {
            return this.raidset;
        }

        public String paramString() {
            String string = "";
            string = string + "id=" + this.id + ",";
            string = string + "raidSet=" + this.raidset;
            return string;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.paramString() + "]";
        }
    }
}

