/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidController;

public class DiskSlot
extends AbstractSystemElement
implements Comparable {
    private int nativeId;
    private int id;
    private int dmaMode = -1;
    private int ultraDmaMode = -1;
    private boolean populated = false;
    private Disk disk;
    RaidController controller;

    public DiskSlot(int n, RaidController raidController) {
        if (raidController == null) {
            throw new NullPointerException("controller cannot be null");
        }
        this.nativeId = n;
        this.controller = raidController;
        int n2 = this.controller.getId();
        if (n2 == 1) {
            this.id = this.nativeId;
        } else if (n2 == 2) {
            this.id = this.nativeId + 7;
        } else {
            throw new IllegalArgumentException("Unrecognized RAID controller \"" + raidController + "\"");
        }
    }

    public DiskSlot(DiskSlot diskSlot) {
        this.nativeId = diskSlot.nativeId;
        this.id = diskSlot.id;
        this.dmaMode = diskSlot.dmaMode;
        this.ultraDmaMode = diskSlot.ultraDmaMode;
        this.populated = diskSlot.populated;
        this.disk = diskSlot.disk;
        this.controller = diskSlot.controller;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Disk Slot " + this.id;
    }

    public int getStatus() {
        return 0;
    }

    void setDmaMode(int n) {
        this.dmaMode = n;
    }

    public int getDmaMode() {
        return this.dmaMode;
    }

    void setUltraDmaMode(int n) {
        this.ultraDmaMode = n;
    }

    public int getUltraDmaMode() {
        return this.ultraDmaMode;
    }

    void setDisk(Disk disk) {
        this.disk = disk;
    }

    public Disk getDisk() {
        return this.disk;
    }

    void setPopulated(boolean bl) {
        this.populated = bl;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public RaidController getRaidController() {
        return this.controller;
    }

    public int compareTo(Object object) {
        DiskSlot diskSlot = (DiskSlot)object;
        return this.id - diskSlot.id;
    }

    public String paramString() {
        String string = "";
        string = string + "nativeId=" + this.nativeId + ",";
        string = string + "id=" + this.id + ",";
        string = string + "dmaMode=" + this.dmaMode + ",";
        string = string + "ultraDmaMode=" + this.ultraDmaMode + ",";
        string = string + "populated=" + this.populated + ",";
        string = string + "disk=" + this.disk;
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }
}

