/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;

public class Battery
extends AbstractSystemElement
implements Comparable {
    private int id;
    private int status;
    private int charge = -1;
    private boolean charging = false;

    public Battery(int n) {
        this.id = n;
    }

    public Battery(Battery battery) {
        this.id = battery.id;
        this.status = battery.status;
        this.charge = battery.charge;
        this.charging = battery.charging;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Battery " + this.id;
    }

    void setStatus(int n) {
        if (n != 0 && n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("illegal status argument (" + n + ")");
        }
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    void setChargePercent(int n) {
        this.charge = n;
    }

    public int getChargePercent() {
        return this.charge;
    }

    void setIsCharging(boolean bl) {
        this.charging = bl;
    }

    public boolean isCharging() {
        return this.charging;
    }

    public int compareTo(Object object) {
        Battery battery = (Battery)object;
        return this.id - battery.id;
    }

    public String paramString() {
        String string = "";
        string = string + "id=" + this.id + ",";
        string = string + "status=" + this.status + ",";
        string = string + "charge=" + this.charge + ",";
        string = string + "charging=" + this.charging;
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }
}

