/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.SocketObserver;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class ObservableSocket
extends Socket {
    private SocketObserver observer;

    public ObservableSocket(String string, int n) throws UnknownHostException, IOException {
        super(string, n);
    }

    public ObservableSocket(InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
    }

    public void attach(SocketObserver socketObserver) {
        this.observer = socketObserver;
    }

    public void detach(SocketObserver socketObserver) {
        if (this.observer == socketObserver) {
            this.observer = null;
        }
    }

    public InputStream getInputStream() throws IOException {
        return new FilterInputStream(super.getInputStream()){

            public int read() throws IOException {
                int n = super.read();
                if (ObservableSocket.this.observer != null) {
                    ObservableSocket.this.observer.writeInput(n);
                }
                return n;
            }
        };
    }

    public OutputStream getOutputStream() throws IOException {
        return new FilterOutputStream(super.getOutputStream()){

            public void write(int n) throws IOException {
                if (ObservableSocket.this.observer != null) {
                    ObservableSocket.this.observer.writeOutput(n);
                }
                super.write(n);
            }
        };
    }
}

