/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.HttpConnection;
import com.apple.xsr.net.HttpMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.ProtocolException;
import org.apache.log4j.Logger;

public class HttpResponse
extends HttpMessage {
    private HttpConnection connection;
    private InputStream inStream;
    private HttpInputStream httpInputStream;
    private boolean close = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$HttpResponse == null ? (class$com$apple$xsr$net$HttpResponse = HttpResponse.class$("com.apple.xsr.net.HttpResponse")) : class$com$apple$xsr$net$HttpResponse);
    static /* synthetic */ Class class$com$apple$xsr$net$HttpResponse;

    HttpResponse(HttpConnection httpConnection) throws IOException {
        if (httpConnection == null) {
            throw new NullPointerException("connection cannot be null");
        }
        this.connection = httpConnection;
        this.inStream = this.connection.getInputStream();
        this.parseHeaders();
    }

    public InputStream getInputStream() throws IOException {
        if (this.httpInputStream == null) {
            this.httpInputStream = new HttpInputStream(this.getBody());
        }
        return this.httpInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public byte[] getBody() throws IOException {
        var1_1 = 0;
        var2_2 = this.getHeaderField("Content-Length");
        if (var2_2 != null) {
            this.contentLength = var1_1 = Integer.parseInt(var2_2);
        }
        var3_3 = new ByteArrayOutputStream(var1_1);
        try {
            for (var5_4 = var1_1; var5_4 > 0; --var5_4) {
                var4_5 = this.inStream.read();
                if (var4_5 == -1) {
                    throw new IOException("Premature end of stream. Content-Length = " + var1_1 + ". Actual bytes = " + (var1_1 - var5_4));
                }
                var3_3.write(var4_5);
            }
            var7_6 = null;
            ** if (this.connection.isPersistent() && !this.close) goto lbl-1000
        }
        catch (Throwable var6_10) {
            var7_7 = null;
            if (!this.connection.isPersistent() || this.close) {
                try {
                    this.inStream.close();
                }
                catch (IOException var8_9) {
                    HttpResponse.logger.error("Should not happen: " + var8_9);
                }
            }
            throw var6_10;
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.inStream.close();
            }
            catch (IOException var8_8) {
                HttpResponse.logger.error("Should not happen: " + var8_8);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        this.connection.setRequestOutstanding(false);
        return var3_3.toByteArray();
    }

    private void parseHeaders() throws IOException {
        String string;
        String string2 = this.readLine();
        if (string2.equals("")) {
            logger.error("Expected HTTP start line");
            throw new EOFException("Expected HTTP start line");
        }
        while (!(string = this.readLine()).equals("")) {
            int n = string.indexOf(58);
            if (n != -1 && n > 0) {
                String string3 = string.substring(0, n).trim();
                String string4 = string.substring(n + 1).trim();
                this.setHeaderField(string3, string4);
                if (!string3.toLowerCase().equals("connection") || !string4.toLowerCase().equals("close")) continue;
                this.close = true;
                continue;
            }
            throw new ProtocolException("Invalid HTTP header: " + string);
        }
    }

    private String readLine() throws IOException {
        StringWriter stringWriter = new StringWriter();
        boolean bl = false;
        while (true) {
            int n;
            if ((n = this.inStream.read()) == -1) {
                logger.warn("Hit end-of-stream");
                break;
            }
            if (n == 10 || n == 13) {
                if (bl) break;
                bl = true;
                continue;
            }
            stringWriter.write(n);
        }
        return stringWriter.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HttpInputStream
    extends ByteArrayInputStream {
        public HttpInputStream(byte[] byArray) {
            super(byArray);
        }

        public void close() throws IOException {
            super.close();
            HttpResponse.this.connection.setRequestOutstanding(false);
        }
    }
}

