/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.HttpConnection;
import com.apple.xsr.net.HttpMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.log4j.Logger;

public class HttpRequest
extends HttpMessage {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String HEAD = "HEAD";
    public static final String PUT = "PUT";
    public static final String LINK = "LINK";
    public static final String UNLINK = "UNLINK";
    public static final String DELETE = "DELETE";
    public static final String OPTIONS = "OPTIONS";
    public static final String TRACE = "TRACE";
    private static final String DEFAULT_USER_AGENT = "Apple-Xserve_RAID_Admin/1.5.1";
    private static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private static final String HTTP_VERSION = "HTTP/1.1";
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$HttpRequest == null ? (class$com$apple$xsr$net$HttpRequest = HttpRequest.class$("com.apple.xsr.net.HttpRequest")) : class$com$apple$xsr$net$HttpRequest);
    private String method;
    private String host;
    private URL url;
    private String version;
    private HttpConnection connection;
    private OutputStream outStream;
    private HttpOutputStream outputBuffer;
    private boolean sent = false;
    static /* synthetic */ Class class$com$apple$xsr$net$HttpRequest;

    HttpRequest(HttpConnection httpConnection, URL uRL) throws IOException {
        this.connection = httpConnection;
        this.method = POST;
        this.url = uRL;
        this.version = HTTP_VERSION;
        this.setHeaderField("Host", uRL.getHost());
        this.setHeaderField("Content-Type", DEFAULT_CONTENT_TYPE);
        this.setHeaderField("User-Agent", DEFAULT_USER_AGENT);
        if (!this.connection.isPersistent()) {
            this.setHeaderField("Connection", "close");
        }
    }

    public void setRequestMethod(String string) {
        this.method = string;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public void setContentType(String string) {
        this.setHeaderField("Content-Type", string);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputBuffer == null) {
            this.outputBuffer = new HttpOutputStream();
        }
        return this.outputBuffer;
    }

    private void send() throws IOException {
        int n = 1;
        while (n > 0) {
            try {
                this.outStream = this.connection.getOutputStream();
                this.sendHeader();
                this.sendBody();
                this.sent = true;
                this.connection.setRequestSent(true);
                n = 0;
            }
            catch (IOException iOException) {
                logger.error(iOException + "");
                --n;
                try {
                    this.connection.disconnect();
                }
                catch (IOException iOException2) {
                    logger.error("Error disconnecting: " + iOException2);
                }
                if (n == 0) {
                    logger.error("Failed to send request.");
                    throw iOException;
                }
                logger.warn("Trying to send again (" + n + ")");
            }
        }
    }

    private void sendHeader() throws IOException {
        byte[] byArray = new byte[]{13, 10};
        String string = this.method + " " + this.url.getFile() + " " + this.version + "\r\n";
        this.contentLength = this.outputBuffer.size();
        this.setHeaderField("Content-Length", this.contentLength + "");
        try {
            this.outStream.write(string.getBytes());
            this.outStream.write(this.getHeaders().getBytes());
            this.outStream.write(byArray);
            this.outStream.flush();
        }
        catch (IOException iOException) {
            logger.error(iOException + "");
            throw iOException;
        }
    }

    private void sendBody() throws IOException {
        try {
            this.outStream.write(this.outputBuffer.toByteArray());
            this.outStream.flush();
        }
        catch (IOException iOException) {
            logger.error(iOException + "");
            throw iOException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HttpOutputStream
    extends ByteArrayOutputStream {
        private HttpOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            super.close();
            if (!HttpRequest.this.sent) {
                HttpRequest.this.send();
            }
        }
    }
}

