/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.net.Response;
import java.util.Map;

public class BasicResponse
implements Response {
    private int type;
    private Object content;
    private int result;
    private Exception exception;

    public BasicResponse(int n, Object object) {
        this(n, object, 0, null);
    }

    public BasicResponse(int n, Object object, int n2) {
        this(n, object, n2, null);
    }

    public BasicResponse(int n, Object object, int n2, Exception exception) {
        this.type = n;
        this.content = object;
        this.result = n2;
        this.exception = exception;
        if (object != null) {
            this.result = this.getStatus((PropertyList)object);
        }
    }

    public int getType() {
        return this.type;
    }

    public Object getContent() {
        return this.content;
    }

    public int getResultCode() {
        return this.result;
    }

    public Exception getException() {
        return this.exception;
    }

    private int getStatus(PropertyList propertyList) {
        int n = -100;
        try {
            Map map = PListUtils.toDictionary(propertyList.getRootElement(), "root dict");
            Object v = map.get("status");
            n = v != null ? PListUtils.toInteger(v, "status").intValue() : 0;
        }
        catch (PropertyListException propertyListException) {
            this.exception = propertyListException;
        }
        return n;
    }
}

