/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.firstaid;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInfoPanelController;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DriveSelectionPanelEx;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.firstaid.AbstractFirstAidPane;
import com.apple.xsr.firstaid.FirstAidDataModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;

class ManageOrphansPane
extends AbstractFirstAidPane {
    public static final String TAG = "MANAGE_ORPHANS_PANE";
    private static final Image IMG_VALIDATE_OK = Resources.getImage("icon.step.four");
    private static final Image IMG_VALIDATE_ERROR = Resources.getImage("icon.step.five");
    private static final String SUMMARY_CAN = Resources.getString("firstAid.manageOrphans.summary.can");
    private static final String SUMMARY_CANNOT = Resources.getString("firstAid.manageOrphans.summary.cannot.general");
    private static final AbstractFirstAidPane.PaneProperties props = new AbstractFirstAidPane.PaneProperties();

    public ManageOrphansPane(AbstractChooserMgmtPane abstractChooserMgmtPane) {
        super(abstractChooserMgmtPane, props);
    }

    public void populateUI(DataModel dataModel) {
        if (dataModel == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (!(dataModel instanceof FirstAidDataModel)) {
            throw new IllegalArgumentException("illegal data model type \"" + dataModel.getClass() + "\"");
        }
        FirstAidDataModel firstAidDataModel = (FirstAidDataModel)dataModel;
        this.system = firstAidDataModel.getRaidSystem();
        this.driveSelectionPanel.setRaidSystem(this.system);
        this.legend.setRaidSystem(this.system);
    }

    public boolean validateUI(DataModel dataModel) {
        if (dataModel != null && paneExecuted.equals(TAG)) {
            if (!(dataModel instanceof FirstAidDataModel)) {
                throw new IllegalArgumentException("illegal data model type \"" + dataModel.getClass() + "\"");
            }
            FirstAidDataModel firstAidDataModel = (FirstAidDataModel)dataModel;
            firstAidDataModel.setOperation(6);
            Object[] objectArray = ((DriveSelectionPanelEx)this.driveSelectionPanel).getSelectedObjects();
            int n = (Integer)objectArray[0];
            firstAidDataModel.setDriveID(n);
            firstAidDataModel.setControllerID(this.system.getDisk(n).getRaidController().getId());
        }
        return true;
    }

    protected final JPanel createDrivePanel(int n, StepByStepPanel stepByStepPanel, JTextPane jTextPane, JButton jButton) {
        JPanel jPanel = GUIFactory.newPanel(new GridBagLayout());
        DriveInformationPanel driveInformationPanel = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.driveSelectionPanel = new DriveSelectionPanelEx(n);
        ((DriveSelectionPanelEx)this.driveSelectionPanel).setSelectionPolicy(new DrivePanel.DefaultSelectionPolicy(1, 4));
        DriveInfoPanelController driveInfoPanelController = new DriveInfoPanelController(driveInformationPanel);
        ((DriveSelectionPanelEx)this.driveSelectionPanel).addDrivePanelListener(driveInfoPanelController);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)((JPanel)((Object)this.driveSelectionPanel)), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)driveInformationPanel, gridBagConstraints);
        return jPanel;
    }

    protected void addSteps() {
        ((DriveSelectionPanelEx)this.driveSelectionPanel).addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Object[] objectArray = itemEvent.getItemSelectable().getSelectedObjects();
                boolean bl = ManageOrphansPane.this.confirmCheckBox.isSelected();
                boolean bl2 = bl & objectArray.length > 0;
                ManageOrphansPane.this.setPaneValid(bl2);
            }
        });
        this.confirmCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                Object[] objectArray = ((DriveSelectionPanelEx)ManageOrphansPane.this.driveSelectionPanel).getSelectedObjects();
                boolean bl2 = bl && objectArray.length > 0;
                ManageOrphansPane.this.setPaneValid(bl2);
            }
        });
        this.summaryLabel.setText(SUMMARY_CANNOT);
        this.buttons.okButton.setEnabled(false);
    }

    private void setPaneValid(boolean bl) {
        this.buttons.okButton.setEnabled(bl);
        this.summaryHeader.setIcon(bl ? IMG_VALIDATE_OK : IMG_VALIDATE_ERROR);
        this.summaryLabel.setText(bl ? SUMMARY_CAN : SUMMARY_CANNOT);
    }

    static {
        ManageOrphansPane.props.icon = new ImageIcon(Resources.getImage("icon.manageOrphans"));
        ManageOrphansPane.props.title = Resources.getString("firstAid.manageOrphans");
        ManageOrphansPane.props.explanation = Resources.getString("firstAid.manageOrphansExplanation");
        ManageOrphansPane.props.tag = TAG;
        ManageOrphansPane.props.headerText = Resources.getString("firstAid.manageOrphans.selectArray");
        ManageOrphansPane.props.legendTitle = Resources.getString("firstAid.general.legendTitle");
        ManageOrphansPane.props.confirmTitle = Resources.getString("firstAid.manageOrphans.confirmation");
        ManageOrphansPane.props.confirmText = Resources.getString("firstAid.manageOrphans.iUnderstand");
        ManageOrphansPane.props.summaryTitle = Resources.getString("firstAid.general.summaryTitle");
        ManageOrphansPane.props.actionButtonText = Resources.getString("firstAid.manageOrphans.actionButton");
        ManageOrphansPane.props.driveSelectionMode = 1;
        ManageOrphansPane.props.arraySelectionMode = 0;
    }
}

