/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.firstaid;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.Resources;
import com.apple.xsr.firstaid.AbstractFirstAidPane;
import com.apple.xsr.firstaid.FirstAidDataModel;
import com.apple.xsr.som.RaidSet;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class ConditionPane
extends AbstractFirstAidPane {
    public static final String TAG = "CONDITION_PANE";
    private static final AbstractFirstAidPane.PaneProperties props = new AbstractFirstAidPane.PaneProperties();
    private static final String START;
    private static final String PAUSE;
    private static final String RESUME;
    private static final String STOP;
    private static final String CONFIRM_DEFAULT;
    private static final String CONFIRM_START;
    private static final String CONFIRM_PAUSE;
    private static final String CONFIRM_RESUME;
    private static final String CONFIRM_STOP;
    private static final String BUTTON_START;
    private static final String BUTTON_PAUSE;
    private static final String BUTTON_RESUME;
    private static final String BUTTON_STOP;
    private static final int[] PRIORITIES;
    private JComboBox actionCombo;
    private JComboBox priorityCombo;
    private int operation = 2;

    public ConditionPane(AbstractChooserMgmtPane abstractChooserMgmtPane) {
        super(abstractChooserMgmtPane, props);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                ConditionPane.this.updateControlsForRaidSet(n);
            }
        };
        this.driveSelectionPanel.addPropertyChangeListener("ArrayIndex", propertyChangeListener);
        this.legend.addPropertyChangeListener("ArrayIndex", propertyChangeListener);
    }

    public void populateUI(DataModel dataModel) {
        if (dataModel == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (!(dataModel instanceof FirstAidDataModel)) {
            throw new IllegalArgumentException("illegal data model type \"" + dataModel.getClass() + "\"");
        }
        FirstAidDataModel firstAidDataModel = (FirstAidDataModel)dataModel;
        this.system = firstAidDataModel.getRaidSystem();
        this.driveSelectionPanel.setRaidSystem(this.system);
        this.legend.setRaidSystem(this.system);
        int n = firstAidDataModel.getConditioningPriority();
        int n2 = 0;
        for (int i = PRIORITIES.length - 1; i >= 0; --i) {
            if (n < PRIORITIES[i]) continue;
            n2 = i;
            break;
        }
        this.priorityCombo.setSelectedIndex(n2);
    }

    public boolean validateUI(DataModel dataModel) {
        if (dataModel != null && paneExecuted.equals(TAG)) {
            if (!(dataModel instanceof FirstAidDataModel)) {
                throw new IllegalArgumentException("illegal data model type \"" + dataModel.getClass() + "\"");
            }
            FirstAidDataModel firstAidDataModel = (FirstAidDataModel)dataModel;
            firstAidDataModel.setArrayID(this.driveSelectionPanel.getSelectedArray());
            firstAidDataModel.setOperation(this.operation);
            int n = this.priorityCombo.getSelectedIndex();
            if (n >= PRIORITIES.length || n < 0) {
                throw new IllegalStateException("Illegal priority pop up index returned!");
            }
            firstAidDataModel.setConditioningPriority(PRIORITIES[n]);
        }
        return true;
    }

    protected void addSteps() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.addStep(this.getNextStep(), Resources.getString("firstAid.condition.optionsTitle"));
        this.actionCombo = new JComboBox<String>(new String[]{START});
        this.actionCombo.setFont(GUIFactory.FONT_SMALL);
        this.actionCombo.setRequestFocusEnabled(false);
        this.actionCombo.addActionListener(new ActionComboListener());
        jPanel.add(this.actionCombo);
        this.priorityCombo = new JComboBox<String>(new String[]{Resources.getString("firstAid.condition.priorityLow"), Resources.getString("firstAid.condition.priorityMedium"), Resources.getString("firstAid.condition.priorityHigh")});
        this.priorityCombo.setFont(GUIFactory.FONT_SMALL);
        this.priorityCombo.setRequestFocusEnabled(false);
        jPanel.add(this.priorityCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.getCurrentRow();
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        this.setCurrentRow(gridBagConstraints.gridy + 1);
    }

    private void updateControlsForRaidSet(int n) {
        RaidSet raidSet;
        boolean bl = false;
        int n2 = -1;
        if (this.system != null && n > 0 && (raidSet = this.system.getRaidSet(n)) != null) {
            bl = raidSet.getOperation() == 5;
            n2 = raidSet.getBackgroundConditioningState();
        }
        if (bl) {
            if (this.actionCombo.getItemCount() == 2) {
                return;
            }
            this.actionCombo.removeAllItems();
            this.actionCombo.addItem(n2 == 1 ? RESUME : PAUSE);
            this.actionCombo.addItem(STOP);
        } else {
            if (this.actionCombo.getItemCount() == 1) {
                return;
            }
            this.actionCombo.removeAllItems();
            this.actionCombo.addItem(START);
        }
    }

    static {
        ConditionPane.props.icon = new ImageIcon(Resources.getImage("icon.condition"));
        ConditionPane.props.title = Resources.getString("firstAid.condition");
        ConditionPane.props.explanation = Resources.getString("firstAid.conditionExplanation");
        ConditionPane.props.tag = TAG;
        ConditionPane.props.headerText = Resources.getString("firstAid.condition.selectArray");
        ConditionPane.props.legendTitle = Resources.getString("firstAid.general.legendTitle");
        ConditionPane.props.confirmTitle = Resources.getString("firstAid.condition.confirmation");
        ConditionPane.props.confirmText = Resources.getString("firstAid.condition.iUnderstand.start");
        ConditionPane.props.summaryTitle = Resources.getString("firstAid.general.summaryTitle");
        ConditionPane.props.summaryText = Resources.getString("firstAid.condition.summary.cannot.general");
        ConditionPane.props.actionButtonText = Resources.getString("firstAid.condition.actionButton.start");
        ConditionPane.props.driveSelectionMode = 10;
        ConditionPane.props.arraySelectionMode = 1;
        START = Resources.getString("firstAid.condition.start");
        PAUSE = Resources.getString("firstAid.condition.pause");
        RESUME = Resources.getString("firstAid.condition.resume");
        STOP = Resources.getString("firstAid.condition.stop");
        CONFIRM_DEFAULT = Resources.getString("firstAid.condition.iUnderstand.start");
        CONFIRM_START = Resources.getString("firstAid.condition.iUnderstand.start");
        CONFIRM_PAUSE = Resources.getString("firstAid.condition.iUnderstand.pause");
        CONFIRM_RESUME = Resources.getString("firstAid.condition.iUnderstand.start");
        CONFIRM_STOP = Resources.getString("firstAid.condition.iUnderstand.stop");
        BUTTON_START = Resources.getString("firstAid.condition.actionButton.start");
        BUTTON_PAUSE = Resources.getString("firstAid.condition.actionButton.pause");
        BUTTON_RESUME = Resources.getString("firstAid.condition.actionButton.resume");
        BUTTON_STOP = Resources.getString("firstAid.condition.actionButton.stop");
        PRIORITIES = new int[]{50, 75, 100};
    }

    private class ActionComboListener
    implements ActionListener {
        private ActionComboListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ConditionPane.this.actionCombo.getItemCount() == 0) {
                return;
            }
            Object object = ConditionPane.this.actionCombo.getSelectedItem();
            boolean bl = true;
            if (object.equals(START)) {
                ConditionPane.this.operation = 2;
                ConditionPane.this.driveSelectionPanel.setSelectionMode(10);
                ConditionPane.this.buttons.okButton.setText(BUTTON_START);
                ConditionPane.this.confirmCheckBox.setText(CONFIRM_START);
            } else if (object.equals(PAUSE)) {
                ConditionPane.this.operation = 3;
                ConditionPane.this.driveSelectionPanel.setSelectionMode(11);
                ConditionPane.this.buttons.okButton.setText(BUTTON_PAUSE);
                ConditionPane.this.confirmCheckBox.setText(CONFIRM_PAUSE);
                bl = false;
            } else if (object.equals(RESUME)) {
                ConditionPane.this.operation = 4;
                ConditionPane.this.driveSelectionPanel.setSelectionMode(12);
                ConditionPane.this.buttons.okButton.setText(BUTTON_RESUME);
                ConditionPane.this.confirmCheckBox.setText(CONFIRM_RESUME);
            } else if (object.equals(STOP)) {
                ConditionPane.this.operation = 5;
                ConditionPane.this.driveSelectionPanel.setSelectionMode(13);
                ConditionPane.this.buttons.okButton.setText(BUTTON_STOP);
                ConditionPane.this.confirmCheckBox.setText(CONFIRM_STOP);
                bl = false;
            }
            ConditionPane.this.priorityCombo.setEnabled(bl);
        }
    }
}

