/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.firstaid;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.som.RaidSystem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public abstract class AbstractFirstAidPane
extends AbstractManagementPane {
    protected static final int STEP_ONE = 1;
    protected static final int STEP_TWO = 2;
    protected static final int STEP_THREE = 3;
    protected static final int STEP_FOUR = 4;
    static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    static final int LEFT_INDENT_1 = 20;
    static final int LEFT_INDENT_2 = 22;
    static final int STEP_VSPACE = 15;
    private static final int PREFERRED_WIDTH = 663;
    private static final int PREFERRED_HEIGHT = 437;
    protected static String paneExecuted = "";
    protected final AbstractChooserMgmtPane parent;
    protected final ImageIcon icon;
    protected final String title;
    protected final String explanation;
    protected final String tag;
    protected RaidSystem system;
    protected DrivePanel driveSelectionPanel;
    protected JLabel legendLabel;
    protected ArraySelectionPanel legend;
    protected StepByStepPanel summaryHeader;
    protected JTextPane summaryLabel;
    protected JCheckBox confirmCheckBox;
    protected ChooserButtonPanel buttons;
    private final GridBagConstraints constraints = new GridBagConstraints();
    private int nextStep = 1;

    public AbstractFirstAidPane(AbstractChooserMgmtPane abstractChooserMgmtPane, PaneProperties paneProperties) {
        super(663, 437);
        this.parent = abstractChooserMgmtPane;
        this.icon = paneProperties.icon;
        this.title = paneProperties.title;
        this.explanation = paneProperties.explanation;
        this.tag = paneProperties.tag;
        this.setLayout(new GridBagLayout());
        this.summaryHeader = new StepByStepPanel(Resources.getImage("icon.step.five"), paneProperties.summaryTitle);
        this.summaryLabel = GUIFactory.newTextPane(paneProperties.summaryText, 2);
        this.buttons = new ChooserButtonPanel(true);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 17;
        this.constraints.fill = 2;
        this.addStep(1, paneProperties.headerText);
        JPanel jPanel = this.createDrivePanel(paneProperties.driveSelectionMode, this.summaryHeader, this.summaryLabel, this.buttons.okButton);
        this.constraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)jPanel, this.constraints);
        this.constraints.insets = ZERO_INSETS;
        ++this.constraints.gridy;
        this.legendLabel = new JLabel(paneProperties.legendTitle);
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        this.constraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.legendLabel, this.constraints);
        this.constraints.insets = ZERO_INSETS;
        ++this.constraints.gridy;
        this.legend = new ArraySelectionPanel(paneProperties.arraySelectionMode);
        this.constraints.insets = new Insets(0, 20, 15, 0);
        this.constraints.fill = 0;
        this.add((Component)this.legend, this.constraints);
        this.constraints.fill = 2;
        this.constraints.insets = ZERO_INSETS;
        ++this.constraints.gridy;
        JPanel jPanel2 = this.createConfirmationPanel(paneProperties.confirmText);
        JPanel jPanel3 = this.createSummaryPanel();
        this.addSteps();
        if (jPanel2 != null) {
            this.addStep(this.getNextStep(), paneProperties.confirmTitle);
            this.constraints.insets = new Insets(0, 20, 15, 0);
            this.constraints.anchor = 17;
            this.constraints.fill = 0;
            this.constraints.weightx = 1.0;
            this.add((Component)jPanel2, this.constraints);
            this.constraints.weightx = 0.0;
            this.constraints.insets = ZERO_INSETS;
            this.constraints.fill = 2;
            ++this.constraints.gridy;
        }
        if (jPanel3 != null) {
            this.add((Component)this.summaryHeader, this.constraints);
            ++this.constraints.gridy;
            this.constraints.fill = 1;
            this.constraints.weightx = 1.0;
            this.constraints.weighty = 1.0;
            this.constraints.insets = new Insets(0, 20, 15, 0);
            this.add((Component)jPanel3, this.constraints);
            this.constraints.weightx = 0.0;
            this.constraints.weighty = 0.0;
            this.constraints.fill = 0;
            this.constraints.insets = ZERO_INSETS;
            ++this.constraints.gridy;
        }
        this.constraints.weighty = 1.0;
        this.add(Box.createVerticalStrut(0), this.constraints);
        this.constraints.weighty = 0.0;
        ++this.constraints.gridy;
        this.constraints.fill = 2;
        this.add((Component)this.buttons, this.constraints);
        this.constraints.fill = 0;
        this.driveSelectionPanel.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                AbstractFirstAidPane.this.legend.setArrayIndex(n);
            }
        });
        this.legend.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                AbstractFirstAidPane.this.driveSelectionPanel.setSelectedArray(n);
            }
        });
        if (jPanel2 != null) {
            this.confirmCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = AbstractFirstAidPane.this.confirmCheckBox.isSelected();
                    AbstractFirstAidPane.this.driveSelectionPanel.setConfirmed(bl);
                }
            });
        }
        this.buttons.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractFirstAidPane.this.parent.goBackToChooser();
            }
        });
        this.buttons.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(AbstractFirstAidPane.this.parent, 1001, "CANCEL");
                AbstractFirstAidPane.this.parent.fireActionPerformed(actionEvent2);
            }
        });
        this.buttons.okButton.setText(paneProperties.actionButtonText);
        this.buttons.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                paneExecuted = AbstractFirstAidPane.this.getTag();
                ActionEvent actionEvent2 = new ActionEvent(AbstractFirstAidPane.this, 1001, "APPLY");
                AbstractFirstAidPane.this.parent.fireActionPerformed(actionEvent2);
            }
        });
        this.setSize(this.getPreferredSize());
    }

    protected int getCurrentRow() {
        return this.constraints.gridy;
    }

    protected void setCurrentRow(int n) {
        this.constraints.gridy = n;
    }

    protected int getNextStep() {
        return this.nextStep;
    }

    protected void incrementStep() {
        ++this.nextStep;
    }

    protected abstract void addSteps();

    protected JPanel createDrivePanel(int n, StepByStepPanel stepByStepPanel, JTextPane jTextPane, JButton jButton) {
        JPanel jPanel = GUIFactory.newPanel(new GridBagLayout());
        DriveInformationPanel driveInformationPanel = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.driveSelectionPanel = new DriveSelectionPanel(n, driveInformationPanel, stepByStepPanel, jTextPane, this.buttons.okButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)((JPanel)((Object)this.driveSelectionPanel)), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)driveInformationPanel, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createConfirmationPanel(String string) {
        JPanel jPanel = GUIFactory.newPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.confirmCheckBox = GUIFactory.newCheckBox(string);
        this.confirmCheckBox.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.confirmCheckBox, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createSummaryPanel() {
        JPanel jPanel = GUIFactory.newPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.summaryLabel, gridBagConstraints);
        return jPanel;
    }

    protected final void addStep(int n, String string) {
        Image image;
        switch (n) {
            case 1: {
                image = Resources.getImage("icon.step.one");
                break;
            }
            case 2: {
                image = Resources.getImage("icon.step.two");
                break;
            }
            case 3: {
                image = Resources.getImage("icon.step.three");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid step constant (" + n + ")");
            }
        }
        this.constraints.gridx = 0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 17;
        this.constraints.fill = 2;
        StepByStepPanel stepByStepPanel = new StepByStepPanel(image, string);
        this.add((Component)stepByStepPanel, this.constraints);
        ++this.constraints.gridy;
        this.incrementStep();
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getTag() {
        return this.tag;
    }

    static class PaneProperties {
        ImageIcon icon;
        String title;
        String explanation;
        String tag;
        String headerText;
        String legendTitle;
        String confirmTitle;
        String confirmText;
        String summaryTitle;
        String summaryText;
        String actionButtonText;
        int driveSelectionMode;
        int arraySelectionMode;

        PaneProperties() {
        }
    }
}

