/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.eventlog;

import com.apple.gui.GUIFactory;
import com.apple.net.acp.AcpEventLog;
import com.apple.xsr.Resources;
import com.apple.xsr.eventlog.EventLocalizer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class EventPropertySheet
extends JPanel {
    public static final String ACTION_PREVIOUS = "PREVIOUS";
    public static final String ACTION_NEXT = "NEXT";
    public static final String ACTION_COPY = "COPY";
    public static final String ACTION_OK = "OK";
    private SimpleDateFormat fullDateFormat;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat timeFormat;
    private AcpEventLog.Event event;
    private static final String DATE_HEADING = Resources.getString("eventLog.propertiesDialog.dateLabel");
    private static final String TIME_HEADING = Resources.getString("eventLog.propertiesDialog.timeLabel");
    private static final String TIMESTAMP_HEADING = Resources.getString("eventLog.propertiesDialog.timestampLabel");
    private static final String PRIORITY_HEADING = Resources.getString("eventLog.propertiesDialog.priorityLabel");
    private static final String CONTROLLER_HEADING = Resources.getString("eventLog.propertiesDialog.controllerLabel");
    private static final String TYPE_HEADING = Resources.getString("eventLog.propertiesDialog.typeLabel");
    private static final String EVENT_ID_HEADING = Resources.getString("eventLog.propertiesDialog.sequenceIdLabel");
    private static final String MESSAGE_HEADING = Resources.getString("eventLog.propertiesDialog.message");
    private static final String DESCRIPTION_HEADING = Resources.getString("eventLog.propertiesDialog.descriptionLabel");
    private static final String UNKNOWN = Resources.getString("som.unknown");
    private final JLabel dateLabel = new JLabel();
    private final JLabel timeLabel = new JLabel();
    private final JLabel priorityLabel = new JLabel();
    private final JLabel controllerLabel = new JLabel();
    private final JLabel typeLabel = new JLabel();
    private final JLabel idLabel = new JLabel();
    private final JButton previousBtn = GUIFactory.newButton(new ImageIcon(Resources.getImage("icon.eventProperty.previous")));
    private final JButton nextBtn = GUIFactory.newButton(new ImageIcon(Resources.getImage("icon.eventProperty.next")));
    private final JButton copyBtn = GUIFactory.newButton(new ImageIcon(Resources.getImage("icon.eventProperty.copy")));
    private final JButton okBtn = GUIFactory.newOKButton();
    private final JTextPane messageText = GUIFactory.newTextPane();
    private final JTextPane descText = GUIFactory.newTextPane();
    private static final String DELIMITER = "\t";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Insets noInsets = new Insets(0, 0, 0, 0);

    public EventPropertySheet() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.add((Component)this.createInfoPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        this.add((Component)this.createButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.createMessagePanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.createDescriptionPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.setDateFormatString(Resources.getString("eventLog.twelveHourDateFormat"));
    }

    public void setEvent(AcpEventLog.Event event) {
        boolean bl;
        this.event = event;
        if (event != null) {
            this.setDateTime(event.getTime());
            this.setPriority(EventLocalizer.getPriorityLevelString(event.getPriority()));
            this.setController(EventLocalizer.getControllerString(event.getControllerId()));
            this.setType(event.getType() + "");
            this.setEventId(event.getSequenceId() + "");
            this.setMessage(event.getLocalizedMessage());
            this.setDescription(event.getDescription());
            bl = true;
        } else {
            this.setDateTime(null);
            this.setPriority(UNKNOWN);
            this.setController(UNKNOWN);
            this.setType(UNKNOWN);
            this.setEventId(UNKNOWN);
            this.setMessage(UNKNOWN);
            this.setDescription(UNKNOWN);
            bl = false;
        }
        this.previousBtn.setEnabled(bl);
        this.nextBtn.setEnabled(bl);
        this.copyBtn.setEnabled(bl);
    }

    public void setDateTime(Date date) {
        if (date != null) {
            this.dateLabel.setText(this.dateFormat.format(date));
            this.timeLabel.setText(this.timeFormat.format(date));
        } else {
            this.dateLabel.setText(UNKNOWN);
            this.timeLabel.setText(UNKNOWN);
        }
    }

    public void setPriority(String string) {
        this.priorityLabel.setText(string);
    }

    public void setController(String string) {
        this.controllerLabel.setText(string);
    }

    public void setType(String string) {
        this.typeLabel.setText(string);
    }

    public void setEventId(String string) {
        this.idLabel.setText(string);
    }

    public void setMessage(String string) {
        this.messageText.setText(string);
    }

    public void setDescription(String string) {
        this.descText.setText(string);
    }

    public void setDateFormatString(String string) {
        this.fullDateFormat = new SimpleDateFormat(string);
        this.splitDateFormatString(string);
        if (this.event != null) {
            this.setDateTime(this.event.getTime());
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.previousBtn.addActionListener(actionListener);
        this.nextBtn.addActionListener(actionListener);
        this.okBtn.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.previousBtn.removeActionListener(actionListener);
        this.nextBtn.removeActionListener(actionListener);
        this.okBtn.removeActionListener(actionListener);
    }

    private String eventToString(AcpEventLog.Event event) {
        String string = "";
        string = string + TIMESTAMP_HEADING + DELIMITER + this.fullDateFormat.format(event.getTime()) + NEWLINE;
        string = string + PRIORITY_HEADING + DELIMITER + EventLocalizer.getPriorityLevelString(event.getPriority()) + NEWLINE;
        string = string + CONTROLLER_HEADING + DELIMITER + EventLocalizer.getControllerString(event.getControllerId()) + NEWLINE;
        string = string + TYPE_HEADING + DELIMITER + event.getType() + NEWLINE;
        string = string + EVENT_ID_HEADING + DELIMITER + event.getSequenceId() + NEWLINE;
        string = string + MESSAGE_HEADING + DELIMITER + event.getLocalizedMessage() + NEWLINE;
        string = string + DESCRIPTION_HEADING + DELIMITER + event.getDescription() + NEWLINE;
        return string;
    }

    private void splitDateFormatString(String string) {
        char[] cArray = new char[]{'h', 'H', 'k', 'K'};
        int n = -1;
        for (int i = 0; i < cArray.length && (n = string.indexOf(cArray[i])) == -1; ++i) {
        }
        this.dateFormat = new SimpleDateFormat(string.substring(0, n));
        this.timeFormat = new SimpleDateFormat(string.substring(n));
    }

    private JPanel createInfoPanel() {
        int n = 25;
        JPanel jPanel = GUIFactory.newPanel(new GridBagLayout());
        int n2 = 0;
        int n3 = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(4, 0, 4, 8);
        Insets insets2 = new Insets(4, 0, 4, 14);
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        JLabel jLabel = new JLabel(DATE_HEADING);
        jLabel.setFont(GUIFactory.FONT_SMALL);
        jLabel.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = n2 + 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 14);
        gridBagConstraints.ipadx = n;
        this.dateLabel.setFont(GUIFactory.FONT_SMALL);
        jPanel.add((Component)this.dateLabel, gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = insets;
        JLabel jLabel2 = new JLabel(TIME_HEADING);
        jLabel2.setFont(GUIFactory.FONT_SMALL);
        jLabel2.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = n2 + 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets2;
        this.timeLabel.setFont(GUIFactory.FONT_SMALL);
        jPanel.add((Component)this.timeLabel, gridBagConstraints);
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = insets;
        JLabel jLabel3 = new JLabel(PRIORITY_HEADING);
        jLabel3.setFont(GUIFactory.FONT_SMALL);
        jLabel3.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = n2 + 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets2;
        this.priorityLabel.setFont(GUIFactory.FONT_SMALL);
        jPanel.add((Component)this.priorityLabel, gridBagConstraints);
        insets = new Insets(4, 0, 4, 8);
        insets2 = new Insets(4, 0, 4, 0);
        n3 = 0;
        gridBagConstraints.gridx = n2 += 2;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        JLabel jLabel4 = new JLabel(CONTROLLER_HEADING);
        jLabel4.setFont(GUIFactory.FONT_SMALL);
        jLabel4.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = n2 + 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints.ipadx = n;
        this.controllerLabel.setFont(GUIFactory.FONT_SMALL);
        jPanel.add((Component)this.controllerLabel, gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = insets;
        JLabel jLabel5 = new JLabel(TYPE_HEADING);
        jLabel5.setFont(GUIFactory.FONT_SMALL);
        jLabel5.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = n2 + 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets2;
        this.typeLabel.setFont(GUIFactory.FONT_SMALL);
        jPanel.add((Component)this.typeLabel, gridBagConstraints);
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = insets;
        JLabel jLabel6 = new JLabel(EVENT_ID_HEADING);
        jLabel6.setFont(GUIFactory.FONT_SMALL);
        jLabel6.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridx = n2 + 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets2;
        this.idLabel.setFont(GUIFactory.FONT_SMALL);
        jPanel.add((Component)this.idLabel, gridBagConstraints);
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = GUIFactory.newPanel(new GridLayout(3, 1, 0, 4));
        this.previousBtn.setActionCommand(ACTION_PREVIOUS);
        this.nextBtn.setActionCommand(ACTION_NEXT);
        this.copyBtn.setActionCommand(ACTION_COPY);
        this.copyBtn.setToolTipText(Resources.getString("eventLog.propertiesDialog.copyTip"));
        this.copyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringSelection stringSelection = new StringSelection(EventPropertySheet.this.eventToString(EventPropertySheet.this.event));
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        jPanel.add(this.previousBtn);
        jPanel.add(this.nextBtn);
        jPanel.add(this.copyBtn);
        return jPanel;
    }

    private JPanel createMessagePanel() {
        JPanel jPanel = GUIFactory.newPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        JLabel jLabel = new JLabel(MESSAGE_HEADING);
        jLabel.setFont(GUIFactory.FONT_SMALL);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.messageText.setFont(GUIFactory.FONT_SMALL);
        this.messageText.setEditable(false);
        this.messageText.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.add((Component)this.messageText, gridBagConstraints);
        return jPanel;
    }

    private JPanel createDescriptionPanel() {
        JPanel jPanel = GUIFactory.newPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        JLabel jLabel = new JLabel(DESCRIPTION_HEADING);
        jLabel.setFont(GUIFactory.FONT_SMALL);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.descText.setFont(GUIFactory.FONT_SMALL);
        this.descText.setEditable(false);
        this.descText.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.add((Component)this.descText, gridBagConstraints);
        return jPanel;
    }

    private JPanel createOkButtonPanel() {
        JPanel jPanel = GUIFactory.newPanel(new FlowLayout(2, 0, 0));
        this.okBtn.setFont(GUIFactory.FONT_SMALL);
        this.okBtn.setActionCommand(ACTION_OK);
        jPanel.add(this.okBtn);
        return jPanel;
    }
}

