/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.eventlog;

import com.apple.gui.AlternatingTable;
import com.apple.gui.GUIFactory;
import com.apple.mrj.MRJFileUtils;
import com.apple.net.acp.AcpEventLog;
import com.apple.util.Gestalt;
import com.apple.util.ImageUtilities;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import com.apple.xsr.StatusIndicator;
import com.apple.xsr.Utilities;
import com.apple.xsr.eventlog.EventLog;
import com.apple.xsr.eventlog.EventLogConstants;
import com.apple.xsr.eventlog.EventPropertySheet;
import com.apple.xsr.som.RaidSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.FilteredImageSource;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class EventLogPane
extends JPanel {
    public static final int TIME_FORMAT_12_HOUR = 12;
    public static final int TIME_FORMAT_24_HOUR = 24;
    public static final int COLUMN_PRIORITY = 0;
    public static final int COLUMN_CONTROLLER = 1;
    public static final int COLUMN_TIME = 2;
    public static final int COLUMN_EVENT = 3;
    private final String[] COLUMNS = new String[]{" ", " ", Resources.getString("eventLog.column.time"), Resources.getString("eventLog.column.event")};
    private static final int TABLE_ROW_HEIGHT = 20;
    private static final int COLUMN_WIDTH_PRIORITY = 20;
    private static final int COLUMN_WIDTH_CONTROLLER = 20;
    private static final String PRIORITY_LEVEL_INFO_STRING = Resources.getString("eventLog.priorityLevel.info");
    private static final String PRIORITY_LEVEL_WARNING_STRING = Resources.getString("eventLog.priorityLevel.warning");
    private static final String PRIORITY_LEVEL_ERROR_STRING = Resources.getString("eventLog.priorityLevel.error");
    private static final String PRIORITY_LEVEL_UNKNOWN_STRING = Resources.getString("eventLog.priorityLevel.unknown");
    private static final String UPPER_CONTROLLER_STRING = Resources.getString("eventLog.upperController");
    private static final String LOWER_CONTROLLER_STRING = Resources.getString("eventLog.lowerController");
    private static final String DATE_FORMAT_12_HOUR = Resources.getString("eventLog.twelveHourDateFormat");
    private static final String DATE_FORMAT_24_HOUR = Resources.getString("eventLog.twentyFourHourDateFormat");
    private static final String SHOW_INSPECTOR_KEY = "apple.showInspector";
    private static final String DESELECT_KEY = "apple.deselectRow";
    private RaidSystem system;
    private Model model;
    private AlternatingTable table;
    private JScrollPane scrollPane;
    private JFrame inspectorWindow;
    private EventPropertySheet propertySheet;
    private JButton printButton = GUIFactory.newButton(Resources.getString("eventLog.printButtonLabel"));
    private JButton saveButton = GUIFactory.newButton(Resources.getString("eventLog.saveButtonLabel"));
    private SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_12_HOUR);
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$eventlog$EventLogPane == null ? (class$com$apple$xsr$eventlog$EventLogPane = EventLogPane.class$("com.apple.xsr.eventlog.EventLogPane")) : class$com$apple$xsr$eventlog$EventLogPane);
    static /* synthetic */ Class class$com$apple$xsr$eventlog$EventLogPane;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public EventLogPane() {
        GUIFactory.configureComponentForPlatform(this);
        this.model = new Model();
        this.table = new AlternatingTable(this.model);
        this.table.getSelectionModel().setSelectionMode(0);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setResizable(false);
        tableColumn.setCellRenderer(new PriorityRenderer());
        tableColumn.setHeaderRenderer(new IconHeaderRenderer(Resources.getImage("icon.status.header")));
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        tableColumn2.setMinWidth(20);
        tableColumn2.setMaxWidth(20);
        tableColumn2.setResizable(false);
        tableColumn2.setCellRenderer(new ControllerRenderer());
        tableColumn2.setHeaderRenderer(new IconHeaderRenderer(Resources.getImage("icon.controller.header")));
        TableColumn tableColumn3 = this.table.getColumnModel().getColumn(2);
        tableColumn3.setMinWidth(135);
        tableColumn3.setCellRenderer(new StringRenderer(this.dateFormat));
        TableColumn tableColumn4 = this.table.getColumnModel().getColumn(3);
        tableColumn4.setMinWidth(250);
        tableColumn4.setCellRenderer(new StringRenderer());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 6, 16));
        this.setLayout(gridBagLayout);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        JPanel jPanel = GUIFactory.newPanel(new BorderLayout());
        jPanel.add((Component)this.scrollPane, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = this.createButtonPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 0, 2, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EventLogPane.this.propertySheet != null) {
                    int n = EventLogPane.this.table.getSelectedRow();
                    EventLogPane.this.propertySheet.setEvent(EventLogPane.this.model.getEvent(n));
                }
            }
        });
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = EventLogPane.this.scrollPane.getViewport().getWidth();
                int n2 = EventLogPane.this.table.getColumnModel().getTotalColumnWidth();
                if (n2 != n) {
                    TableColumn tableColumn = EventLogPane.this.table.getColumnModel().getColumn(3);
                    tableColumn.setPreferredWidth(tableColumn.getWidth() + n - n2);
                }
            }
        });
        this.saveButton.addActionListener(new SaveAction());
        this.printButton.addActionListener(new PrintAction());
        this.setButtonsEnabled(false);
        ShowInspectorAction showInspectorAction = new ShowInspectorAction();
        DeselectAction deselectAction = new DeselectAction();
        ActionMap actionMap = this.table.getActionMap();
        InputMap inputMap = this.table.getInputMap(1);
        if (actionMap != null && inputMap != null) {
            actionMap.put(SHOW_INSPECTOR_KEY, showInspectorAction);
            inputMap.put(KeyStroke.getKeyStroke(10, 0), SHOW_INSPECTOR_KEY);
            actionMap.put(DESELECT_KEY, deselectAction);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), DESELECT_KEY);
        }
        this.table.addMouseListener(showInspectorAction);
        Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        if (preferences != null) {
            String string = Gestalt.timeFormat == 12 ? "12" : "24";
            String string2 = preferences.getString("TimeFormat", string);
            this.setTimeFormat(string2);
            preferences.addPreferenceChangeListener(new Preferences.PreferenceChangeListener(){

                public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
                    if (preferenceChangeEvent.getKey().equals("TimeFormat")) {
                        EventLogPane.this.setTimeFormat((String)preferenceChangeEvent.getNewValue());
                        EventLogPane.this.repaint();
                    } else if (preferenceChangeEvent.getKey().equals("UseShapes")) {
                        EventLogPane.this.repaint();
                    }
                }
            });
        }
    }

    public void updateInfo(RaidSystem raidSystem) {
        this.system = raidSystem;
        if (raidSystem != null) {
            if (this.model.log != raidSystem.getEventLog()) {
                this.model.setEventLog(raidSystem.getEventLog());
            }
        } else {
            this.model.setEventLog(null);
            if (this.propertySheet != null) {
                this.propertySheet.setEvent(null);
            }
        }
    }

    public void setTimeFormat(int n) {
        if (n != 12 && n != 24) {
            throw new IllegalArgumentException("Invalid time format: " + n);
        }
        String string = n == 12 ? DATE_FORMAT_12_HOUR : DATE_FORMAT_24_HOUR;
        this.dateFormat.applyPattern(string);
        if (this.propertySheet != null) {
            this.propertySheet.setDateFormatString(string);
        }
    }

    public void setTimeFormat(String string) {
        if (string.equals("12")) {
            this.setTimeFormat(12);
        } else {
            this.setTimeFormat(24);
        }
    }

    private void displayInspectorWindow(int n) {
        AcpEventLog.Event event = this.model.getEvent(n);
        if (this.inspectorWindow == null) {
            this.propertySheet = new EventPropertySheet();
            Frame frame = (Frame)SwingUtilities.getWindowAncestor(this);
            this.inspectorWindow = new InspectorWindow(frame, this.propertySheet);
        }
        this.propertySheet.setEvent(event);
        this.inspectorWindow.show();
    }

    private void setButtonsEnabled(boolean bl) {
        this.saveButton.setEnabled(bl);
        this.printButton.setEnabled(bl);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = GUIFactory.newPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 0);
        jPanel.setLayout(boxLayout);
        this.saveButton.setFont(GUIFactory.FONT_SMALL);
        this.printButton.setFont(GUIFactory.FONT_SMALL);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.saveButton);
        jPanel.add(Box.createHorizontalStrut(8));
        jPanel.add(this.printButton);
        return jPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class InspectorWindow
    extends JFrame {
        private static final int WIDTH = 450;
        private static final int HEIGHT = 350;

        public InspectorWindow(Frame frame, EventPropertySheet eventPropertySheet) {
            eventPropertySheet.setBorder(BorderFactory.createEmptyBorder(20, 20, 28, 20));
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)eventPropertySheet, "Center");
            this.setTitle(Resources.getString("eventLog.propertiesDialog.windowTitle"));
            this.setJMenuBar(RaidAdmin.newMenuBar(1));
            this.setDefaultCloseOperation(2);
            this.setSize(450, 350);
            this.setResizable(false);
            Utilities.setWindowLocationRelativeToComponent(this, frame);
            eventPropertySheet.addActionListener(new ActionListener(this, EventLogPane.this){
                private final /* synthetic */ EventLogPane val$this$0;
                private final /* synthetic */ InspectorWindow this$1;
                {
                    this.this$1 = inspectorWindow;
                    this.val$this$0 = eventLogPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2 = n = EventLogPane.access$100(InspectorWindow.access$1700(this.this$1)).getSelectedRow();
                    if (actionEvent.getActionCommand().equals("PREVIOUS")) {
                        if (n != -1 && n > 0) {
                            n2 = n - 1;
                        }
                    } else if (actionEvent.getActionCommand().equals("NEXT") && n != -1 && n < EventLogPane.access$200(InspectorWindow.access$1700(this.this$1)).getRowCount() - 1) {
                        n2 = n + 1;
                    }
                    if (n2 != n) {
                        EventLogPane.access$100(InspectorWindow.access$1700(this.this$1)).setRowSelectionInterval(n2, n2);
                        Rectangle rectangle = EventLogPane.access$100(InspectorWindow.access$1700(this.this$1)).getCellRect(n2, 0, false);
                        EventLogPane.access$100(InspectorWindow.access$1700(this.this$1)).scrollRectToVisible(rectangle);
                        AcpEventLog.Event event = EventLogPane.access$200(InspectorWindow.access$1700(this.this$1)).getEvent(n2);
                        if (event != null) {
                            EventLogPane.access$000(InspectorWindow.access$1700(this.this$1)).setEvent(event);
                        }
                    }
                }
            });
        }

        static /* synthetic */ EventLogPane access$1700(InspectorWindow inspectorWindow) {
            return inspectorWindow.EventLogPane.this;
        }
    }

    private class ShowInspectorAction
    extends AbstractAction
    implements MouseListener {
        public ShowInspectorAction() {
            this.putValue("ActionCommandKey", EventLogPane.SHOW_INSPECTOR_KEY);
            this.putValue("LongDescription", "");
            this.putValue("ShortDescription", "");
            this.putValue("SmallIcon", null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = EventLogPane.this.table.getSelectedRow();
            this.showInspector(n);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = EventLogPane.this.table.rowAtPoint(mouseEvent.getPoint());
                this.showInspector(n);
            }
        }

        private void showInspector(int n) {
            if (n >= 0 && n <= EventLogPane.this.table.getRowCount()) {
                EventLogPane.this.displayInspectorWindow(n);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class DeselectAction
    extends AbstractAction {
        public DeselectAction() {
            this.putValue("ActionCommandKey", EventLogPane.DESELECT_KEY);
            this.putValue("LongDescription", "");
            this.putValue("ShortDescription", "");
            this.putValue("SmallIcon", null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventLogPane.this.table.clearSelection();
        }
    }

    class PrintAction
    implements ActionListener,
    Printable {
        private final String COLUMN_HEADING_PRIORITY = Resources.getString("eventLog.print.column.priority");
        private final String COLUMN_HEADING_CONTROLLER = Resources.getString("eventLog.print.column.controller");
        private final String COLUMN_HEADING_TIME = Resources.getString("eventLog.print.column.time");
        private final String COLUMN_HEADING_EVENT = Resources.getString("eventLog.print.column.event");
        private final int HEADER_HEIGHT = 45;
        private final int FOOTER_HEIGHT = 0;
        private final int[] COLUMN_OFFSETS = new int[]{0, 50, 140, 250};
        private final Font font = GUIFactory.FONT_PRINT;
        private final float fontSize = this.font.getSize();
        private final Color color = Color.black;
        private EventLog log;

        PrintAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.log = EventLogPane.this.system.getEventLog();
            if (this.log != null) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(this);
                try {
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            double d = pageFormat.getImageableHeight() - 45.0 - 0.0;
            int n2 = (int)(d / (double)this.fontSize) - (d % (double)this.fontSize > 0.0 ? 1 : 0);
            int n3 = this.log.getEventCount();
            int n4 = n3 / n2 + (n3 % n2 > 0 ? 1 : 0);
            if (n > n4 - 1) {
                return 1;
            }
            logger.info("Printing event log page index " + n + ". Count = " + n3 + " Pages = " + n4);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            graphics.setFont(this.font);
            graphics.setColor(this.color);
            this.renderHeader(graphics2D, pageFormat, n);
            this.renderBody(graphics2D, pageFormat, n);
            this.renderFooter(graphics2D, pageFormat, n);
            return 0;
        }

        private void renderBody(Graphics2D graphics2D, PageFormat pageFormat, int n) {
            int n2 = 0;
            int n3 = 45;
            double d = pageFormat.getImageableHeight() - 45.0 - 0.0;
            int n4 = (int)(d / (double)this.fontSize) - (d % (double)this.fontSize > 0.0 ? 1 : 0);
            Iterator iterator = this.log.getEvents(n4 * n);
            for (int i = 0; iterator.hasNext() && i < n4; ++i) {
                AcpEventLog.Event event = (AcpEventLog.Event)iterator.next();
                int n5 = EventLogConstants.eventPriorityToElementStatus(event.getPriority());
                String string = n5 == 0 ? " " : (n5 == 1 ? PRIORITY_LEVEL_WARNING_STRING : (n5 == 64 ? PRIORITY_LEVEL_ERROR_STRING : " "));
                graphics2D.drawString(string, n2 + this.COLUMN_OFFSETS[0], n3);
                string = event.getControllerId() == 1 ? UPPER_CONTROLLER_STRING : LOWER_CONTROLLER_STRING;
                graphics2D.drawString(string, n2 + this.COLUMN_OFFSETS[1], n3);
                string = EventLogPane.this.dateFormat.format(event.getTime());
                graphics2D.drawString(string, n2 + this.COLUMN_OFFSETS[2], n3);
                string = event.getLocalizedMessage();
                graphics2D.drawString(string, n2 + this.COLUMN_OFFSETS[3], n3);
                n3 = (int)((float)n3 + this.fontSize);
            }
        }

        private void renderHeader(Graphics2D graphics2D, PageFormat pageFormat, int n) {
            int n2 = 0;
            int n3 = (int)this.fontSize;
            double d = pageFormat.getImageableWidth();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            String string = Resources.getStringWithReplacement("eventLog.print.pageTitle", new Object[]{"system_name", EventLogPane.this.system.getName()});
            Rectangle2D rectangle2D = this.font.getStringBounds(string, fontRenderContext);
            graphics2D.setFont(this.font.deriveFont(1));
            graphics2D.drawString(string, (float)(d / 2.0 - rectangle2D.getWidth() / 2.0), (float)n3);
            graphics2D.setFont(this.font);
            n3 = (int)((float)n3 + this.fontSize * 2.0f);
            graphics2D.drawString(this.COLUMN_HEADING_PRIORITY, n2 + this.COLUMN_OFFSETS[0], n3);
            graphics2D.drawString(this.COLUMN_HEADING_CONTROLLER, n2 + this.COLUMN_OFFSETS[1], n3);
            graphics2D.drawString(this.COLUMN_HEADING_TIME, n2 + this.COLUMN_OFFSETS[2], n3);
            graphics2D.drawString(this.COLUMN_HEADING_EVENT, n2 + this.COLUMN_OFFSETS[3], n3);
            String string2 = Resources.getStringWithReplacement("eventLog.print.pageNumber", new Object[]{"page", n + 1 + ""});
            rectangle2D = this.font.getStringBounds(string2, fontRenderContext);
            graphics2D.drawString(string2, (int)(d - rectangle2D.getWidth()), n3);
            n3 = (int)((float)n3 + this.fontSize / 2.0f);
            graphics2D.drawLine(n2, n3, (int)d, n3);
        }

        private void renderFooter(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        }
    }

    class SaveAction
    implements ActionListener {
        private final String ENCODING = "UTF-16";
        private final String DELIMITER = Resources.getString("eventLog.saveToFile.fieldDelimiter");

        SaveAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.showSaveDialog();
            if (string != null) {
                this.saveLog(string);
            }
        }

        private String showSaveDialog() {
            String string = null;
            FileDialog fileDialog = this.createFileDialog();
            fileDialog.show();
            if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
                string = fileDialog.getDirectory() + fileDialog.getFile();
            }
            fileDialog.dispose();
            return string;
        }

        private FileDialog createFileDialog() {
            Component component;
            String string = "";
            String string2 = null;
            if (Gestalt.isMacOS()) {
                try {
                    string2 = MRJFileUtils.findFolder(MRJFileUtils.kDesktopFolderType).getPath();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if ((component = SwingUtilities.getRoot(EventLogPane.this)) == null || !(component instanceof Frame)) {
                throw new NullPointerException("Could not find root frame for " + EventLogPane.this.getName());
            }
            FileDialog fileDialog = new FileDialog((Frame)component, string, 1);
            String string3 = Resources.getStringWithReplacement("eventLog.saveToFile.defaultFilename", new Object[]{"system_name", EventLogPane.this.system.getName()});
            fileDialog.setFile(string3);
            if (string2 != null) {
                fileDialog.setDirectory(string2);
            }
            return fileDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void saveLog(String string) {
            EventLog eventLog = EventLogPane.this.system.getEventLog();
            if (eventLog.getEventCount() <= 0) return;
            BufferedWriter bufferedWriter = null;
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-16"));
            Iterator iterator = eventLog.getEvents();
            while (iterator.hasNext()) {
                AcpEventLog.Event event = (AcpEventLog.Event)iterator.next();
                String string2 = "";
                int n = EventLogConstants.eventPriorityToElementStatus(event.getPriority());
                string2 = n == 0 ? string2 + " " : (n == 1 ? string2 + PRIORITY_LEVEL_WARNING_STRING : (n == 64 ? string2 + PRIORITY_LEVEL_ERROR_STRING : string2 + " "));
                string2 = string2 + this.DELIMITER;
                string2 = event.getControllerId() == 1 ? string2 + UPPER_CONTROLLER_STRING : string2 + LOWER_CONTROLLER_STRING;
                string2 = string2 + this.DELIMITER;
                string2 = string2 + EventLogPane.this.dateFormat.format(event.getTime()) + this.DELIMITER;
                string2 = string2 + event.getLocalizedMessage();
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            Object var9_9 = null;
            if (bufferedWriter == null) return;
            try {
                bufferedWriter.close();
                return;
            }
            catch (IOException iOException) {}
            return;
            {
                catch (IOException iOException) {
                    Object var9_10 = null;
                    if (bufferedWriter == null) return;
                    try {
                        bufferedWriter.close();
                        return;
                    }
                    catch (IOException iOException2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (bufferedWriter == null) throw throwable;
                try {
                    bufferedWriter.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static class StringRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel label = new JLabel();
        private AlternatingTable.CellBorder border = new AlternatingTable.CellBorder();
        private Format formatter;

        public StringRenderer() {
            this((Format)null);
        }

        public StringRenderer(Format format) {
            this.formatter = format;
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(this.border);
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            this.border.setAttributes(bl, jTable.hasFocus(), n);
            if (this.formatter != null) {
                this.label.setText(this.formatter.format(object));
            } else {
                this.label.setText((String)object);
            }
            this.label.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    static class ControllerRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel label = new JLabel();
        private AlternatingTable.CellBorder border = new AlternatingTable.CellBorder();
        private static final ImageIcon upper = new ImageIcon(Resources.getImage("icon.controller.upper"));
        private static final ImageIcon lower = new ImageIcon(Resources.getImage("icon.controller.lower"));
        private final ImageIcon upperSelected = new ImageIcon(this.createImage(new FilteredImageSource(upper.getImage().getSource(), ImageUtilities.getWhiteningFilterInstance())));
        private final ImageIcon lowerSelected = new ImageIcon(this.createImage(new FilteredImageSource(lower.getImage().getSource(), ImageUtilities.getWhiteningFilterInstance())));

        public ControllerRenderer() {
            this.setLayout(new GridLayout(1, 1, 0, 0));
            this.setBorder(this.border);
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            int n3 = (Integer)object;
            if (n3 == 1) {
                this.label.setIcon(bl ? this.upperSelected : upper);
                this.setToolTipText(UPPER_CONTROLLER_STRING);
            } else if (n3 == 2) {
                this.label.setIcon(bl ? this.lowerSelected : lower);
                this.setToolTipText(LOWER_CONTROLLER_STRING);
            } else {
                this.label.setIcon(null);
                this.setToolTipText("");
            }
            this.label.setForeground(bl ? Color.white : Color.black);
            this.border.setAttributes(bl, jTable.hasFocus(), n);
            return this;
        }
    }

    class PriorityRenderer
    extends JPanel
    implements TableCellRenderer {
        AlternatingTable.CellBorder border = new AlternatingTable.CellBorder();
        StatusIndicator indicator = new StatusIndicator();

        public PriorityRenderer() {
            this.setLayout(new GridLayout(1, 1, 0, 0));
            this.setBorder(this.border);
            this.indicator.setStatus(-1);
            this.add(this.indicator);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            int n3 = EventLogConstants.eventPriorityToElementStatus((Integer)object);
            this.indicator.setStatus(n3);
            if (n3 == 0) {
                this.setToolTipText(PRIORITY_LEVEL_INFO_STRING);
            } else if (n3 == 1) {
                this.setToolTipText(PRIORITY_LEVEL_WARNING_STRING);
            } else if (n3 == 64) {
                this.setToolTipText(PRIORITY_LEVEL_ERROR_STRING);
            } else {
                this.setToolTipText(PRIORITY_LEVEL_UNKNOWN_STRING);
            }
            this.border.setAttributes(bl, jTable.hasFocus(), n);
            return this;
        }
    }

    static class IconHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        public IconHeaderRenderer(Image image) {
            JLabel jLabel = new JLabel();
            jLabel.setIcon(new ImageIcon(image));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.add(jLabel);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this;
        }
    }

    private class Model
    extends AbstractTableModel
    implements ListDataListener {
        EventLog log;

        public void setEventLog(EventLog eventLog) {
            if (this.log != null) {
                this.log.removeListDataListener(this);
            }
            this.log = eventLog;
            this.fireTableDataChanged();
            EventLogPane.this.setButtonsEnabled(this.log != null && this.log.getEventCount() > 0);
            if (eventLog != null) {
                eventLog.addListDataListener(this);
            }
        }

        public EventLog getEventLog() {
            return this.log;
        }

        public int getRowCount() {
            if (this.log == null) {
                return 0;
            }
            return this.log.getEventCount();
        }

        public int getColumnCount() {
            return EventLogPane.this.COLUMNS.length;
        }

        public AcpEventLog.Event getEvent(int n) {
            AcpEventLog.Event event = null;
            if (n != -1 && this.log != null) {
                event = this.log.getEvent(n);
            }
            return event;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (this.log != null) {
                AcpEventLog.Event event = this.log.getEvent(n);
                switch (n2) {
                    case 0: {
                        object = new Integer(event.getPriority());
                        break;
                    }
                    case 1: {
                        object = new Integer(event.getControllerId());
                        break;
                    }
                    case 2: {
                        object = event.getTime();
                        break;
                    }
                    case 3: {
                        object = event.getLocalizedMessage();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal column: " + n2);
                    }
                }
            }
            return object;
        }

        public String getColumnName(int n) {
            if (n >= EventLogPane.this.COLUMNS.length) {
                throw new IllegalArgumentException("Illegal column: " + n);
            }
            return EventLogPane.this.COLUMNS[n];
        }

        public Class getColumnClass(int n) {
            Class clazz = null;
            switch (n) {
                case 0: {
                    clazz = class$java$lang$Object == null ? (class$java$lang$Object = EventLogPane.class$("java.lang.Object")) : class$java$lang$Object;
                    break;
                }
                case 1: {
                    clazz = class$java$lang$String == null ? (class$java$lang$String = EventLogPane.class$("java.lang.String")) : class$java$lang$String;
                    break;
                }
                case 2: {
                    clazz = class$java$lang$String == null ? (class$java$lang$String = EventLogPane.class$("java.lang.String")) : class$java$lang$String;
                    break;
                }
                case 3: {
                    clazz = class$java$lang$String == null ? (class$java$lang$String = EventLogPane.class$("java.lang.String")) : class$java$lang$String;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + n);
                }
            }
            return clazz;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Model this$1;
                {
                    this.this$1 = model;
                }

                public void run() {
                    this.this$1.fireTableDataChanged();
                    EventLogPane.access$400(Model.access$600(this.this$1), this.this$1.log.getEventCount() > 0);
                }
            });
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        static /* synthetic */ EventLogPane access$600(Model model) {
            return model.EventLogPane.this;
        }
    }
}

