/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.eventlog;

import com.apple.net.acp.AcpEventLog;
import com.apple.util.plist.PropertyListUtilities;
import com.apple.xsr.eventlog.EventLocalizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class EventLog
extends AcpEventLog
implements ListModel {
    protected Comparator comparator;
    protected EventLocalizer localizer = new EventLocalizer();
    protected EventListenerList listenerList = new EventListenerList();
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$eventlog$EventLog == null ? (class$com$apple$xsr$eventlog$EventLog = EventLog.class$("com.apple.xsr.eventlog.EventLog")) : class$com$apple$xsr$eventlog$EventLog);
    static /* synthetic */ Class class$com$apple$xsr$eventlog$EventLog;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public EventLog() {
    }

    public EventLog(EventLog eventLog) {
        this.comparator = eventLog.comparator;
        this.events = (ArrayList)eventLog.events.clone();
    }

    public EventLog(String string, int n) throws Exception {
        List list = (List)PropertyListUtilities.readXML(new StringReader(string));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AcpEventLog.Event event = new AcpEventLog.Event((String)iterator.next(), n);
            this.events.add(event);
        }
        this.sort();
    }

    public EventLog(Iterator iterator, int n) throws Exception {
        this.appendEvents(iterator, n);
    }

    public synchronized void setSortOrder(Comparator comparator) {
        this.comparator = comparator;
    }

    public synchronized void appendEvents(Iterator iterator) throws Exception {
        this.appendEvents(iterator, -1);
    }

    public synchronized void appendEvents(Iterator iterator, int n) throws Exception {
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                AcpEventLog.Event event = new AcpEventLog.Event(string, n);
                this.localizer.localize(event);
                this.events.add(event);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                logger.error("Unable to parse event \"" + string + "\". Possibly using old event format.");
            }
            catch (Exception exception) {
                logger.error("Error while appending events to the event log: " + exception);
            }
        }
        this.sort();
        this.fireListDataContentsChanged();
    }

    public synchronized AcpEventLog.Event getLastEvent(int n) {
        if (this.events.isEmpty()) {
            return null;
        }
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            AcpEventLog.Event event = (AcpEventLog.Event)iterator.next();
            if (event.getControllerId() != n) continue;
            return event;
        }
        return null;
    }

    public synchronized void clearEvents() {
        super.clearEvents();
        this.fireListDataContentsChanged();
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = EventLog.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = EventLog.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public int getSize() {
        return this.getEventCount();
    }

    public Object getElementAt(int n) {
        return this.events.get(n);
    }

    protected void fireListDataContentsChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? EventLog.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 0, -1, -1);
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    protected void fireListDataIntervalAdded() {
        this.fireListDataContentsChanged();
    }

    protected void fireListDataIntervalRemoved() {
        this.fireListDataContentsChanged();
    }

    private void sort() {
        if (this.comparator == null) {
            Collections.sort(this.events);
        } else {
            Collections.sort(this.events, this.comparator);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

