/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.advanced;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.advanced.AdvancedPane;
import com.apple.xsr.advanced.AdvancedSlicingModel;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.apache.log4j.Logger;

public class AdvancedSlicingPane
extends AbstractManagementPane {
    private final AdvancedPane parent;
    private DriveSelectionPanel drivePanel;
    private JLabel legendLabel;
    private ArraySelectionPanel legend;
    RadioButtonGroup sliceCountRadioGroup;
    JRadioButton[] sliceRadioButton;
    JLabel sliceCountLabel;
    JLabel sliceCountCurrentLabel;
    private StepByStepPanel summaryHeader;
    private JTextPane summaryLabel;
    JCheckBox confirmCheckBox;
    ChooserButtonPanel buttons;
    private JTextField[] sizeTextFields;
    private JLabel totalLabel = new JLabel();
    private RaidSystem system;
    private int[][] sliceSizes;
    private int mode = -1;
    private static final String TAG = "ADVANCED_SLICING";
    private static final int PREFERRED_WIDTH = 663;
    private static final int PREFERRED_HEIGHT = 437;
    private static final int MAX_SLICES = 6;
    private static final int MIN_EXPAND_DIFFERENCE_MB = 81920;
    private static final int MODE_SLICING = 0;
    private static final int MODE_MERGING = 1;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final int LEFT_INDENT = 20;
    private static final int STEP_VSPACE = 15;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$advanced$AdvancedSlicingPane == null ? (class$com$apple$xsr$advanced$AdvancedSlicingPane = AdvancedSlicingPane.class$("com.apple.xsr.advanced.AdvancedSlicingPane")) : class$com$apple$xsr$advanced$AdvancedSlicingPane);
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedSlicingPane;
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedSlicingModel;

    public AdvancedSlicingPane(AdvancedPane advancedPane) {
        super(663, 437);
        this.parent = advancedPane;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        StepByStepPanel stepByStepPanel = new StepByStepPanel(Resources.getImage("icon.step.five"), Resources.getString("advanced.slicing.summary"));
        this.summaryLabel = GUIFactory.newTextPane(Resources.getString("advanced.slicing.summary.cannot.general"), 2);
        this.buttons = new ChooserButtonPanel(true);
        this.buttons.setRestartRequiredLabelVisible(true);
        this.buttons.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedSlicingPane.this.parent.goBackToChooser();
            }
        });
        this.buttons.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(AdvancedSlicingPane.this.parent, 1001, "CANCEL");
                AdvancedSlicingPane.this.parent.fireActionPerformed(actionEvent2);
            }
        });
        this.buttons.okButton.setText(Resources.getString("advanced.slicing.defaultButton.slice"));
        this.buttons.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(AdvancedSlicingPane.this, 1001, "APPLY");
                AdvancedSlicingPane.this.parent.fireActionPerformed(actionEvent2);
            }
        });
        StepByStepPanel stepByStepPanel2 = new StepByStepPanel(Resources.getImage("icon.step.one"), Resources.getString("advanced.slicing.selectArray"));
        this.addComponent(stepByStepPanel2, this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        DriveInformationPanel driveInformationPanel = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        JPanel jPanel = GUIFactory.newPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.weightx = 1.0;
        this.addComponent(driveInformationPanel, jPanel, gridBagLayout2, gridBagConstraints2);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = ZERO_INSETS;
        gridBagConstraints2.fill = 0;
        this.drivePanel = new DriveSelectionPanel(8, driveInformationPanel, stepByStepPanel, this.summaryLabel, this.buttons.okButton);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 20);
        this.addComponent(this.drivePanel, jPanel, gridBagLayout2, gridBagConstraints2);
        gridBagConstraints2.insets = ZERO_INSETS;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        this.addComponent(jPanel, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        this.legendLabel = new JLabel(Resources.getString("advanced.slicing.legendNote"));
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.addComponent(this.legendLabel, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        this.legend = new ArraySelectionPanel(1);
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.fill = 0;
        this.addComponent(this.legend, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        this.legend.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                AdvancedSlicingPane.this.drivePanel.setArrayIndex(n);
                AdvancedSlicingPane.this.syncSliceCountRadioButtons();
            }
        });
        this.drivePanel.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                AdvancedSlicingPane.this.legend.setArrayIndex(n);
                AdvancedSlicingPane.this.syncSliceCountRadioButtons();
            }
        });
        JPanel jPanel2 = GUIFactory.newPanel();
        jPanel2.setOpaque(true);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout3);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 0;
        this.sliceRadioButton = new JRadioButton[5];
        this.sliceCountRadioGroup = new RadioButtonGroup();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        this.sliceCountLabel = new JLabel(Resources.getString("advanced.slicing.slicesToCreate"));
        this.sliceCountLabel.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(this.sliceCountLabel, jPanel2, gridBagLayout3, gridBagConstraints3);
        ++gridBagConstraints3.gridx;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 10);
        this.sliceCountCurrentLabel = new JLabel(Resources.getString("som.unknown"));
        this.sliceCountCurrentLabel.setVisible(false);
        this.sliceCountCurrentLabel.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(this.sliceCountCurrentLabel, jPanel2, gridBagLayout3, gridBagConstraints3);
        ++gridBagConstraints3.gridx;
        for (int i = 2; i <= 6; ++i) {
            int n = i - 2;
            this.sliceRadioButton[n] = GUIFactory.newRadioButton("" + i);
            this.sliceRadioButton[n].setActionCommand(i + "");
            this.sliceRadioButton[n].setFont(GUIFactory.FONT_SMALL);
            this.sliceCountRadioGroup.add(this.sliceRadioButton[n]);
            this.addComponent(this.sliceRadioButton[n], jPanel2, gridBagLayout3, gridBagConstraints3);
            ++gridBagConstraints3.gridx;
        }
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints3.weightx = 1.0;
        this.addComponent(Box.createHorizontalStrut(0), jPanel2, gridBagLayout3, gridBagConstraints3);
        gridBagConstraints3.weightx = 0.0;
        ++gridBagConstraints3.gridx;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.addComponent(jPanel2, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        StepByStepPanel stepByStepPanel3 = new StepByStepPanel(Resources.getImage("icon.step.two"), Resources.getString("advanced.slicing.confirmation"));
        this.addComponent(stepByStepPanel3, this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = GUIFactory.newPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout4);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        int n = 0;
        this.confirmCheckBox = GUIFactory.newCheckBox(Resources.getString("advanced.slicing.iUnderstand"));
        this.confirmCheckBox.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = n++;
        this.addComponent(this.confirmCheckBox, jPanel3, gridBagLayout4, gridBagConstraints4);
        this.confirmCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AdvancedSlicingPane.this.confirmCheckBox.isSelected();
                AdvancedSlicingPane.this.drivePanel.setConfirmed(bl);
            }
        });
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.addComponent(jPanel3, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = ZERO_INSETS;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        this.addComponent(stepByStepPanel, this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel4 = GUIFactory.newPanel();
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout5);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.fill = 2;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.fill = 1;
        this.addComponent(this.summaryLabel, jPanel4, gridBagLayout5, gridBagConstraints5);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        this.addComponent(jPanel4, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.addComponent(Box.createVerticalStrut(0), this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        this.addComponent(this.buttons, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this.setSize(this.getPreferredSize());
    }

    void syncSliceCountRadioButtons() {
        if (this.drivePanel.getArrayIndex() > 0) {
            boolean bl;
            int n;
            int n2;
            int n3 = this.countSlicesInArray(this.drivePanel.getArrayIndex());
            if (n3 > 1 || n3 == 1 && this.isArrayExpanded(this.drivePanel.getArrayIndex())) {
                for (n2 = 0; n2 <= 4; ++n2) {
                    this.sliceRadioButton[n2].setVisible(false);
                }
                this.sliceCountLabel.setText(Resources.getString("advanced.slicing.existingSlices"));
                this.sliceCountCurrentLabel.setText("" + n3);
                this.sliceCountCurrentLabel.setVisible(true);
                this.mode = 1;
                this.drivePanel.setSelectionMode(9);
                this.buttons.okButton.setText(Resources.getString("advanced.slicing.defaultButton.merge"));
            } else {
                this.sliceCountLabel.setText(Resources.getString("advanced.slicing.slicesToCreate"));
                this.sliceCountCurrentLabel.setVisible(false);
                this.sliceCountCurrentLabel.setText(Resources.getString("som.unknown"));
                for (n2 = 0; n2 <= 4; ++n2) {
                    this.sliceRadioButton[n2].setVisible(true);
                }
                this.mode = 0;
                this.drivePanel.setSelectionMode(8);
                this.buttons.okButton.setText(Resources.getString("advanced.slicing.defaultButton.slice"));
            }
            n2 = this.drivePanel.countAvailableLuns();
            for (n = 0; n <= 4; ++n) {
                bl = n + 2 <= n2 + 1;
                this.sliceRadioButton[n].setEnabled(bl);
                if (bl || !this.sliceRadioButton[n].isSelected()) continue;
                this.sliceCountRadioGroup.remove(this.sliceRadioButton[n]);
                this.sliceRadioButton[n].setSelected(false);
                this.sliceCountRadioGroup.add(this.sliceRadioButton[n]);
            }
            n = 0;
            for (bl = false; bl <= 4 != 0; bl += 1) {
                if (!this.sliceRadioButton[bl].isSelected()) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                this.sliceRadioButton[0].setSelected(true);
            }
        }
    }

    private int countSlicesInArray(int n) {
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.sliceSizes[n - 1][i] <= 0) continue;
            ++n2;
        }
        return n2;
    }

    private boolean isArrayExpanded(int n) {
        RaidSet raidSet;
        Integer n2 = null;
        int n3 = 0;
        for (int i = 0; i < 8; ++i) {
            n3 += this.sliceSizes[n - 1][i];
        }
        if (this.system != null && (raidSet = this.system.getRaidSet(n)) != null) {
            n2 = new Integer((int)(raidSet.getCapacityBytes() / 1024L / 1024L));
        }
        boolean bl = n2 != null && n2 - n3 > 81920;
        logger.debug("isArrayExpanded: sliceCapacity=" + n3 + " arrayCapacity=" + n2 + " result=" + bl);
        return bl;
    }

    public void populateUI(DataModel dataModel) {
        if (dataModel.getClass() != (class$com$apple$xsr$advanced$AdvancedSlicingModel == null ? (class$com$apple$xsr$advanced$AdvancedSlicingModel = AdvancedSlicingPane.class$("com.apple.xsr.advanced.AdvancedSlicingModel")) : class$com$apple$xsr$advanced$AdvancedSlicingModel)) {
            throw new IllegalArgumentException("illegal data model type " + dataModel.getClass());
        }
        if (dataModel != null) {
            AdvancedSlicingModel advancedSlicingModel = (AdvancedSlicingModel)dataModel;
            this.system = advancedSlicingModel.getRaidSystem();
            if (this.system == null) {
                throw new NullPointerException("RAID system cannot be null");
            }
            this.drivePanel.setRaidSystem(this.system);
            this.legend.setRaidSystem(this.system);
            this.sliceSizes = advancedSlicingModel.getSliceSizes();
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel dataModel) {
        if (dataModel != null) {
            AdvancedSlicingModel advancedSlicingModel = (AdvancedSlicingModel)dataModel;
            int n = this.drivePanel.getArrayIndex();
            int n2 = 1;
            if (this.mode == 0) {
                try {
                    n2 = Integer.parseInt(this.sliceCountRadioGroup.getSelection().getActionCommand());
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            advancedSlicingModel.setArrayIndex(n);
            advancedSlicingModel.setSliceCount(n2);
        }
        return true;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(Resources.getImage("icon.slicing"));
    }

    public String getTitle() {
        return Resources.getString("advanced.slicing");
    }

    public String getExplanation() {
        return Resources.getString("advanced.slicingExplanation");
    }

    public String getTag() {
        return TAG;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

