/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.advanced;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.advanced.AdvancedExpansionModel;
import com.apple.xsr.advanced.AdvancedPane;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;

public class AdvancedExpansionPane
extends AbstractManagementPane {
    private final AdvancedPane parent;
    DriveSelectionPanel drivePanel;
    JLabel legendLabel;
    ArraySelectionPanel legend;
    RadioButtonGroup driveCountRadioGroup;
    JRadioButton[] driveRadioButton;
    int driveCount;
    StepByStepPanel summaryHeader;
    JTextPane summaryLabel;
    JCheckBox confirmCheckBox;
    private static final String TAG = "ADVANCED_EXPANSION";
    private static final int PREFERRED_WIDTH = 663;
    private static final int PREFERRED_HEIGHT = 437;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final int LEFT_INDENT = 20;
    private static final int STEP_VSPACE = 15;
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedExpansionModel;

    public AdvancedExpansionPane(AdvancedPane advancedPane) {
        super(663, 437);
        this.parent = advancedPane;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        StepByStepPanel stepByStepPanel = new StepByStepPanel(Resources.getImage("icon.step.five"), Resources.getString("advanced.expansion.summary"));
        this.summaryLabel = GUIFactory.newTextPane(Resources.getString("advanced.expansion.summary.cannot.general"), 2);
        ChooserButtonPanel chooserButtonPanel = new ChooserButtonPanel(true);
        chooserButtonPanel.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedExpansionPane.this.parent.goBackToChooser();
            }
        });
        chooserButtonPanel.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(AdvancedExpansionPane.this.parent, 1001, "CANCEL");
                AdvancedExpansionPane.this.parent.fireActionPerformed(actionEvent2);
            }
        });
        chooserButtonPanel.okButton.setText(Resources.getString("advanced.expansion.defaultButton"));
        chooserButtonPanel.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(AdvancedExpansionPane.this, 1001, "APPLY");
                AdvancedExpansionPane.this.parent.fireActionPerformed(actionEvent2);
            }
        });
        StepByStepPanel stepByStepPanel2 = new StepByStepPanel(Resources.getImage("icon.step.one"), Resources.getString("advanced.expansion.selectArray"));
        this.addComponent(stepByStepPanel2, this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        DriveInformationPanel driveInformationPanel = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        JPanel jPanel = GUIFactory.newPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.weightx = 1.0;
        this.addComponent(driveInformationPanel, jPanel, gridBagLayout2, gridBagConstraints2);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = ZERO_INSETS;
        gridBagConstraints2.fill = 0;
        this.drivePanel = new DriveSelectionPanel(5, driveInformationPanel, stepByStepPanel, this.summaryLabel, chooserButtonPanel.okButton);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 20);
        this.addComponent(this.drivePanel, jPanel, gridBagLayout2, gridBagConstraints2);
        gridBagConstraints2.insets = ZERO_INSETS;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        this.addComponent(jPanel, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        this.legendLabel = new JLabel(Resources.getString("advanced.expansion.legendNote"));
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.addComponent(this.legendLabel, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        this.legend = new ArraySelectionPanel(1);
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.fill = 0;
        this.addComponent(this.legend, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        this.legend.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                AdvancedExpansionPane.this.drivePanel.setArrayIndex(n);
                AdvancedExpansionPane.this.syncDriveCountRadioButtons();
            }
        });
        this.drivePanel.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                AdvancedExpansionPane.this.legend.setArrayIndex(n);
                AdvancedExpansionPane.this.syncDriveCountRadioButtons();
            }
        });
        JPanel jPanel2 = GUIFactory.newPanel();
        jPanel2.setOpaque(true);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout3);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 0;
        this.driveRadioButton = new JRadioButton[5];
        this.driveCountRadioGroup = new RadioButtonGroup();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        JLabel jLabel = new JLabel(Resources.getString("advanced.expansion.drivesToAdd"));
        jLabel.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(jLabel, jPanel2, gridBagLayout3, gridBagConstraints3);
        ++gridBagConstraints3.gridx;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 10);
        for (int i = 1; i <= 5; ++i) {
            final int n = i;
            this.driveRadioButton[i - 1] = GUIFactory.newRadioButton("" + i);
            this.driveRadioButton[i - 1].setFont(GUIFactory.FONT_SMALL);
            this.driveCountRadioGroup.add(this.driveRadioButton[i - 1]);
            this.addComponent(this.driveRadioButton[i - 1], jPanel2, gridBagLayout3, gridBagConstraints3);
            ++gridBagConstraints3.gridx;
            this.driveRadioButton[i - 1].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AdvancedExpansionPane.this.driveCount = n;
                    AdvancedExpansionPane.this.drivePanel.setSelectedDriveCount(n);
                }
            });
        }
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints3.weightx = 1.0;
        this.addComponent(Box.createHorizontalStrut(0), jPanel2, gridBagLayout3, gridBagConstraints3);
        gridBagConstraints3.weightx = 0.0;
        ++gridBagConstraints3.gridx;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.addComponent(jPanel2, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        StepByStepPanel stepByStepPanel3 = new StepByStepPanel(Resources.getImage("icon.step.two"), Resources.getString("advanced.expansion.confirmation"));
        this.addComponent(stepByStepPanel3, this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel3 = GUIFactory.newPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout4);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        int n = 0;
        this.confirmCheckBox = GUIFactory.newCheckBox(Resources.getString("advanced.expansion.iUnderstand"));
        this.confirmCheckBox.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = n++;
        this.addComponent(this.confirmCheckBox, jPanel3, gridBagLayout4, gridBagConstraints4);
        this.confirmCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AdvancedExpansionPane.this.confirmCheckBox.isSelected();
                AdvancedExpansionPane.this.drivePanel.setConfirmed(bl);
            }
        });
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.addComponent(jPanel3, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = ZERO_INSETS;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        this.addComponent(stepByStepPanel, this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel4 = GUIFactory.newPanel();
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout5);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.fill = 2;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.fill = 1;
        this.addComponent(this.summaryLabel, jPanel4, gridBagLayout5, gridBagConstraints5);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        this.addComponent(jPanel4, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.addComponent(Box.createVerticalStrut(0), this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        this.addComponent(chooserButtonPanel, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this.setSize(this.getPreferredSize());
    }

    void syncDriveCountRadioButtons() {
        int n = this.drivePanel.getAvailableDriveCount();
        int n2 = this.driveCount;
        for (int i = 0; i < 5; ++i) {
            boolean bl = i < n;
            this.driveRadioButton[i].setEnabled(bl);
            if (bl || !this.driveRadioButton[i].isSelected()) continue;
            this.driveCountRadioGroup.remove(this.driveRadioButton[i]);
            this.driveRadioButton[i].setSelected(false);
            this.driveCountRadioGroup.add(this.driveRadioButton[i]);
            n2 = 0;
        }
        if (n2 > 0) {
            this.driveRadioButton[n2 - 1].setSelected(true);
        }
        this.drivePanel.setSelectedDriveCount(n2);
    }

    public void populateUI(DataModel dataModel) {
        if (dataModel.getClass() != (class$com$apple$xsr$advanced$AdvancedExpansionModel == null ? (class$com$apple$xsr$advanced$AdvancedExpansionModel = AdvancedExpansionPane.class$("com.apple.xsr.advanced.AdvancedExpansionModel")) : class$com$apple$xsr$advanced$AdvancedExpansionModel)) {
            throw new IllegalArgumentException("illegal data model type " + dataModel.getClass());
        }
        if (dataModel != null) {
            AdvancedExpansionModel advancedExpansionModel = (AdvancedExpansionModel)dataModel;
            this.drivePanel.setRaidSystem(advancedExpansionModel.getRaidSystem());
            this.legend.setRaidSystem(advancedExpansionModel.getRaidSystem());
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel dataModel) {
        if (dataModel != null) {
            AdvancedExpansionModel advancedExpansionModel = (AdvancedExpansionModel)dataModel;
            advancedExpansionModel.setArrayIndex(this.drivePanel.getArrayIndex());
            advancedExpansionModel.setDriveStates(this.drivePanel.getDriveStates());
        }
        return true;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(Resources.getImage("icon.expansion"));
    }

    public String getTitle() {
        return Resources.getString("advanced.expansion");
    }

    public String getExplanation() {
        return Resources.getString("advanced.expansionExplanation");
    }

    public String getTag() {
        return TAG;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

