/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.AlternatingTable;
import com.apple.gui.GUIFactory;
import com.apple.xsr.AquaProgressClock;
import com.apple.xsr.AquaTableCellBorder;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.StatusIndicator;
import com.apple.xsr.SystemMonitorController;
import com.apple.xsr.SystemRegistry;
import com.apple.xsr.SystemRegistryEvent;
import com.apple.xsr.SystemRegistryListener;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.som.RaidSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.UnknownHostException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SystemTable
extends JPanel {
    public static final int STATUS_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int ADDRESS_COLUMN = 2;
    public static final int INFO_COLUMN = 3;
    public static final int MESSAGE_COLUMN = 4;
    public static final String STATUS_INDICATOR_PRESSED = "status_indicator_pressed";
    public static final String MODULES_INDICATOR_PRESSED = "modules_indicator_pressed";
    public static final String ARRAYS_DRIVES_INDICATOR_PRESSED = "arrays_drives_indicator_pressed";
    public static final String FIBRE_CHANNEL_INDICATOR_PRESSED = "fibre_channel_indicator_pressed";
    public static final String NETWORK_INDICATOR_PRESSED = "network_indicator_pressed";
    public static final String MESSAGE_BUTTON_PRESSED = "message_button_pressed";
    private static final int TABLE_ROW_HEIGHT = 20;
    private static final int STATUS_COLUMN_WIDTH = 20;
    private static final int NAME_COLUMN_MIN_WIDTH = 200;
    private static final int ADDRESS_COLUMN_MIN_WIDTH = 115;
    private static final int MESSAGE_COLUMN_MIN_WIDTH = 200;
    private static final Dimension minimumSize = new Dimension(100, 152);
    private final String[] COLUMNS = new String[]{" ", Resources.getString("systemTable.nameColumn"), Resources.getString("systemTable.addressColumn"), " ", Resources.getString("systemTable.messageColumn")};
    private ContextualMenuAwareTable table;
    private JScrollPane tableScrollPane;
    private SystemMonitorController controller;
    public Model tableModel;
    private StatusEditor statusEditor;
    private InfoEditor infoEditor;
    private MessageEditor messageEditor;
    private Timer timer = null;
    private AquaProgressClock progress = new AquaProgressClock();
    TableColumn messageColumn = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public SystemTable(SystemMonitorController systemMonitorController) {
        this.controller = systemMonitorController;
        this.setLayout(new BorderLayout());
        this.tableModel = new Model();
        this.table = new ContextualMenuAwareTable(this.tableModel);
        this.table.setRowHeight(20);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.setAutoResizeMode(0);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setFont(GUIFactory.FONT_SMALL);
        this.statusEditor = new StatusEditor();
        this.infoEditor = new InfoEditor();
        this.messageEditor = new MessageEditor(this.progress);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setResizable(false);
        tableColumn.setCellRenderer(new StatusRenderer());
        tableColumn.setCellEditor(this.statusEditor);
        IconHeaderRenderer iconHeaderRenderer = new IconHeaderRenderer(Resources.getImage("icon.status.header"));
        iconHeaderRenderer.setToolTipText(Resources.getString("systemTable.infoColumn"));
        tableColumn.setHeaderRenderer(iconHeaderRenderer);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        tableColumn2.setMinWidth(200);
        tableColumn2.setCellRenderer(new StringRenderer());
        TableColumn tableColumn3 = this.table.getColumnModel().getColumn(2);
        tableColumn3.setMinWidth(115);
        tableColumn3.setCellRenderer(new StringRenderer());
        TableColumn tableColumn4 = this.table.getColumnModel().getColumn(3);
        tableColumn4.setResizable(false);
        tableColumn4.setCellRenderer(new InfoRenderer());
        tableColumn4.setCellEditor(this.infoEditor);
        IconHeaderRenderer iconHeaderRenderer2 = new IconHeaderRenderer(Resources.getImage("icon.info.header"));
        iconHeaderRenderer2.setToolTipText(Resources.getString("systemInfo.tab.arraysAndDrives") + Resources.getString("som.raidset.driveSeparator") + Resources.getString("systemInfo.tab.modules") + Resources.getString("som.raidset.driveSeparator") + Resources.getString("systemInfo.tab.fibreChannel") + Resources.getString("som.raidset.driveSeparator") + Resources.getString("systemInfo.tab.network"));
        tableColumn4.setHeaderRenderer(iconHeaderRenderer2);
        this.messageColumn = this.table.getColumnModel().getColumn(4);
        this.messageColumn.setMinWidth(200);
        this.messageColumn.setCellRenderer(new MessageRenderer(this.progress));
        this.messageColumn.setCellEditor(this.messageEditor);
        this.tableScrollPane = new JScrollPane(this.table);
        this.tableScrollPane.setVerticalScrollBarPolicy(22);
        this.tableScrollPane.setHorizontalScrollBarPolicy(32);
        this.add((Component)this.tableScrollPane, "Center");
        this.tableScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SystemTable.this.autoResizeMessageColumn();
            }
        });
        this.table.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                SystemTable.this.autoResizeMessageColumn();
            }
        });
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                SystemTable.this.tableScrollPane.repaint();
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
                SystemTable.this.tableScrollPane.repaint();
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SystemTable.this.table.cancelPopup();
            }
        });
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void setRegistry(SystemRegistry systemRegistry) {
        if (systemRegistry != null) {
            systemRegistry.addSystemRegistryListener(this.tableModel);
            this.tableModel.addAll(systemRegistry.getSystems());
        }
    }

    public Dimension getMinimumSize() {
        return minimumSize;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener == null) {
            throw new NullPointerException("listener cannot be null");
        }
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addStatusIndicatorListener(ActionListener actionListener) {
        this.statusEditor.addActionListener(actionListener);
        this.infoEditor.addActionListener(actionListener);
        this.messageEditor.addActionListener(actionListener);
    }

    public void addStatusIndicatorMouseListener(MouseListener mouseListener) {
        this.statusEditor.addMouseListener(mouseListener);
        this.infoEditor.addMouseListener(mouseListener);
        this.messageEditor.addMouseListener(mouseListener);
    }

    public boolean isSystemSelected() {
        return this.table.getRowCount() > 0 && this.table.getSelectedRow() != -1;
    }

    public RaidSystem[] getSelectedSystems() {
        RaidSystem[] raidSystemArray;
        if (this.table.getRowCount() > 0) {
            int[] nArray = this.table.getSelectedRows();
            raidSystemArray = new RaidSystem[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                raidSystemArray[i] = this.tableModel.getSystem(nArray[i]);
            }
        } else {
            raidSystemArray = new RaidSystem[]{};
        }
        return raidSystemArray;
    }

    public RaidSystem getSelectedSystem() {
        int n;
        RaidSystem raidSystem = null;
        if (this.table.getRowCount() > 0 && (n = this.table.getSelectedRow()) != -1) {
            raidSystem = this.tableModel.getSystem(n);
        }
        return raidSystem;
    }

    public void setSelectedSystem(RaidSystem raidSystem) {
        if (this.table.getEditingRow() != -1) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (raidSystem == null) {
            this.table.setRowSelectionInterval(-1, -1);
        } else {
            int n = this.table.getRowCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    RaidSystem raidSystem2 = this.tableModel.getSystem(i);
                    if (raidSystem2 != raidSystem) continue;
                    this.table.setRowSelectionInterval(i, i);
                    break;
                }
            }
        }
    }

    public void stopEditing() {
        if (this.table.getEditingRow() != -1) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    private void autoResizeMessageColumn() {
        int n = this.tableScrollPane.getViewport().getWidth();
        int n2 = this.table.getColumnModel().getTotalColumnWidth();
        if (n2 != n) {
            this.messageColumn.setPreferredWidth(this.messageColumn.getWidth() + n - n2);
        }
    }

    private void updateAnimation() {
        if (this.table == null) {
            return;
        }
        int n = this.table.getRowCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                RaidSystem raidSystem = this.tableModel.getSystem(i);
                if (!raidSystem.getUserMessageIsAsync()) continue;
                this.startAnimation();
                return;
            }
        }
        this.stopAnimation();
    }

    private synchronized void startAnimation() {
        if (this.timer == null) {
            this.timer = new Timer(66, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SystemTable.this.progress.advanceFrame();
                    SystemTable.this.repaint();
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    private void stopAnimation() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ContextualMenuAwareTable
    extends AlternatingTable {
        private JPopupMenu popup = null;
        private int locX;
        private int locY;

        ContextualMenuAwareTable(Model model) {
            super(model);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = SystemTable.this.table.rowAtPoint(mouseEvent.getPoint());
                if (n != -1 && !SystemTable.this.table.isCellSelected(n, 0)) {
                    super.processMouseEvent(mouseEvent);
                }
                this.cancelPopup();
                this.popup = this.buildContextualMenu(SystemTable.this.getSelectedSystems());
                if (this.popup != null) {
                    this.locX = mouseEvent.getX() + 3;
                    this.locY = mouseEvent.getY() - 3;
                    this.popup.show(mouseEvent.getComponent(), this.locX, this.locY);
                }
            } else {
                int n;
                if (mouseEvent.getID() == 501 && this.popup != null) {
                    this.cancelPopup();
                }
                if (mouseEvent.getID() == 502 && this.popup != null) {
                    JMenuItem jMenuItem = (JMenuItem)this.popup.findComponentAt(mouseEvent.getX() - this.locX, mouseEvent.getY() - this.locY);
                    if (jMenuItem != null) {
                        jMenuItem.doClick();
                        this.cancelPopup();
                    }
                } else {
                    super.processMouseEvent(mouseEvent);
                }
                if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2 && (n = SystemTable.this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
                    RaidSystem raidSystem = SystemTable.this.tableModel.getSystem(n);
                    if (raidSystem.getUserMessageIndex() == 11) {
                        SystemTable.this.controller.showMonitoringAuthenticationSheet();
                    } else {
                        raidSystem.updateImmediately(false);
                    }
                }
            }
        }

        public void cancelPopup() {
            if (this.popup != null) {
                this.popup.setVisible(false);
                this.popup = null;
            }
        }

        private JPopupMenu buildContextualMenu(RaidSystem[] raidSystemArray) {
            if (raidSystemArray == null || raidSystemArray.length == 0) {
                return null;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            int n = 0;
            if (raidSystemArray.length == 1) {
                if (raidSystemArray[0].getPowerState() == -1) {
                    JMenuItem jMenuItem;
                    if (raidSystemArray[0].getUserMessageIndex() == 11) {
                        jMenuItem = new JMenuItem(Resources.getString("application.menu.system.reenterPassword"));
                        jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.enterMonitoringPassword);
                        jPopupMenu.add(jMenuItem);
                        ++n;
                        jPopupMenu.addSeparator();
                    }
                    jMenuItem = new JMenuItem(Resources.getString("deleteItem"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteSystem);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                } else if (raidSystemArray[0].getPowerState() == 0) {
                    JMenuItem jMenuItem = new JMenuItem(Resources.getString("application.menu.system.powerOn"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.shutdown);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(Resources.getString("deleteItem"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteSystem);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                } else {
                    JMenuItem jMenuItem = new JMenuItem(Resources.getString("application.menu.system.updateNow"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.updateNow);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(Resources.getString("createArray.menuItem"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.createArray);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                    jMenuItem = new JMenuItem(Resources.getString("deleteArray.menuItem"));
                    jMenuItem.setEnabled(raidSystemArray[0].getRaidSets().size() > 0);
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteArray);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(Resources.getString("systemSettings.menuItem"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.setup);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                    jMenuItem = new JMenuItem(Resources.getString("configureNotifications.menuItem"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.notifications);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(Resources.getString("advanced.menuItem"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.advanced);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                    jPopupMenu.addSeparator();
                    jMenuItem = raidSystemArray[0].getServiceIdState() == 0 ? new JMenuItem(Resources.getString("application.menu.system.serviceID.on")) : new JMenuItem(Resources.getString("application.menu.system.serviceID.off"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.serviceID);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(Resources.getString("application.menu.system.shutdown"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.shutdown);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                    if (raidSystemArray[0].getManagementPasswordSaved()) {
                        jPopupMenu.addSeparator();
                        jMenuItem = new JMenuItem(Resources.getString("application.menu.system.forgetPassword"));
                        jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.forgetPassword);
                        jPopupMenu.add(jMenuItem);
                        ++n;
                    }
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(Resources.getString("deleteItem"));
                    jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteSystem);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                }
            } else {
                JMenuItem jMenuItem = new JMenuItem(Resources.getString("deleteItems"));
                jMenuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteSystem);
                jPopupMenu.add(jMenuItem);
                ++n;
            }
            return jPopupMenu;
        }
    }

    static class StringRenderer
    extends JPanel
    implements TableCellRenderer {
        AquaTableCellBorder border;
        JLabel label;

        public StringRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.label = new JLabel();
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            this.border.setAttributes(bl, jTable.hasFocus(), n);
            this.label.setText((String)object);
            this.label.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    static class MessageEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        MessageRenderer renderer;
        RaidSystem value;

        public MessageEditor(AquaProgressClock aquaProgressClock) {
            this.renderer = new MessageRenderer(aquaProgressClock);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = (RaidSystem)object;
            jTable.setRowSelectionInterval(n, n);
            return this.renderer.getTableCellRendererComponent(jTable, object, true, false, n, n2);
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void addActionListener(ActionListener actionListener) {
            this.renderer.button.addActionListener(actionListener);
        }

        public void addMouseListener(MouseListener mouseListener) {
            this.renderer.button.addMouseListener(mouseListener);
        }
    }

    static class MessageRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final int BUTTON_HEIGHT = 18;
        AquaTableCellBorder border;
        AquaProgressClock progress;
        JLabel label;
        JLabel badge;
        JButton button;

        public MessageRenderer(AquaProgressClock aquaProgressClock) {
            this.setLayout(new GridBagLayout());
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.progress = aquaProgressClock;
            this.progress.setOpaque(false);
            this.label = new JLabel();
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.badge = new JLabel();
            this.badge.setIcon(new ImageIcon(Resources.getImage("icon.status.adminpassword")));
            this.button = GUIFactory.newButton(Resources.getString("systemTable.messageButton"));
            this.button.setFont(GUIFactory.FONT_SMALL);
            this.button.setOpaque(false);
            this.button.setMinimumSize(new Dimension(this.button.getMinimumSize().width, 18));
            this.button.setActionCommand(SystemTable.MESSAGE_BUTTON_PRESSED);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 4, 0, 4);
            this.add((Component)this.progress, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.add((Component)this.label, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.badge, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ++gridBagConstraints.gridx;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 2, 0, 2);
            this.add((Component)this.button, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        }

        private void addComponent(Component component, Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
            gridBagLayout.setConstraints(component, gridBagConstraints);
            container.add(component);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            RaidSystem raidSystem = (RaidSystem)object;
            this.border.setAttributes(bl, jTable.hasFocus(), n);
            this.progress.setVisible(raidSystem.getUserMessageIsAsync());
            this.progress.setSelected(bl);
            this.label.setText(SOMLocalizer.getLocalizedUserMessage(raidSystem.getUserMessageIndex()));
            this.label.setForeground(bl ? Color.white : Color.black);
            this.badge.setVisible(raidSystem.getManagementPasswordSaved());
            this.button.setVisible(raidSystem.getUserMessageIndex() == 11);
            return this;
        }
    }

    static class InfoEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        InfoRenderer renderer = new InfoRenderer();
        RaidSystem value;

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = (RaidSystem)object;
            jTable.setRowSelectionInterval(n, n);
            return this.renderer.getTableCellRendererComponent(jTable, object, true, false, n, n2);
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void addActionListener(ActionListener actionListener) {
            this.renderer.addActionListener(actionListener);
        }

        public void addMouseListener(MouseListener mouseListener) {
            this.renderer.modulesIndicator.addMouseListener(mouseListener);
            this.renderer.arraysAndDrivesIndicator.addMouseListener(mouseListener);
            this.renderer.fibreIndicator.addMouseListener(mouseListener);
            this.renderer.networkIndicator.addMouseListener(mouseListener);
        }
    }

    static class InfoRenderer
    extends JPanel
    implements TableCellRenderer {
        private StatusIndicator modulesIndicator;
        private StatusIndicator arraysAndDrivesIndicator;
        private StatusIndicator fibreIndicator;
        private StatusIndicator networkIndicator;
        AquaTableCellBorder border;

        public InfoRenderer() {
            this.setLayout(new GridLayout(1, 4, 0, 0));
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.arraysAndDrivesIndicator = new StatusIndicator();
            this.arraysAndDrivesIndicator.setActionCommand(SystemTable.ARRAYS_DRIVES_INDICATOR_PRESSED);
            this.add(this.arraysAndDrivesIndicator);
            this.modulesIndicator = new StatusIndicator();
            this.modulesIndicator.setActionCommand(SystemTable.MODULES_INDICATOR_PRESSED);
            this.add(this.modulesIndicator);
            this.fibreIndicator = new StatusIndicator();
            this.fibreIndicator.setActionCommand(SystemTable.FIBRE_CHANNEL_INDICATOR_PRESSED);
            this.add(this.fibreIndicator);
            this.networkIndicator = new StatusIndicator();
            this.networkIndicator.setActionCommand(SystemTable.NETWORK_INDICATOR_PRESSED);
            this.add(this.networkIndicator);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            RaidSystem raidSystem = (RaidSystem)object;
            if (raidSystem.getPowerState() == 1) {
                this.arraysAndDrivesIndicator.setStatusAndSelectedState(raidSystem.getGeneralRaidSetAndDiskStatus(), bl);
                this.modulesIndicator.setStatusAndSelectedState(raidSystem.getGeneralComponentStatus(), bl);
                this.fibreIndicator.setStatusAndSelectedState(raidSystem.getGeneralHostInterfaceStatus(), bl);
                this.networkIndicator.setStatusAndSelectedState(raidSystem.getGeneralNetworkInterfaceStatus(), bl);
            } else {
                this.arraysAndDrivesIndicator.setStatusAndSelectedState(-1, bl);
                this.modulesIndicator.setStatusAndSelectedState(-1, bl);
                this.fibreIndicator.setStatusAndSelectedState(-1, bl);
                this.networkIndicator.setStatusAndSelectedState(-1, bl);
            }
            this.border.setAttributes(bl, jTable.hasFocus(), n);
            return this;
        }

        public void addActionListener(ActionListener actionListener) {
            this.modulesIndicator.addActionListener(actionListener);
            this.arraysAndDrivesIndicator.addActionListener(actionListener);
            this.fibreIndicator.addActionListener(actionListener);
            this.networkIndicator.addActionListener(actionListener);
        }

        public void addMouseListener(MouseListener mouseListener) {
            this.modulesIndicator.addMouseListener(mouseListener);
            this.arraysAndDrivesIndicator.addMouseListener(mouseListener);
            this.fibreIndicator.addMouseListener(mouseListener);
            this.networkIndicator.addMouseListener(mouseListener);
        }
    }

    static class StatusEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        StatusRenderer renderer = new StatusRenderer();
        RaidSystem value;

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = (RaidSystem)object;
            jTable.setRowSelectionInterval(n, n);
            return this.renderer.getTableCellRendererComponent(jTable, object, true, true, n, n2);
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void addActionListener(ActionListener actionListener) {
            this.renderer.indicator.addActionListener(actionListener);
        }

        public void addMouseListener(MouseListener mouseListener) {
            this.renderer.indicator.addMouseListener(mouseListener);
        }
    }

    static class StatusRenderer
    extends JPanel
    implements TableCellRenderer {
        AquaTableCellBorder border;
        StatusIndicator indicator;

        public StatusRenderer() {
            this.setLayout(new GridLayout(1, 4, 0, 0));
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.indicator = new StatusIndicator();
            this.indicator.setActionCommand(SystemTable.STATUS_INDICATOR_PRESSED);
            this.indicator.setStatus(-1);
            this.add(this.indicator);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            RaidSystem raidSystem = (RaidSystem)object;
            if (raidSystem.getPowerState() == 1) {
                this.indicator.setStatusAndSelectedState(raidSystem.getStatus(), bl);
            } else {
                this.indicator.setStatusAndSelectedState(-1, bl);
            }
            this.border.setAttributes(bl, jTable.hasFocus(), n);
            return this;
        }
    }

    static class IconHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        public IconHeaderRenderer(Image image) {
            JLabel jLabel = new JLabel();
            jLabel.setIcon(new ImageIcon(image));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.add(jLabel);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this;
        }
    }

    class Model
    extends AbstractTableModel
    implements SystemRegistryListener {
        private List systemList;
        private SystemComparator comparator = new SystemComparator(0);

        public Model() {
            this.systemList = new ArrayList();
        }

        public void addAll(Collection collection) {
            this.systemList.addAll(collection);
            this.sort();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Model this$1;
                {
                    this.this$1 = model;
                }

                public void run() {
                    this.this$1.fireTableChanged(new TableModelEvent(this.this$1));
                }
            });
        }

        public void add(RaidSystem[] raidSystemArray) {
            for (int i = 0; i < raidSystemArray.length; ++i) {
                this.systemList.add(raidSystemArray[i]);
            }
            this.sort();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Model this$1;
                {
                    this.this$1 = model;
                }

                public void run() {
                    this.this$1.fireTableChanged(new TableModelEvent(this.this$1));
                }
            });
        }

        public void remove(RaidSystem[] raidSystemArray) {
            for (int i = 0; i < raidSystemArray.length; ++i) {
                this.systemList.remove(raidSystemArray[i]);
            }
            this.sort();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Model this$1;
                {
                    this.this$1 = model;
                }

                public void run() {
                    this.this$1.fireTableChanged(new TableModelEvent(this.this$1));
                }
            });
        }

        public void update(RaidSystem[] raidSystemArray) {
            this.sort();
            SwingUtilities.invokeLater(new Runnable(this, raidSystemArray){
                private final /* synthetic */ RaidSystem[] val$systems;
                private final /* synthetic */ Model this$1;
                {
                    this.this$1 = model;
                    this.val$systems = raidSystemArray;
                }

                public void run() {
                    int n = Model.access$400(this.this$1).indexOf(this.val$systems[0]);
                    this.this$1.fireTableChanged(new TableModelEvent(this.this$1, n));
                }
            });
        }

        public int getRowCount() {
            return this.systemList.size();
        }

        public int getColumnCount() {
            return SystemTable.this.COLUMNS.length;
        }

        public Class getColumnClass(int n) {
            Class clazz = null;
            switch (n) {
                case 0: {
                    clazz = class$java$lang$Object == null ? (class$java$lang$Object = SystemTable.class$("java.lang.Object")) : class$java$lang$Object;
                    break;
                }
                case 1: {
                    clazz = class$java$lang$String == null ? (class$java$lang$String = SystemTable.class$("java.lang.String")) : class$java$lang$String;
                    break;
                }
                case 2: {
                    clazz = class$java$lang$String == null ? (class$java$lang$String = SystemTable.class$("java.lang.String")) : class$java$lang$String;
                    break;
                }
                case 3: {
                    clazz = class$java$lang$Object == null ? (class$java$lang$Object = SystemTable.class$("java.lang.Object")) : class$java$lang$Object;
                    break;
                }
                case 4: {
                    clazz = class$java$lang$Object == null ? (class$java$lang$Object = SystemTable.class$("java.lang.Object")) : class$java$lang$Object;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + n);
                }
            }
            return clazz;
        }

        public String getColumnName(int n) {
            if (n >= SystemTable.this.COLUMNS.length) {
                throw new IllegalArgumentException("Illegal column: " + n);
            }
            return SystemTable.this.COLUMNS[n];
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0 || n2 == 3) {
                return true;
            }
            return n2 == 4 && this.getSystem(n).getUserMessageIndex() == 11;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            RaidSystem raidSystem = (RaidSystem)this.systemList.get(n);
            if (raidSystem != null) {
                switch (n2) {
                    case 0: 
                    case 3: 
                    case 4: {
                        object = raidSystem;
                        break;
                    }
                    case 1: {
                        object = raidSystem.getName();
                        break;
                    }
                    case 2: {
                        object = raidSystem.getHostAddress();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal column: " + n2);
                    }
                }
            }
            return object;
        }

        public RaidSystem getSystem(int n) {
            return (RaidSystem)this.systemList.get(n);
        }

        public void registryChanged(SystemRegistryEvent systemRegistryEvent) {
            int n = systemRegistryEvent.getType();
            if (n == 0) {
                this.add(systemRegistryEvent.getSystems());
            } else if (n == 1) {
                this.remove(systemRegistryEvent.getSystems());
            } else if (n == 2) {
                this.update(systemRegistryEvent.getSystems());
            }
            SystemTable.this.updateAnimation();
        }

        public void sort() {
            Collections.sort(this.systemList, this.comparator);
        }

        static /* synthetic */ List access$400(Model model) {
            return model.systemList;
        }

        class SystemComparator
        implements Comparator {
            public static final int SORT_KEY_NAME = 0;
            public static final int SORT_KEY_IP_ADDRESS = 1;
            public static final int SORT_KEY_STATUS = 2;
            private int sortKey = 0;
            private Collator collator = Collator.getInstance();

            public SystemComparator(int n) {
                this.sortKey = n;
            }

            public synchronized void setSortKey(int n) {
                this.sortKey = n;
            }

            public synchronized int compare(Object object, Object object2) {
                return this.compare((RaidSystem)object, (RaidSystem)object2);
            }

            public synchronized int compare(RaidSystem raidSystem, RaidSystem raidSystem2) {
                int n = 1;
                if (this.sortKey == 0) {
                    n = this.collator.compare(raidSystem.getName(), raidSystem2.getName());
                } else if (this.sortKey == 1) {
                    try {
                        IPAddress iPAddress = new IPAddress(raidSystem.getPrimaryHostAddress());
                        IPAddress iPAddress2 = new IPAddress(raidSystem2.getPrimaryHostAddress());
                        n = iPAddress.compareTo(iPAddress2);
                    }
                    catch (UnknownHostException unknownHostException) {}
                } else {
                    n = this.sortKey == 2 ? raidSystem.getStatus() - raidSystem2.getStatus() : this.collator.compare(raidSystem.getName(), raidSystem2.getName());
                }
                return n;
            }
        }
    }
}

