/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.AquaToolBar;
import com.apple.xsr.AquaToolBarButton;
import com.apple.xsr.Resources;
import com.apple.xsr.SystemInfoPane;
import com.apple.xsr.SystemMonitorController;
import com.apple.xsr.SystemRegistryEvent;
import com.apple.xsr.SystemRegistryListener;
import com.apple.xsr.SystemTable;
import com.apple.xsr.som.RaidSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;

public class SystemMonitorWindow
extends JFrame
implements SystemRegistryListener {
    private static final int WIDTH = 700;
    private static final int HEIGHT = 520;
    private SystemMonitorController controller;
    public SystemTable systemTable;
    private SystemInfoPane systemInfoPane;
    private AquaToolBar toolbar;
    private Action addSystemAction;
    private Action deleteSystemAction;
    private Action createArrayAction;
    private Action deleteArrayAction;
    private Action setupAction;
    private Action notificationsAction;
    private Action firstAidAction;
    private Action advancedAction;
    private AquaToolBarButton addSystemBtn;
    private AquaToolBarButton deleteSystemBtn;
    private AquaToolBarButton createArrayBtn;
    private AquaToolBarButton deleteArrayBtn;
    private AquaToolBarButton setupBtn;
    private AquaToolBarButton notificationsBtn;
    private AquaToolBarButton firstAidBtn;
    private AquaToolBarButton advancedBtn;
    private static final Dimension TOOLBAR_SEPARATOR_SIZE = new Dimension(16, 0);

    public SystemMonitorWindow(SystemMonitorController systemMonitorController) {
        this.controller = systemMonitorController;
        this.setTitle(Resources.getString("appName"));
        this.setSize(700, 520);
        this.toolbar = new AquaToolBar();
        this.addSystemBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.addSystemBtn);
        this.deleteSystemBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.deleteSystemBtn);
        if (Gestalt.isMacLookAndFeel) {
            this.toolbar.addSeparator();
        } else {
            this.toolbar.addSeparator(TOOLBAR_SEPARATOR_SIZE);
        }
        this.createArrayBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.createArrayBtn);
        this.deleteArrayBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.deleteArrayBtn);
        if (Gestalt.isMacLookAndFeel) {
            this.toolbar.addSeparator();
        } else {
            this.toolbar.addSeparator(TOOLBAR_SEPARATOR_SIZE);
        }
        this.setupBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.setupBtn);
        this.notificationsBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.notificationsBtn);
        this.firstAidBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.firstAidBtn);
        if (Gestalt.isMacLookAndFeel) {
            this.toolbar.addSeparator();
        } else {
            this.toolbar.addSeparator(TOOLBAR_SEPARATOR_SIZE);
        }
        this.advancedBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.advancedBtn);
        this.systemTable = new SystemTable(this.controller);
        this.systemTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl;
                RaidSystem[] raidSystemArray = SystemMonitorWindow.this.systemTable.getSelectedSystems();
                boolean bl2 = bl = raidSystemArray.length > 0;
                if (SystemMonitorWindow.this.deleteSystemAction != null) {
                    SystemMonitorWindow.this.deleteSystemAction.setEnabled(bl);
                }
                if (raidSystemArray.length == 1) {
                    SystemMonitorWindow.this.systemInfoPane.setSystem(raidSystemArray[0]);
                } else {
                    SystemMonitorWindow.this.systemInfoPane.setSystem(null);
                }
            }
        });
        this.systemTable.addStatusIndicatorListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("status_indicator_pressed")) {
                    SystemMonitorWindow.this.systemInfoPane.setSelectedTab(0);
                } else if (string.equals("modules_indicator_pressed")) {
                    SystemMonitorWindow.this.systemInfoPane.setSelectedTab(2);
                } else if (string.equals("arrays_drives_indicator_pressed")) {
                    SystemMonitorWindow.this.systemInfoPane.setSelectedTab(1);
                } else if (string.equals("fibre_channel_indicator_pressed")) {
                    SystemMonitorWindow.this.systemInfoPane.setSelectedTab(3);
                } else if (string.equals("network_indicator_pressed")) {
                    SystemMonitorWindow.this.systemInfoPane.setSelectedTab(4);
                } else if (string.equals("message_button_pressed")) {
                    SystemMonitorWindow.this.controller.showMonitoringAuthenticationSheet();
                }
            }
        });
        this.systemTable.addStatusIndicatorMouseListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                SystemMonitorWindow.this.systemTable.stopEditing();
            }
        });
        this.systemInfoPane = new SystemInfoPane();
        JComponent jComponent = this.createContentPane(this.systemTable, this.systemInfoPane);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)jComponent, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                SystemMonitorWindow.this.updatePreferences();
                System.exit(0);
            }
        });
        Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        if (preferences.exists("MonitoringWindowLeft")) {
            int n = preferences.getInteger("MonitoringWindowLeft", 0);
            int n2 = preferences.getInteger("MonitoringWindowTop", 0);
            int n3 = preferences.getInteger("MonitoringWindowWidth", 800);
            int n4 = preferences.getInteger("MonitoringWindowHeight", 578);
            this.setLocation(n, n2);
            this.setSize(n3, n4);
        } else {
            this.setSize(800, 578);
        }
    }

    public void toggleToolbar() {
        this.toolbar.setVisible(!this.toolbar.isVisible());
    }

    public boolean isToolbarVisible() {
        return this.toolbar.isVisible();
    }

    public void updatePreferences() {
        Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        preferences.setInteger("MonitoringWindowLeft", this.getX());
        preferences.setInteger("MonitoringWindowTop", this.getY());
        preferences.setInteger("MonitoringWindowWidth", this.getWidth());
        preferences.setInteger("MonitoringWindowHeight", this.getHeight());
        preferences.synchronize();
    }

    public void registryChanged(SystemRegistryEvent systemRegistryEvent) {
        if (systemRegistryEvent.getType() == 2) {
            RaidSystem[] raidSystemArray = this.getSelectedSystems();
            RaidSystem raidSystem = null;
            if (raidSystemArray == null) {
                return;
            }
            if (raidSystemArray.length != 1) {
                return;
            }
            raidSystem = raidSystemArray[0];
            raidSystemArray = systemRegistryEvent.getSystems();
            for (int i = 0; i < raidSystemArray.length; ++i) {
                if (raidSystem != raidSystemArray[i]) continue;
                if (raidSystem.getPowerState() == 1) {
                    this.systemInfoPane.updateInfo(raidSystem);
                    this.controller.updateMenuActionStatus();
                    break;
                }
                if (raidSystem.getUserMessageIndex() != 11) break;
                this.controller.updateMenuActionStatus();
                break;
            }
        }
    }

    public void setSelectedSystem(RaidSystem raidSystem) {
        this.systemTable.setSelectedSystem(raidSystem);
    }

    public RaidSystem getSelectedSystem() {
        return this.systemTable.getSelectedSystem();
    }

    public RaidSystem[] getSelectedSystems() {
        return this.systemTable.getSelectedSystems();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.systemTable.addListSelectionListener(listSelectionListener);
    }

    void setAddSystemAction(Action action) {
        this.addSystemAction = action;
        this.addSystemBtn.setAction(action);
    }

    void setDeleteSystemAction(Action action) {
        this.deleteSystemAction = action;
        this.deleteSystemBtn.setAction(action);
    }

    void setCreateArrayAction(Action action) {
        this.createArrayAction = action;
        this.createArrayBtn.setAction(action);
    }

    void setDeleteArrayAction(Action action) {
        this.deleteArrayAction = action;
        this.deleteArrayBtn.setAction(action);
    }

    void setSetupAction(Action action) {
        this.setupAction = action;
        this.setupBtn.setAction(action);
    }

    void setNotificationsAction(Action action) {
        this.notificationsAction = action;
        this.notificationsBtn.setAction(action);
    }

    void setFirstAidAction(Action action) {
        this.firstAidAction = action;
        this.firstAidBtn.setAction(action);
    }

    void setAdvancedAction(Action action) {
        this.advancedAction = action;
        this.advancedBtn.setAction(action);
    }

    private JComponent createContentPane(SystemTable systemTable, SystemInfoPane systemInfoPane) {
        JSplitPane jSplitPane = this.createSplitContentPane(systemTable, systemInfoPane);
        return jSplitPane;
    }

    private JSplitPane createSplitContentPane(JComponent jComponent, JComponent jComponent2) {
        SplitPane splitPane = new SplitPane(0, true);
        splitPane.setBorder(null);
        splitPane.setResizeWeight(1.0);
        splitPane.setOneTouchExpandable(false);
        jComponent.setBorder(BorderFactory.createEmptyBorder(12, 20, 12, 20));
        jComponent2.setBorder(BorderFactory.createEmptyBorder(12, 16, 20, 16));
        splitPane.setTopComponent(jComponent);
        splitPane.setBottomComponent(jComponent2);
        return splitPane;
    }

    private JPanel createStandardContentPane(JComponent jComponent, JComponent jComponent2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = GUIFactory.newPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 20, 20, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        jPanel.add((Component)jComponent2, gridBagConstraints);
        return jPanel;
    }

    static class SplitPane
    extends JSplitPane {
        SplitPane(int n, boolean bl) {
            super(n, bl);
        }

        public int getDividerSize() {
            if (Gestalt.isJava141OrLater) {
                return super.getDividerSize();
            }
            return 9;
        }
    }
}

