/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.HyperTextPane;
import com.apple.gui.MenuManager;
import com.apple.util.Gestalt;
import com.apple.util.StringUtilities;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.AbstractAddSystemAction;
import com.apple.xsr.AbstractAdvancedAction;
import com.apple.xsr.AbstractClearErrorAction;
import com.apple.xsr.AbstractClearLogAction;
import com.apple.xsr.AbstractCreateArrayAction;
import com.apple.xsr.AbstractDeleteArrayAction;
import com.apple.xsr.AbstractFirstAidAction;
import com.apple.xsr.AbstractForgetPassAction;
import com.apple.xsr.AbstractNotificationAction;
import com.apple.xsr.AbstractServiceIDAction;
import com.apple.xsr.AbstractSetupAction;
import com.apple.xsr.AbstractUpdateFWAction;
import com.apple.xsr.AbstractUpdateNowAction;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertAdapter;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.AquaProgressClock;
import com.apple.xsr.AuthenticatedMenu;
import com.apple.xsr.DefaultSystemRegistry;
import com.apple.xsr.DeleteSystemAction;
import com.apple.xsr.ManagementController;
import com.apple.xsr.OperationManager;
import com.apple.xsr.RendezvousPanel;
import com.apple.xsr.Resources;
import com.apple.xsr.ShutdownAction;
import com.apple.xsr.SystemMonitorWindow;
import com.apple.xsr.Utilities;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.SystemController;
import com.apple.xsr.update.FirmwareUpdater;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SystemMonitorController
implements Preferences.PreferenceChangeListener {
    private static final SystemMonitorController INSTANCE = new SystemMonitorController();
    public DefaultSystemRegistry registry;
    public SystemMonitorWindow monitorWindow;
    private ManagementController managementController;
    private JMenuBar menuBar;
    private Action addSystem = new AddSystemAction();
    public Action deleteSystem;
    public Action createArray;
    public Action deleteArray;
    public Action setup;
    public Action notifications;
    public Action firstAid;
    public Action advanced;
    private Action clearErrorStatus;
    public Action serviceID;
    public Action forgetPassword;
    public Action updateNow;
    private Action clearEventLog;
    public Action restart;
    public Action shutdown;
    public Action resetUpperRaid;
    public Action resetLowerRaid;
    private Action repairLunMap;
    private Action updateFirmware;
    public Action enterMonitoringPassword;
    private RaidSystem savedSystem;
    private static final int MAX_FAILED_AUTHENTICATIONS_ALLOWED = 3;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$SystemMonitorController == null ? (class$com$apple$xsr$SystemMonitorController = SystemMonitorController.class$("com.apple.xsr.SystemMonitorController")) : class$com$apple$xsr$SystemMonitorController);
    static /* synthetic */ Class class$com$apple$xsr$SystemMonitorController;
    static /* synthetic */ Class class$com$apple$xsr$SystemMonitorController$ResetRaidAction;
    static /* synthetic */ Class class$com$apple$xsr$SystemMonitorController$ResetRaidAction$ResetThread;

    public static SystemMonitorController getInstance() {
        return INSTANCE;
    }

    private SystemMonitorController() {
        this.addSystem.setEnabled(true);
        this.deleteSystem = new DeleteSystemAction(this);
        this.deleteSystem.setEnabled(false);
        this.createArray = new AbstractCreateArrayAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                RaidSystem raidSystem = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                try {
                    if (!OperationManager.isSupported(raidSystem, OperationManager.OP_CREATE_ARRAY)) {
                        UnsupportedOperationDialog unsupportedOperationDialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                        unsupportedOperationDialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                        return;
                    }
                }
                catch (Exception exception) {
                    logger.error(exception);
                }
                boolean bl = true;
                if (raidSystem.supportsGlobalDriveCacheFeature() && (n = raidSystem.getDriveCacheFlags()) != 0 && n != 127) {
                    bl = false;
                    SystemMonitorController.this.showGlobalDriveCacheNotConfiguredSheet();
                }
                if (bl) {
                    SystemMonitorController.this.showManagementAuthenticationSheet("create_array_pane");
                }
            }
        };
        this.createArray.setEnabled(false);
        this.deleteArray = new AbstractDeleteArrayAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RaidSystem raidSystem = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                    if (!OperationManager.isSupported(raidSystem, OperationManager.OP_DELETE_ARRAY)) {
                        UnsupportedOperationDialog unsupportedOperationDialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                        unsupportedOperationDialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                        return;
                    }
                }
                catch (Exception exception) {
                    logger.error(exception);
                }
                SystemMonitorController.this.showManagementAuthenticationSheet("delete_array_pane");
            }
        };
        this.deleteArray.setEnabled(false);
        this.setup = new AbstractSetupAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                RaidSystem raidSystem = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                try {
                    bl = OperationManager.isSupported(raidSystem, OperationManager.OP_CONFIGURE_DISK_CACHE) && OperationManager.isSupported(raidSystem, OperationManager.OP_CONFIGURE_SYNC_CACHE) && OperationManager.isSupported(raidSystem, OperationManager.OP_CONFIGURE_SLOW_READ_BYPASS);
                }
                catch (Exception exception) {
                    bl = true;
                    logger.error(exception);
                }
                if (bl) {
                    SystemMonitorController.this.showManagementAuthenticationSheet("setup_pane");
                } else {
                    UnsupportedOperationDialog unsupportedOperationDialog = new UnsupportedOperationDialog(SystemMonitorController.this, Resources.getString("someUnsupportedOperationsDialog.message"), UnsupportedOperationDialog.DEFAULT_EXPLANATION, Resources.getString("ok"), null);
                    unsupportedOperationDialog.addAquaAlertListener(new AquaAlertAdapter(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void aquaAlertDismissed(int n, Object object) {
                            if (n == 1) {
                                3.access$100(this.this$1).showManagementAuthenticationSheet("setup_pane");
                            }
                        }
                    });
                    unsupportedOperationDialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                }
            }

            static /* synthetic */ SystemMonitorController access$100(3 var0) {
                return var0.SystemMonitorController.this;
            }
        };
        this.setup.setEnabled(false);
        this.notifications = new AbstractNotificationAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SystemMonitorController.this.showManagementAuthenticationSheet("notifications_pane");
            }
        };
        this.notifications.setEnabled(false);
        this.firstAid = new AbstractFirstAidAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                RaidSystem raidSystem = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                boolean bl = true;
                boolean bl2 = true;
                try {
                    bl = OperationManager.isSupported(raidSystem, OperationManager.OP_REBUILD_ARRAY) && OperationManager.isSupported(raidSystem, OperationManager.OP_VERIFY_ARRAY) && OperationManager.isSupported(raidSystem, OperationManager.OP_BACKGROUND_CONDITION) && OperationManager.isSupported(raidSystem, OperationManager.OP_DELETE_ORPHAN);
                    bl2 = OperationManager.isSupported(raidSystem, OperationManager.OP_REBUILD_ARRAY) || OperationManager.isSupported(raidSystem, OperationManager.OP_VERIFY_ARRAY) || OperationManager.isSupported(raidSystem, OperationManager.OP_BACKGROUND_CONDITION) || OperationManager.isSupported(raidSystem, OperationManager.OP_DELETE_ORPHAN);
                }
                catch (Exception exception) {
                    logger.error(exception);
                }
                if (bl) {
                    SystemMonitorController.this.showManagementAuthenticationSheet("first_aid");
                } else if (bl2) {
                    UnsupportedOperationDialog unsupportedOperationDialog = new UnsupportedOperationDialog(SystemMonitorController.this, Resources.getString("someUnsupportedOperationsDialog.message"), UnsupportedOperationDialog.DEFAULT_EXPLANATION, Resources.getString("ok"), null);
                    unsupportedOperationDialog.addAquaAlertListener(new AquaAlertAdapter(this){
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void aquaAlertDismissed(int n, Object object) {
                            if (n == 1) {
                                6.access$200(this.this$1).showManagementAuthenticationSheet("first_aid");
                            }
                        }
                    });
                    unsupportedOperationDialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                } else {
                    UnsupportedOperationDialog unsupportedOperationDialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                    unsupportedOperationDialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                }
            }

            static /* synthetic */ SystemMonitorController access$200(6 var0) {
                return var0.SystemMonitorController.this;
            }
        };
        this.firstAid.setEnabled(false);
        this.advanced = new AbstractAdvancedAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                RaidSystem raidSystem = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                boolean bl = true;
                boolean bl2 = true;
                try {
                    bl = OperationManager.isSupported(raidSystem, OperationManager.OP_SLICE_ARRAY) && OperationManager.isSupported(raidSystem, OperationManager.OP_EXPAND_ARRAY) && OperationManager.isSupported(raidSystem, OperationManager.OP_CONFIGURE_LUN_MASKING);
                    bl2 = OperationManager.isSupported(raidSystem, OperationManager.OP_SLICE_ARRAY) || OperationManager.isSupported(raidSystem, OperationManager.OP_EXPAND_ARRAY) || OperationManager.isSupported(raidSystem, OperationManager.OP_CONFIGURE_LUN_MASKING);
                }
                catch (Exception exception) {
                    logger.error(exception);
                }
                if (bl) {
                    SystemMonitorController.this.showManagementAuthenticationSheet("advanced_pane");
                } else if (bl2) {
                    UnsupportedOperationDialog unsupportedOperationDialog = new UnsupportedOperationDialog(SystemMonitorController.this, Resources.getString("someUnsupportedOperationsDialog.message"), UnsupportedOperationDialog.DEFAULT_EXPLANATION, Resources.getString("ok"), null);
                    unsupportedOperationDialog.addAquaAlertListener(new AquaAlertAdapter(this){
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void aquaAlertDismissed(int n, Object object) {
                            if (n == 1) {
                                8.access$300(this.this$1).showManagementAuthenticationSheet("advanced_pane");
                            }
                        }
                    });
                    unsupportedOperationDialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                } else {
                    UnsupportedOperationDialog unsupportedOperationDialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                    unsupportedOperationDialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                }
            }

            static /* synthetic */ SystemMonitorController access$300(8 var0) {
                return var0.SystemMonitorController.this;
            }
        };
        this.advanced.setEnabled(false);
        this.clearErrorStatus = new ClearErrorAction();
        this.clearErrorStatus.setEnabled(false);
        this.serviceID = new ServiceIDAction();
        this.serviceID.setEnabled(false);
        this.forgetPassword = new ForgetPasswordAction();
        this.forgetPassword.setEnabled(false);
        this.updateNow = new UpdateNowAction();
        this.updateNow.setEnabled(false);
        this.clearEventLog = new ClearEventLogAction();
        this.clearEventLog.setEnabled(false);
        this.restart = new RestartAction();
        this.restart.setEnabled(false);
        this.shutdown = new ShutdownAction(this);
        this.shutdown.setEnabled(false);
        this.resetUpperRaid = new ResetRaidAction(1);
        this.resetLowerRaid = new ResetRaidAction(2);
        this.repairLunMap = new RepairLunMapAction();
        this.repairLunMap.setEnabled(false);
        this.updateFirmware = new UpdateFirmwareAction();
        this.updateFirmware.setEnabled(false);
        this.enterMonitoringPassword = new EnterMonitoringPasswordAction();
        this.enterMonitoringPassword.setEnabled(false);
        this.monitorWindow = new SystemMonitorWindow(this);
        this.monitorWindow.setDefaultCloseOperation(2);
        this.monitorWindow.setAddSystemAction(this.addSystem);
        this.monitorWindow.setDeleteSystemAction(this.deleteSystem);
        this.monitorWindow.setCreateArrayAction(this.createArray);
        this.monitorWindow.setDeleteArrayAction(this.deleteArray);
        this.monitorWindow.setSetupAction(this.setup);
        this.monitorWindow.setNotificationsAction(this.notifications);
        this.monitorWindow.setFirstAidAction(this.firstAid);
        this.monitorWindow.setAdvancedAction(this.advanced);
        MenuManager menuManager = MenuManager.getInstance();
        menuManager.register("addItem", this.addSystem);
        menuManager.register("deleteItem", this.deleteSystem);
        menuManager.register("createArray", this.createArray);
        menuManager.register("deleteArray", this.deleteArray);
        menuManager.register("systemSettings", this.setup);
        menuManager.register("configureNotifications", this.notifications);
        menuManager.register("advanced", this.advanced);
        menuManager.register("firstAid", this.firstAid);
        menuManager.register("application.menu.system.updateNow", this.updateNow);
        menuManager.register("application.menu.system.serviceID.toggle", this.serviceID);
        menuManager.register("application.menu.system.clearEventLog", this.clearEventLog);
        menuManager.register("clearErrorStatus", this.clearErrorStatus);
        menuManager.register("application.menu.system.forgetPassword", this.forgetPassword);
        menuManager.register("application.menu.system.restart", this.restart);
        menuManager.register("application.menu.system.shutdown", this.shutdown);
        menuManager.register("application.menu.system.reset.upperRAID", this.resetUpperRaid);
        menuManager.register("application.menu.system.reset.lowerRAID", this.resetLowerRaid);
        menuManager.register("application.menu.system.repairLunMap", this.repairLunMap);
        menuManager.register("application.menu.system.updateFirmware", this.updateFirmware);
        this.menuBar = menuManager.newMenuBar();
        this.monitorWindow.setJMenuBar(this.menuBar);
        this.monitorWindow.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SystemMonitorController.this.updateMenuActionStatus();
            }
        });
        this.managementController = new ManagementController();
        this.registry = new DefaultSystemRegistry();
        this.registry.addSystemRegistryListener(this.monitorWindow);
        this.monitorWindow.systemTable.setRegistry(this.registry);
        RaidSystem[] raidSystemArray = this.monitorWindow.getSelectedSystems();
        this.deleteSystem.setEnabled(raidSystemArray.length > 0);
        this.updateMenuActionStatus();
        Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        preferences.addPreferenceChangeListener(this);
        GUIFactory.configureComponentForPlatform(this.monitorWindow);
        this.monitorWindow.setVisible(true);
    }

    public SystemMonitorWindow getMonitorWindow() {
        return this.monitorWindow;
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals("UseShapes")) {
            this.monitorWindow.systemTable.stopEditing();
            this.monitorWindow.systemTable.repaint();
            RaidSystem[] raidSystemArray = this.monitorWindow.systemTable.getSelectedSystems();
            if (raidSystemArray != null && raidSystemArray.length == 1) {
                this.registry.fireSystemUpdated(raidSystemArray);
            }
        }
    }

    public void showMonitoringAuthenticationSheet() {
        this.savedSystem = this.monitorWindow.getSelectedSystem();
        this.menuBar.setEnabled(false);
        MonitoringAuthenticationSheet monitoringAuthenticationSheet = new MonitoringAuthenticationSheet(this.savedSystem.getName());
        AquaAlert aquaAlert = new AquaAlert(monitoringAuthenticationSheet, monitoringAuthenticationSheet.getOKButton(), monitoringAuthenticationSheet.getCancelButton(), null);
        aquaAlert.associateKeyCodeWithButton(46, 4, 2);
        aquaAlert.associateKeyCodeWithButton(27, 0, 2);
        aquaAlert.showSheet(this.monitorWindow, new MonitoringAuthenticationListener(monitoringAuthenticationSheet, aquaAlert), monitoringAuthenticationSheet);
    }

    public void showManagementAuthenticationSheet(String string) {
        this.savedSystem = this.monitorWindow.getSelectedSystem();
        if (this.okToManageNewSystem(string)) {
            if (this.savedSystem.getManagementPasswordSaved()) {
                this.savedSystem.authenticate(new ManagementSessionAuthenticationListener(string), "admin", this.savedSystem.getManagementPassword(), false);
            } else {
                this.menuBar.setEnabled(false);
                ManagementAuthenticationSheet managementAuthenticationSheet = new ManagementAuthenticationSheet(this.savedSystem.getName());
                managementAuthenticationSheet.setRequestedManagementPane(string);
                AquaAlert aquaAlert = new AquaAlert(managementAuthenticationSheet, managementAuthenticationSheet.getOKButton(), managementAuthenticationSheet.getCancelButton(), null);
                aquaAlert.associateKeyCodeWithButton(46, 4, 2);
                aquaAlert.associateKeyCodeWithButton(27, 0, 2);
                aquaAlert.associateKeyCodeWithButton(75, 4, managementAuthenticationSheet.getSavePasswordCheckbox());
                aquaAlert.showSheet(this.monitorWindow, new ManagementAuthenticationListener(managementAuthenticationSheet, aquaAlert), managementAuthenticationSheet);
            }
        }
    }

    protected void showGlobalDriveCacheNotConfiguredSheet() {
        this.menuBar.setEnabled(false);
        AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.driveCachePolicyNotSetMessage"), Resources.getString("systemMonitorController.driveCachePolicyNotSetExplanation"), null, Resources.getString("ok"), Resources.getString("cancel"), Resources.getString("systemMonitorController.createArray"));
        aquaAlert.showSheet(this.monitorWindow, new AquaAlertListener(){

            public void aquaAlertWillBeShown(Object object) {
            }

            public void aquaAlertResized(Object object) {
            }

            public void aquaAlertDismissed(int n, Object object) {
                SystemMonitorController.this.menuBar.setEnabled(true);
                SystemMonitorController.this.updateMenuActionStatus();
                if (n == 1) {
                    SystemMonitorController.this.showManagementAuthenticationSheet("setup_pane");
                } else if (n == 3) {
                    SystemMonitorController.this.showManagementAuthenticationSheet("create_array_pane");
                }
            }

            public void aquaAlertSheetVisible(Object object) {
            }

            public boolean allowAquaAlertToBeDismissed(int n, Object object) {
                return true;
            }
        }, null);
    }

    public void showManagementAuthenticationSheet(AuthenticatedMenu authenticatedMenu) {
        this.savedSystem = this.monitorWindow.getSelectedSystem();
        if (this.savedSystem.getManagementPasswordSaved()) {
            this.savedSystem.authenticate(new ManagementSessionAuthenticationListener(authenticatedMenu), "admin", this.savedSystem.getManagementPassword(), false);
        } else {
            this.menuBar.setEnabled(false);
            ManagementAuthenticationSheet managementAuthenticationSheet = new ManagementAuthenticationSheet(this.savedSystem.getName());
            managementAuthenticationSheet.setAuthenticatedMenuItem(authenticatedMenu);
            AquaAlert aquaAlert = new AquaAlert(managementAuthenticationSheet, managementAuthenticationSheet.getOKButton(), managementAuthenticationSheet.getCancelButton(), null);
            aquaAlert.associateKeyCodeWithButton(46, 4, 2);
            aquaAlert.associateKeyCodeWithButton(27, 0, 2);
            aquaAlert.associateKeyCodeWithButton(75, 4, managementAuthenticationSheet.getSavePasswordCheckbox());
            aquaAlert.showSheet(this.monitorWindow, new ManagementAuthenticationListener(managementAuthenticationSheet, aquaAlert), managementAuthenticationSheet);
        }
    }

    private boolean okToManageNewSystem(String string) {
        boolean bl = true;
        if (string == null) {
            throw new NullPointerException("requestedPane may not be null");
        }
        if (this.managementController.aSystemIsBeingManaged()) {
            bl = false;
            if (this.savedSystem == this.managementController.getManagedSystem()) {
                if (string.equals(this.managementController.getManagementPaneType())) {
                    this.managementController.managementWindowToFront();
                } else {
                    this.showInformationalAlertSheet(Resources.getString("systemMonitorController.thisSystemAlreadyManagedMessage"), Resources.getString("systemMonitorController.thisSystemAlreadyManagedExplanation"));
                }
            } else {
                this.showInformationalAlertSheet(Resources.getString("systemMonitorController.anotherSystemAlreadyManagedMessage"), Resources.getString("systemMonitorController.anotherSystemAlreadyManagedExplanation"));
            }
        }
        return bl;
    }

    private void showInformationalAlertSheet(String string, String string2) {
        this.menuBar.setEnabled(false);
        AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(string, string2, Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        aquaAlert.showSheet(this.monitorWindow, new AquaAlertListener(){

            public void aquaAlertWillBeShown(Object object) {
            }

            public void aquaAlertResized(Object object) {
            }

            public void aquaAlertDismissed(int n, Object object) {
                SystemMonitorController.this.menuBar.setEnabled(true);
                SystemMonitorController.this.updateMenuActionStatus();
            }

            public void aquaAlertSheetVisible(Object object) {
            }

            public boolean allowAquaAlertToBeDismissed(int n, Object object) {
                return true;
            }
        }, null);
    }

    public void updateMenuActionStatus() {
        int n;
        RaidSystem[] raidSystemArray = this.monitorWindow.getSelectedSystems();
        int n2 = raidSystemArray.length;
        boolean bl = n2 == 1;
        RaidSystem raidSystem = null;
        int n3 = -1;
        boolean bl2 = false;
        if (!this.menuBar.isEnabled()) {
            return;
        }
        if (bl) {
            raidSystem = raidSystemArray[0];
            n3 = raidSystem.getPowerState();
        }
        if (bl && n3 == 1) {
            bl2 = true;
            this.clearErrorStatus.setEnabled(raidSystem.getEmailNotificationStatus() == 1);
            this.serviceID.putValue("Name", raidSystem.getServiceIdState() == 1 ? Resources.getString("application.menu.system.serviceID.off") : Resources.getString("application.menu.system.serviceID.on"));
        } else {
            bl2 = false;
            this.clearErrorStatus.setEnabled(false);
            this.serviceID.putValue("Name", Resources.getString("application.menu.system.serviceID.toggle"));
        }
        if (n3 == -1) {
            this.shutdown.setEnabled(false);
            this.shutdown.putValue("Name", Resources.getString("application.menu.system.shutdown"));
            this.restart.setEnabled(false);
            this.repairLunMap.setEnabled(false);
            this.updateFirmware.setEnabled(false);
        } else {
            this.shutdown.setEnabled(bl);
            this.shutdown.putValue("Name", n3 == 0 && bl ? Resources.getString("application.menu.system.powerOn") : Resources.getString("application.menu.system.shutdown"));
            this.restart.setEnabled(bl && n3 == 1);
            this.repairLunMap.setEnabled(bl && n3 == 1);
            this.updateFirmware.setEnabled(bl && n3 == 1);
        }
        this.addSystem.setEnabled(true);
        this.deleteSystem.setEnabled(n2 > 0);
        this.deleteSystem.putValue("Name", n2 > 1 ? Resources.getString("deleteItems") : Resources.getString("deleteItem"));
        this.createArray.setEnabled(bl2);
        this.deleteArray.setEnabled(bl2);
        this.setup.setEnabled(bl2);
        this.notifications.setEnabled(bl2);
        this.firstAid.setEnabled(bl2);
        this.advanced.setEnabled(bl2);
        this.serviceID.setEnabled(bl2);
        this.clearEventLog.setEnabled(bl2);
        this.restart.setEnabled(bl2);
        this.resetUpperRaid.setEnabled(bl2);
        this.resetLowerRaid.setEnabled(bl2);
        boolean bl3 = false;
        for (n = 0; n < n2; ++n) {
            if (raidSystemArray[n].getPowerState() == -1) continue;
            bl3 = true;
            break;
        }
        this.updateNow.setEnabled(bl3);
        n = 0;
        for (int i = 0; i < n2; ++i) {
            if (!raidSystemArray[i].getManagementPasswordSaved()) continue;
            n = 1;
            break;
        }
        this.forgetPassword.setEnabled(n != 0);
    }

    private void showBadPassword() {
        AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.passwordIncorrectMessage"), Resources.getString("systemMonitorController.passwordIncorrectExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        aquaAlert.showDialog(this.monitorWindow, Resources.getString("systemMonitorController.passwordIncorrectTitle"), null, null);
    }

    private void showLastChance() {
        AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.passwordIncorrectMessage"), Resources.getString("systemMonitorController.passwordIncorrectLastExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        aquaAlert.showDialog(this.monitorWindow, Resources.getString("systemMonitorController.passwordIncorrectTitle"), null, null);
    }

    private void showConnectionFailure() {
        AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.connectionFailureMessage"), Resources.getString("systemMonitorController.connectionFailureExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        aquaAlert.showDialog(this.monitorWindow, Resources.getString("systemMonitorController.connectionFailureTitle"), null, null);
    }

    private void showSystemBusySheet() {
        this.menuBar.setEnabled(false);
        AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.cannotUpdateFirmwareMessage"), Resources.getString("systemMonitorController.cannotUpdateFirmwareExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        aquaAlert.showSheet(this.monitorWindow, new AquaAlertListener(){

            public void aquaAlertWillBeShown(Object object) {
            }

            public void aquaAlertResized(Object object) {
            }

            public void aquaAlertDismissed(int n, Object object) {
                SystemMonitorController.this.menuBar.setEnabled(true);
                SystemMonitorController.this.updateMenuActionStatus();
            }

            public void aquaAlertSheetVisible(Object object) {
            }

            public boolean allowAquaAlertToBeDismissed(int n, Object object) {
                return true;
            }
        }, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class UnsupportedOperationDialog
    extends JPanel
    implements AquaAlertListener,
    HyperlinkListener {
        static final String DEFAULT_MESSAGE = Resources.getString("unsupportedOperationDialog.message");
        static final String DEFAULT_EXPLANATION = Resources.getString("unsupportedOperationDialog.explanation");
        static final String DEFAULT_ACTION_BTN_TITLE = Resources.getString("cancel");
        private static final int BUTTON_SPACING = 12;
        private AquaAlert alert;
        private SystemMonitorController monitorController;
        private JButton defaultButton;
        private JButton altButton;
        private JButton updateButton;
        private String url;

        public UnsupportedOperationDialog(SystemMonitorController systemMonitorController) {
            this(systemMonitorController, DEFAULT_MESSAGE, DEFAULT_EXPLANATION, DEFAULT_ACTION_BTN_TITLE, null);
        }

        public UnsupportedOperationDialog(SystemMonitorController systemMonitorController, String string, String string2, String string3, String string4) {
            this.monitorController = systemMonitorController;
            Image image = Resources.getImage("icon.application");
            String string5 = Resources.getString("unsupportedOperationDialog.updateButton");
            this.url = Resources.getString("unsupportedOperationDialog.url");
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            this.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)new JLabel(new ImageIcon(image)), gridBagConstraints);
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setFont(GUIFactory.FONT_NORMAL_BOLD);
            jTextArea.setBackground(null);
            jTextArea.setHighlighter(null);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(false);
            jTextArea.setMargin(new Insets(0, 14, 4, 4));
            jTextArea.setMinimumSize(new Dimension(300, 48));
            jTextArea.setMaximumSize(new Dimension(300, 200));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            this.add((Component)jTextArea, gridBagConstraints);
            HyperTextPane hyperTextPane = new HyperTextPane(string2);
            hyperTextPane.setFont(GUIFactory.FONT_SMALL);
            hyperTextPane.setMargin(new Insets(4, 14, 20, 4));
            hyperTextPane.setMinimumSize(new Dimension(300, 48));
            hyperTextPane.setMaximumSize(new Dimension(300, 200));
            hyperTextPane.addHyperlinkListener(this);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            this.add((Component)hyperTextPane, gridBagConstraints);
            Box box = Box.createHorizontalBox();
            this.updateButton = GUIFactory.newButton(string5);
            box.add(this.updateButton);
            box.add(Box.createHorizontalGlue());
            if (string4 != null) {
                box.add(Box.createHorizontalStrut(12));
                this.altButton = GUIFactory.newButton(string4);
                box.add(this.altButton);
            }
            this.defaultButton = GUIFactory.newButton(string3);
            this.defaultButton.setDefaultCapable(true);
            box.add(this.defaultButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 2;
            this.add((Component)box, gridBagConstraints);
            this.alert = new AquaAlert(this, this.defaultButton, this.altButton, this.updateButton);
        }

        public void showAsSheet(JFrame jFrame) {
            this.alert.showSheet(jFrame, this, null);
        }

        public void addAquaAlertListener(AquaAlertListener aquaAlertListener) {
            if (aquaAlertListener != null) {
                this.alert.addAquaAlertListener(aquaAlertListener);
            }
        }

        public void removeAquaAlertListener(AquaAlertListener aquaAlertListener) {
            if (this.alert != null && aquaAlertListener != null) {
                this.alert.removeAquaAlertListener(aquaAlertListener);
            }
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    BrowserLauncher.openURL(this.url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void aquaAlertDismissed(int n, Object object) {
            if (n == 3) {
                this.monitorController.updateFirmware.actionPerformed(new ActionEvent(this.monitorController.monitorWindow, 1001, ""));
            }
        }

        public boolean allowAquaAlertToBeDismissed(int n, Object object) {
            return true;
        }

        public void aquaAlertWillBeShown(Object object) {
        }

        public void aquaAlertSheetVisible(Object object) {
        }

        public void aquaAlertResized(Object object) {
        }
    }

    private class ManagementSessionAuthenticationListener
    implements CommunicationHandler {
        String requestedManagementPane = null;
        AuthenticatedMenu authenticatedMenu = null;

        ManagementSessionAuthenticationListener(String string) {
            this.requestedManagementPane = string;
        }

        ManagementSessionAuthenticationListener(AuthenticatedMenu authenticatedMenu) {
            this.authenticatedMenu = authenticatedMenu;
        }

        public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
            int n = response.getResultCode();
            if (n == 0) {
                if (this.authenticatedMenu != null) {
                    this.authenticatedMenu.performMenuSelection(raidSystem, raidSystem.getManagementPassword());
                } else if (this.requestedManagementPane != null) {
                    SystemMonitorController.this.managementController.showManagementWindow(raidSystem, this.requestedManagementPane, SystemMonitorController.this.monitorWindow);
                }
            } else if (n == -16 || n == -27 || n == -28) {
                raidSystem.setManagementPasswordSaved(false);
            } else if (n == -101) {
                SystemMonitorController.this.showConnectionFailure();
            }
        }
    }

    private class ManagementAuthenticationListener
    implements AquaAlertListener,
    CommunicationHandler {
        private int numFailedAuthentications = 0;
        private ManagementAuthenticationSheet authenticationPanel;
        private AquaAlert authenticationAlert;

        public ManagementAuthenticationListener(ManagementAuthenticationSheet managementAuthenticationSheet, AquaAlert aquaAlert) {
            this.authenticationPanel = managementAuthenticationSheet;
            this.authenticationAlert = aquaAlert;
        }

        public void aquaAlertWillBeShown(Object object) {
        }

        public void aquaAlertResized(Object object) {
        }

        public void aquaAlertSheetVisible(Object object) {
            ManagementAuthenticationSheet managementAuthenticationSheet = (ManagementAuthenticationSheet)object;
            managementAuthenticationSheet.getFirstFocus().requestFocus();
        }

        public boolean allowAquaAlertToBeDismissed(int n, Object object) {
            if (n == 1) {
                String string = "admin";
                ManagementAuthenticationSheet managementAuthenticationSheet = (ManagementAuthenticationSheet)object;
                String string2 = managementAuthenticationSheet.getPassword();
                AquaProgressClock aquaProgressClock = managementAuthenticationSheet.getProgressClock();
                aquaProgressClock.setVisible(true);
                aquaProgressClock.startAnimation();
                SystemMonitorController.this.savedSystem.authenticate(this, string, string2, true);
                return false;
            }
            return true;
        }

        public void aquaAlertDismissed(int n, Object object) {
            if (n == 1) {
                AuthenticatedMenu authenticatedMenu = null;
                authenticatedMenu = ((ManagementAuthenticationSheet)object).getAuthenticatedMenuItem();
                if (authenticatedMenu != null) {
                    try {
                        String string = Utilities.crypt(this.authenticationPanel.getPassword());
                        authenticatedMenu.performMenuSelection(SystemMonitorController.this.savedSystem, string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        logger.error(unsupportedEncodingException);
                    }
                } else if (((ManagementAuthenticationSheet)object).getRequestedManagementPane() != null && this.numFailedAuthentications < 3) {
                    SystemMonitorController.this.managementController.showManagementWindow(SystemMonitorController.this.savedSystem, ((ManagementAuthenticationSheet)object).getRequestedManagementPane(), SystemMonitorController.this.monitorWindow);
                }
            }
            this.numFailedAuthentications = 0;
            SystemMonitorController.this.menuBar.setEnabled(true);
            SystemMonitorController.this.updateMenuActionStatus();
        }

        public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
            AquaProgressClock aquaProgressClock = this.authenticationPanel.getProgressClock();
            aquaProgressClock.setVisible(false);
            aquaProgressClock.stopAnimation();
            int n = response.getResultCode();
            if (n == 0) {
                if (this.authenticationPanel.getSavePassword()) {
                    try {
                        raidSystem.setManagementPassword(Utilities.crypt(this.authenticationPanel.getPassword()));
                        raidSystem.setManagementPasswordSaved(true);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        logger.error(unsupportedEncodingException);
                    }
                }
                this.authenticationAlert.dismissSheetOrDialog(1);
            } else if (n == -16 || n == -27 || n == -28) {
                ++this.numFailedAuthentications;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ManagementAuthenticationListener this$1;
                    {
                        this.this$1 = managementAuthenticationListener;
                    }

                    public void run() {
                        ManagementAuthenticationListener.access$1900(this.this$1).resetPassword();
                    }
                });
                if (this.numFailedAuthentications >= 3) {
                    SystemMonitorController.this.showLastChance();
                    this.authenticationAlert.dismissSheetOrDialog(2);
                } else {
                    SystemMonitorController.this.showBadPassword();
                }
            } else if (n == -101) {
                SystemMonitorController.this.showConnectionFailure();
                this.authenticationAlert.dismissSheetOrDialog(2);
            }
        }

        static /* synthetic */ ManagementAuthenticationSheet access$1900(ManagementAuthenticationListener managementAuthenticationListener) {
            return managementAuthenticationListener.authenticationPanel;
        }
    }

    private static class ManagementAuthenticationSheet
    extends JPanel {
        public static final int ADDRESS_FIELD_WIDTH = 20;
        private JPasswordField mPasswordField = null;
        private JCheckBox mSavePasswordCheckbox = null;
        private AquaProgressClock mProgress = null;
        private JButton mOKButton = null;
        private JButton mCancelButton = null;
        private String mRequestedPane = null;
        private AuthenticatedMenu mMenuItem = null;

        public ManagementAuthenticationSheet(String string) {
            String string2 = Resources.getString("management.authenticationSheet.message");
            string2 = StringUtilities.replaceAll(string2, "{name}", string);
            this.setLayout(new GridBagLayout());
            Box box = Box.createHorizontalBox();
            JLabel jLabel = new JLabel(Resources.getString("management.authenticationSheet.passwordLabel"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mPasswordField = GUIFactory.newPasswordField(20);
            this.mSavePasswordCheckbox = GUIFactory.newCheckBox(Resources.getString("management.authenticationSheet.savePasswordCheckbox"));
            this.mSavePasswordCheckbox.addActionListener(new ActionListener(this){
                private final /* synthetic */ ManagementAuthenticationSheet this$0;
                {
                    this.this$0 = managementAuthenticationSheet;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ManagementAuthenticationSheet.access$1700(this.this$0).grabFocus();
                }
            });
            this.mProgress = new AquaProgressClock();
            this.mProgress.setVisible(false);
            this.mOKButton = GUIFactory.newOKButton();
            this.mCancelButton = GUIFactory.newCancelButton();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 8, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            JTextArea jTextArea = new JTextArea(string2);
            jTextArea.setFont(GUIFactory.FONT_SMALL);
            jTextArea.setBackground(null);
            jTextArea.setHighlighter(null);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setSize(300, 64);
            jTextArea.setMinimumSize(new Dimension(300, 48));
            jTextArea.setMaximumSize(new Dimension(300, 200));
            this.add((Component)jTextArea, gridBagConstraints);
            jLabel.setFont(GUIFactory.FONT_SMALL);
            this.mPasswordField.setFont(GUIFactory.FONT_SMALL);
            if (Gestalt.isMacLookAndFeel) {
                this.mPasswordField.setEchoChar('\u2022');
            }
            gridBagConstraints.insets = new Insets(0, 0, 8, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            this.add((Component)this.mPasswordField, gridBagConstraints);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 8, 8);
            gridBagConstraints.gridx = 0;
            this.add((Component)jLabel, gridBagConstraints);
            this.mSavePasswordCheckbox.setFont(GUIFactory.FONT_SMALL);
            gridBagConstraints.insets = new Insets(0, 0, 8, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            this.add((Component)this.mSavePasswordCheckbox, gridBagConstraints);
            box.add(Box.createHorizontalStrut(1));
            box.add(this.mProgress);
            box.add(Box.createHorizontalGlue());
            box.add(this.mCancelButton);
            box.add(Box.createHorizontalStrut(8));
            box.add(this.mOKButton);
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            this.add((Component)box, gridBagConstraints);
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public void setRequestedManagementPane(String string) {
            this.mRequestedPane = string;
        }

        public String getRequestedManagementPane() {
            return this.mRequestedPane;
        }

        public void setAuthenticatedMenuItem(AuthenticatedMenu authenticatedMenu) {
            this.mMenuItem = authenticatedMenu;
        }

        public AuthenticatedMenu getAuthenticatedMenuItem() {
            return this.mMenuItem;
        }

        public JButton getOKButton() {
            return this.mOKButton;
        }

        public JButton getCancelButton() {
            return this.mCancelButton;
        }

        public String getPassword() {
            return new String(this.mPasswordField.getPassword());
        }

        public void resetPassword() {
            this.mPasswordField.setText("");
        }

        public boolean getSavePassword() {
            return this.mSavePasswordCheckbox.isSelected();
        }

        public JCheckBox getSavePasswordCheckbox() {
            return this.mSavePasswordCheckbox;
        }

        public AquaProgressClock getProgressClock() {
            return this.mProgress;
        }

        public JComponent getFirstFocus() {
            return this.mPasswordField;
        }

        static /* synthetic */ JPasswordField access$1700(ManagementAuthenticationSheet managementAuthenticationSheet) {
            return managementAuthenticationSheet.mPasswordField;
        }
    }

    private class MonitoringAuthenticationListener
    implements AquaAlertListener,
    CommunicationHandler {
        private int numFailedAuthentications = 0;
        private MonitoringAuthenticationSheet authenticationPanel;
        private AquaAlert authenticationAlert;

        public MonitoringAuthenticationListener(MonitoringAuthenticationSheet monitoringAuthenticationSheet, AquaAlert aquaAlert) {
            this.authenticationPanel = monitoringAuthenticationSheet;
            this.authenticationAlert = aquaAlert;
        }

        public void aquaAlertWillBeShown(Object object) {
        }

        public void aquaAlertResized(Object object) {
        }

        public void aquaAlertSheetVisible(Object object) {
            MonitoringAuthenticationSheet monitoringAuthenticationSheet = (MonitoringAuthenticationSheet)object;
            monitoringAuthenticationSheet.getFirstFocus().requestFocus();
        }

        public boolean allowAquaAlertToBeDismissed(int n, Object object) {
            if (n == 1) {
                String string = "guest";
                MonitoringAuthenticationSheet monitoringAuthenticationSheet = (MonitoringAuthenticationSheet)object;
                String string2 = monitoringAuthenticationSheet.getPassword();
                AquaProgressClock aquaProgressClock = monitoringAuthenticationSheet.getProgressClock();
                aquaProgressClock.setVisible(true);
                aquaProgressClock.startAnimation();
                SystemMonitorController.this.savedSystem.authenticate(this, string, string2, true);
                return false;
            }
            return true;
        }

        public void aquaAlertDismissed(int n, Object object) {
            if (n == 1) {
                // empty if block
            }
            this.numFailedAuthentications = 0;
            SystemMonitorController.this.menuBar.setEnabled(true);
            SystemMonitorController.this.updateMenuActionStatus();
        }

        public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
            AquaProgressClock aquaProgressClock = this.authenticationPanel.getProgressClock();
            aquaProgressClock.setVisible(false);
            aquaProgressClock.stopAnimation();
            int n = response.getResultCode();
            if (n == 0) {
                try {
                    raidSystem.setMonitoringPassword(Utilities.crypt(this.authenticationPanel.getPassword()));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.error(unsupportedEncodingException);
                }
                raidSystem.setUserMessageIndex(3);
                this.authenticationAlert.dismissSheetOrDialog(1);
            } else if (n == -16 || n == -27 || n == -28) {
                ++this.numFailedAuthentications;
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ MonitoringAuthenticationListener this$1;
                    {
                        this.this$1 = monitoringAuthenticationListener;
                    }

                    public void run() {
                        MonitoringAuthenticationListener.access$1300(this.this$1).resetPassword();
                    }
                });
                if (this.numFailedAuthentications >= 3) {
                    SystemMonitorController.this.showLastChance();
                    this.authenticationAlert.dismissSheetOrDialog(2);
                } else {
                    SystemMonitorController.this.showBadPassword();
                }
            } else if (n == -101) {
                SystemMonitorController.this.showConnectionFailure();
                this.authenticationAlert.dismissSheetOrDialog(2);
            }
        }

        static /* synthetic */ MonitoringAuthenticationSheet access$1300(MonitoringAuthenticationListener monitoringAuthenticationListener) {
            return monitoringAuthenticationListener.authenticationPanel;
        }
    }

    private static class MonitoringAuthenticationSheet
    extends JPanel {
        public static final int ADDRESS_FIELD_WIDTH = 20;
        private JPasswordField mPasswordField = null;
        private JCheckBox mSavePasswordCheckbox = null;
        private AquaProgressClock mProgress = null;
        private JButton mOKButton = null;
        private JButton mCancelButton = null;
        private String mRequestedPane = null;
        private AuthenticatedMenu mMenuItem = null;

        public MonitoringAuthenticationSheet(String string) {
            String string2 = Resources.getString("monitoring.authenticationSheet.message");
            string2 = StringUtilities.replaceAll(string2, "{name}", string);
            this.setLayout(new GridBagLayout());
            Box box = Box.createHorizontalBox();
            JLabel jLabel = new JLabel(Resources.getString("management.authenticationSheet.passwordLabel"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mPasswordField = GUIFactory.newPasswordField(20);
            this.mProgress = new AquaProgressClock();
            this.mProgress.setVisible(false);
            this.mOKButton = GUIFactory.newOKButton();
            this.mCancelButton = GUIFactory.newCancelButton();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 8, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            JTextArea jTextArea = new JTextArea(string2);
            jTextArea.setFont(GUIFactory.FONT_SMALL);
            jTextArea.setBackground(null);
            jTextArea.setHighlighter(null);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setSize(300, 64);
            jTextArea.setMinimumSize(new Dimension(300, 48));
            jTextArea.setMaximumSize(new Dimension(300, 200));
            this.add((Component)jTextArea, gridBagConstraints);
            jLabel.setFont(GUIFactory.FONT_SMALL);
            this.mPasswordField.setFont(GUIFactory.FONT_SMALL);
            if (Gestalt.isMacLookAndFeel) {
                this.mPasswordField.setEchoChar('\u2022');
            }
            gridBagConstraints.insets = new Insets(0, 0, 8, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            this.add((Component)this.mPasswordField, gridBagConstraints);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 8, 8);
            gridBagConstraints.gridx = 0;
            this.add((Component)jLabel, gridBagConstraints);
            box.add(Box.createHorizontalStrut(1));
            box.add(this.mProgress);
            box.add(Box.createHorizontalGlue());
            box.add(this.mCancelButton);
            box.add(Box.createHorizontalStrut(8));
            box.add(this.mOKButton);
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            this.add((Component)box, gridBagConstraints);
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public JButton getOKButton() {
            return this.mOKButton;
        }

        public JButton getCancelButton() {
            return this.mCancelButton;
        }

        public String getPassword() {
            return new String(this.mPasswordField.getPassword());
        }

        public void resetPassword() {
            this.mPasswordField.setText("");
        }

        public AquaProgressClock getProgressClock() {
            return this.mProgress;
        }

        public JComponent getFirstFocus() {
            return this.mPasswordField;
        }
    }

    private class EnterMonitoringPasswordAction
    extends AbstractAction {
        public static final String COMMAND_KEY = "enter_monitoring_password";

        public EnterMonitoringPasswordAction() {
            this.putValue("Name", Resources.getString("application.menu.system.reenterPassword"));
            this.putValue("MnemonicKey", null);
            this.putValue("ActionCommandKey", COMMAND_KEY);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemMonitorController.this.showMonitoringAuthenticationSheet();
        }
    }

    private class UpdateFirmwareAction
    extends AbstractUpdateFWAction
    implements AuthenticatedMenu {
        private UpdateFirmwareAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RaidSystem raidSystem = SystemMonitorController.this.monitorWindow.getSelectedSystem();
            if (raidSystem.isBusy()) {
                SystemMonitorController.this.showSystemBusySheet();
            } else {
                SystemMonitorController.this.showManagementAuthenticationSheet(this);
            }
        }

        public void performMenuSelection(RaidSystem raidSystem, String string) {
            new FirmwareUpdater(SystemMonitorController.this.monitorWindow, raidSystem, string);
        }
    }

    private class RepairLunMapAction
    extends AbstractAction
    implements AuthenticatedMenu {
        public static final String COMMAND_KEY = "repair_lun_map";
        public static final int OK_BUTTON_IDENTIFIER = 2;

        public RepairLunMapAction() {
            this.putValue("Name", Resources.getString("application.menu.system.repairLunMap"));
            this.putValue("MnemonicKey", null);
            this.putValue("ActionCommandKey", COMMAND_KEY);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                RaidSystem raidSystem = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                if (!OperationManager.isSupported(raidSystem, OperationManager.OP_REPAIR_LUN_MAP)) {
                    UnsupportedOperationDialog unsupportedOperationDialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                    unsupportedOperationDialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                    return;
                }
            }
            catch (Exception exception) {
                logger.error(exception);
            }
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem raidSystem, String string) {
            new ConfirmDialog(SystemMonitorController.this.monitorWindow, new AquaAlertAdapter(this, raidSystem){
                private final /* synthetic */ RaidSystem val$system;
                private final /* synthetic */ RepairLunMapAction this$1;
                {
                    this.this$1 = repairLunMapAction;
                    this.val$system = raidSystem;
                }

                public void aquaAlertDismissed(int n, Object object) {
                    if (n == 2) {
                        new Thread(new ManagementController.LunMapRepairer(this.val$system)).start();
                    }
                }
            });
        }

        class ConfirmDialog {
            public ConfirmDialog(JFrame jFrame, AquaAlertListener aquaAlertListener) {
                AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("repairLunMapDialog.message"), Resources.getString("repairLunMapDialog.explanation"), Resources.getImage("icon.application"), Resources.getString("cancel"), Resources.getString("ok"), null);
                aquaAlert.associateKeyCodeWithButton(46, 4, 1);
                aquaAlert.associateKeyCodeWithButton(27, 0, 1);
                aquaAlert.showSheet(jFrame, aquaAlertListener, null);
            }
        }
    }

    private class ResetRaidAction
    extends AbstractAction
    implements AuthenticatedMenu {
        public static final String COMMAND_KEY = "reset_raid";
        public static final int OK_BUTTON_IDENTIFIER = 2;
        protected int controllerID;
        private final Logger logger = Logger.getLogger(class$com$apple$xsr$SystemMonitorController$ResetRaidAction == null ? (class$com$apple$xsr$SystemMonitorController$ResetRaidAction = SystemMonitorController.class$("com.apple.xsr.SystemMonitorController$ResetRaidAction")) : class$com$apple$xsr$SystemMonitorController$ResetRaidAction);

        public ResetRaidAction(int n) {
            this.controllerID = n;
            String string = n == 1 ? Resources.getString("application.menu.system.reset.upperRAID") : Resources.getString("application.menu.system.reset.lowerRAID");
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("Name", string);
            this.putValue("MnemonicKey", null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                RaidSystem raidSystem = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                if (!OperationManager.isSupported(raidSystem, OperationManager.OP_RESET_RAID_CONTROLLER)) {
                    UnsupportedOperationDialog unsupportedOperationDialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                    unsupportedOperationDialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                    return;
                }
            }
            catch (Exception exception) {
                this.logger.error(exception);
            }
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem raidSystem, String string) {
            new ConfirmDialog(SystemMonitorController.this.monitorWindow, new AquaAlertAdapter(this, raidSystem){
                private final /* synthetic */ RaidSystem val$system;
                private final /* synthetic */ ResetRaidAction this$1;
                {
                    this.this$1 = resetRaidAction;
                    this.val$system = raidSystem;
                }

                public void aquaAlertDismissed(int n, Object object) {
                    if (n == 2) {
                        this.this$1.new ResetThread(this.val$system, this.this$1.controllerID).start();
                    }
                }
            });
        }

        class ConfirmDialog {
            public ConfirmDialog(JFrame jFrame, AquaAlertListener aquaAlertListener) {
                AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("resetRaidDialog.message"), Resources.getString("resetRaidDialog.explanation"), Resources.getImage("icon.application"), Resources.getString("cancel"), Resources.getString("ok"), null);
                aquaAlert.associateKeyCodeWithButton(46, 4, 1);
                aquaAlert.associateKeyCodeWithButton(27, 0, 1);
                aquaAlert.showSheet(jFrame, aquaAlertListener, null);
            }
        }

        class ResetThread
        extends Thread {
            private RaidSystem system;
            private int controllerID;
            private final Logger logger = Logger.getLogger(class$com$apple$xsr$SystemMonitorController$ResetRaidAction$ResetThread == null ? (class$com$apple$xsr$SystemMonitorController$ResetRaidAction$ResetThread = SystemMonitorController.class$("com.apple.xsr.SystemMonitorController$ResetRaidAction$ResetThread")) : class$com$apple$xsr$SystemMonitorController$ResetRaidAction$ResetThread);

            public ResetThread(RaidSystem raidSystem, int n) {
                this.system = raidSystem;
                this.controllerID = n;
            }

            public void run() {
                MessageFactory messageFactory = this.system.getMessageFactory();
                RequestMessage requestMessage = messageFactory.newResetControllerNvramRequest();
                try {
                    this.system.postMessage(requestMessage, this.controllerID);
                    this.logger.info("Waiting for RAID controller " + this.controllerID + " to restart...");
                    this.system.waitForRaidControllerOnline(this.controllerID);
                    this.logger.info("RAID controller " + this.controllerID + " is online");
                }
                catch (Exception exception) {
                    this.logger.error(exception);
                }
                new ManagementController.LunMapRepairer(this.system, new int[]{this.controllerID}).run();
            }
        }
    }

    private class RestartAction
    extends AbstractAction
    implements AuthenticatedMenu {
        public static final String COMMAND_KEY = "restart_system";

        public RestartAction() {
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("Name", Resources.getString("application.menu.system.restart"));
            this.putValue("MnemonicKey", null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem raidSystem, String string) {
            int n = 15;
            InvocationEvent invocationEvent = new InvocationEvent((Object)SystemMonitorController.this, new Runnable(this, raidSystem){
                private final /* synthetic */ RaidSystem val$system;
                private final /* synthetic */ RestartAction this$1;
                {
                    this.this$1 = restartAction;
                    this.val$system = raidSystem;
                }

                public void run() {
                    this.val$system.authenticate(null, this.val$system.getMonitoringUserId(), this.val$system.getMonitoringPassword(), false);
                }
            });
            raidSystem.setUserMessageIndex(7);
            ManagementController.Restarter restarter = new ManagementController.Restarter(raidSystem, n, true, invocationEvent);
            new Thread(restarter).start();
        }
    }

    private class ClearEventLogAction
    extends AbstractClearLogAction
    implements AuthenticatedMenu {
        private ClearEventLogAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem raidSystem, String string) {
            raidSystem.setUserMessageIndex(13);
            MessageFactory messageFactory = raidSystem.getMessageFactory();
            RequestMessage requestMessage = messageFactory.newClearEventLogRequest();
            if (raidSystem.isControllerModulePresent(1)) {
                raidSystem.postMessageAsync(null, requestMessage, 1, null);
            }
            if (raidSystem.isControllerModulePresent(2)) {
                raidSystem.postMessageAsync(null, requestMessage, 2, null);
            }
            raidSystem.getEventLog().clearEvents();
        }
    }

    private class UpdateNowAction
    extends AbstractUpdateNowAction {
        private UpdateNowAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RaidSystem[] raidSystemArray = SystemMonitorController.this.monitorWindow.getSelectedSystems();
            for (int i = 0; i < raidSystemArray.length; ++i) {
                RaidSystem raidSystem = raidSystemArray[i];
                int n = raidSystem.getPowerState();
                if (n == -1) continue;
                raidSystem.updateImmediately(true);
            }
        }
    }

    private class ForgetPasswordAction
    extends AbstractForgetPassAction {
        private ForgetPasswordAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RaidSystem[] raidSystemArray = SystemMonitorController.this.monitorWindow.getSelectedSystems();
            for (int i = 0; i < raidSystemArray.length; ++i) {
                raidSystemArray[i].setManagementPasswordSaved(false);
            }
        }
    }

    private class ServiceIDAction
    extends AbstractServiceIDAction
    implements AuthenticatedMenu {
        private ServiceIDAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem raidSystem, String string) {
            MessageFactory messageFactory = raidSystem.getMessageFactory();
            int n = raidSystem.getServiceIdState();
            int n2 = n == 1 ? 0 : 1;
            RequestMessage requestMessage = n == 0 ? messageFactory.newIlluminateRequest("service", null, "on") : messageFactory.newIlluminateRequest("service", null, "off");
            CommunicationHandler communicationHandler = new CommunicationHandler(this){
                private final /* synthetic */ ServiceIDAction this$1;
                {
                    this.this$1 = serviceIDAction;
                }

                public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
                    int n = raidSystem.getServiceIdState();
                    if (n == 1) {
                        this.this$1.putValue("Name", Resources.getString("application.menu.system.serviceID.off"));
                    } else if (n == 0) {
                        this.this$1.putValue("Name", Resources.getString("application.menu.system.serviceID.on"));
                    }
                }
            };
            requestMessage.setTargetController(RequestMessage.Target.TOP);
            raidSystem.postMessageAsync(communicationHandler, requestMessage);
            raidSystem.setServiceIdState(n2);
        }
    }

    private class ClearErrorAction
    extends AbstractClearErrorAction
    implements AuthenticatedMenu {
        private ClearErrorAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem raidSystem, String string) {
            MessageFactory messageFactory = raidSystem.getMessageFactory();
            CommunicationHandler communicationHandler = new CommunicationHandler(this){
                private final /* synthetic */ ClearErrorAction this$1;
                {
                    this.this$1 = clearErrorAction;
                }

                public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
                    if (response.getResultCode() == 0) {
                        raidSystem.setEmailNotificationStatus(0);
                    }
                }
            };
            RequestMessage requestMessage = messageFactory.newSystemMonitorResetRequest();
            requestMessage.setTargetController(RequestMessage.Target.COMPANION);
            raidSystem.postMessageAsync(null, requestMessage);
            requestMessage.setTargetController(null);
            raidSystem.postMessageAsync(communicationHandler, requestMessage);
        }
    }

    private class AddSystemAction
    extends AbstractAddSystemAction
    implements AquaAlertListener,
    CommunicationHandler {
        private final ImageIcon smallIcon = new ImageIcon(Resources.getImage("icon.addItem"));
        private RendezvousPanel panel;
        private AquaAlert logonSheet;
        private int systemsAdded = 0;

        public AddSystemAction() {
            this.putValue("SmallIcon", this.smallIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList arrayList = this.getMonitoredMACAddresses();
            ArrayList arrayList2 = this.getMonitoredIPAddresses();
            this.panel = new RendezvousPanel(arrayList, arrayList2);
            this.logonSheet = new AquaAlert(this.panel, this.panel.getAddButton(), this.panel.getCancelButton(), null);
            this.logonSheet.associateKeyCodeWithButton(46, 4, 2);
            this.logonSheet.associateKeyCodeWithButton(27, 0, 2);
            SystemMonitorController.this.menuBar.setEnabled(false);
            this.logonSheet.showSheet(SystemMonitorController.this.monitorWindow, this, this.panel);
        }

        protected ArrayList getMonitoredMACAddresses() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = SystemMonitorController.this.registry.getSystems().iterator();
            while (iterator.hasNext()) {
                RaidSystem raidSystem = (RaidSystem)iterator.next();
                if (raidSystem == null) continue;
                Iterator iterator2 = raidSystem.getSystemControllers().iterator();
                while (iterator2.hasNext()) {
                    String string;
                    NetworkInterface networkInterface;
                    SystemController systemController = (SystemController)iterator2.next();
                    if (systemController == null || (networkInterface = systemController.getNetworkInterface()) == null || (string = networkInterface.getMacAddress()) == null) continue;
                    arrayList.add(string);
                }
            }
            return arrayList;
        }

        protected ArrayList getMonitoredIPAddresses() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = SystemMonitorController.this.registry.getSystems().iterator();
            while (iterator.hasNext()) {
                RaidSystem raidSystem = (RaidSystem)iterator.next();
                if (raidSystem == null) continue;
                String string = raidSystem.getPrimaryHostAddress();
                String string2 = raidSystem.getSecondaryHostAddress();
                if (string != null) {
                    arrayList.add(string);
                }
                if (string2 != null) {
                    arrayList.add(string2);
                }
                Iterator iterator2 = raidSystem.getSystemControllers().iterator();
                while (iterator2.hasNext()) {
                    String string3;
                    IPAddress iPAddress;
                    NetworkInterface networkInterface;
                    SystemController systemController = (SystemController)iterator2.next();
                    if (systemController == null || (networkInterface = systemController.getNetworkInterface()) == null || (iPAddress = networkInterface.getAddress()) == null || (string3 = iPAddress.toString()) == null || string3.equals(string) || string3.equals(string2)) continue;
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }

        public void aquaAlertWillBeShown(Object object) {
        }

        public void aquaAlertResized(Object object) {
        }

        public void aquaAlertSheetVisible(Object object) {
            RendezvousPanel rendezvousPanel = (RendezvousPanel)object;
            rendezvousPanel.beginServices();
        }

        public boolean allowAquaAlertToBeDismissed(int n, Object object) {
            return true;
        }

        public void aquaAlertDismissed(int n, Object object) {
            RendezvousPanel rendezvousPanel = (RendezvousPanel)object;
            rendezvousPanel.endServices();
            if (n == 1) {
                int n2;
                String[] stringArray = rendezvousPanel.getAddresses();
                String[] stringArray2 = rendezvousPanel.getNames();
                String string = new String(rendezvousPanel.getPassword());
                this.systemsAdded = n2 = stringArray2.length;
                for (int i = 0; i < n2; ++i) {
                    RaidSystem raidSystem = new RaidSystem(stringArray[i]);
                    if (stringArray2[i] == null) {
                        stringArray2[i] = Resources.getString("rendezvousPanel.unknownSystemName");
                    } else if (stringArray2[i].equals("")) {
                        stringArray2[i] = Resources.getString("rendezvousPanel.unknownSystemName");
                    }
                    raidSystem.setName(stringArray2[i]);
                    raidSystem.setUserMessageIndex(2);
                    SystemMonitorController.this.registry.add(raidSystem);
                    raidSystem.connect(this, "guest", string, true);
                }
            } else {
                this.systemsAdded = 0;
            }
            SystemMonitorController.this.menuBar.setEnabled(true);
            SystemMonitorController.this.updateMenuActionStatus();
        }

        public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
            int n = response.getResultCode();
            if (n == 0) {
                raidSystem.setUserMessageIndex(3);
                SystemMonitorController.this.registry.synchronizePrefs();
            } else if (n == -16 || n == -27 || n == -28) {
                raidSystem.setUserMessageIndex(11);
            } else if (n == -101) {
                raidSystem.setUserMessageIndex(4);
            }
            if (this.systemsAdded == 1) {
                SystemMonitorController.this.monitorWindow.setSelectedSystem(raidSystem);
            }
        }
    }
}

