/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.ModuleSelectionPanel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.SelectableLabel;
import com.apple.xsr.SelectableStatusLabel;
import com.apple.xsr.SizeLinkedPanel;
import com.apple.xsr.eventlog.EventLogPane;
import com.apple.xsr.som.Battery;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.Fan;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.PowerSupply;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.SystemController;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SystemInfoPane
extends JPanel {
    public static final int SUMMARY_TAB = 0;
    public static final int ARRAYS_DRIVES_TAB = 1;
    public static final int MODULES_TAB = 2;
    public static final int FIBRE_CHANNEL_TAB = 3;
    public static final int NETWORK_TAB = 4;
    public static final int EVENT_LOG_TAB = 5;
    public static final int COLUMN_WIDTH = 250;
    public static final int COMBO_LABEL_WIDTH = 64;
    public static final int COMBO_WIDTH = 150;
    private static final Border TAB_BORDER = new EmptyBorder(10, 10, 0, 10);
    private JTabbedPane tabbedPane;
    private InfoPanel infoPanel;
    private ComponentsPanel componentsPanel;
    private ArrayDrivePanel arraysAndDrivesPanel;
    private FibreChannelPanel fibreChannelPanel;
    private NetworkPanel networkPanel;
    private EventLogPane eventPanel;

    public SystemInfoPane() {
        GUIFactory.configureComponentForPlatform(this);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setFont(GUIFactory.FONT_SMALL);
        this.infoPanel = new InfoPanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.summary"), this.infoPanel);
        this.arraysAndDrivesPanel = new ArrayDrivePanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.arraysAndDrives"), this.arraysAndDrivesPanel);
        this.componentsPanel = new ComponentsPanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.modules"), this.componentsPanel);
        this.fibreChannelPanel = new FibreChannelPanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.fibreChannel"), this.fibreChannelPanel);
        this.networkPanel = new NetworkPanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.network"), this.networkPanel);
        this.eventPanel = new EventLogPane();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.events"), this.eventPanel);
        this.add((Component)this.tabbedPane, "Center");
    }

    public void setSelectedTab(int n) {
        if (n < 0 || n >= this.tabbedPane.getTabCount()) {
            throw new IllegalArgumentException("Illegal tab: " + n);
        }
        this.tabbedPane.setSelectedIndex(n);
    }

    public void setSystem(RaidSystem raidSystem) {
        this.infoPanel.updateInfo(raidSystem);
        if (raidSystem != null && raidSystem.getPowerState() == 1) {
            this.componentsPanel.updateInfo(raidSystem);
            this.arraysAndDrivesPanel.updateInfo(raidSystem);
            this.fibreChannelPanel.updateInfo(raidSystem);
            this.networkPanel.updateInfo(raidSystem);
            this.eventPanel.updateInfo(raidSystem);
        } else {
            this.componentsPanel.updateInfo(null);
            this.arraysAndDrivesPanel.updateInfo(null);
            this.fibreChannelPanel.updateInfo(null);
            this.networkPanel.updateInfo(null);
            this.eventPanel.updateInfo(null);
        }
    }

    public void updateInfo(final RaidSystem raidSystem) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SystemInfoPane.this.setSystem(raidSystem);
            }
        });
    }

    private static class SizeLinkedColumn
    extends SizeLinkedPanel {
        public static final int LEFT_COLUMN = 0;
        public static final int RIGHT_COLUMN = 1;
        public static final int MIDDLE_COLUMN = 2;
        private int mItemCount = 0;
        private final GridBagConstraints mConstraints = new GridBagConstraints();
        private final Insets mInsetsItemSpacing = new Insets(0, 0, 0, 10);
        private final Insets mInsetsNone = new Insets(0, 0, 0, 0);

        public SizeLinkedColumn(String string) {
            this.setFont(GUIFactory.FONT_SMALL);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
            titledBorder.setTitleFont(GUIFactory.FONT_SMALL);
            EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
            this.setBorder(new CompoundBorder(titledBorder, emptyBorder));
            this.setLayout(new GridBagLayout());
            this.mConstraints.gridx = 0;
            this.mConstraints.gridy = this.mItemCount;
        }

        public void addField(String string, SelectableLabel selectableLabel) {
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jLabel.setHorizontalAlignment(4);
            selectableLabel.setFont(GUIFactory.FONT_SMALL);
            this.mConstraints.anchor = 13;
            this.mConstraints.fill = 0;
            this.mConstraints.insets = this.mInsetsItemSpacing;
            this.mConstraints.weightx = 0.0;
            this.mConstraints.gridx = 0;
            this.mConstraints.gridy = this.mItemCount;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add((Component)jLabel, this.mConstraints);
            this.mConstraints.anchor = 17;
            this.mConstraints.fill = 2;
            this.mConstraints.insets = this.mInsetsNone;
            this.mConstraints.weightx = 1.0;
            this.mConstraints.gridx = 1;
            this.mConstraints.gridy = this.mItemCount++;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add((Component)selectableLabel, this.mConstraints);
        }

        public void addLabeledComponent(String string, JComponent jComponent) {
            this.addLabeledComponent(new JLabel(string), jComponent);
        }

        public void addLabeledComponent(JLabel jLabel, JComponent jComponent) {
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jLabel.setHorizontalAlignment(4);
            jComponent.setFont(GUIFactory.FONT_SMALL);
            this.mConstraints.anchor = 13;
            this.mConstraints.fill = 0;
            this.mConstraints.insets = this.mInsetsItemSpacing;
            this.mConstraints.weightx = 0.0;
            this.mConstraints.gridx = 0;
            this.mConstraints.gridy = this.mItemCount;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add((Component)jLabel, this.mConstraints);
            this.mConstraints.anchor = 17;
            this.mConstraints.fill = 2;
            this.mConstraints.insets = this.mInsetsNone;
            this.mConstraints.weightx = 1.0;
            this.mConstraints.gridx = 1;
            this.mConstraints.gridy = this.mItemCount++;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add((Component)jComponent, this.mConstraints);
        }

        public void padRemainder() {
            this.mConstraints.anchor = 13;
            this.mConstraints.fill = 0;
            this.mConstraints.insets = this.mInsetsItemSpacing;
            this.mConstraints.weightx = 0.0;
            this.mConstraints.weighty = 1.0;
            this.mConstraints.gridx = 0;
            this.mConstraints.gridy = this.mItemCount++;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add(Box.createVerticalStrut(0), this.mConstraints);
            this.mConstraints.weighty = 0.0;
        }

        public int getItemCount() {
            return this.mItemCount;
        }
    }

    private static class NetworkPanel
    extends JPanel {
        private final SelectableLabel[] address;
        private final SelectableLabel[] macAddress;
        private final SelectableStatusLabel[] status;
        private final SelectableLabel[] speed;
        private final SelectableLabel[] configuredVia;
        private final SelectableLabel[] subnet;
        private final SelectableLabel[] router;
        private final SelectableLabel[] dns1;
        private final SelectableLabel[] dns2;
        private final SelectableLabel[] dns3;
        private final SelectableLabel[] dhcpClientId;
        private static final String unknown = Resources.noDataLabel();
        private static final int NETWORK_INTERFACE_COUNT = 2;
        private static final boolean SHOW_ROUTER_AND_DNS = false;

        public NetworkPanel() {
            GUIFactory.configureComponentForPlatform(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setBorder(TAB_BORDER);
            this.setLayout(new GridBagLayout());
            SizeLinkedColumn[] sizeLinkedColumnArray = new SizeLinkedColumn[2];
            this.address = new SelectableLabel[2];
            this.macAddress = new SelectableLabel[2];
            this.status = new SelectableStatusLabel[2];
            this.speed = new SelectableLabel[2];
            this.configuredVia = new SelectableLabel[2];
            this.subnet = new SelectableLabel[2];
            this.router = new SelectableLabel[2];
            this.dns1 = new SelectableLabel[2];
            this.dns2 = new SelectableLabel[2];
            this.dns3 = new SelectableLabel[2];
            this.dhcpClientId = new SelectableLabel[2];
            for (int i = 0; i < 2; ++i) {
                sizeLinkedColumnArray[i] = i == 0 ? new SizeLinkedColumn(" " + Resources.getString("systemInfo.summaryPanel.topController") + " ") : new SizeLinkedColumn(" " + Resources.getString("systemInfo.summaryPanel.bottomController") + " ");
                this.status[i] = new SelectableStatusLabel();
                sizeLinkedColumnArray[i].addLabeledComponent(Resources.getString("systemInfo.networkPanel.status"), (JComponent)this.status[i]);
                this.address[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.networkPanel.address"), this.address[i]);
                this.subnet[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.networkPanel.subnet"), this.subnet[i]);
                this.macAddress[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.networkPanel.macAddress"), this.macAddress[i]);
                this.speed[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.networkPanel.speed"), this.speed[i]);
                this.configuredVia[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.networkPanel.configuredVia"), this.configuredVia[i]);
                this.dhcpClientId[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.networkPanel.dhcpClientId"), this.dhcpClientId[i]);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = i < 1 ? new Insets(0, 0, 0, 10) : new Insets(0, 0, 0, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridx = i;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)sizeLinkedColumnArray[i], gridBagConstraints);
                if (i == 0) continue;
                sizeLinkedColumnArray[i].linkPanel(sizeLinkedColumnArray[i - 1]);
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            this.add(Box.createHorizontalStrut(1), gridBagConstraints);
            this.updateInfo(null);
        }

        public void updateInfo(RaidSystem raidSystem) {
            if (raidSystem != null) {
                for (int i = 0; i < 2; ++i) {
                    NetworkInterface networkInterface = i == 0 ? raidSystem.getSystemController(1).getNetworkInterface() : raidSystem.getSystemController(2).getNetworkInterface();
                    if (networkInterface != null) {
                        this.status[i].setStatus(networkInterface.getStatus());
                        this.status[i].setText(SOMLocalizer.getNetworkLinkState(networkInterface));
                        this.address[i].setText(SOMLocalizer.getGenericString(networkInterface.getAddressString()));
                        this.subnet[i].setText(SOMLocalizer.getGenericString(networkInterface.getSubnetMaskString()));
                        this.macAddress[i].setText(SOMLocalizer.getGenericString(networkInterface.getMacAddressString()));
                        this.speed[i].setText(SOMLocalizer.getNetworkSpeed(networkInterface));
                        this.configuredVia[i].setText(SOMLocalizer.getConfigurationMethod(networkInterface));
                        this.dhcpClientId[i].setText(SOMLocalizer.getGenericString(networkInterface.getDhcpClientId()));
                        continue;
                    }
                    this.fillInDefaults(i);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.fillInDefaults(i);
                }
            }
        }

        private void fillInDefaults(int n) {
            this.status[n].setStatus(-3);
            this.status[n].setText(unknown);
            this.address[n].setText(unknown);
            this.subnet[n].setText(unknown);
            this.macAddress[n].setText(unknown);
            this.speed[n].setText(unknown);
            this.configuredVia[n].setText(unknown);
            this.dhcpClientId[n].setText(unknown);
        }
    }

    private static class FibreChannelPanel
    extends JPanel {
        private final SelectableStatusLabel[] status;
        private final SelectableLabel[] topology;
        private final SelectableLabel[] speed;
        private final SelectableLabel[] worldWidePortName;
        private final SelectableLabel[] worldWideNodeName;
        private final SelectableLabel[] lunMaskingStatus;
        private final SelectableLabel[] hardLoopId;
        private static final String unknown = Resources.noDataLabel();
        private static final int FC_INTERFACE_COUNT = 2;

        public FibreChannelPanel() {
            GUIFactory.configureComponentForPlatform(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setBorder(TAB_BORDER);
            this.setLayout(new GridBagLayout());
            SizeLinkedColumn[] sizeLinkedColumnArray = new SizeLinkedColumn[2];
            this.status = new SelectableStatusLabel[2];
            this.topology = new SelectableLabel[2];
            this.speed = new SelectableLabel[2];
            this.worldWidePortName = new SelectableLabel[2];
            this.worldWideNodeName = new SelectableLabel[2];
            this.lunMaskingStatus = new SelectableLabel[2];
            this.hardLoopId = new SelectableLabel[2];
            for (int i = 0; i < 2; ++i) {
                sizeLinkedColumnArray[i] = i == 0 ? new SizeLinkedColumn(" " + Resources.getString("systemInfo.summaryPanel.topController") + " ") : new SizeLinkedColumn(" " + Resources.getString("systemInfo.summaryPanel.bottomController") + " ");
                this.status[i] = new SelectableStatusLabel();
                sizeLinkedColumnArray[i].addLabeledComponent(Resources.getString("systemInfo.fibreChannelPanel.status"), (JComponent)this.status[i]);
                this.speed[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.fibreChannelPanel.speed"), this.speed[i]);
                this.topology[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.fibreChannelPanel.topology"), this.topology[i]);
                this.lunMaskingStatus[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.fibreChannelPanel.lunMaskingStatus"), this.lunMaskingStatus[i]);
                this.hardLoopId[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.fibreChannelPanel.hardLoopId"), this.hardLoopId[i]);
                this.worldWideNodeName[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.fibreChannelPanel.worldWideNodeName"), this.worldWideNodeName[i]);
                this.worldWidePortName[i] = new SelectableLabel();
                sizeLinkedColumnArray[i].addField(Resources.getString("systemInfo.fibreChannelPanel.worldWidePortName"), this.worldWidePortName[i]);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = i < 1 ? new Insets(0, 0, 0, 10) : new Insets(0, 0, 0, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridx = i;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)sizeLinkedColumnArray[i], gridBagConstraints);
                if (i == 0) continue;
                sizeLinkedColumnArray[i].linkPanel(sizeLinkedColumnArray[i - 1]);
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            this.add(Box.createHorizontalStrut(1), gridBagConstraints);
            this.updateInfo(null);
        }

        public void updateInfo(RaidSystem raidSystem) {
            if (raidSystem != null) {
                for (int i = 0; i < 2; ++i) {
                    FibreChannelInterface fibreChannelInterface;
                    RaidController raidController;
                    if (i == 0) {
                        raidController = raidSystem.getRaidController(1);
                        fibreChannelInterface = (FibreChannelInterface)raidController.getHostInterface(1);
                    } else {
                        raidController = raidSystem.getRaidController(2);
                        fibreChannelInterface = (FibreChannelInterface)raidController.getHostInterface(1);
                    }
                    if (fibreChannelInterface != null) {
                        this.status[i].setStatus(fibreChannelInterface.getStatus());
                        this.status[i].setText(SOMLocalizer.getFCLinkState(fibreChannelInterface));
                        this.worldWidePortName[i].setText(SOMLocalizer.getGenericString(fibreChannelInterface.getWorldWidePortName()));
                        this.worldWideNodeName[i].setText(SOMLocalizer.getGenericString(fibreChannelInterface.getWorldWideNodeName()));
                        this.lunMaskingStatus[i].setText(SOMLocalizer.getLunMaskingState(raidController.getLunMaskEnabled()));
                        this.topology[i].setText(SOMLocalizer.getFCTopology(fibreChannelInterface));
                        this.speed[i].setText(SOMLocalizer.getFCSpeed(fibreChannelInterface));
                        this.hardLoopId[i].setText(SOMLocalizer.getFCHardLoopEnabled(fibreChannelInterface));
                        continue;
                    }
                    this.fillInDefaults(i);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.fillInDefaults(i);
                }
            }
        }

        private void fillInDefaults(int n) {
            this.status[n].setStatus(-3);
            this.status[n].setText(unknown);
            this.topology[n].setText(unknown);
            this.speed[n].setText(unknown);
            this.worldWidePortName[n].setText(unknown);
            this.worldWideNodeName[n].setText(unknown);
            this.lunMaskingStatus[n].setText(unknown);
            this.hardLoopId[n].setText(unknown);
        }
    }

    private static class ComponentsPanel
    extends JPanel {
        private ModuleSelectionPanel modulePanel;
        private JPanel infoPanel;
        private CardLayout cardLayout;
        SizeLinkedColumn[] controllerColumn;
        SizeLinkedColumn[] batteryColumn;
        SizeLinkedColumn[] blowerColumn;
        SizeLinkedColumn[] powerColumn;
        private final SelectableStatusLabel[] controllerStatus;
        private final SelectableLabel[] controllerCache;
        private final SelectableLabel[] controllerFirmware;
        private final SelectableStatusLabel[] batteryStatus;
        private final SelectableLabel[] batteryChargeState;
        private final SelectableLabel[] batteryCharge;
        private final SelectableStatusLabel[] blowerStatus;
        private final SelectableLabel[] blowerSpeed;
        private final SelectableStatusLabel[] powerStatus;
        private static final String unknown = Resources.noDataLabel();
        private static final String notInstalled = Resources.getString("systemInfo.modulesPanel.notInstalled");
        private static final int CONTROLLER_COUNT = 2;

        public ComponentsPanel() {
            GUIFactory.configureComponentForPlatform(this);
            this.controllerColumn = new SizeLinkedColumn[2];
            this.batteryColumn = new SizeLinkedColumn[2];
            this.blowerColumn = new SizeLinkedColumn[2];
            this.powerColumn = new SizeLinkedColumn[2];
            this.batteryStatus = new SelectableStatusLabel[2];
            this.batteryChargeState = new SelectableLabel[2];
            this.batteryCharge = new SelectableLabel[2];
            this.controllerStatus = new SelectableStatusLabel[2];
            this.controllerCache = new SelectableLabel[2];
            this.controllerFirmware = new SelectableLabel[2];
            this.blowerStatus = new SelectableStatusLabel[2];
            this.blowerSpeed = new SelectableLabel[2];
            this.powerStatus = new SelectableStatusLabel[2];
            this.setBorder(TAB_BORDER);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            this.modulePanel = new ModuleSelectionPanel();
            gridBagConstraints.insets = new Insets(0, 10, 0, 20);
            this.addComponent(this.modulePanel, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ++gridBagConstraints.gridx;
            this.modulePanel.addPropertyChangeListener("module", new PropertyChangeListener(this){
                private final /* synthetic */ ComponentsPanel this$0;
                {
                    this.this$0 = componentsPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    String string = "";
                    if (n == 6) {
                        string = "controller0";
                    } else if (n == 7) {
                        string = "controller1";
                    } else if (n == 2) {
                        string = "battery0";
                    } else if (n == 3) {
                        string = "battery1";
                    } else if (n == 8) {
                        string = "blower0";
                    } else if (n == 9) {
                        string = "blower1";
                    } else if (n == 4) {
                        string = "power0";
                    } else if (n == 5) {
                        string = "power1";
                    }
                    ComponentsPanel.access$900(this.this$0).show(ComponentsPanel.access$800(this.this$0), string);
                }
            });
            this.infoPanel = GUIFactory.newPanel();
            this.cardLayout = new CardLayout();
            this.infoPanel.setLayout(this.cardLayout);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            this.addComponent(this.infoPanel, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridheight = 1;
            for (int i = 0; i < 2; ++i) {
                int n = 300;
                String string = Resources.getString(i == 0 ? "systemInfo.modulesPanel.topController" : "systemInfo.modulesPanel.bottomController");
                this.controllerColumn[i] = new SizeLinkedColumn(" " + string + " ");
                this.controllerStatus[i] = new SelectableStatusLabel();
                this.controllerStatus[i].setFont(GUIFactory.FONT_SMALL);
                this.controllerCache[i] = new SelectableLabel();
                this.controllerFirmware[i] = new SelectableLabel();
                this.controllerColumn[i].addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.controllerStatus[i]);
                this.controllerColumn[i].addField(Resources.getString("systemInfo.modulesPanel.controllerCache"), this.controllerCache[i]);
                this.controllerColumn[i].addField(Resources.getString("systemInfo.modulesPanel.controllerFirmware"), this.controllerFirmware[i]);
                this.infoPanel.add((Component)this.controllerColumn[i], "controller" + i);
                String string2 = Resources.getString(i == 0 ? "systemInfo.modulesPanel.topBattery" : "systemInfo.modulesPanel.bottomBattery");
                this.batteryColumn[i] = new SizeLinkedColumn(" " + string2 + " ");
                this.batteryStatus[i] = new SelectableStatusLabel();
                this.batteryChargeState[i] = new SelectableLabel();
                this.batteryCharge[i] = new SelectableLabel();
                this.batteryColumn[i].addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.batteryStatus[i]);
                this.batteryColumn[i].addField(Resources.getString("systemInfo.modulesPanel.batteryChargeState"), this.batteryChargeState[i]);
                this.batteryColumn[i].addField(Resources.getString("systemInfo.modulesPanel.batteryCharge"), this.batteryCharge[i]);
                this.infoPanel.add((Component)this.batteryColumn[i], "battery" + i);
                String string3 = Resources.getString(i == 0 ? "systemInfo.modulesPanel.topBlower" : "systemInfo.modulesPanel.bottomBlower");
                this.blowerColumn[i] = new SizeLinkedColumn(" " + string3 + " ");
                this.blowerStatus[i] = new SelectableStatusLabel();
                this.blowerSpeed[i] = new SelectableLabel();
                this.blowerColumn[i].addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.blowerStatus[i]);
                this.blowerColumn[i].addField(Resources.getString("systemInfo.modulesPanel.blowerSpeed"), this.blowerSpeed[i]);
                this.infoPanel.add((Component)this.blowerColumn[i], "blower" + i);
                String string4 = Resources.getString(i == 0 ? "systemInfo.modulesPanel.leftPower" : "systemInfo.modulesPanel.rightPower");
                this.powerColumn[i] = new SizeLinkedColumn(" " + string4 + " ");
                this.powerStatus[i] = new SelectableStatusLabel();
                this.powerColumn[i].addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.powerStatus[i]);
                this.infoPanel.add((Component)this.powerColumn[i], "power" + i);
            }
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            this.addComponent(Box.createHorizontalStrut(1), this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.weighty = 1.0;
            this.addComponent(Box.createVerticalStrut(1), this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.weighty = 0.0;
            this.updateInfo(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void updateInfo(RaidSystem raidSystem) {
            if (raidSystem != null) {
                for (int i = 0; i < 2; ++i) {
                    int n;
                    RaidController raidController = raidSystem.getRaidController(i + 1);
                    SystemController systemController = raidSystem.getSystemController(i + 1);
                    int n2 = i == 0 ? 6 : 7;
                    int n3 = n = i == 0 ? 1 : 2;
                    if (raidSystem.isControllerModulePresent(n)) {
                        int n4 = raidSystem.getControllerModuleStatus(n);
                        this.controllerStatus[i].setStatus(n4);
                        this.controllerStatus[i].setText(SOMLocalizer.getStatusString(n4));
                        this.controllerCache[i].setText(SOMLocalizer.getRaidControllerMemorySize(raidController));
                        this.controllerFirmware[i].setText(SOMLocalizer.getCombinedFirmwareVersion(systemController, raidController));
                        this.modulePanel.setModuleStatus(n2, true, n4);
                    } else {
                        this.controllerStatus[i].setStatus(-2);
                        this.controllerStatus[i].setText(notInstalled);
                        this.controllerCache[i].setText(unknown);
                        this.controllerFirmware[i].setText(unknown);
                        this.modulePanel.setModuleStatus(n2, false, -2);
                    }
                    Battery battery = raidSystem.getBattery(2 - i);
                    int n5 = i == 0 ? 2 : (n2 = 3);
                    if (battery != null) {
                        int n6 = battery.getStatus();
                        this.batteryStatus[i].setStatus(n6);
                        this.batteryStatus[i].setText(SOMLocalizer.getElementStatus(battery));
                        this.batteryChargeState[i].setText(SOMLocalizer.getBatteryChargeState(battery));
                        this.batteryCharge[i].setText(SOMLocalizer.getBatteryCharge(battery));
                        this.modulePanel.setModuleStatus(n2, true, n6);
                    } else {
                        this.batteryStatus[i].setStatus(-2);
                        this.batteryStatus[i].setText(notInstalled);
                        this.batteryChargeState[i].setText(unknown);
                        this.batteryCharge[i].setText(unknown);
                        this.modulePanel.setModuleStatus(n2, false, -2);
                    }
                    Fan fan = raidSystem.getFan(i + 1);
                    int n7 = i == 0 ? 8 : (n2 = 9);
                    if (fan != null) {
                        int n8 = fan.getStatus();
                        this.blowerStatus[i].setStatus(n8);
                        this.blowerStatus[i].setText(SOMLocalizer.getFanStatus(fan));
                        this.blowerSpeed[i].setText(SOMLocalizer.getFanRPM(fan));
                        this.modulePanel.setModuleStatus(n2, true, n8);
                    } else {
                        this.blowerStatus[i].setStatus(2);
                        this.blowerStatus[i].setText(notInstalled);
                        this.blowerSpeed[i].setText(unknown);
                        this.modulePanel.setModuleStatus(n2, false, 2);
                    }
                    PowerSupply powerSupply = raidSystem.getPowerSupply(2 - i);
                    int n9 = i == 0 ? 4 : (n2 = 5);
                    if (powerSupply != null) {
                        int n10 = powerSupply.getStatus();
                        this.powerStatus[i].setStatus(n10);
                        this.powerStatus[i].setText(SOMLocalizer.getPowerSupplyStatus(powerSupply));
                        this.modulePanel.setModuleStatus(n2, true, n10);
                        continue;
                    }
                    this.powerStatus[i].setStatus(-2);
                    this.powerStatus[i].setText(notInstalled);
                    this.modulePanel.setModuleStatus(n2, false, -2);
                }
                this.modulePanel.setActive(true);
            } else {
                this.modulePanel.setActive(false);
                for (int i = 0; i < 2; ++i) {
                    this.controllerStatus[i].setStatus(-3);
                    this.controllerStatus[i].setText(unknown);
                    this.controllerCache[i].setText(unknown);
                    this.controllerFirmware[i].setText(unknown);
                    this.batteryStatus[i].setStatus(-3);
                    this.batteryStatus[i].setText(unknown);
                    this.batteryCharge[i].setText(unknown);
                    this.blowerStatus[i].setStatus(-3);
                    this.blowerStatus[i].setText(unknown);
                    this.blowerSpeed[i].setText(unknown);
                    this.powerStatus[i].setStatus(-3);
                    this.powerStatus[i].setText(unknown);
                    int n = i == 0 ? 6 : 7;
                    this.modulePanel.setModuleStatus(n, false, -1);
                    n = i == 0 ? 2 : 3;
                    this.modulePanel.setModuleStatus(n, false, -1);
                    n = i == 0 ? 8 : 9;
                    this.modulePanel.setModuleStatus(n, false, -1);
                    n = i == 0 ? 4 : 5;
                    this.modulePanel.setModuleStatus(n, false, -1);
                }
            }
        }

        private void addComponent(Component component, Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
            gridBagLayout.setConstraints(component, gridBagConstraints);
            container.add(component);
        }

        static /* synthetic */ JPanel access$800(ComponentsPanel componentsPanel) {
            return componentsPanel.infoPanel;
        }

        static /* synthetic */ CardLayout access$900(ComponentsPanel componentsPanel) {
            return componentsPanel.cardLayout;
        }
    }

    private static class ArrayDrivePanel
    extends JPanel {
        private static final int MIN_HEIGHT = 224;
        private DriveSelectionPanel drivePanel;
        private ArraySelectionPanel arrayPanel;
        private JPanel infoPanel;
        private JPanel cardPanel;
        private CardLayout cardLayout;
        private JRadioButton arraysRadioButton;
        private JRadioButton drivesRadioButton;
        private SelectableStatusLabel arrayStatus;
        private SelectableLabel arrayLevel;
        private SelectableLabel arrayCapacity;
        private SelectableLabel arraySlices;
        private SelectableLabel arrayLUNs;
        private JLabel arrayProgressLabel;
        private JProgressBar arrayProgress;
        private JLabel arrayAvailableLabel;
        private SelectableLabel arrayAvailable;
        private MessagePanel messagePanel;
        private SelectableStatusLabel driveStatus;
        private SelectableLabel driveType;
        private SelectableLabel driveModel;
        private SelectableLabel driveFirmware;
        private SelectableLabel driveCapacity;
        private SelectableLabel drivePowerOnHours;
        private SelectableLabel driveCache;
        private int selectedArray = -1;
        private int selectedDrive = -1;
        private RaidSystem system;
        private static final String unknown = Resources.noDataLabel();
        private static final String notInstalled = Resources.getString("systemInfo.modulesPanel.notInstalled");

        public ArrayDrivePanel() {
            GUIFactory.configureComponentForPlatform(this);
            this.setBorder(TAB_BORDER);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            this.drivePanel = new DriveSelectionPanel(4, null, null, null, null);
            gridBagConstraints.insets = new Insets(0, 10, 0, 20);
            this.add((Component)this.drivePanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ++gridBagConstraints.gridy;
            this.drivePanel.addPropertyChangeListener("DriveIndex", new PropertyChangeListener(this){
                private final /* synthetic */ ArrayDrivePanel this$0;
                {
                    this.this$0 = arrayDrivePanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    ArrayDrivePanel.access$102(this.this$0, n);
                    this.this$0.refreshInfoForSelectedDrive();
                }
            });
            this.drivePanel.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(this){
                private final /* synthetic */ ArrayDrivePanel this$0;
                {
                    this.this$0 = arrayDrivePanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    ArrayDrivePanel.access$202(this.this$0, n - 1);
                    this.this$0.refreshInfoForSelectedArray();
                }
            });
            this.drivePanel.addPropertyChangeListener("SelectionMode", new PropertyChangeListener(this){
                private final /* synthetic */ ArrayDrivePanel this$0;
                {
                    this.this$0 = arrayDrivePanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    if (n == 4) {
                        ArrayDrivePanel.access$300(this.this$0).doClick();
                    } else if (n == 3) {
                        ArrayDrivePanel.access$400(this.this$0).doClick();
                    }
                }
            });
            this.arrayPanel = new ArraySelectionPanel(3);
            gridBagConstraints.insets = new Insets(0, 10, 0, 20);
            this.add((Component)this.arrayPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ++gridBagConstraints.gridy;
            this.arrayPanel.addPropertyChangeListener("ArrayIndex", new PropertyChangeListener(this){
                private final /* synthetic */ ArrayDrivePanel this$0;
                {
                    this.this$0 = arrayDrivePanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    ArrayDrivePanel.access$202(this.this$0, n - 1);
                    ArrayDrivePanel.access$500(this.this$0).setArrayIndex(n);
                    ArrayDrivePanel.access$500(this.this$0).setSelectionMode(4);
                    ArrayDrivePanel.access$300(this.this$0).setSelected(true);
                    this.this$0.refreshInfoForSelectedArray();
                    ArrayDrivePanel.access$700(this.this$0).show(ArrayDrivePanel.access$600(this.this$0), "arrays");
                }
            });
            gridBagConstraints.weighty = 1.0;
            this.add(Box.createVerticalStrut(0), gridBagConstraints);
            gridBagConstraints.weighty = 0.0;
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridy = 0;
            int n = 300;
            this.infoPanel = GUIFactory.newPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.infoPanel.setLayout(gridBagLayout);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 0;
            RadioButtonGroup radioButtonGroup = new RadioButtonGroup();
            JPanel jPanel = GUIFactory.newPanel();
            JLabel jLabel = new JLabel(Resources.getString("systemInfo.drivePanel.show"));
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jPanel.add(jLabel);
            this.arraysRadioButton = GUIFactory.newRadioButton(Resources.getString("systemInfo.drivePanel.arrays"), true);
            this.arraysRadioButton.setFont(GUIFactory.FONT_SMALL);
            this.arraysRadioButton.addActionListener(new RadioGroupActionListener(0));
            radioButtonGroup.add(this.arraysRadioButton);
            jPanel.add(this.arraysRadioButton);
            this.drivesRadioButton = GUIFactory.newRadioButton(Resources.getString("systemInfo.drivePanel.drives"), false);
            this.drivesRadioButton.setFont(GUIFactory.FONT_SMALL);
            this.drivesRadioButton.addActionListener(new RadioGroupActionListener(1));
            radioButtonGroup.add(this.drivesRadioButton);
            jPanel.add(this.drivesRadioButton);
            this.infoPanel.add((Component)jPanel, gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            this.cardPanel = GUIFactory.newPanel();
            this.cardLayout = new CardLayout();
            this.cardPanel.setLayout(this.cardLayout);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            this.infoPanel.add((Component)this.cardPanel, gridBagConstraints2);
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            ++gridBagConstraints2.gridy;
            String string = Resources.getString("systemInfo.drivePanel.arrayInfo");
            SizeLinkedColumn sizeLinkedColumn = new SizeLinkedColumn(" " + string + " ");
            this.arrayStatus = new SelectableStatusLabel();
            this.arrayLevel = new SelectableLabel();
            this.arrayCapacity = new SelectableLabel();
            this.arraySlices = new SelectableLabel();
            this.arrayLUNs = new SelectableLabel();
            this.arrayProgressLabel = new JLabel(Resources.getString("systemInfo.arrayPanel.progress"));
            this.arrayProgressLabel.setVisible(false);
            this.arrayProgress = new JProgressBar(0, 100);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EmptyBorder(2, 0, 1, 0), this.arrayProgress.getBorder());
            this.arrayProgress.setBorder(compoundBorder);
            this.arrayProgress.setVisible(false);
            this.arrayAvailableLabel = new JLabel(Resources.getString("systemInfo.arrayPanel.available"));
            this.arrayAvailable = new SelectableLabel();
            sizeLinkedColumn.addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.arrayStatus);
            sizeLinkedColumn.addLabeledComponent(this.arrayProgressLabel, (JComponent)this.arrayProgress);
            sizeLinkedColumn.addLabeledComponent(this.arrayAvailableLabel, (JComponent)this.arrayAvailable);
            sizeLinkedColumn.addField(Resources.getString("systemInfo.arrayPanel.raid_level"), this.arrayLevel);
            sizeLinkedColumn.addField(Resources.getString("systemInfo.arrayPanel.capacity"), this.arrayCapacity);
            sizeLinkedColumn.addField(Resources.getString("systemInfo.arrayPanel.slices"), this.arraySlices);
            sizeLinkedColumn.addField(Resources.getString("systemInfo.arrayPanel.lun"), this.arrayLUNs);
            this.messagePanel = new MessagePanel();
            this.messagePanel.setVisible(false);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = sizeLinkedColumn.getItemCount();
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.insets = new Insets(8, 0, 0, 0);
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.ipady = 0;
            sizeLinkedColumn.add((Component)this.messagePanel, gridBagConstraints3);
            sizeLinkedColumn.padRemainder();
            this.cardPanel.add((Component)sizeLinkedColumn, "arrays");
            String string2 = Resources.getString("systemInfo.drivePanel.driveInfo");
            SizeLinkedColumn sizeLinkedColumn2 = new SizeLinkedColumn(" " + string2 + " ");
            this.driveStatus = new SelectableStatusLabel();
            this.driveType = new SelectableLabel();
            this.driveModel = new SelectableLabel();
            this.driveFirmware = new SelectableLabel();
            this.driveCapacity = new SelectableLabel();
            this.drivePowerOnHours = new SelectableLabel();
            this.driveCache = new SelectableLabel();
            sizeLinkedColumn2.addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.driveStatus);
            sizeLinkedColumn2.addField(Resources.getString("systemInfo.drivePanel.type"), this.driveType);
            sizeLinkedColumn2.addField(Resources.getString("systemInfo.drivePanel.model"), this.driveModel);
            sizeLinkedColumn2.addField(Resources.getString("systemInfo.drivePanel.revision"), this.driveFirmware);
            sizeLinkedColumn2.addField(Resources.getString("systemInfo.drivePanel.capacity"), this.driveCapacity);
            sizeLinkedColumn2.addField(Resources.getString("systemInfo.drivePanel.powerOnHours"), this.drivePowerOnHours);
            sizeLinkedColumn2.addField(Resources.getString("systemInfo.drivePanel.writeCache"), this.driveCache);
            sizeLinkedColumn2.padRemainder();
            this.cardPanel.add((Component)sizeLinkedColumn2, "drives");
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this.add((Component)this.infoPanel, gridBagConstraints);
            this.updateInfo(null);
        }

        public void updateInfo(RaidSystem raidSystem) {
            if (raidSystem != null) {
                this.system = raidSystem;
                this.drivePanel.setRaidSystem(raidSystem);
                this.arrayPanel.configureForRaidSystem(raidSystem);
                this.refreshInfoForSelectedArray();
                this.refreshInfoForSelectedDrive();
            } else {
                this.system = null;
                this.drivePanel.setRaidSystem(null);
                this.arrayPanel.resetPanel();
                this.refreshInfoForSelectedArray();
                this.refreshInfoForSelectedDrive();
            }
        }

        public void refreshInfoForSelectedArray() {
            RaidSet[] raidSetArray = this.system != null ? this.system.getRaidSets().toArray(new RaidSet[0]) : null;
            if (raidSetArray != null && this.selectedArray + 1 > 0 && this.selectedArray < raidSetArray.length) {
                String string;
                RaidSet raidSet = raidSetArray[this.selectedArray];
                boolean bl = raidSet.getMappedSlices().size() != raidSet.getLiveSliceCount();
                int n = raidSet.getStatus();
                if ((n == 0 || n == -1) && !this.system.isRaidSetBeingCreated(raidSet) && bl) {
                    n = 1;
                    string = SOMLocalizer.getStatusString(n);
                } else {
                    string = SOMLocalizer.getRaidSetOperationStatus(raidSet);
                }
                this.arrayStatus.setStatus(n);
                this.arrayStatus.setText(string);
                int n2 = raidSet.getOperation();
                if (n2 != -1) {
                    this.arrayProgress.setValue(raidSet.getProgress());
                    this.arrayProgressLabel.setVisible(true);
                    this.arrayProgress.setVisible(true);
                    if (n2 == 1) {
                        this.arrayAvailable.setText(SOMLocalizer.getRaidSetAvailability(raidSet));
                        this.arrayAvailableLabel.setVisible(true);
                        this.arrayAvailable.setVisible(true);
                    } else {
                        this.arrayAvailable.setText(unknown);
                        this.arrayAvailableLabel.setVisible(false);
                        this.arrayAvailable.setVisible(false);
                    }
                } else {
                    this.arrayProgressLabel.setVisible(false);
                    this.arrayProgress.setVisible(false);
                    this.arrayProgress.setValue(0);
                    this.arrayAvailableLabel.setVisible(false);
                    this.arrayAvailable.setVisible(false);
                    this.arrayAvailable.setText(unknown);
                }
                this.arrayLevel.setText(SOMLocalizer.getRaidSetLevel(raidSet));
                this.arrayCapacity.setText(SOMLocalizer.getRaidSetCapacity(raidSet));
                this.arraySlices.setText(SOMLocalizer.getRaidSetSlices(raidSet));
                this.arrayLUNs.setText(SOMLocalizer.getRaidSetLuns(raidSet));
                if (raidSet.getState() == 1) {
                    this.messagePanel.setText(Resources.getString("systemInfo.message.deleteOfflineArray"));
                    this.messagePanel.setVisible(true);
                } else if (bl && !this.system.isRaidSetBeingCreated(raidSet)) {
                    this.messagePanel.setText(Resources.getString("systemInfo.message.unmapped"));
                    this.messagePanel.setVisible(true);
                } else {
                    this.messagePanel.setVisible(false);
                }
            } else if (this.system != null && DriveSelectionPanel.isJbod(this.selectedArray + 1) && this.drivePanel.jbodExists(this.selectedArray + 1)) {
                this.arrayStatus.setStatus(0);
                this.arrayStatus.setText(Resources.getString("raidset.state.online"));
                this.arrayProgressLabel.setVisible(false);
                this.arrayProgress.setVisible(false);
                this.arrayAvailableLabel.setVisible(false);
                this.arrayAvailable.setVisible(false);
                this.arrayLevel.setText(Resources.getString("management.create.jbod"));
                this.arrayCapacity.setText(Resources.getString("som.jbod.capacity"));
                this.arraySlices.setText(unknown);
                RaidController raidController = this.system.getRaidController(this.selectedArray + 1 == -2 ? 1 : 2);
                this.arrayLUNs.setText(SOMLocalizer.getJbodLuns(raidController));
                this.messagePanel.setVisible(false);
            } else {
                this.arrayStatus.setStatus(-3);
                this.arrayStatus.setText(unknown);
                this.arrayProgressLabel.setVisible(false);
                this.arrayProgress.setVisible(false);
                this.arrayAvailableLabel.setVisible(false);
                this.arrayAvailable.setVisible(false);
                this.arrayLevel.setText(unknown);
                this.arrayCapacity.setText(unknown);
                this.arraySlices.setText(unknown);
                this.arrayLUNs.setText(unknown);
                this.messagePanel.setVisible(false);
            }
        }

        public void refreshInfoForSelectedDrive() {
            DiskSlot[] diskSlotArray = this.system != null ? this.system.getDiskSlots().toArray(new DiskSlot[0]) : null;
            if (diskSlotArray != null && this.selectedDrive > -1 && this.selectedDrive < diskSlotArray.length) {
                DiskSlot diskSlot = diskSlotArray[this.selectedDrive];
                if (diskSlot.isPopulated()) {
                    Disk disk = diskSlot.getDisk();
                    int n = disk.getType() != 4 ? disk.getStatus() : 1;
                    this.driveStatus.setStatus(n);
                    this.driveStatus.setText(SOMLocalizer.getStatusString(n));
                    this.driveType.setText(SOMLocalizer.getDiskType(disk));
                    this.driveModel.setText(disk.getModel().trim());
                    this.driveFirmware.setText(disk.getRevision());
                    this.driveCapacity.setText(SOMLocalizer.getDiskCapacityShort(disk));
                    this.drivePowerOnHours.setText(SOMLocalizer.getDiskPowerOnHoursShort(disk));
                    this.driveCache.setText(SOMLocalizer.getDiskCacheState(disk));
                } else {
                    this.driveStatus.setStatus(-2);
                    this.driveStatus.setText(notInstalled);
                    this.driveType.setText(unknown);
                    this.driveModel.setText(unknown);
                    this.driveFirmware.setText(unknown);
                    this.driveCapacity.setText(unknown);
                    this.drivePowerOnHours.setText(unknown);
                    this.driveCache.setText(unknown);
                }
            } else {
                this.driveStatus.setStatus(-3);
                this.driveStatus.setText(unknown);
                this.driveType.setText(unknown);
                this.driveModel.setText(unknown);
                this.driveFirmware.setText(unknown);
                this.driveCapacity.setText(unknown);
                this.drivePowerOnHours.setText(unknown);
                this.driveCache.setText(unknown);
            }
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            return new Dimension(dimension.width, 224 > dimension.height ? 224 : dimension.height);
        }

        static /* synthetic */ int access$102(ArrayDrivePanel arrayDrivePanel, int n) {
            arrayDrivePanel.selectedDrive = n;
            return arrayDrivePanel.selectedDrive;
        }

        static /* synthetic */ int access$202(ArrayDrivePanel arrayDrivePanel, int n) {
            arrayDrivePanel.selectedArray = n;
            return arrayDrivePanel.selectedArray;
        }

        static /* synthetic */ JRadioButton access$300(ArrayDrivePanel arrayDrivePanel) {
            return arrayDrivePanel.arraysRadioButton;
        }

        static /* synthetic */ JRadioButton access$400(ArrayDrivePanel arrayDrivePanel) {
            return arrayDrivePanel.drivesRadioButton;
        }

        private static class MessagePanel
        extends JPanel {
            private JLabel icon;
            private JLabel label;

            public MessagePanel() {
                this.setLayout(new GridBagLayout());
                this.setOpaque(false);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.icon = new JLabel(new ImageIcon(Resources.getImage("icon.validate")));
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 5);
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                this.add((Component)this.icon, gridBagConstraints);
                this.label = new JLabel();
                this.label.setFont(GUIFactory.FONT_SMALL);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                this.add((Component)this.label, gridBagConstraints);
            }

            public void setText(String string) {
                this.label.setText(string);
            }
        }

        class RadioGroupActionListener
        implements ActionListener {
            int show;

            RadioGroupActionListener(int n) {
                this.show = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayDrivePanel.this.drivePanel.setSelectionMode(this.show == 0 ? 4 : 3);
                ArrayDrivePanel.this.cardLayout.show(ArrayDrivePanel.this.cardPanel, this.show == 0 ? "arrays" : "drives");
            }
        }
    }

    private static class InfoPanel
    extends JPanel {
        private static final int NUM_MODULES = 2;
        private final SelectableLabel name;
        private final SelectableLabel location;
        private final SelectableLabel contact;
        private final SelectableStatusLabel serviceID;
        private final SelectableLabel powerState;
        private final SelectableLabel keyLockStatus;
        private final SelectableStatusLabel[] status;
        private final SelectableLabel[] uptime;
        private final SelectableLabel[] serialNumber;
        private final SelectableLabel[] ambientTemp;
        private final SelectableLabel[] writeCache;
        private final SelectableLabel[] prefetchSize;
        private static final String unknown = Resources.noDataLabel();

        public InfoPanel() {
            GUIFactory.configureComponentForPlatform(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 0;
            this.setBorder(TAB_BORDER);
            this.setLayout(new GridBagLayout());
            this.status = new SelectableStatusLabel[2];
            this.uptime = new SelectableLabel[2];
            this.serialNumber = new SelectableLabel[2];
            this.ambientTemp = new SelectableLabel[2];
            this.writeCache = new SelectableLabel[2];
            this.prefetchSize = new SelectableLabel[2];
            this.name = new SelectableLabel();
            this.location = new SelectableLabel();
            this.contact = new SelectableLabel();
            this.keyLockStatus = new SelectableLabel();
            this.serviceID = new SelectableStatusLabel();
            this.powerState = new SelectableLabel();
            JPanel jPanel = this.createSystemInfoPanel();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            this.add((Component)jPanel, gridBagConstraints);
            SizeLinkedPanel sizeLinkedPanel = null;
            for (int i = 0; i < 2; ++i) {
                String string = i == 0 ? "systemInfo.summaryPanel.topController" : "systemInfo.summaryPanel.bottomController";
                SizeLinkedColumn sizeLinkedColumn = new SizeLinkedColumn(" " + Resources.getString(string) + " ");
                this.status[i] = new SelectableStatusLabel();
                this.uptime[i] = new SelectableLabel();
                sizeLinkedColumn.addField(Resources.getString("systemInfo.summaryPanel.uptime"), this.uptime[i]);
                this.serialNumber[i] = new SelectableLabel();
                sizeLinkedColumn.addField(Resources.getString("systemInfo.summaryPanel.serialNumber"), this.serialNumber[i]);
                this.ambientTemp[i] = new SelectableLabel();
                sizeLinkedColumn.addField(Resources.getString("systemInfo.summaryPanel.ambientTemp"), this.ambientTemp[i]);
                this.writeCache[i] = new SelectableLabel();
                sizeLinkedColumn.addField(Resources.getString("systemInfo.summaryPanel.writeCache"), this.writeCache[i]);
                this.prefetchSize[i] = new SelectableLabel();
                sizeLinkedColumn.addField(Resources.getString("systemInfo.summaryPanel.prefetch"), this.prefetchSize[i]);
                if (i == 0) {
                    gridBagConstraints.anchor = 17;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(12, 0, 0, 10);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridheight = 1;
                } else if (i == 1) {
                    gridBagConstraints.anchor = 13;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(12, 0, 0, 0);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridheight = 1;
                }
                if (sizeLinkedPanel != null) {
                    sizeLinkedPanel.linkPanel(sizeLinkedColumn);
                }
                this.add((Component)sizeLinkedColumn, gridBagConstraints);
                sizeLinkedPanel = sizeLinkedColumn;
            }
            ++n;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = ++n;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add(Box.createHorizontalStrut(1), gridBagConstraints);
            this.updateInfo(null);
        }

        private JPanel createSystemInfoPanel() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = GUIFactory.newPanel();
            JPanel jPanel2 = GUIFactory.newPanel();
            JPanel jPanel3 = GUIFactory.newPanel();
            jPanel.setLayout(new GridLayout(1, 2));
            jPanel2.setLayout(new GridBagLayout());
            jPanel3.setLayout(new GridBagLayout());
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            JLabel jLabel = new JLabel(Resources.getString("systemInfo.summaryPanel.name"));
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.name.setFont(GUIFactory.FONT_SMALL);
            jPanel2.add((Component)this.name, gridBagConstraints);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            jLabel = new JLabel(Resources.getString("systemInfo.summaryPanel.location"));
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.location.setFont(GUIFactory.FONT_SMALL);
            jPanel2.add((Component)this.location, gridBagConstraints);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            jLabel = new JLabel(Resources.getString("systemInfo.summaryPanel.contact"));
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.contact.setFont(GUIFactory.FONT_SMALL);
            jPanel2.add((Component)this.contact, gridBagConstraints);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            jLabel = new JLabel(Resources.getString("systemInfo.summaryPanel.serviceId"));
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jPanel3.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.serviceID.setFont(GUIFactory.FONT_SMALL);
            jPanel3.add((Component)this.serviceID, gridBagConstraints);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            jLabel = new JLabel(Resources.getString("systemInfo.summaryPanel.powerState"));
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jPanel3.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.powerState.setFont(GUIFactory.FONT_SMALL);
            jPanel3.add((Component)this.powerState, gridBagConstraints);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            jLabel = new JLabel(Resources.getString("systemInfo.summaryPanel.lock"));
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jPanel3.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.keyLockStatus.setFont(GUIFactory.FONT_SMALL);
            jPanel3.add((Component)this.keyLockStatus, gridBagConstraints);
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            return jPanel;
        }

        public void addField(SelectableLabel selectableLabel, String string, int n, int n2) {
            JLabel jLabel = new JLabel(string);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            selectableLabel.setFont(GUIFactory.FONT_SMALL);
            jLabel.setFont(GUIFactory.FONT_SMALL);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = n2;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = n2 + 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add((Component)selectableLabel, gridBagConstraints);
        }

        public void updateInfo(RaidSystem raidSystem) {
            if (raidSystem != null) {
                this.name.setText(raidSystem.getName());
                this.location.setText(SOMLocalizer.getGenericString(raidSystem.getLocation()));
                this.contact.setText(SOMLocalizer.getGenericString(raidSystem.getContact()));
                this.powerState.setText(SOMLocalizer.getPowerState(raidSystem));
                if (raidSystem.getPowerState() == 1) {
                    int n;
                    RaidController raidController;
                    SystemController systemController;
                    this.serviceID.setStatus(raidSystem.getServiceIdState() == 1 ? 1 : -3);
                    this.serviceID.setText(SOMLocalizer.getRaidSystemServiceIdState(raidSystem));
                    this.keyLockStatus.setText(SOMLocalizer.getRaidSystemLockState(raidSystem));
                    if (raidSystem.isControllerModulePresent(1)) {
                        systemController = raidSystem.getSystemController(1);
                        raidController = raidSystem.getRaidController(1);
                        n = raidSystem.getControllerModuleStatus(1);
                        this.status[0].setText(SOMLocalizer.getStatusString(n));
                        this.status[0].setStatus(n);
                        this.uptime[0].setText(SOMLocalizer.getRaidSystemUptime(systemController));
                        this.serialNumber[0].setText(raidController.getSerialNumber());
                        this.ambientTemp[0].setText(SOMLocalizer.getRaidSystemAmbientTemperature(systemController));
                        this.writeCache[0].setText(SOMLocalizer.getRaidControllerCacheState(raidController));
                        this.prefetchSize[0].setText(SOMLocalizer.getRaidControllerPrefetchSetting(raidController));
                    } else {
                        this.defaultControllerModuleFields(0);
                    }
                    if (raidSystem.isControllerModulePresent(2)) {
                        systemController = raidSystem.getSystemController(2);
                        raidController = raidSystem.getRaidController(2);
                        n = raidSystem.getControllerModuleStatus(2);
                        this.status[1].setText(SOMLocalizer.getStatusString(n));
                        this.status[1].setStatus(n);
                        this.uptime[1].setText(SOMLocalizer.getRaidSystemUptime(systemController));
                        this.serialNumber[1].setText(raidController.getSerialNumber());
                        this.ambientTemp[1].setText(SOMLocalizer.getRaidSystemAmbientTemperature(systemController));
                        this.writeCache[1].setText(SOMLocalizer.getRaidControllerCacheState(raidController));
                        this.prefetchSize[1].setText(SOMLocalizer.getRaidControllerPrefetchSetting(raidController));
                    } else {
                        this.defaultControllerModuleFields(1);
                    }
                } else {
                    this.serviceID.setStatus(-1);
                    this.serviceID.setText(unknown);
                    this.keyLockStatus.setText(unknown);
                    for (int i = 0; i < 2; ++i) {
                        this.defaultControllerModuleFields(i);
                    }
                }
            } else {
                this.name.setText(unknown);
                this.location.setText(unknown);
                this.contact.setText(unknown);
                this.serviceID.setStatus(-1);
                this.serviceID.setText(unknown);
                this.powerState.setText(unknown);
                this.keyLockStatus.setText(unknown);
                for (int i = 0; i < 2; ++i) {
                    this.defaultControllerModuleFields(i);
                }
            }
        }

        private void defaultControllerModuleFields(int n) {
            this.uptime[n].setText(unknown);
            this.serialNumber[n].setText(unknown);
            this.ambientTemp[n].setText(unknown);
            this.status[n].setText(unknown);
            this.status[n].setStatus(-3);
            this.writeCache[n].setText(unknown);
            this.prefetchSize[n].setText(unknown);
        }
    }
}

