/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.Gestalt;
import com.apple.xsr.StatusIcon;
import java.awt.Insets;
import javax.swing.JButton;

public class StatusIndicator
extends JButton {
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int FAILURE = 2;
    public static final int UNKNOWN = -1;
    private boolean selected = false;
    private int status = -1;

    public StatusIndicator() {
        this.setStatus(-1);
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        if (Gestalt.isJava141OrLater) {
            this.setMargin(new Insets(2, 2, 2, 2));
        } else {
            this.setMargin(new Insets(0, 0, 0, 0));
        }
        this.setBorder(null);
    }

    public void setStatusAndSelectedState(int n, boolean bl) {
        this.selected = bl;
        this.setStatus(n);
    }

    public void setStatus(int n) {
        if (n != 0 && n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("Illegal status (" + n + ")");
        }
        this.status = n;
        this.setIcon(StatusIcon.getStatusIconInstance(n, this.selected && n == -1 ? 2 : 0));
        this.setPressedIcon(StatusIcon.getStatusIconInstance(n, 1));
    }
}

