/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.ImageUtilities;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.Resources;
import com.apple.xsr.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import javax.swing.Icon;

public class StatusIcon
implements Icon {
    public static final int NOTINSTALLED = -2;
    public static final int CLEAR = -1;
    public static final int GREEN = 0;
    public static final int AMBER = 1;
    public static final int RED = 2;
    public static final int GRAY = 3;
    public static final int NONE = 0;
    public static final int MODULE = 1;
    public static final int DRIVE = 2;
    public static final int FIBRE = 3;
    public static final int NETWORK = 4;
    private static Image GRAY_IMAGE;
    private static Image CLEAR_IMAGE;
    private static Image CLEAR_SHAPE_IMAGE;
    private static Image GREEN_IMAGE;
    private static Image GREEN_SHAPE_IMAGE;
    private static Image AMBER_IMAGE;
    private static Image AMBER_SHAPE_IMAGE;
    private static Image RED_IMAGE;
    private static Image RED_SHAPE_IMAGE;
    private static Image NOTINSTALLED_IMAGE;
    private static boolean useShapes;
    private static final StatusIcon[][][][] allIcons;
    private static final int KIND_BLOB = 0;
    private static final int KIND_SHAPE = 1;
    private static final int SCALE_NORMAL = 0;
    private static final int SCALE_SMALL = 1;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_DIMMED = 1;
    public static final int STATE_WHITENED = 2;
    private static final Dimension NORMAL_SIZE;
    private static final Dimension SMALL_SIZE;
    private int state;
    private boolean scaled;
    private Image statusImage;
    private Image infoImage;
    private Dimension iconsize;

    private StatusIcon(int n, int n2, boolean bl, Dimension dimension) {
        this.state = n2;
        this.setStatusImage(n, bl);
        this.iconsize = dimension == null && this.statusImage != null ? new Dimension(this.statusImage.getWidth(null), this.statusImage.getHeight(null)) : dimension;
        this.scaled = true;
    }

    public static StatusIcon getStatusIconInstance(int n) {
        return allIcons[2 + n][useShapes ? 1 : 0][0][0];
    }

    public static StatusIcon getStatusIconInstance(int n, int n2) {
        return allIcons[2 + n][useShapes ? 1 : 0][0][n2];
    }

    public static StatusIcon getSmallStatusIconInstance(int n) {
        return allIcons[2 + n][useShapes ? 1 : 0][1][0];
    }

    public int getIconWidth() {
        return this.iconsize.width;
    }

    public int getIconHeight() {
        return this.iconsize.height;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        MediaTracker mediaTracker;
        graphics.setColor(Color.black);
        if (this.scaled) {
            mediaTracker = new MediaTracker(component);
            AreaAveragingScaleFilter areaAveragingScaleFilter = new AreaAveragingScaleFilter(this.iconsize.width, this.iconsize.height);
            if (this.statusImage != null) {
                this.statusImage = component.createImage(new FilteredImageSource(this.statusImage.getSource(), areaAveragingScaleFilter));
                mediaTracker.addImage(this.statusImage, 0);
            }
            if (this.infoImage != null) {
                this.infoImage = component.createImage(new FilteredImageSource(this.infoImage.getSource(), areaAveragingScaleFilter));
                mediaTracker.addImage(this.infoImage, 0);
            }
            try {
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.scaled = false;
        }
        if (this.statusImage != null && (this.state == 1 || this.state == 2)) {
            this.statusImage = this.state == 1 ? component.createImage(new FilteredImageSource(this.statusImage.getSource(), ImageUtilities.getDimmingFilterInstance())) : component.createImage(new FilteredImageSource(this.statusImage.getSource(), ImageUtilities.getWhiteningFilterInstance()));
            mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(this.statusImage, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            mediaTracker.removeImage(this.statusImage);
            this.state = 0;
        }
        if (this.statusImage != null) {
            graphics.drawImage(this.statusImage, n, n2, this.iconsize.width, this.iconsize.height, null);
        }
        if (this.infoImage != null) {
            graphics.drawImage(this.infoImage, n, n2, this.iconsize.width, this.iconsize.height, null);
        }
    }

    private void setStatusImage(int n, boolean bl) {
        switch (n) {
            case 3: {
                this.statusImage = bl ? GRAY_IMAGE : GRAY_IMAGE;
                break;
            }
            case 0: {
                this.statusImage = bl ? GREEN_SHAPE_IMAGE : GREEN_IMAGE;
                break;
            }
            case 1: {
                this.statusImage = bl ? AMBER_SHAPE_IMAGE : AMBER_IMAGE;
                break;
            }
            case 2: {
                this.statusImage = bl ? RED_SHAPE_IMAGE : RED_IMAGE;
                break;
            }
            case -1: {
                this.statusImage = bl ? CLEAR_SHAPE_IMAGE : CLEAR_IMAGE;
                break;
            }
            case -2: {
                this.statusImage = bl ? NOTINSTALLED_IMAGE : NOTINSTALLED_IMAGE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal status " + n);
            }
        }
    }

    public static boolean getUseShapes() {
        return useShapes;
    }

    public static void syncUseShapes() {
        Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        if (preferences != null) {
            useShapes = preferences.getBoolean("UseShapes", false);
        }
    }

    static {
        useShapes = true;
        allIcons = new StatusIcon[6][2][2][3];
        NORMAL_SIZE = new Dimension(16, 16);
        SMALL_SIZE = new Dimension(12, 12);
        CLEAR_IMAGE = Utilities.getImage(Resources.getString("icon.status.clear"), true, null);
        CLEAR_SHAPE_IMAGE = Utilities.getImage(Resources.getString("icon.status.clearShape"), true, null);
        GREEN_IMAGE = Utilities.getImage(Resources.getString("icon.status.green"), true, null);
        GREEN_SHAPE_IMAGE = Utilities.getImage(Resources.getString("icon.status.greenShape"), true, null);
        AMBER_IMAGE = Utilities.getImage(Resources.getString("icon.status.amber"), true, null);
        AMBER_SHAPE_IMAGE = Utilities.getImage(Resources.getString("icon.status.amberShape"), true, null);
        RED_IMAGE = Utilities.getImage(Resources.getString("icon.status.red"), true, null);
        RED_SHAPE_IMAGE = Utilities.getImage(Resources.getString("icon.status.redShape"), true, null);
        GRAY_IMAGE = Utilities.getImage(Resources.getString("icon.status.gray"), true, null);
        NOTINSTALLED_IMAGE = Utilities.getImage(Resources.getString("icon.status.notinstalled"), true, null);
        for (int i = -2; i <= 3; ++i) {
            for (int j = 0; j <= 1; ++j) {
                for (int k = 0; k <= 1; ++k) {
                    for (int i2 = 0; i2 <= 2; ++i2) {
                        boolean bl = j == 1;
                        Dimension dimension = k == 0 ? NORMAL_SIZE : SMALL_SIZE;
                        StatusIcon.allIcons[2 + i][j][k][i2] = new StatusIcon(i, i2, bl, dimension);
                    }
                }
            }
        }
        StatusIcon.syncUseShapes();
        Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        preferences.addPreferenceChangeListener(new Preferences.PreferenceChangeListener(){

            public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
                if (preferenceChangeEvent.getKey().equals("UseShapes")) {
                    StatusIcon.syncUseShapes();
                }
            }
        });
    }
}

