/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

class SizeLinkedPanel
extends JPanel {
    public static final int LINK_WIDTH = 1;
    public static final int LINK_HEIGHT = 2;
    public static final int LINK_BOTH = 3;
    private Vector linkedPanels = new Vector();

    SizeLinkedPanel() {
        GUIFactory.configureComponentForPlatform(this);
    }

    public void linkPanel(SizeLinkedPanel sizeLinkedPanel) {
        this.linkPanel(sizeLinkedPanel, 3);
    }

    public void linkPanel(SizeLinkedPanel sizeLinkedPanel, int n) {
        if (sizeLinkedPanel != null) {
            this.linkedPanels.add(new LinkData(sizeLinkedPanel, n));
            sizeLinkedPanel.linkPanelNonRecursive(this, n);
        }
    }

    public void linkPanelNonRecursive(SizeLinkedPanel sizeLinkedPanel) {
        this.linkPanelNonRecursive(sizeLinkedPanel, 3);
    }

    public void linkPanelNonRecursive(SizeLinkedPanel sizeLinkedPanel, int n) {
        if (sizeLinkedPanel != null) {
            this.linkedPanels.add(new LinkData(sizeLinkedPanel, n));
        }
    }

    public void unlinkPanel(SizeLinkedPanel sizeLinkedPanel) {
        if (sizeLinkedPanel != null) {
            this.linkedPanels.remove(sizeLinkedPanel);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Enumeration enumeration = this.linkedPanels.elements();
        while (enumeration.hasMoreElements()) {
            LinkData linkData = (LinkData)enumeration.nextElement();
            Dimension dimension2 = linkData.panel.getPreferredSizeFromSuper();
            if ((linkData.linkedDimensions & 1) != 0 && dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if ((linkData.linkedDimensions & 2) == 0 || dimension2.height <= dimension.height) continue;
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    public Dimension getPreferredSizeFromSuper() {
        return super.getPreferredSize();
    }

    private static class LinkData {
        final SizeLinkedPanel panel;
        final int linkedDimensions;

        public LinkData(SizeLinkedPanel sizeLinkedPanel) {
            this(sizeLinkedPanel, 3);
        }

        public LinkData(SizeLinkedPanel sizeLinkedPanel, int n) {
            this.panel = sizeLinkedPanel;
            this.linkedDimensions = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof LinkData)) {
                return false;
            }
            LinkData linkData = (LinkData)object;
            return linkData.panel.equals(this.panel) && linkData.linkedDimensions == this.linkedDimensions;
        }

        public int hashCode() {
            int n = 13;
            n = 37 * n + this.panel.hashCode();
            n = 37 * n + this.linkedDimensions;
            return n;
        }
    }
}

