/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.net.acp.AcpPropertyCode;
import com.apple.net.acp.AcpTextRecord;
import com.apple.util.Gestalt;
import com.apple.util.SortedArrayList;
import com.apple.xsr.IconFamily;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import com.chaotic.rendezvous.Browser;
import com.chaotic.rendezvous.BrowserListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jmdns.ServiceInfo;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class RendezvousPanel
extends JPanel
implements ListSelectionListener {
    public static final String XSERVE_RAID_SERVICE_NAME = new String("_xserveraid._tcp");
    public static final String XSERVE_SERVICE_NAME = new String("_xserve._tcp");
    public static final int XSERVE_RAID_MANGEMENT_USER = 1;
    public static final int XSERVE_RAID_MONITOR_USER = 2;
    private static final Dimension DEFAULT_DIMENSIONS = new Dimension(230, 200);
    private static final Color BOX_COLOR = Color.getHSBColor(0.0f, 0.0f, 0.99f);
    private static final Color SIDE_BORDER_COLOR = Color.lightGray;
    private static final Color TOP_BORDER_COLOR = RendezvousPanel.getRGBColor(124, 124, 124);
    private static final Color BOTTOM_BORDER_COLOR = RendezvousPanel.getRGBColor(207, 207, 207);
    private RendezvousBrowserPanel mPanel;
    private RestrictedTextField mIPAddressTextField;
    private JPasswordField mPassword;
    private JButton mAdd;
    private JButton mCancel;
    private ArrayList mMonitoredMacAddresses = null;
    private ArrayList mMonitoredIPAddresses = null;

    public RendezvousPanel(ArrayList arrayList, ArrayList arrayList2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = new String[]{XSERVE_RAID_SERVICE_NAME};
        String[] stringArray2 = new String[]{"icon.xserveraid"};
        this.mMonitoredMacAddresses = arrayList;
        this.mMonitoredIPAddresses = arrayList2;
        this.setLayout(new GridBagLayout());
        this.mPanel = new RendezvousBrowserPanel(stringArray, stringArray2);
        this.mPanel.addListSelectionListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.mPanel, gridBagConstraints);
        JLabel jLabel = new JLabel(Resources.getString("rendezvousPanel.addressLabel"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)jLabel, gridBagConstraints);
        this.mIPAddressTextField = GUIFactory.newRestrictedTextField(20);
        this.mIPAddressTextField.setRestrictedCharacterSet(Resources.getString("aquaTextField.validDNSCharacters"));
        this.mIPAddressTextField.setFont(GUIFactory.FONT_SMALL);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.mIPAddressTextField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)new JLabel(Resources.getString("rendezvousPanel.passwordLabel")), gridBagConstraints);
        this.mPassword = GUIFactory.newPasswordField(10);
        this.mPassword.setFont(GUIFactory.FONT_SMALL);
        if (Gestalt.isMacLookAndFeel) {
            this.mPassword.setEchoChar('\u2022');
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.mPassword, gridBagConstraints);
        Box box = Box.createHorizontalBox();
        this.mAdd = GUIFactory.newButton(Resources.getString("rendezvousPanel.addButton"));
        this.mCancel = GUIFactory.newCancelButton();
        this.mAdd.setEnabled(false);
        box.add(Box.createHorizontalGlue());
        box.add(this.mCancel);
        box.add(Box.createHorizontalStrut(12));
        box.add(this.mAdd);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)box, gridBagConstraints);
        this.mIPAddressTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.clearRendezvousSelectionIfEditing();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.clearRendezvousSelectionIfEditing();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.clearRendezvousSelectionIfEditing();
            }

            void clearRendezvousSelectionIfEditing() {
                if (RendezvousPanel.this.mIPAddressTextField.hasFocus()) {
                    RendezvousPanel.this.mPanel.mList.clearSelection();
                }
            }
        });
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                try {
                    String string = new String(RendezvousPanel.this.mIPAddressTextField.getText());
                    String string2 = new String(RendezvousPanel.this.mPassword.getPassword());
                    if (string.length() > 0 && string2.length() > 0) {
                        RendezvousPanel.this.mAdd.setEnabled(true);
                    } else {
                        RendezvousPanel.this.mAdd.setEnabled(false);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    RendezvousPanel.this.mAdd.setEnabled(false);
                }
            }
        };
        this.mIPAddressTextField.addCaretListener(caretListener);
        this.mPassword.addCaretListener(caretListener);
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public JButton getAddButton() {
        return this.mAdd;
    }

    public JButton getCancelButton() {
        return this.mCancel;
    }

    public String[] getAddresses() {
        String[] stringArray;
        Object[] objectArray = this.mPanel.mList.getSelectedValues();
        int n = objectArray.length;
        if (n == 0) {
            stringArray = new String[]{this.mIPAddressTextField.getText()};
        } else {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((RendezvousListItem)objectArray[i]).getAddress();
            }
        }
        return stringArray;
    }

    public String[] getNames() {
        String[] stringArray;
        Object[] objectArray = this.mPanel.mList.getSelectedValues();
        int n = objectArray.length;
        if (n == 0) {
            stringArray = new String[]{""};
        } else {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((RendezvousListItem)objectArray[i]).getName();
            }
        }
        return stringArray;
    }

    public String getPassword() {
        return new String(this.mPassword.getPassword());
    }

    public void resetPassword() {
        this.mPassword.setText("");
    }

    public void beginServices() {
        String[] stringArray = new String[]{XSERVE_RAID_SERVICE_NAME};
        this.mPanel.requestFocus();
        this.mPanel.startRendezvousServices(stringArray);
    }

    public void endServices() {
        this.mPanel.stopRendezvousServices();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() instanceof JList) {
            JList jList = (JList)listSelectionEvent.getSource();
            Object[] objectArray = jList.getSelectedValues();
            int n = objectArray.length;
            if (n == 1) {
                RendezvousListItem rendezvousListItem = (RendezvousListItem)objectArray[0];
                this.mIPAddressTextField.setRestrictedCharacterSet(Resources.getString("aquaTextField.validDNSCharacters"));
                this.mIPAddressTextField.setText(rendezvousListItem.getAddress());
                GUIFactory.configureTextFieldAsField(this.mIPAddressTextField);
                this.mPassword.setText("");
            } else if (n > 1) {
                this.mIPAddressTextField.setRestrictedCharacterSet(null);
                this.mIPAddressTextField.setText(Resources.getString("rendezvousPanel.multipleSelection"));
                GUIFactory.configureTextFieldAsLabel(this.mIPAddressTextField);
                this.mPassword.setText("");
            } else if (!this.mIPAddressTextField.hasFocus()) {
                this.mIPAddressTextField.setRestrictedCharacterSet(Resources.getString("aquaTextField.validDNSCharacters"));
                this.mIPAddressTextField.setText("");
                GUIFactory.configureTextFieldAsField(this.mIPAddressTextField);
                this.mIPAddressTextField.requestFocus();
            }
        }
    }

    public static Color getRGBColor(int n, int n2, int n3) {
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        fArray = Color.RGBtoHSB(n, n2, n3, fArray);
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    private class RendezvousListItem
    extends IconFamily
    implements Comparable {
        private ControllerRendezvousRecord mFirstDiscoveredRecord = null;
        private ControllerRendezvousRecord mSecondDiscoveredRecord = null;

        RendezvousListItem(ControllerRendezvousRecord controllerRendezvousRecord, String string) {
            super(string);
            this.add(controllerRendezvousRecord);
        }

        public void add(ControllerRendezvousRecord controllerRendezvousRecord) {
            if (this.mFirstDiscoveredRecord == null) {
                this.mFirstDiscoveredRecord = controllerRendezvousRecord;
            } else if (this.mSecondDiscoveredRecord == null) {
                if (this.mFirstDiscoveredRecord.getLocation() == 0 || this.mFirstDiscoveredRecord.getLocation() == -1) {
                    this.mSecondDiscoveredRecord = controllerRendezvousRecord;
                } else {
                    this.mSecondDiscoveredRecord = this.mFirstDiscoveredRecord;
                    this.mFirstDiscoveredRecord = controllerRendezvousRecord;
                }
            }
        }

        public void remove(ControllerRendezvousRecord controllerRendezvousRecord) {
            if (this.mFirstDiscoveredRecord != null && controllerRendezvousRecord.getEthernetAddress().equals(this.mFirstDiscoveredRecord.getEthernetAddress())) {
                this.mFirstDiscoveredRecord = this.mSecondDiscoveredRecord;
                this.mSecondDiscoveredRecord = null;
            } else if (this.mSecondDiscoveredRecord != null && controllerRendezvousRecord.getEthernetAddress().equals(this.mSecondDiscoveredRecord.getEthernetAddress())) {
                this.mSecondDiscoveredRecord = null;
            }
        }

        public boolean isFull() {
            return this.mFirstDiscoveredRecord != null && this.mSecondDiscoveredRecord != null;
        }

        public boolean isEmpty() {
            return this.mFirstDiscoveredRecord == null && this.mSecondDiscoveredRecord == null;
        }

        public int compareTo(Object object) {
            int n = -1;
            if (!(object instanceof RendezvousListItem)) {
                throw new ClassCastException("RendezvousListItems must only compared to other RendezvousListItems.");
            }
            RendezvousListItem rendezvousListItem = (RendezvousListItem)object;
            if (this.equals(rendezvousListItem)) {
                n = 0;
            } else if (this.mFirstDiscoveredRecord != null && (n = this.mFirstDiscoveredRecord.getName().compareTo(rendezvousListItem.getName())) == 0) {
                n = -1;
            }
            return n;
        }

        public boolean containsController(ControllerRendezvousRecord controllerRendezvousRecord) {
            boolean bl = false;
            if (this.mFirstDiscoveredRecord != null && this.mFirstDiscoveredRecord.equals(controllerRendezvousRecord)) {
                bl = true;
            }
            if (this.mSecondDiscoveredRecord != null && this.mSecondDiscoveredRecord.equals(controllerRendezvousRecord)) {
                bl = true;
            }
            return bl;
        }

        public boolean containsCompanionOf(ControllerRendezvousRecord controllerRendezvousRecord) {
            boolean bl = false;
            if (this.mFirstDiscoveredRecord != null && this.mFirstDiscoveredRecord.isCompanionOf(controllerRendezvousRecord)) {
                bl = true;
            }
            if (this.mSecondDiscoveredRecord != null && this.mSecondDiscoveredRecord.isCompanionOf(controllerRendezvousRecord)) {
                bl = true;
            }
            return bl;
        }

        public boolean containsControllerWithMacAddress(String string) {
            boolean bl = false;
            if (string != null && (string.equals(this.getEthernetAddress()) || string.equals(this.getSecondEthernetAddress()))) {
                bl = true;
            }
            return bl;
        }

        public boolean containsControllerWithIPAddress(String string) {
            boolean bl = false;
            if (string != null && (string.equals(this.getAddress()) || string.equals(this.getSecondAddress())) && !string.equals("")) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(RendezvousListItem rendezvousListItem) {
            boolean bl = false;
            if (this.mFirstDiscoveredRecord != null && this.mSecondDiscoveredRecord != null) {
                if (this.mFirstDiscoveredRecord.getEthernetAddress().equals(rendezvousListItem.getEthernetAddress()) && this.mSecondDiscoveredRecord.getEthernetAddress().equals(rendezvousListItem.getSecondEthernetAddress())) {
                    bl = true;
                }
            } else if (this.mFirstDiscoveredRecord != null) {
                if (this.mFirstDiscoveredRecord.getEthernetAddress().equals(rendezvousListItem.getEthernetAddress()) && rendezvousListItem.getSecondEthernetAddress() == null) {
                    bl = true;
                }
            } else if (this.mSecondDiscoveredRecord != null) {
                if (this.mSecondDiscoveredRecord.getEthernetAddress().equals(rendezvousListItem.getSecondEthernetAddress()) && rendezvousListItem.getEthernetAddress() == null) {
                    bl = true;
                }
            } else if (this.mFirstDiscoveredRecord == null && this.mSecondDiscoveredRecord == null && rendezvousListItem.getEthernetAddress() == null && rendezvousListItem.getSecondEthernetAddress() == null) {
                bl = true;
            }
            return bl;
        }

        public String getName() {
            return this.mFirstDiscoveredRecord.getName();
        }

        public String getAddress() {
            String string = "";
            if (this.mFirstDiscoveredRecord != null) {
                string = this.mFirstDiscoveredRecord.getIPAddress();
            }
            return string;
        }

        public String getSecondAddress() {
            String string = "";
            if (this.mSecondDiscoveredRecord != null) {
                string = this.mSecondDiscoveredRecord.getIPAddress();
            }
            return string;
        }

        public String getEthernetAddress() {
            String string = null;
            if (this.mFirstDiscoveredRecord != null) {
                string = this.mFirstDiscoveredRecord.getEthernetAddress();
            }
            return string;
        }

        public String getSecondEthernetAddress() {
            String string = null;
            if (this.mSecondDiscoveredRecord != null) {
                string = this.mSecondDiscoveredRecord.getEthernetAddress();
            }
            return string;
        }

        public int getProductID() {
            int n = 0;
            int n2 = 0;
            if (this.mFirstDiscoveredRecord != null) {
                n = this.mFirstDiscoveredRecord.getProductID();
            }
            if (this.mSecondDiscoveredRecord != null) {
                n2 = this.mSecondDiscoveredRecord.getProductID();
            }
            int n3 = n != 0 && n2 != 0 ? (n > n2 ? n : n2) : (n != 0 ? n : n2);
            return n3;
        }
    }

    private class ControllerRendezvousRecord {
        public static final int TOP = 0;
        public static final int BOTTOM = 1;
        public static final int UNDETERMINED = -1;
        private static final int TOP_CONTROLLER_MASK = 4096;
        private ServiceInfo serviceInfo;
        private String presentationName;
        private String presentationIP;
        private String presentationEthernet;
        private String companionIP;
        private String companionEthernet;
        private int topOrBottom;
        private int productID;

        public String getName() {
            return this.presentationName;
        }

        public String getIPAddress() {
            return this.presentationIP;
        }

        public String getEthernetAddress() {
            return this.presentationEthernet;
        }

        public String getOtherEthernetAddress() {
            return this.companionEthernet;
        }

        public int getLocation() {
            return this.topOrBottom;
        }

        public int getProductID() {
            return this.productID;
        }

        ControllerRendezvousRecord(ServiceInfo serviceInfo) {
            AcpTextRecord acpTextRecord = null;
            this.serviceInfo = serviceInfo;
            try {
                acpTextRecord = new AcpTextRecord(this.serviceInfo.getTextBytes());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            if (acpTextRecord != null) {
                this.presentationName = acpTextRecord.getPropertyString(AcpPropertyCode.SYS_PRESENTATION_NAME.fourCharCode());
                if (this.presentationName == null) {
                    this.presentationName = this.serviceInfo.getName();
                }
                if (this.presentationName == null) {
                    this.presentationName = Resources.getString("rendezvousPanel.unknownSystemName");
                }
                this.presentationIP = this.serviceInfo.getAddress();
                this.presentationEthernet = acpTextRecord.getPropertyString(AcpPropertyCode.LAN_MAC_ADDRESS.fourCharCode());
                this.companionIP = acpTextRecord.getCompanionPropertyString(AcpPropertyCode.LAN_IP_ADDRESS.fourCharCode());
                this.companionEthernet = acpTextRecord.getCompanionPropertyString(AcpPropertyCode.LAN_MAC_ADDRESS.fourCharCode());
                int n = acpTextRecord.getPropertyInteger(AcpPropertyCode.SYS_FLAGS.fourCharCode(), 0);
                int n2 = acpTextRecord.getCompanionPropertyInteger(AcpPropertyCode.SYS_FLAGS.fourCharCode(), 0);
                this.topOrBottom = (n & 0x1000) != 0 ? 0 : ((n2 & 0x1000) != 0 ? 1 : -1);
                this.productID = acpTextRecord.getPropertyInteger(AcpPropertyCode.SYS_APPLE_PRODUCT_ID.fourCharCode(), 0);
            }
        }

        public boolean isCompanionOf(ControllerRendezvousRecord controllerRendezvousRecord) {
            boolean bl = false;
            if (this.presentationEthernet != null && this.presentationEthernet.equals(controllerRendezvousRecord.getOtherEthernetAddress())) {
                bl = true;
            }
            if (this.companionEthernet != null && this.companionEthernet.equals(controllerRendezvousRecord.getEthernetAddress())) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(ControllerRendezvousRecord controllerRendezvousRecord) {
            boolean bl = false;
            if (this.presentationEthernet != null && this.companionEthernet != null) {
                if (this.presentationEthernet.equals(controllerRendezvousRecord.getEthernetAddress()) && this.companionEthernet.equals(controllerRendezvousRecord.getOtherEthernetAddress())) {
                    bl = true;
                }
            } else if (this.presentationEthernet != null) {
                if (this.presentationEthernet.equals(controllerRendezvousRecord.getEthernetAddress()) && controllerRendezvousRecord.getOtherEthernetAddress() == null) {
                    bl = true;
                }
            } else if (this.companionEthernet != null) {
                if (this.companionEthernet.equals(controllerRendezvousRecord.getOtherEthernetAddress()) && controllerRendezvousRecord.getEthernetAddress() == null) {
                    bl = true;
                }
            } else if (this.presentationEthernet == null && this.companionEthernet == null && controllerRendezvousRecord.getEthernetAddress() == null && controllerRendezvousRecord.getOtherEthernetAddress() == null) {
                bl = true;
            }
            return bl;
        }
    }

    public class RendezvousBrowserPanel
    extends JPanel {
        private JLabel mRendezvousNameLabel = null;
        private JLabel mFirstIPAddressLabel = null;
        private JLabel mSecondIPAddressLabel = null;
        private JLabel mIconLabel = null;
        private JList mList = null;
        private JScrollPane mScrollPane = null;
        private RendezvousListModel mModel = null;

        RendezvousBrowserPanel(String[] stringArray, String[] stringArray2) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add((Component)this.createListView(stringArray, stringArray2), gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.createMoreInfoView(), gridBagConstraints);
        }

        private JPanel createListView(String[] stringArray, String[] stringArray2) {
            JPanel jPanel = GUIFactory.newPanel();
            this.mModel = new RendezvousListModel(stringArray, stringArray2);
            this.mList = new JList(this.mModel);
            this.mList.setSelectionMode(2);
            this.mList.setCellRenderer(new RendezvousListCellRenderer());
            this.mScrollPane = new JScrollPane(this.mList);
            this.mScrollPane.setMinimumSize(new Dimension(DEFAULT_DIMENSIONS));
            this.mScrollPane.setPreferredSize(new Dimension(DEFAULT_DIMENSIONS));
            this.mList.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ RendezvousBrowserPanel this$1;
                {
                    this.this$1 = rendezvousBrowserPanel;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (RendezvousBrowserPanel.access$200(this.this$1).locationToIndex(mouseEvent.getPoint()) == -1) {
                        RendezvousBrowserPanel.access$200(this.this$1).clearSelection();
                    }
                }
            });
            jPanel.add(this.mScrollPane);
            return jPanel;
        }

        public void requestFocus() {
            this.mList.requestFocus();
        }

        public void startRendezvousServices(String[] stringArray) {
            this.mModel.startRendezvousServices(stringArray);
        }

        public void stopRendezvousServices() {
            this.mModel.stopRendezvousServices();
        }

        private JPanel createMoreInfoView() {
            return new MoreInfoPanel();
        }

        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            this.mList.addListSelectionListener(listSelectionListener);
        }

        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
            this.mList.removeListSelectionListener(listSelectionListener);
        }

        class RendezvousListCellRenderer
        extends DefaultListCellRenderer {
            RendezvousListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                RendezvousListItem rendezvousListItem = (RendezvousListItem)object;
                this.setIcon(rendezvousListItem.getIcon16());
                this.setText(rendezvousListItem.getName());
                return component;
            }
        }

        public class RendezvousListModel
        extends AbstractListModel
        implements BrowserListener {
            private SortedArrayList mSystems = new SortedArrayList();
            private SortedArrayList mVisibleSystems = new SortedArrayList();
            private Browser mBrowser = null;
            private HashMap mServiceIconMap = new HashMap();

            RendezvousListModel(String[] stringArray, String[] stringArray2) {
                this.mBrowser = new Browser(this);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.mServiceIconMap.put(stringArray[i], stringArray2[i]);
                }
            }

            public void startRendezvousServices(String[] stringArray) {
                String[] stringArray2 = stringArray;
                try {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        this.mBrowser.startServiceSearch(stringArray2[i], null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void stopRendezvousServices() {
                try {
                    this.mBrowser.stopServiceSearch();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void serviceAdded(Browser browser, ServiceInfo serviceInfo) {
            }

            private boolean shouldDisplayItem(RendezvousListItem rendezvousListItem) {
                String string;
                Iterator iterator;
                ArrayList arrayList = RendezvousPanel.this.mMonitoredMacAddresses;
                ArrayList arrayList2 = RendezvousPanel.this.mMonitoredIPAddresses;
                boolean bl = true;
                if (arrayList != null) {
                    iterator = arrayList.iterator();
                    while (iterator.hasNext() && bl) {
                        string = (String)iterator.next();
                        if (!rendezvousListItem.containsControllerWithMacAddress(string = string.replace(':', '-'))) continue;
                        bl = false;
                        break;
                    }
                }
                if (arrayList2 != null && bl) {
                    iterator = arrayList2.iterator();
                    while (iterator.hasNext() && bl) {
                        string = (String)iterator.next();
                        if (!rendezvousListItem.containsControllerWithIPAddress(string)) continue;
                        bl = false;
                        break;
                    }
                }
                iterator = (Iterator)RaidAdmin.getSupportedProductIds();
                boolean bl2 = false;
                for (int i = 0; i < ((Iterator<E>)iterator).length; ++i) {
                    if (rendezvousListItem.getProductID() != iterator[i]) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    bl = false;
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addRecord(ServiceInfo serviceInfo) {
                ControllerRendezvousRecord controllerRendezvousRecord = new ControllerRendezvousRecord(serviceInfo);
                String string = ".local.";
                String string2 = new String(serviceInfo.getType());
                string2 = string2.substring(0, string2.lastIndexOf(string));
                String string3 = (String)this.mServiceIconMap.get(string2);
                SortedArrayList sortedArrayList = this.mSystems;
                synchronized (sortedArrayList) {
                    Object object;
                    int n = this.mSystems.size();
                    for (int i = 0; i < n; ++i) {
                        object = (RendezvousListItem)this.mSystems.get(i);
                        if (((RendezvousListItem)object).isFull() || !((RendezvousListItem)object).containsCompanionOf(controllerRendezvousRecord)) continue;
                        int n2 = this.mVisibleSystems.indexOf((Comparable)object);
                        ((RendezvousListItem)object).add(controllerRendezvousRecord);
                        if (!this.shouldDisplayItem((RendezvousListItem)object) && n2 != -1) {
                            SortedArrayList sortedArrayList2 = this.mVisibleSystems;
                            synchronized (sortedArrayList2) {
                                this.mVisibleSystems.remove(object);
                                this.intervalRemoved(n2, n2);
                            }
                        } else if (n2 != -1) {
                            this.contentsChanged(n2, n2);
                        }
                        return;
                    }
                    RendezvousListItem rendezvousListItem = new RendezvousListItem(controllerRendezvousRecord, string3);
                    this.mSystems.add(rendezvousListItem);
                    if (this.shouldDisplayItem(rendezvousListItem)) {
                        object = this.mVisibleSystems;
                        synchronized (object) {
                            this.mVisibleSystems.add(rendezvousListItem);
                            int n3 = this.mVisibleSystems.fastIndexOf(rendezvousListItem);
                            this.intervalAdded(n3, n3);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void removeRecord(ControllerRendezvousRecord controllerRendezvousRecord) {
                SortedArrayList sortedArrayList = this.mSystems;
                synchronized (sortedArrayList) {
                    for (int i = this.mSystems.size() - 1; i >= 0; --i) {
                        RendezvousListItem rendezvousListItem = (RendezvousListItem)this.mSystems.get(i);
                        if (!rendezvousListItem.containsController(controllerRendezvousRecord)) continue;
                        rendezvousListItem.remove(controllerRendezvousRecord);
                        if (!rendezvousListItem.isEmpty()) break;
                        this.mSystems.remove(rendezvousListItem);
                        int n = this.mVisibleSystems.indexOf(rendezvousListItem);
                        if (n == -1) break;
                        SortedArrayList sortedArrayList2 = this.mVisibleSystems;
                        synchronized (sortedArrayList2) {
                            this.mVisibleSystems.remove(rendezvousListItem);
                            this.intervalRemoved(n, n);
                            break;
                        }
                    }
                }
            }

            public void serviceRemoved(Browser browser, ServiceInfo serviceInfo) {
                ServiceInfo serviceInfo2 = serviceInfo;
                ControllerRendezvousRecord controllerRendezvousRecord = new ControllerRendezvousRecord(serviceInfo2);
                SwingUtilities.invokeLater(new Runnable(this, controllerRendezvousRecord){
                    private final /* synthetic */ ControllerRendezvousRecord val$aRecord;
                    private final /* synthetic */ RendezvousListModel this$2;
                    {
                        this.this$2 = rendezvousListModel;
                        this.val$aRecord = controllerRendezvousRecord;
                    }

                    public void run() {
                        RendezvousListModel.access$1700(this.this$2, this.val$aRecord);
                    }
                });
            }

            public void serviceResolved(Browser browser, ServiceInfo serviceInfo) {
                ServiceInfo serviceInfo2 = serviceInfo;
                SwingUtilities.invokeLater(new Runnable(this, serviceInfo2){
                    private final /* synthetic */ ServiceInfo val$theServiceInfo;
                    private final /* synthetic */ RendezvousListModel this$2;
                    {
                        this.this$2 = rendezvousListModel;
                        this.val$theServiceInfo = serviceInfo;
                    }

                    public void run() {
                        RendezvousListModel.access$1800(this.this$2, this.val$theServiceInfo);
                    }
                });
            }

            public void contentsChanged(int n, int n2) {
                this.fireContentsChanged(this, n, n2);
            }

            public void intervalAdded(int n, int n2) {
                this.fireIntervalAdded(this, n, n2);
            }

            public void intervalRemoved(int n, int n2) {
                this.fireIntervalRemoved(this, n, n2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized int getSize() {
                int n = 0;
                SortedArrayList sortedArrayList = this.mVisibleSystems;
                synchronized (sortedArrayList) {
                    n = this.mVisibleSystems.size();
                }
                return n;
            }

            public ImageIcon getIconForObject(Object object) {
                RendezvousListItem rendezvousListItem = null;
                ImageIcon imageIcon = null;
                if (object != null && object instanceof RendezvousListItem) {
                    rendezvousListItem = (RendezvousListItem)object;
                    imageIcon = rendezvousListItem.getIcon128();
                }
                return imageIcon;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getElementAt(int n) {
                Comparable comparable = null;
                SortedArrayList sortedArrayList = this.mVisibleSystems;
                synchronized (sortedArrayList) {
                    comparable = this.mVisibleSystems.get(n);
                }
                return comparable;
            }

            static /* synthetic */ void access$1700(RendezvousListModel rendezvousListModel, ControllerRendezvousRecord controllerRendezvousRecord) {
                rendezvousListModel.removeRecord(controllerRendezvousRecord);
            }

            static /* synthetic */ void access$1800(RendezvousListModel rendezvousListModel, ServiceInfo serviceInfo) {
                rendezvousListModel.addRecord(serviceInfo);
            }
        }

        private class MoreInfoPanel
        extends JPanel
        implements ListSelectionListener {
            MoreInfoPanel() {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setBorder(new EmptyBorder(12, 12, 12, 12));
                this.setMinimumSize(new Dimension(DEFAULT_DIMENSIONS));
                this.setPreferredSize(new Dimension(DEFAULT_DIMENSIONS));
                this.setLayout(new GridBagLayout());
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                RendezvousBrowserPanel.this.mIconLabel = new JLabel();
                this.add((Component)RendezvousBrowserPanel.this.mIconLabel, gridBagConstraints);
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.insets = new Insets(0, 0, 2, 0);
                RendezvousBrowserPanel.this.mRendezvousNameLabel = new JLabel("");
                this.add((Component)RendezvousBrowserPanel.this.mRendezvousNameLabel, gridBagConstraints);
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.insets = new Insets(0, 0, 2, 0);
                RendezvousBrowserPanel.this.mFirstIPAddressLabel = new JLabel("");
                this.add((Component)RendezvousBrowserPanel.this.mFirstIPAddressLabel, gridBagConstraints);
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.insets = new Insets(0, 0, 2, 0);
                RendezvousBrowserPanel.this.mSecondIPAddressLabel = new JLabel("");
                this.add((Component)RendezvousBrowserPanel.this.mSecondIPAddressLabel, gridBagConstraints);
                RendezvousBrowserPanel.this.addListSelectionListener(this);
            }

            public void paint(Graphics graphics) {
                graphics.setColor(TOP_BORDER_COLOR);
                graphics.drawLine(0, 3, this.getWidth() - 1, 3);
                graphics.setColor(SIDE_BORDER_COLOR);
                graphics.drawLine(0, 4, this.getWidth() - 1, 4);
                graphics.setColor(SIDE_BORDER_COLOR);
                graphics.drawLine(0, 4, 0, this.getHeight() - 3);
                graphics.drawLine(this.getWidth() - 1, 4, this.getWidth() - 1, this.getHeight() - 3);
                graphics.setColor(BOTTOM_BORDER_COLOR);
                graphics.drawLine(0, this.getHeight() - 3, this.getWidth() - 1, this.getHeight() - 3);
                graphics.setColor(BOX_COLOR);
                graphics.fillRect(1, 5, this.getWidth() - 2, this.getHeight() - 8);
                this.paintChildren(graphics);
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getSource() instanceof JList) {
                    JList jList = (JList)listSelectionEvent.getSource();
                    Object[] objectArray = jList.getSelectedValues();
                    int n = objectArray.length;
                    if (n == 1) {
                        RendezvousListItem rendezvousListItem = (RendezvousListItem)objectArray[0];
                        RendezvousBrowserPanel.this.mRendezvousNameLabel.setText(rendezvousListItem.getName());
                        if (rendezvousListItem.getAddress() != null && rendezvousListItem.getAddress() != "") {
                            RendezvousBrowserPanel.this.mFirstIPAddressLabel.setText(rendezvousListItem.getAddress());
                        } else {
                            RendezvousBrowserPanel.this.mFirstIPAddressLabel.setText(" ");
                        }
                        if (rendezvousListItem.getSecondAddress() != null && rendezvousListItem.getSecondAddress() != "") {
                            RendezvousBrowserPanel.this.mSecondIPAddressLabel.setText(rendezvousListItem.getSecondAddress());
                        } else {
                            RendezvousBrowserPanel.this.mSecondIPAddressLabel.setText(" ");
                        }
                        RendezvousBrowserPanel.this.mIconLabel.setIcon(rendezvousListItem.getIcon128());
                    } else if (n > 1) {
                        RendezvousBrowserPanel.this.mIconLabel.setIcon(new ImageIcon(Resources.getImage("icon.multiple")));
                        RendezvousBrowserPanel.this.mRendezvousNameLabel.setText(Resources.getString("rendezvousPanel.multipleSelection"));
                        RendezvousBrowserPanel.this.mFirstIPAddressLabel.setText(" ");
                        RendezvousBrowserPanel.this.mSecondIPAddressLabel.setText(" ");
                    } else {
                        RendezvousBrowserPanel.this.mRendezvousNameLabel.setText("");
                        RendezvousBrowserPanel.this.mFirstIPAddressLabel.setText("");
                        RendezvousBrowserPanel.this.mSecondIPAddressLabel.setText("");
                        RendezvousBrowserPanel.this.mIconLabel.setIcon(null);
                        jList.clearSelection();
                    }
                }
            }
        }
    }
}

