/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.MenuManager;
import com.apple.gui.text.SelectAllAction;
import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import com.apple.util.Gestalt;
import com.apple.util.ImageUtilities;
import com.apple.util.StringUtilities;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.AboutBox;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertAdapter;
import com.apple.xsr.PreferencesWindow;
import com.apple.xsr.Resources;
import com.apple.xsr.SystemMonitorController;
import com.apple.xsr.Utilities;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultEditorKit;

public class RaidAdmin
implements MRJOpenDocumentHandler {
    public static final int MENU_BAR_TYPE_MANAGEMENT_DISABLED = 1;
    private static final int GRID_BAG_INSET_VALUE = 12;
    private Preferences preferences;
    private static SystemMonitorController monitorController;
    private AquaAlert firmwareUpdateAlert;
    public static String lastFirmwareFilePath;

    public RaidAdmin() throws MissingResourceException {
        Resources.load();
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setEnabled(true);
        toolTipManager.setInitialDelay(750);
        toolTipManager.setReshowDelay(500);
        if (Gestalt.isAquaLookAndFeel) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if (Gestalt.isMacLookAndFeel) {
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        }
        this.loadPreferences();
        if (!this.displayLicenseAgreementIfNeeded()) {
            this.runApplication();
        }
    }

    private void runApplication() {
        this.initMenuBar();
        monitorController = SystemMonitorController.getInstance();
        MRJApplicationUtils.registerOpenDocumentHandler(this);
    }

    private void loadPreferences() {
        this.preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
    }

    private void initMenuBar() {
        MenuManager menuManager = MenuManager.getInstance();
        AboutAction aboutAction = new AboutAction();
        MRJApplicationUtils.registerAboutHandler(aboutAction);
        menuManager.register("application.menu.misc.about", aboutAction);
        PrefsHandler prefsHandler = new PrefsHandler();
        MRJApplicationUtils.registerPrefsHandler(prefsHandler);
        menuManager.register("application.menu.misc.preferences", prefsHandler);
        QuitHandler quitHandler = new QuitHandler();
        MRJApplicationUtils.registerQuitHandler(quitHandler);
        menuManager.register("application.menu.misc.quit", quitHandler);
        menuManager.register("application.menu.file.closeWindow", menuManager.newCloseWindowListener());
        MenuManager.EditMenuListener editMenuListener = menuManager.newEditMenuListener("application.menu.edit.cut", "application.menu.edit.copy", "application.menu.edit.paste", "application.menu.edit.selectAll");
        menuManager.register("application.menu.edit", editMenuListener);
        DefaultEditorKit.CutAction cutAction = new DefaultEditorKit.CutAction();
        cutAction.putValue("Name", Resources.getString("application.menu.edit.cut"));
        cutAction.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.edit.cut.accelerator"));
        menuManager.register("application.menu.edit.cut", cutAction);
        DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
        copyAction.putValue("Name", Resources.getString("application.menu.edit.copy"));
        copyAction.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.edit.copy.accelerator"));
        menuManager.register("application.menu.edit.copy", copyAction);
        DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
        pasteAction.putValue("Name", Resources.getString("application.menu.edit.paste"));
        pasteAction.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.edit.paste.accelerator"));
        menuManager.register("application.menu.edit.paste", pasteAction);
        SelectAllAction selectAllAction = new SelectAllAction();
        selectAllAction.putValue("Name", Resources.getString("application.menu.edit.selectAll"));
        selectAllAction.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.edit.selectAll.accelerator"));
        menuManager.register("application.menu.edit.selectAll", selectAllAction);
        menuManager.register("application.menu.help.appHelp", new HelpListener());
    }

    private boolean displayLicenseAgreementIfNeeded() {
        boolean bl = false;
        if (!this.preferences.exists("LicenseAgreementAccepted")) {
            bl = true;
            LicensePanel licensePanel = new LicensePanel();
            final JFrame jFrame = new JFrame();
            jFrame.setTitle(Resources.getString("licenseAgreement.title"));
            jFrame.setDefaultCloseOperation(3);
            jFrame.setContentPane(licensePanel);
            JButton jButton = licensePanel.getAcceptButton();
            JButton jButton2 = licensePanel.getDeclineButton();
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.dispose();
                    RaidAdmin.this.preferences.setBoolean("LicenseAgreementAccepted", true);
                    RaidAdmin.this.preferences.synchronize();
                    RaidAdmin.this.runApplication();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.dispose();
                    new QuitHandler().handleQuit();
                }
            });
            jFrame.setSize(licensePanel.getPreferredSize());
            jFrame.show();
        }
        return bl;
    }

    public static String getAppVersion() {
        return Resources.getAppVersion();
    }

    public static int[] getSupportedProductIds() {
        int[] nArray = new int[]{2, 4};
        return nArray;
    }

    public static SystemMonitorController getMonitorController() {
        return monitorController;
    }

    public static JMenuBar newMenuBar(int n) {
        JMenu jMenu;
        JMenuBar jMenuBar = null;
        if (n == 1 && (jMenu = MenuManager.getMenu(jMenuBar = MenuManager.getInstance().newMenuBar(), "application.menu.system")) != null) {
            MenuManager.removeActions(jMenu);
            MenuManager.setMenuEnabled(jMenu, false);
        }
        return jMenuBar;
    }

    public void handleOpenFile(File file) {
        lastFirmwareFilePath = file.getParent();
        if (this.firmwareUpdateAlert == null) {
            String string = Resources.getString("firmwareAlert.message");
            string = StringUtilities.replaceAll(string, "{filename}", file.getName());
            this.firmwareUpdateAlert = AquaAlert.createStandardAquaAlert(string, Resources.getString("firmwareAlert.explanation"), Resources.getImage("icon.firmware").getScaledInstance(48, 48, 4), Resources.getString("ok"), null, null);
            AquaAlertAdapter aquaAlertAdapter = new AquaAlertAdapter(){

                public void aquaAlertDismissed(int n, Object object) {
                    RaidAdmin.this.firmwareUpdateAlert = null;
                }
            };
            this.firmwareUpdateAlert.showSheet(RaidAdmin.monitorController.monitorWindow, aquaAlertAdapter, null);
        }
    }

    static class HelpListener
    implements ActionListener {
        HelpListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                BrowserLauncher.openURL(Resources.getString("helpURL"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PrefsHandler
    implements ActionListener,
    MRJPrefsHandler {
        PrefsHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PreferencesWindow preferencesWindow = PreferencesWindow.getSharedInstance();
            if (!preferencesWindow.isVisible()) {
                Utilities.setWindowLocationRelativeToComponent(preferencesWindow, monitorController.monitorWindow);
            }
            preferencesWindow.show();
        }

        public void handlePrefs() {
            this.actionPerformed(new ActionEvent(this, 1001, "PREFS_MENU_ITEM_SELECTED"));
        }
    }

    class QuitHandler
    implements ActionListener,
    MRJQuitHandler {
        QuitHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (monitorController != null && monitorController.monitorWindow != null) {
                monitorController.monitorWindow.updatePreferences();
            }
            System.exit(0);
        }

        public void handleQuit() {
            this.actionPerformed(new ActionEvent(this, 1001, "QUIT_MENU_ITEM_SELECTED"));
        }
    }

    static class AboutAction
    extends AbstractAction
    implements ActionListener,
    MRJAboutHandler {
        public static final String COMMAND_KEY = "about";

        public AboutAction() {
            String string = Resources.getStringWithReplacement("application.menu.misc.about", new String[]{"appName", Resources.getString("appName")});
            this.putValue("Name", string);
            this.putValue("ActionCommandKey", COMMAND_KEY);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AboutBox aboutBox = AboutBox.getSharedInstance();
            aboutBox.setResizable(false);
            Utilities.setWindowLocationRelativeToComponent(aboutBox, monitorController.getMonitorWindow());
            aboutBox.show();
        }

        public void handleAbout() {
            this.actionPerformed(new ActionEvent(this, 1001, COMMAND_KEY));
        }
    }

    class LicensePanel
    extends JPanel {
        private JComboBox mLanguageSelectPopUp;
        private InvertableImageIcon[] mLicenseLanguageIcons;
        private JScrollPane mScrollPane;
        private JButton mAcceptButton;
        private JButton mDeclineButton;
        private JLabel brazilianPortugueseLabel = null;
        private JLabel danishLabel = null;
        private JLabel dutchLabel = null;
        private JLabel englishLabel = null;
        private JLabel finnishLabel = null;
        private JLabel frenchLabel = null;
        private JLabel germanLabel = null;
        private JLabel italianLabel = null;
        private JLabel japaneseLabel = null;
        private JLabel koreanLabel = null;
        private JLabel norwegianLabel = null;
        private JLabel simplifiedChineseLabel = null;
        private JLabel spanishLabel = null;
        private JLabel swedishLabel = null;
        private JLabel traditionalChineseLabel = null;
        private ImageIcon brazilianPortugueseYesLabel = null;
        private ImageIcon danishYesLabel = null;
        private ImageIcon dutchYesLabel = null;
        private ImageIcon englishYesLabel = null;
        private ImageIcon finnishYesLabel = null;
        private ImageIcon frenchYesLabel = null;
        private ImageIcon germanYesLabel = null;
        private ImageIcon italianYesLabel = null;
        private ImageIcon japaneseYesLabel = null;
        private ImageIcon koreanYesLabel = null;
        private ImageIcon norwegianYesLabel = null;
        private ImageIcon simplifiedChineseYesLabel = null;
        private ImageIcon spanishYesLabel = null;
        private ImageIcon swedishYesLabel = null;
        private ImageIcon traditionalChineseYesLabel = null;
        private ImageIcon brazilianPortugueseNoLabel = null;
        private ImageIcon danishNoLabel = null;
        private ImageIcon dutchNoLabel = null;
        private ImageIcon englishNoLabel = null;
        private ImageIcon finnishNoLabel = null;
        private ImageIcon frenchNoLabel = null;
        private ImageIcon germanNoLabel = null;
        private ImageIcon italianNoLabel = null;
        private ImageIcon japaneseNoLabel = null;
        private ImageIcon koreanNoLabel = null;
        private ImageIcon norwegianNoLabel = null;
        private ImageIcon simplifiedChineseNoLabel = null;
        private ImageIcon spanishNoLabel = null;
        private ImageIcon swedishNoLabel = null;
        private ImageIcon traditionalChineseNoLabel = null;
        private static final int LICENSE_PANEL_WIDTH = 660;
        private static final int LICENSE_PANEL_HEIGHT = 400;

        public LicensePanel() {
            EmptyBorder emptyBorder = new EmptyBorder(12, 12, 16, 12);
            this.setBorder(emptyBorder);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Box box = Box.createHorizontalBox();
            this.mAcceptButton = GUIFactory.newButton();
            this.mDeclineButton = GUIFactory.newButton();
            this.mLicenseLanguageIcons = new InvertableImageIcon[15];
            this.mLanguageSelectPopUp = new JComboBox();
            this.preparePopUp();
            this.mLanguageSelectPopUp.setMaximumSize(this.mLanguageSelectPopUp.getPreferredSize());
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            this.add((Component)this.mLanguageSelectPopUp, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.mScrollPane = new JScrollPane();
            this.mScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.mScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            this.mScrollPane.setVerticalScrollBarPolicy(22);
            this.mScrollPane.getViewport().setBackground(Color.white);
            this.add((Component)this.mScrollPane, gridBagConstraints);
            this.switchLicenseAgreementUI(Resources.getInt("licenseAgreement.defaultLanguageIndex"));
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            box.add(this.mDeclineButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(this.mAcceptButton);
            this.add((Component)box, gridBagConstraints);
        }

        public void preparePopUp() {
            this.mLicenseLanguageIcons[11] = new InvertableImageIcon(Resources.getImage("licenseAgreement.brazilianPortugueseLanguagePopup"));
            this.mLicenseLanguageIcons[7] = new InvertableImageIcon(Resources.getImage("licenseAgreement.danishLanguagePopup"));
            this.mLicenseLanguageIcons[0] = new InvertableImageIcon(Resources.getImage("licenseAgreement.dutchLanguagePopup"));
            this.mLicenseLanguageIcons[1] = new InvertableImageIcon(Resources.getImage("licenseAgreement.englishLanguagePopup"));
            this.mLicenseLanguageIcons[8] = new InvertableImageIcon(Resources.getImage("licenseAgreement.finnishLanguagePopup"));
            this.mLicenseLanguageIcons[2] = new InvertableImageIcon(Resources.getImage("licenseAgreement.frenchLanguagePopup"));
            this.mLicenseLanguageIcons[3] = new InvertableImageIcon(Resources.getImage("licenseAgreement.germanLanguagePopup"));
            this.mLicenseLanguageIcons[4] = new InvertableImageIcon(Resources.getImage("licenseAgreement.italianLanguagePopup"));
            this.mLicenseLanguageIcons[5] = new InvertableImageIcon(Resources.getImage("licenseAgreement.japaneseLanguagePopup"));
            this.mLicenseLanguageIcons[9] = new InvertableImageIcon(Resources.getImage("licenseAgreement.koreanLanguagePopup"));
            this.mLicenseLanguageIcons[10] = new InvertableImageIcon(Resources.getImage("licenseAgreement.norwegianLanguagePopup"));
            this.mLicenseLanguageIcons[13] = new InvertableImageIcon(Resources.getImage("licenseAgreement.simplifiedChineseLanguagePopup"));
            this.mLicenseLanguageIcons[6] = new InvertableImageIcon(Resources.getImage("licenseAgreement.spanishLanguagePopup"));
            this.mLicenseLanguageIcons[12] = new InvertableImageIcon(Resources.getImage("licenseAgreement.swedishLanguagePopup"));
            this.mLicenseLanguageIcons[14] = new InvertableImageIcon(Resources.getImage("licenseAgreement.traditionalChineseLanguagePopup"));
            for (int i = 0; i < 15; ++i) {
                this.mLanguageSelectPopUp.addItem(this.mLicenseLanguageIcons[i]);
            }
            this.mLanguageSelectPopUp.addActionListener(new ActionListener(this){
                private final /* synthetic */ LicensePanel this$1;
                {
                    this.this$1 = licensePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = LicensePanel.access$300(this.this$1).getSelectedIndex();
                    this.this$1.switchLicenseAgreementUI(n);
                }
            });
            this.mLanguageSelectPopUp.setRenderer(new LanguageMenuRenderer());
            this.mLanguageSelectPopUp.setMaximumRowCount(15);
        }

        public void switchLicenseAgreementUI(int n) {
            if (this.mLanguageSelectPopUp.getSelectedIndex() != n) {
                this.mLanguageSelectPopUp.setSelectedIndex(n);
            }
            JViewport jViewport = this.mScrollPane.getViewport();
            switch (n) {
                case 11: {
                    if (this.brazilianPortugueseLabel == null) {
                        this.brazilianPortugueseLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.brazilianPortugueseLanguageAgreement")));
                        this.brazilianPortugueseYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.brazilianPortugueseButtonYes"));
                        this.brazilianPortugueseNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.brazilianPortugueseButtonNo"));
                    }
                    this.syncInterface(this.brazilianPortugueseLabel, this.brazilianPortugueseYesLabel, this.brazilianPortugueseNoLabel);
                    break;
                }
                case 7: {
                    if (this.danishLabel == null) {
                        this.danishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.danishLanguageAgreement")));
                        this.danishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.danishButtonYes"));
                        this.danishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.danishButtonNo"));
                    }
                    this.syncInterface(this.danishLabel, this.danishYesLabel, this.danishNoLabel);
                    break;
                }
                case 0: {
                    if (this.dutchLabel == null) {
                        this.dutchLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.dutchLanguageAgreement")));
                        this.dutchYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.dutchButtonYes"));
                        this.dutchNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.dutchButtonNo"));
                    }
                    this.syncInterface(this.dutchLabel, this.dutchYesLabel, this.dutchNoLabel);
                    break;
                }
                case 1: {
                    if (this.englishLabel == null) {
                        this.englishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.englishLanguageAgreement")));
                        this.englishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.englishButtonYes"));
                        this.englishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.englishButtonNo"));
                    }
                    this.syncInterface(this.englishLabel, this.englishYesLabel, this.englishNoLabel);
                    break;
                }
                case 8: {
                    if (this.finnishLabel == null) {
                        this.finnishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.finnishLanguageAgreement")));
                        this.finnishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.finnishButtonYes"));
                        this.finnishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.finnishButtonNo"));
                    }
                    this.syncInterface(this.finnishLabel, this.finnishYesLabel, this.finnishNoLabel);
                    break;
                }
                case 2: {
                    if (this.frenchLabel == null) {
                        this.frenchLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.frenchLanguageAgreement")));
                        this.frenchYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.frenchButtonYes"));
                        this.frenchNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.frenchButtonNo"));
                    }
                    this.syncInterface(this.frenchLabel, this.frenchYesLabel, this.frenchNoLabel);
                    break;
                }
                case 3: {
                    if (this.germanLabel == null) {
                        this.germanLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.germanLanguageAgreement")));
                        this.germanYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.germanButtonYes"));
                        this.germanNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.germanButtonNo"));
                    }
                    this.syncInterface(this.germanLabel, this.germanYesLabel, this.germanNoLabel);
                    break;
                }
                case 4: {
                    if (this.italianLabel == null) {
                        this.italianLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.italianLanguageAgreement")));
                        this.italianYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.italianButtonYes"));
                        this.italianNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.italianButtonNo"));
                    }
                    this.syncInterface(this.italianLabel, this.italianYesLabel, this.italianNoLabel);
                    break;
                }
                case 5: {
                    if (this.japaneseLabel == null) {
                        this.japaneseLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.japaneseLanguageAgreement")));
                        this.japaneseYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.japaneseButtonYes"));
                        this.japaneseNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.japaneseButtonNo"));
                    }
                    this.syncInterface(this.japaneseLabel, this.japaneseYesLabel, this.japaneseNoLabel);
                    break;
                }
                case 9: {
                    if (this.koreanLabel == null) {
                        this.koreanLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.koreanLanguageAgreement")));
                        this.koreanYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.koreanButtonYes"));
                        this.koreanNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.koreanButtonNo"));
                    }
                    this.syncInterface(this.koreanLabel, this.koreanYesLabel, this.koreanNoLabel);
                    break;
                }
                case 10: {
                    if (this.norwegianLabel == null) {
                        this.norwegianLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.norwegianLanguageAgreement")));
                        this.norwegianYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.norwegianButtonYes"));
                        this.norwegianNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.norwegianButtonNo"));
                    }
                    this.syncInterface(this.norwegianLabel, this.norwegianYesLabel, this.norwegianNoLabel);
                    break;
                }
                case 13: {
                    if (this.simplifiedChineseLabel == null) {
                        this.simplifiedChineseLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.simplifiedChineseLanguageAgreement")));
                        this.simplifiedChineseYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.simplifiedChineseButtonYes"));
                        this.simplifiedChineseNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.simplifiedChineseButtonNo"));
                    }
                    this.syncInterface(this.simplifiedChineseLabel, this.simplifiedChineseYesLabel, this.simplifiedChineseNoLabel);
                    break;
                }
                case 6: {
                    if (this.spanishLabel == null) {
                        this.spanishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.spanishLanguageAgreement")));
                        this.spanishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.spanishButtonYes"));
                        this.spanishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.spanishButtonNo"));
                    }
                    this.syncInterface(this.spanishLabel, this.spanishYesLabel, this.spanishNoLabel);
                    break;
                }
                case 12: {
                    if (this.swedishLabel == null) {
                        this.swedishLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.swedishLanguageAgreement")));
                        this.swedishYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.swedishButtonYes"));
                        this.swedishNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.swedishButtonNo"));
                    }
                    this.syncInterface(this.swedishLabel, this.swedishYesLabel, this.swedishNoLabel);
                    break;
                }
                case 14: {
                    if (this.traditionalChineseLabel == null) {
                        this.traditionalChineseLabel = new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.traditionalChineseLanguageAgreement")));
                        this.traditionalChineseYesLabel = new ImageIcon(Resources.getImage("licenseAgreement.traditionalChineseButtonYes"));
                        this.traditionalChineseNoLabel = new ImageIcon(Resources.getImage("licenseAgreement.traditionalChineseButtonNo"));
                    }
                    this.syncInterface(this.traditionalChineseLabel, this.traditionalChineseYesLabel, this.traditionalChineseNoLabel);
                    break;
                }
                default: {
                    this.syncInterface(null, null, null);
                }
            }
        }

        private void syncInterface(JLabel jLabel, ImageIcon imageIcon, ImageIcon imageIcon2) {
            if (jLabel != null) {
                this.mScrollPane.getViewport().setView(jLabel);
            } else {
                this.mScrollPane.getViewport().setView(new JLabel(new ImageIcon(Resources.getImage("licenseAgreement.defaultPath"))));
            }
            if (imageIcon != null) {
                this.mAcceptButton.setIcon(imageIcon);
                this.mAcceptButton.setMargin(new Insets(2, 10, 2, 10));
                this.mAcceptButton.setText(null);
            } else {
                this.mAcceptButton.setText(Resources.getString("licenseAgreement.acceptButton"));
                this.mAcceptButton.setMargin(null);
                this.mAcceptButton.setIcon(null);
            }
            if (imageIcon2 != null) {
                this.mDeclineButton.setIcon(imageIcon2);
                this.mDeclineButton.setMargin(new Insets(2, 10, 2, 10));
                this.mDeclineButton.setText(null);
            } else {
                this.mDeclineButton.setText(Resources.getString("licenseAgreement.declineButton"));
                this.mDeclineButton.setMargin(null);
                this.mDeclineButton.setIcon(null);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(660, 400);
        }

        public JButton getAcceptButton() {
            return this.mAcceptButton;
        }

        public JButton getDeclineButton() {
            return this.mDeclineButton;
        }

        static /* synthetic */ JComboBox access$300(LicensePanel licensePanel) {
            return licensePanel.mLanguageSelectPopUp;
        }

        private class InvertableImageIcon
        extends ImageIcon {
            final int marginX = 22;
            final int marginY = 1;
            Image invertedImage = null;
            boolean inverted = false;

            InvertableImageIcon(Image image) {
                super(image);
            }

            public int getIconWidth() {
                return super.getIconWidth() + 44;
            }

            public int getIconHeight() {
                return super.getIconHeight() + 2;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                if (this.invertedImage == null) {
                    this.invertedImage = component.createImage(new FilteredImageSource(this.getImage().getSource(), ImageUtilities.getInvertingFilterInstance()));
                    MediaTracker mediaTracker = new MediaTracker(component);
                    mediaTracker.addImage(this.invertedImage, 0);
                    try {
                        mediaTracker.waitForAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    mediaTracker.removeImage(this.invertedImage);
                }
                if (this.inverted && this.invertedImage != null) {
                    graphics.drawImage(this.invertedImage, n + 22, n2 + 1, null);
                } else {
                    super.paintIcon(component, graphics, n + 22, n2 + 1);
                }
            }

            public void setInverted(boolean bl) {
                this.inverted = bl;
            }
        }

        private class LanguageMenuRenderer
        extends DefaultListCellRenderer {
            private LanguageMenuRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                ((InvertableImageIcon)((JLabel)component).getIcon()).setInverted(bl && n > -1);
                return component;
            }
        }
    }
}

