/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.VersionNumber;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.SystemController;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class OperationManager {
    public static final Operation OP_MONITOR = new Operation("*", "*");
    public static final Operation OP_CREATE_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_DELETE_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_SLICE_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_EXPAND_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_VERIFY_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_REBUILD_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_CONFIGURE_LUN_MASKING = new Operation("1.2+", "*");
    public static final Operation OP_CONFIGURE_SYSTEM_SETTINGS = new Operation("*", "*");
    public static final Operation OP_CONFIGURE_NOTIFICATIONS = new Operation("*", "*");
    public static final Operation OP_TOGGLE_SERVICE_ID = new Operation("*", "*");
    public static final Operation OP_CLEAR_EVENT_LOG = new Operation("*", "*");
    public static final Operation OP_CLEAR_ERROR_STATUS = new Operation("*", "*");
    public static final Operation OP_RESTART = new Operation("*", "*");
    public static final Operation OP_SHUTDOWN = new Operation("*", "*");
    public static final Operation OP_RESET_RAID_CONTROLLER = new Operation("*", "1.50+");
    public static final Operation OP_REPAIR_LUN_MAP = new Operation("1.2+", "*");
    public static final Operation OP_UPDATE_FIRMWARE = new Operation("*", "*");
    public static final Operation OP_BACKGROUND_CONDITION = new Operation("1.5b4+", "*");
    public static final Operation OP_DELETE_ORPHAN = new Operation("1.5b4+", "*");
    public static final Operation OP_READ_EVENT_LOG = new Operation("1.2+", "*");
    public static final Operation OP_CONFIGURE_DISK_CACHE = new Operation("*", "*");
    public static final Operation OP_CONFIGURE_SYNC_CACHE = new Operation("1.5b4+", "*");
    public static final Operation OP_CONFIGURE_SLOW_READ_BYPASS = new Operation("1.5b4+", "*");
    private static final boolean DEBUG = true;
    static /* synthetic */ Class class$com$apple$xsr$OperationManager$Operation;

    public static boolean isSupported(RaidSystem raidSystem, Operation operation) throws Exception {
        if (raidSystem == null) {
            throw new NullPointerException("system cannot be null");
        }
        if (operation == null) {
            throw new NullPointerException("operation cannot be null");
        }
        return operation.isSupported(raidSystem);
    }

    public static boolean isSupported(RaidSystem raidSystem, int n, Operation operation) throws Exception {
        if (raidSystem == null) {
            throw new NullPointerException("system cannot be null");
        }
        if (operation == null) {
            throw new NullPointerException("operation cannot be null");
        }
        return operation.isSupported(raidSystem, n);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            VersionNumber versionNumber = VersionNumber.newAppleVersionNumber("1.2.1");
            VersionNumber versionNumber2 = VersionNumber.newAcsVersionNumber("2.1");
            ++n;
            if (!OP_MONITOR.isSupported(versionNumber, versionNumber2)) {
                throw new RuntimeException("Failed unit test " + n + ".");
            }
            ++n;
            if (!OP_CREATE_ARRAY.isSupported(versionNumber, versionNumber2)) {
                throw new RuntimeException("Failed unit test " + n + ".");
            }
            ++n;
            if (!OP_DELETE_ARRAY.isSupported(versionNumber, versionNumber2)) {
                throw new RuntimeException("Failed unit test " + n + ".");
            }
            versionNumber = VersionNumber.newAppleVersionNumber("1.1.9");
            ++n;
            if (OP_CREATE_ARRAY.isSupported(versionNumber, versionNumber2)) {
                throw new RuntimeException("Failed unit test " + n + ".");
            }
            ++n;
            if (OP_DELETE_ARRAY.isSupported(versionNumber, versionNumber2)) {
                throw new RuntimeException("Failed unit test " + n + ".");
            }
            System.out.println("ALL TESTS PASSED");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\n\nTEST FAILED\n");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Operation {
        public static final int ANY = 0;
        public static final int NONE = 1;
        public static final int EQ = 2;
        public static final int NE = 3;
        public static final int GE = 4;
        public static final int LE = 5;
        public static final int LT = 6;
        public static final int GT = 7;
        public static final int COPROCESSOR = 0;
        public static final int RAID_CONTROLLER = 1;
        private VersionNumber coprocessorVersion;
        private VersionNumber controllerVersion;
        private int coprocessorQualifier;
        private int controllerQualifier;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$OperationManager$Operation == null ? (class$com$apple$xsr$OperationManager$Operation = OperationManager.class$("com.apple.xsr.OperationManager$Operation")) : class$com$apple$xsr$OperationManager$Operation);

        public Operation(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("coprocessor version cannot be null");
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("coprocessor version cannot be empty");
            }
            if (string2 == null) {
                throw new NullPointerException("RAID controller version cannot be null");
            }
            if (string2.length() == 0) {
                throw new IllegalArgumentException("RAID controller version cannot be empty");
            }
            try {
                this.parseSpecifier(string, 0);
                this.parseSpecifier(string2, 1);
            }
            catch (ParseException parseException) {
                this.coprocessorQualifier = 0;
                this.controllerQualifier = 0;
                logger.error(parseException);
            }
        }

        public boolean isSupported(RaidSystem raidSystem) throws Exception {
            RaidController raidController;
            SystemController systemController;
            if (raidSystem == null) {
                throw new NullPointerException("system cannot be null");
            }
            VersionNumber versionNumber = null;
            VersionNumber versionNumber2 = null;
            VersionNumber versionNumber3 = null;
            VersionNumber versionNumber4 = null;
            Boolean bl = null;
            Boolean bl2 = null;
            if (raidSystem.isControllerModulePresent(1)) {
                try {
                    systemController = raidSystem.getSystemController(1);
                    if (systemController != null) {
                        versionNumber = VersionNumber.newAppleVersionNumber(systemController.getSystemVersion());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    raidController = raidSystem.getRaidController(1);
                    if (raidController != null) {
                        versionNumber2 = VersionNumber.newAcsVersionNumber(raidController.getFirmwareVersion());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = new Boolean(this.isSupported(versionNumber, versionNumber2));
            }
            if (raidSystem.isControllerModulePresent(2)) {
                try {
                    systemController = raidSystem.getSystemController(2);
                    if (systemController != null) {
                        versionNumber3 = VersionNumber.newAppleVersionNumber(systemController.getSystemVersion());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    raidController = raidSystem.getRaidController(2);
                    if (raidController != null) {
                        versionNumber4 = VersionNumber.newAcsVersionNumber(raidController.getFirmwareVersion());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl2 = new Boolean(this.isSupported(versionNumber3, versionNumber4));
            }
            if (bl != null && bl2 != null) {
                return bl != false && bl2 != false;
            }
            if (bl != null) {
                return bl;
            }
            if (bl2 != null) {
                return bl2;
            }
            throw new Exception("Unable to determine compatibility. No version information available.");
        }

        public boolean isSupported(RaidSystem raidSystem, int n) throws Exception {
            RaidController raidController;
            if (raidSystem == null) {
                throw new NullPointerException("system cannot be null");
            }
            VersionNumber versionNumber = null;
            VersionNumber versionNumber2 = null;
            SystemController systemController = raidSystem.getSystemController(n);
            if (systemController != null) {
                try {
                    versionNumber = VersionNumber.newAppleVersionNumber(systemController.getSystemVersion());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((raidController = raidSystem.getRaidController(n)) != null) {
                try {
                    versionNumber2 = VersionNumber.newAcsVersionNumber(raidController.getFirmwareVersion());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.isSupported(versionNumber, versionNumber2);
        }

        public boolean isSupported(VersionNumber versionNumber, VersionNumber versionNumber2) throws Exception {
            boolean bl = this.compare(versionNumber, this.coprocessorVersion, this.coprocessorQualifier);
            boolean bl2 = this.compare(versionNumber2, this.controllerVersion, this.controllerQualifier);
            return bl && bl2;
        }

        public VersionNumber getSupportedVersion(int n) {
            if (n == 0) {
                return this.coprocessorVersion;
            }
            if (n == 1) {
                return this.controllerVersion;
            }
            throw new IllegalArgumentException("Invalid component (" + n + ")");
        }

        public int getQualifier(int n) {
            if (n == 0) {
                return this.coprocessorQualifier;
            }
            if (n == 1) {
                return this.controllerQualifier;
            }
            throw new IllegalArgumentException("Invalid component (" + n + ")");
        }

        public String getQualifierAsString(int n) {
            int n2 = this.getQualifier(n);
            String string = n2 == 0 ? "*" : (n2 == 1 ? "None" : (n2 == 2 ? "=" : (n2 == 3 ? "!=" : (n2 == 4 ? ">=" : (n2 == 5 ? "<=" : (n2 == 6 ? "<" : (n2 == 7 ? ">" : "")))))));
            return string;
        }

        public String toString() {
            String string = "Coprocessor ";
            string = this.coprocessorQualifier != 0 ? string + this.getQualifierAsString(0) + this.coprocessorVersion + ", Controller " : string + "*, Controller";
            string = this.controllerQualifier != 0 ? string + this.getQualifierAsString(1) + this.controllerVersion : string + "*";
            return string;
        }

        private boolean compare(VersionNumber versionNumber, VersionNumber versionNumber2, int n) throws Exception {
            boolean bl;
            if (n == 0) {
                bl = true;
            } else if (n == 1) {
                bl = false;
            } else if (n == 2) {
                if (versionNumber == null) {
                    throw new Exception("Error performing EQ comparison: installed version null");
                }
                if (versionNumber2 == null) {
                    throw new Exception("Error performing EQ comparison: supported version null");
                }
                bl = versionNumber.compareTo(versionNumber2) == 0;
            } else if (n == 3) {
                if (versionNumber == null) {
                    throw new Exception("Error performing NE comparison: installed version null");
                }
                if (versionNumber2 == null) {
                    throw new Exception("Error performing NE comparison: supported version null");
                }
                bl = versionNumber.compareTo(versionNumber2) != 0;
            } else if (n == 4) {
                if (versionNumber == null) {
                    throw new Exception("Error performing GE comparison: installed version null");
                }
                if (versionNumber2 == null) {
                    throw new Exception("Error performing GE comparison: supported version null");
                }
                bl = versionNumber.compareTo(versionNumber2) == 0 || versionNumber.compareTo(versionNumber2) > 0;
            } else if (n == 5) {
                if (versionNumber == null) {
                    throw new Exception("Error performing LE comparison: installed version null");
                }
                if (versionNumber2 == null) {
                    throw new Exception("Error performing LE comparison: supported version null");
                }
                bl = versionNumber.compareTo(versionNumber2) == 0 || versionNumber.compareTo(versionNumber2) < 0;
            } else if (n == 7) {
                if (versionNumber == null) {
                    throw new Exception("Error performing GT comparison: installed version null");
                }
                if (versionNumber2 == null) {
                    throw new Exception("Error performing GT comparison: supported version null");
                }
                bl = versionNumber.compareTo(versionNumber2) > 0;
            } else if (n == 6) {
                if (versionNumber == null) {
                    throw new Exception("Error performing LT comparison: installed version null");
                }
                if (versionNumber2 == null) {
                    throw new Exception("Error performing LT comparison: supported version null");
                }
                bl = versionNumber.compareTo(versionNumber2) < 0;
            } else {
                throw new IllegalArgumentException("Unrecognized qualifier: " + n);
            }
            return bl;
        }

        private void parseSpecifier(String string, int n) throws ParseException {
            int n2 = -1;
            String string2 = null;
            if (string.startsWith("*")) {
                if (string.length() > 1) {
                    throw new ParseException("Illegal characters following '*': " + string, 1);
                }
                n2 = 0;
            }
            if (string.startsWith("+")) {
                if (string.length() < 2) {
                    throw new ParseException("Missing version: " + string, 1);
                }
                n2 = 7;
                string2 = string.substring(1);
            }
            if (string.startsWith("-")) {
                if (string.length() < 2) {
                    throw new ParseException("Missing version: " + string, 1);
                }
                n2 = 6;
                string2 = string.substring(1);
            }
            if (string.startsWith("!")) {
                if (string.length() < 2) {
                    throw new ParseException("Missing version: " + string, 1);
                }
                n2 = 3;
                string2 = string.substring(1);
            }
            if (string.endsWith("+")) {
                if (n2 != -1) {
                    throw new ParseException("Multiple qualifiers: " + string, 0);
                }
                if (string.length() < 2) {
                    throw new ParseException("Missing version: " + string, 1);
                }
                n2 = 4;
                string2 = string.substring(0, string.length() - 1);
            }
            if (string.endsWith("-")) {
                if (n2 != -1) {
                    throw new ParseException("Multiple qualifiers:" + string, 0);
                }
                if (string.length() < 2) {
                    throw new ParseException("Missing version: " + string, 1);
                }
                n2 = 5;
                string2 = string.substring(0, string.length() - 1);
            }
            if (n2 == -1) {
                if (string.length() == 0) {
                    throw new ParseException("Missing version: " + string, 0);
                }
                n2 = 2;
                string2 = string;
            }
            if (n == 0) {
                this.coprocessorQualifier = n2;
                if (string2 != null) {
                    this.coprocessorVersion = VersionNumber.newAppleVersionNumber(string2);
                }
            } else if (n == 1) {
                this.controllerQualifier = n2;
                if (string2 != null) {
                    this.controllerVersion = VersionNumber.newAcsVersionNumber(string2);
                }
            }
        }
    }
}

