/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.AquaTableCellBorder;
import com.apple.xsr.DataModel;
import com.apple.xsr.GridBagPanel;
import com.apple.xsr.NotificationsModel;
import com.apple.xsr.Resources;
import com.apple.xsr.TestEmail;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class NotificationsPane
extends AbstractManagementPane {
    private NotificationsPaneInner mNotificationsPaneInner = null;
    private JButton mApplyButton = null;
    private JButton mCancelButton = null;
    private static final int preferredWidth = 588;
    private static final int preferredHeight = 454;

    public NotificationsPane() {
        super(588, 454);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(0, 8, 0, 8));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.mNotificationsPaneInner = new NotificationsPaneInner();
        this.add((Component)this.mNotificationsPaneInner, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        this.add(Box.createVerticalStrut(0), gridBagConstraints);
        this.mApplyButton = GUIFactory.newOKButton();
        this.mApplyButton.setFont(GUIFactory.FONT_SMALL);
        this.mApplyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(NotificationsPane.this, 1001, "APPLY");
                NotificationsPane.this.fireActionPerformed(actionEvent2);
            }
        });
        this.mCancelButton = GUIFactory.newCancelButton();
        this.mCancelButton.setFont(GUIFactory.FONT_SMALL);
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(NotificationsPane.this, 1001, "CANCEL");
                NotificationsPane.this.fireActionPerformed(actionEvent2);
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(this.mCancelButton);
        box.add(Box.createHorizontalStrut(12));
        box.add(this.mApplyButton);
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add((Component)box, gridBagConstraints);
    }

    public void populateUI(DataModel dataModel) {
        if (dataModel == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (!(dataModel instanceof NotificationsModel)) {
            throw new IllegalArgumentException("illegal data model type " + dataModel.getClass());
        }
        this.mNotificationsPaneInner.populateUI((NotificationsModel)dataModel);
    }

    public boolean validateUI(DataModel dataModel) {
        boolean bl = this.mNotificationsPaneInner.checkValidity();
        if (dataModel != null) {
            if (!(dataModel instanceof NotificationsModel)) {
                throw new IllegalArgumentException("illegal data model type " + dataModel.getClass());
            }
            if (bl) {
                this.mNotificationsPaneInner.fillInModel((NotificationsModel)dataModel);
            }
        }
        return bl;
    }

    public boolean allowAbort() {
        return true;
    }

    public class NotificationsPaneInner
    extends JPanel
    implements AquaAlertListener {
        public static final int GRID_BAG_INSET_VALUE = 8;
        private static final int TABLE_ROW_HEIGHT = 20;
        private static final int REMOVE_EMAIL_ADDRESS_MODE = 1;
        private static final int SEND_TEST_EMAIL_MODE = 2;
        private EmailTableModel mEmailModel = null;
        private JTable mTable = null;
        private JButton mRemoveEmailButton = null;
        private JButton mEditEmailButton = null;
        private JButton mSendTestEmailButton = null;
        private SMTPPanel mSMTPPanel = null;

        public NotificationsPaneInner() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(8, 0, 8, 0));
            this.mEmailModel = new EmailTableModel();
            this.mTable = GUIFactory.newTable(this.mEmailModel);
            this.mTable.setAutoResizeMode(3);
            this.mTable.addMouseListener(new MouseAdapter(this, NotificationsPane.this){
                private final /* synthetic */ NotificationsPane val$this$0;
                private final /* synthetic */ NotificationsPaneInner this$1;
                {
                    this.this$1 = notificationsPaneInner;
                    this.val$this$0 = notificationsPane;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() >= 2 && NotificationsPaneInner.access$000(this.this$1).getSelectedRow() != -1) {
                        NotificationsPaneInner.access$100(this.this$1);
                    }
                }
            });
            this.mRemoveEmailButton = GUIFactory.newButton(Resources.getString("notifications.removeEmailButton"));
            this.mEditEmailButton = GUIFactory.newButton(Resources.getString("notifications.editEmailButton"));
            this.mSendTestEmailButton = GUIFactory.newButton(Resources.getString("notifications.testNotifications"));
            JLabel jLabel = this.jlabelWithFont(Resources.getString("notifications.listOfEmailAddresses"), GUIFactory.FONT_SMALL);
            JLabel jLabel2 = this.jlabelWithFont(Resources.getString("notifications.emailTo"), GUIFactory.FONT_SMALL);
            JScrollPane jScrollPane = new JScrollPane(this.mTable);
            JButton jButton = GUIFactory.newButton(Resources.getString("notifications.addEmailButton"));
            jScrollPane.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ NotificationsPaneInner this$1;
                {
                    this.this$1 = notificationsPaneInner;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (NotificationsPaneInner.access$000(this.this$1).rowAtPoint(mouseEvent.getPoint()) == -1) {
                        NotificationsPaneInner.access$000(this.this$1).clearSelection();
                    }
                }
            });
            jButton.setFont(GUIFactory.FONT_SMALL);
            this.mRemoveEmailButton.setFont(GUIFactory.FONT_SMALL);
            this.mEditEmailButton.setFont(GUIFactory.FONT_SMALL);
            this.mSendTestEmailButton.setFont(GUIFactory.FONT_SMALL);
            this.mRemoveEmailButton.setEnabled(false);
            this.mEditEmailButton.setEnabled(false);
            this.mSendTestEmailButton.setEnabled(false);
            jButton.addActionListener(new ActionListener(this, NotificationsPane.this){
                private final /* synthetic */ NotificationsPane val$this$0;
                private final /* synthetic */ NotificationsPaneInner this$1;
                {
                    this.this$1 = notificationsPaneInner;
                    this.val$this$0 = notificationsPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    NotificationsPaneInner.access$200(this.this$1);
                }
            });
            this.mRemoveEmailButton.addActionListener(new ActionListener(this, NotificationsPane.this){
                private final /* synthetic */ NotificationsPane val$this$0;
                private final /* synthetic */ NotificationsPaneInner this$1;
                {
                    this.this$1 = notificationsPaneInner;
                    this.val$this$0 = notificationsPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (NotificationsPaneInner.access$000(this.this$1).getSelectionModel().getMinSelectionIndex() != -1) {
                        NotificationsPaneInner.access$300(this.this$1);
                    }
                }
            });
            this.mEditEmailButton.addActionListener(new ActionListener(this, NotificationsPane.this){
                private final /* synthetic */ NotificationsPane val$this$0;
                private final /* synthetic */ NotificationsPaneInner this$1;
                {
                    this.this$1 = notificationsPaneInner;
                    this.val$this$0 = notificationsPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    NotificationsPaneInner.access$100(this.this$1);
                }
            });
            this.mSendTestEmailButton.addActionListener(new ActionListener(this, NotificationsPane.this){
                private final /* synthetic */ NotificationsPane val$this$0;
                private final /* synthetic */ NotificationsPaneInner this$1;
                {
                    this.this$1 = notificationsPaneInner;
                    this.val$this$0 = notificationsPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("notifications.sendTestEmailAlertMessage"), Resources.getString("notifications.sendTestEmailAlertExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), Resources.getString("cancel"), null);
                    aquaAlert.showSheet((JFrame)this.this$1.getTopLevelAncestor(), this.this$1, new Integer(2));
                }
            });
            this.mTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ NotificationsPaneInner this$1;
                {
                    this.this$1 = notificationsPaneInner;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (NotificationsPaneInner.access$000(this.this$1).getSelectionModel().getMinSelectionIndex() == -1) {
                        NotificationsPaneInner.access$400(this.this$1).setEnabled(false);
                        NotificationsPaneInner.access$500(this.this$1).setEnabled(false);
                    } else {
                        NotificationsPaneInner.access$400(this.this$1).setEnabled(true);
                        int n = NotificationsPaneInner.access$000(this.this$1).getSelectionModel().getMinSelectionIndex();
                        int n2 = NotificationsPaneInner.access$000(this.this$1).getSelectionModel().getMaxSelectionIndex();
                        if (n == n2) {
                            NotificationsPaneInner.access$500(this.this$1).setEnabled(true);
                        } else {
                            NotificationsPaneInner.access$500(this.this$1).setEnabled(false);
                        }
                    }
                }
            });
            this.mTable.setRowHeight(20);
            TableColumn tableColumn = this.mTable.getColumnModel().getColumn(0);
            tableColumn.setHeaderValue(Resources.getString("notifications.emailHeader"));
            tableColumn.setResizable(false);
            tableColumn.setCellRenderer(new EmailAddressRenderer());
            HeaderRenderer headerRenderer = new HeaderRenderer();
            headerRenderer.setHorizontalAlignment(2);
            JTableHeader jTableHeader = this.mTable.getTableHeader();
            jTableHeader.setDefaultRenderer(headerRenderer);
            jTableHeader.setFont(GUIFactory.FONT_SMALL);
            jTableHeader.setReorderingAllowed(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            this.mSMTPPanel = new SMTPPanel();
            this.add((Component)this.mSMTPPanel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(8, 8, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add((Component)jButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add((Component)this.mRemoveEmailButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add((Component)this.mEditEmailButton, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 8, 8, 0);
            gridBagConstraints.anchor = 16;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add((Component)this.mSendTestEmailButton, gridBagConstraints);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(8, 0, 8, 0);
            gridBagConstraints.ipadx = 340;
            gridBagConstraints.ipady = 150;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 4;
            this.add((Component)jScrollPane, gridBagConstraints);
        }

        public void populateUI(NotificationsModel notificationsModel) {
            ArrayList arrayList = notificationsModel.getEmailAddressList();
            if (arrayList != null) {
                this.mEmailModel.setEmailList(arrayList);
                this.mSendTestEmailButton.setEnabled(this.mSMTPPanel.sendTestEmailShouldBeEnabled());
            }
            this.mSMTPPanel.populateUI(notificationsModel);
        }

        public boolean checkValidity() {
            return this.mSMTPPanel.checkValidity();
        }

        public void fillInModel(NotificationsModel notificationsModel) {
            notificationsModel.setEmailAddressList(this.mEmailModel.getEmailList());
            this.mSMTPPanel.fillInModel(notificationsModel);
        }

        public void aquaAlertWillBeShown(Object object) {
        }

        public void aquaAlertResized(Object object) {
        }

        public void aquaAlertSheetVisible(Object object) {
            if (object instanceof EmailAddressSheet) {
                EmailAddressSheet emailAddressSheet = (EmailAddressSheet)object;
                emailAddressSheet.getFirstFocus().requestFocus();
            }
        }

        public void aquaAlertDismissed(int n, Object object) {
            if (object instanceof Integer && n == 1) {
                Integer n2 = (Integer)object;
                if (n2 == 1) {
                    this.handleRemoveEmailAddresses();
                    this.mSendTestEmailButton.setEnabled(this.mSMTPPanel.sendTestEmailShouldBeEnabled());
                } else if (n2 == 2) {
                    this.handleSendTestEmail();
                }
            } else if (object instanceof EmailAddressSheet && n == 1) {
                this.handleAddEmailAddresses((EmailAddressSheet)object);
                this.mSendTestEmailButton.setEnabled(this.mSMTPPanel.sendTestEmailShouldBeEnabled());
            }
        }

        private void showAddEmailDialog() {
            EmailAddressSheet emailAddressSheet = new EmailAddressSheet(Resources.getString("notifications.addEmailAddressDialogMessage"));
            AquaAlert aquaAlert = new AquaAlert(emailAddressSheet, emailAddressSheet.getOKButton(), emailAddressSheet.getCancelButton(), null);
            aquaAlert.associateKeyCodeWithButton(46, 4, 2);
            aquaAlert.associateKeyCodeWithButton(27, 0, 2);
            emailAddressSheet.setMode(1);
            aquaAlert.showSheet((JFrame)this.getTopLevelAncestor(), this, emailAddressSheet);
        }

        private void showRemoveEmailDialog() {
            AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("notifications.removeAddressesAlertMessage"), Resources.getString("notifications.removeAddressesAlertExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), Resources.getString("cancel"), null);
            aquaAlert.showSheet((JFrame)this.getTopLevelAncestor(), this, new Integer(1));
        }

        private void showEditEmailDialog() {
            EmailAddressSheet emailAddressSheet = new EmailAddressSheet(Resources.getString("notifications.editEmailAddressDialogMessage"));
            AquaAlert aquaAlert = new AquaAlert(emailAddressSheet, emailAddressSheet.getOKButton(), emailAddressSheet.getCancelButton(), null);
            aquaAlert.associateKeyCodeWithButton(46, 4, 2);
            aquaAlert.associateKeyCodeWithButton(27, 0, 2);
            emailAddressSheet.setMode(2);
            int n = this.mTable.getSelectionModel().getMinSelectionIndex();
            emailAddressSheet.setEditIndex(n);
            emailAddressSheet.setEmailAddressFieldText((String)this.mEmailModel.getValueAt(n, 0));
            aquaAlert.showSheet((JFrame)this.getTopLevelAncestor(), this, emailAddressSheet);
        }

        private void handleRemoveEmailAddresses() {
            for (int i = this.mEmailModel.getRowCount() - 1; i >= 0; --i) {
                if (!this.mTable.getSelectionModel().isSelectedIndex(i)) continue;
                try {
                    this.mEmailModel.removeEmailAddressAtIndex(i);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.mTable.tableChanged(new TableModelEvent(this.mEmailModel));
                }
            }
            this.mTable.tableChanged(new TableModelEvent(this.mEmailModel));
        }

        private void handleSendTestEmail() {
            TestEmail testEmail = new TestEmail(Resources.getString("notifications.testEmail"), this.mSMTPPanel.fromEmailAddress(), this.mSMTPPanel.fromSenderPassword(), this.mSMTPPanel.fromServer(), this.mSMTPPanel.fromSenderUsername(), Resources.getString("notifications.testEmailSubject"), this.mEmailModel.getEmailList());
            ActionEvent actionEvent = new ActionEvent(testEmail, 1001, "TEST_EMAIL");
            NotificationsPane.this.fireActionPerformed(actionEvent);
        }

        private void handleAddEmailAddresses(EmailAddressSheet emailAddressSheet) {
            int n = 0;
            int n2 = 0;
            Vector vector = emailAddressSheet.getVectorOfEmailAddresses();
            if (emailAddressSheet.getMode() == 1) {
                n = this.mEmailModel.getRowCount();
                for (int i = 0; i < vector.size(); ++i) {
                    this.mEmailModel.addEmailAddress(((String)vector.elementAt(i)).trim());
                }
                n2 = this.mEmailModel.getRowCount() - 1;
            } else {
                int n3;
                n = n3 = emailAddressSheet.getEditIndex();
                this.mEmailModel.removeEmailAddressAtIndex(n3);
                n2 = n + vector.size() - 2;
                for (int i = vector.size() - 1; i >= 0; --i) {
                    this.mEmailModel.addEmailAddressAtIndex(((String)vector.elementAt(i)).trim(), n3);
                }
            }
            this.mTable.tableChanged(new TableModelEvent(this.mEmailModel, n, n2, -1, 1));
        }

        public boolean allowAquaAlertToBeDismissed(int n, Object object) {
            return true;
        }

        public JLabel jlabelWithFont(String string, Font font) {
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            return jLabel;
        }

        static /* synthetic */ JTable access$000(NotificationsPaneInner notificationsPaneInner) {
            return notificationsPaneInner.mTable;
        }

        static /* synthetic */ void access$100(NotificationsPaneInner notificationsPaneInner) {
            notificationsPaneInner.showEditEmailDialog();
        }

        static /* synthetic */ void access$200(NotificationsPaneInner notificationsPaneInner) {
            notificationsPaneInner.showAddEmailDialog();
        }

        static /* synthetic */ void access$300(NotificationsPaneInner notificationsPaneInner) {
            notificationsPaneInner.showRemoveEmailDialog();
        }

        static /* synthetic */ JButton access$400(NotificationsPaneInner notificationsPaneInner) {
            return notificationsPaneInner.mRemoveEmailButton;
        }

        static /* synthetic */ JButton access$500(NotificationsPaneInner notificationsPaneInner) {
            return notificationsPaneInner.mEditEmailButton;
        }

        public class EmailAddressSheet
        extends GridBagPanel {
            public static final int ADDRESS_FIELD_WIDTH = 20;
            public static final int ADD_EMAIL_MODE = 1;
            public static final int EDIT_EMAIL_MODE = 2;
            private JTextField mAddressField = null;
            private JButton mOKButton = null;
            private JButton mCancelButton = null;
            private int mMode = 1;
            private int mEditIndex = 0;

            public EmailAddressSheet(String string) {
                Box box = Box.createHorizontalBox();
                JLabel jLabel = new JLabel(Resources.getString("notifications.emailSheetLabel"));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.mAddressField = GUIFactory.newTextField(20);
                this.mOKButton = GUIFactory.newOKButton();
                this.mCancelButton = GUIFactory.newCancelButton();
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 8, 0);
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setFont(GUIFactory.FONT_SMALL);
                jTextArea.setBackground(null);
                jTextArea.setHighlighter(null);
                jTextArea.setEditable(false);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setSize(300, 64);
                jTextArea.setMinimumSize(new Dimension(300, 48));
                jTextArea.setMaximumSize(new Dimension(300, 200));
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridheight = 1;
                this.add((Component)jTextArea, gridBagConstraints);
                jLabel.setFont(GUIFactory.FONT_SMALL);
                this.mAddressField.setFont(GUIFactory.FONT_SMALL);
                gridBagConstraints.insets = new Insets(0, 0, 8, 0);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mAddressField, gridBagConstraints);
                gridBagConstraints.anchor = 13;
                gridBagConstraints.insets = new Insets(0, 0, 8, 8);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)jLabel, gridBagConstraints);
                box.add(this.mCancelButton);
                box.add(Box.createHorizontalStrut(8));
                box.add(this.mOKButton);
                gridBagConstraints.insets = new Insets(8, 0, 0, 0);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridheight = 1;
                this.add((Component)box, gridBagConstraints);
            }

            public boolean isFocusCycleRoot() {
                return true;
            }

            public int getMode() {
                return this.mMode;
            }

            public void setMode(int n) {
                this.mMode = n;
            }

            public JComponent getFirstFocus() {
                return this.mAddressField;
            }

            public Vector getVectorOfEmailAddresses() {
                String string = this.mAddressField.getText();
                int n = 0;
                int n2 = 0;
                Vector<String> vector = new Vector<String>();
                while (n2 >= 0) {
                    n2 = string.indexOf(Resources.getString("notifications.emailAddressDelimiter"), n + 1);
                    String string2 = null;
                    string2 = n == 0 && n2 == -1 ? string.substring(n, string.length()) : (n == 0 ? string.substring(n, n2) : (n2 >= 0 ? string.substring(n + 1, n2) : string.substring(n + 1, string.length())));
                    if (!string2.trim().equals("")) {
                        vector.add(string2);
                    }
                    n = n2;
                }
                return vector;
            }

            public void setEmailAddressFieldText(String string) {
                this.mAddressField.setText(string);
            }

            public int getEditIndex() {
                return this.mEditIndex;
            }

            public void setEditIndex(int n) {
                this.mEditIndex = n;
            }

            public JButton getOKButton() {
                return this.mOKButton;
            }

            public JButton getCancelButton() {
                return this.mCancelButton;
            }
        }

        public class SMTPPanel
        extends JPanel {
            public static final String TITLED_BORDER_SPACING = " ";
            public static final int TEXT_FIELD_WIDTH = 120;
            public static final int GRID_BAG_COLUMN_SEPERATOR_INSET_VALUE = 20;
            public static final int CHECKBOX_SUBCOMPONENT_OFFSET = 22;
            private JCheckBox mEnableSMTPAuthenticationCheckBox;
            private JTextField mServerTextField;
            private JTextField mEmailAddressTextField;
            private JLabel mSMTPServerValidateLabel;
            private JLabel mSMTPEmailAddressValidateLabel;
            private JLabel mUsernameLabel;
            private JLabel mPasswordLabel;
            private JTextField mUsernameTextField;
            private JPasswordField mPasswordField;
            private JLabel mSMTPUsernameValidateLabel;
            private JLabel mSMTPPasswordValidateLabel;

            public SMTPPanel() {
                DocumentListener documentListener = new DocumentListener(this, NotificationsPaneInner.this){
                    private final /* synthetic */ NotificationsPaneInner val$this$1;
                    private final /* synthetic */ SMTPPanel this$2;
                    {
                        this.this$2 = sMTPPanel;
                        this.val$this$1 = notificationsPaneInner;
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        int n = documentEvent.getDocument().getLength();
                        if (n == 0 || n == documentEvent.getLength()) {
                            NotificationsPaneInner.access$900(NotificationsPane.access$800(NotificationsPaneInner.access$700(SMTPPanel.access$600(this.this$2)))).setEnabled(this.this$2.sendTestEmailShouldBeEnabled());
                        }
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        int n = documentEvent.getDocument().getLength();
                        if (n == 0 || n == documentEvent.getLength()) {
                            NotificationsPaneInner.access$900(NotificationsPane.access$800(NotificationsPaneInner.access$700(SMTPPanel.access$600(this.this$2)))).setEnabled(this.this$2.sendTestEmailShouldBeEnabled());
                        }
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                    }
                };
                this.setLayout(new GridBagLayout());
                TitledBorder titledBorder = BorderFactory.createTitledBorder(TITLED_BORDER_SPACING + Resources.getString("management.network.smtp.title") + TITLED_BORDER_SPACING);
                titledBorder.setTitleFont(GUIFactory.FONT_SMALL);
                EmptyBorder emptyBorder = new EmptyBorder(0, 12, 12, 12);
                this.setBorder(new CompoundBorder(titledBorder, emptyBorder));
                JLabel jLabel = NotificationsPaneInner.this.jlabelWithFont(Resources.getString("management.network.smtp.server"), GUIFactory.FONT_SMALL);
                JLabel jLabel2 = NotificationsPaneInner.this.jlabelWithFont(Resources.getString("management.network.smtp.emailAddress"), GUIFactory.FONT_SMALL);
                this.mServerTextField = GUIFactory.newTextField(120);
                this.mServerTextField.setFont(GUIFactory.FONT_SMALL);
                this.mServerTextField.getDocument().addDocumentListener(documentListener);
                this.mEmailAddressTextField = GUIFactory.newTextField(120);
                this.mEmailAddressTextField.setFont(GUIFactory.FONT_SMALL);
                this.mEmailAddressTextField.getDocument().addDocumentListener(documentListener);
                this.mEnableSMTPAuthenticationCheckBox = GUIFactory.newCheckBox(Resources.getString("management.network.smtp.enableAuthentication"));
                this.mEnableSMTPAuthenticationCheckBox.setFont(GUIFactory.FONT_SMALL);
                this.mEnableSMTPAuthenticationCheckBox.addActionListener(new ActionListener(this, NotificationsPaneInner.this){
                    private final /* synthetic */ NotificationsPaneInner val$this$1;
                    private final /* synthetic */ SMTPPanel this$2;
                    {
                        this.this$2 = sMTPPanel;
                        this.val$this$1 = notificationsPaneInner;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = SMTPPanel.access$1000(this.this$2).isSelected();
                        SMTPPanel.access$1100(this.this$2).setEnabled(bl);
                        SMTPPanel.access$1200(this.this$2).setEnabled(bl);
                        SMTPPanel.access$1300(this.this$2).setEnabled(bl);
                        SMTPPanel.access$1400(this.this$2).setEnabled(bl);
                        NotificationsPaneInner.access$900(NotificationsPane.access$800(NotificationsPaneInner.access$700(SMTPPanel.access$600(this.this$2)))).setEnabled(this.this$2.sendTestEmailShouldBeEnabled());
                    }
                });
                ImageIcon imageIcon = new ImageIcon(Resources.getImage("icon.validate"));
                this.mSMTPServerValidateLabel = new JLabel(imageIcon);
                this.mSMTPEmailAddressValidateLabel = new JLabel(imageIcon);
                this.mSMTPServerValidateLabel.setVisible(false);
                this.mSMTPEmailAddressValidateLabel.setVisible(false);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 13;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.ipady = 0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.ipadx = 120;
                gridBagConstraints.insets = new Insets(0, 8, 0, 0);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mServerTextField, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mEmailAddressTextField, gridBagConstraints);
                gridBagConstraints.ipadx = 0;
                gridBagConstraints.insets = new Insets(0, 20, 8, 0);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mEnableSMTPAuthenticationCheckBox, gridBagConstraints);
                gridBagConstraints.anchor = 13;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)jLabel2, gridBagConstraints);
                gridBagConstraints.insets = new Insets(0, 4, 4, 0);
                gridBagConstraints.anchor = 16;
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mSMTPServerValidateLabel, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mSMTPEmailAddressValidateLabel, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add(Box.createHorizontalStrut(imageIcon.getIconWidth()), gridBagConstraints);
                this.mUsernameLabel = NotificationsPaneInner.this.jlabelWithFont(Resources.getString("management.network.smtp.username"), GUIFactory.FONT_SMALL);
                this.mUsernameLabel.setEnabled(false);
                this.mPasswordLabel = NotificationsPaneInner.this.jlabelWithFont(Resources.getString("management.network.smtp.password"), GUIFactory.FONT_SMALL);
                this.mPasswordLabel.setEnabled(false);
                this.mUsernameTextField = GUIFactory.newTextField(120);
                this.mUsernameTextField.setFont(GUIFactory.FONT_SMALL);
                this.mUsernameTextField.setEnabled(false);
                this.mUsernameTextField.getDocument().addDocumentListener(documentListener);
                this.mPasswordField = GUIFactory.newPasswordField();
                this.mPasswordField.setFont(GUIFactory.FONT_SMALL);
                this.mPasswordField.setEnabled(false);
                this.mPasswordField.getDocument().addDocumentListener(documentListener);
                if (Gestalt.isMacLookAndFeel) {
                    this.mPasswordField.setEchoChar('\u2022');
                }
                this.mSMTPUsernameValidateLabel = new JLabel(imageIcon);
                this.mSMTPPasswordValidateLabel = new JLabel(imageIcon);
                this.mSMTPUsernameValidateLabel.setVisible(false);
                this.mSMTPPasswordValidateLabel.setVisible(false);
                gridBagConstraints.anchor = 13;
                gridBagConstraints.insets = new Insets(0, 42, 0, 0);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mUsernameLabel, gridBagConstraints);
                gridBagConstraints.insets = new Insets(8, 42, 0, 0);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mPasswordLabel, gridBagConstraints);
                gridBagConstraints.insets = new Insets(0, 4, 4, 0);
                gridBagConstraints.anchor = 16;
                gridBagConstraints.gridx = 5;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mSMTPUsernameValidateLabel, gridBagConstraints);
                gridBagConstraints.gridx = 5;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mSMTPPasswordValidateLabel, gridBagConstraints);
                gridBagConstraints.gridx = 5;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add(Box.createHorizontalStrut(imageIcon.getIconWidth()), gridBagConstraints);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.ipadx = 120;
                gridBagConstraints.insets = new Insets(0, 8, 0, 0);
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mUsernameTextField, gridBagConstraints);
                gridBagConstraints.insets = new Insets(8, 8, 0, 0);
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                this.add((Component)this.mPasswordField, gridBagConstraints);
            }

            public String fromServer() {
                return this.mServerTextField.getText() + "";
            }

            public String fromEmailAddress() {
                return this.mEmailAddressTextField.getText() + "";
            }

            public String fromSenderUsername() {
                String string = this.mEnableSMTPAuthenticationCheckBox.isSelected() ? this.mUsernameTextField.getText() + "" : null;
                return string;
            }

            public String fromSenderPassword() {
                String string = this.mEnableSMTPAuthenticationCheckBox.isSelected() ? new String(this.mPasswordField.getPassword()) + "" : null;
                return string;
            }

            public void populateUI(NotificationsModel notificationsModel) {
                boolean bl = notificationsModel.getSMTPServerRequiresAuthentication();
                this.mEnableSMTPAuthenticationCheckBox.setSelected(bl);
                this.mServerTextField.setText(notificationsModel.getSMTPServer());
                this.mEmailAddressTextField.setText(notificationsModel.getSMTPFromEmailAddress());
                this.mUsernameTextField.setText(notificationsModel.getSMTPUsername());
                this.mPasswordField.setText(notificationsModel.getSMTPPassword());
                this.mUsernameTextField.setEnabled(bl);
                this.mPasswordField.setEnabled(bl);
                NotificationsPane.this.mNotificationsPaneInner.mSendTestEmailButton.setEnabled(this.sendTestEmailShouldBeEnabled());
            }

            public boolean checkValidity() {
                boolean bl = true;
                if (this.mEnableSMTPAuthenticationCheckBox.isSelected()) {
                    if (this.fromSenderUsername().length() == 0) {
                        this.mSMTPUsernameValidateLabel.setVisible(true);
                        bl = false;
                    } else {
                        this.mSMTPUsernameValidateLabel.setVisible(false);
                    }
                    if (this.fromSenderPassword().length() == 0) {
                        this.mSMTPPasswordValidateLabel.setVisible(true);
                        bl = false;
                    } else {
                        this.mSMTPPasswordValidateLabel.setVisible(false);
                    }
                }
                return bl;
            }

            public void fillInModel(NotificationsModel notificationsModel) {
                notificationsModel.setSMTPServer(this.mServerTextField.getText());
                notificationsModel.setSMTPFromEmailAddress(this.mEmailAddressTextField.getText());
                notificationsModel.setSMTPServerRequiresAuthentication(this.mEnableSMTPAuthenticationCheckBox.isSelected());
                notificationsModel.setSMTPUsername(this.mUsernameTextField.getText());
                notificationsModel.setSMTPPassword(new String(this.mPasswordField.getPassword()));
            }

            public boolean sendTestEmailShouldBeEnabled() {
                boolean bl = false;
                if (this.fromServer().length() > 0 && this.fromEmailAddress().length() > 0 && NotificationsPane.this.mNotificationsPaneInner.mEmailModel.getRowCount() > 0) {
                    bl = true;
                }
                if (bl && this.mEnableSMTPAuthenticationCheckBox.isSelected() && (this.fromSenderUsername().length() == 0 || this.fromSenderPassword().length() == 0)) {
                    bl = false;
                }
                return bl;
            }

            static /* synthetic */ NotificationsPaneInner access$600(SMTPPanel sMTPPanel) {
                return sMTPPanel.NotificationsPaneInner.this;
            }

            static /* synthetic */ JCheckBox access$1000(SMTPPanel sMTPPanel) {
                return sMTPPanel.mEnableSMTPAuthenticationCheckBox;
            }

            static /* synthetic */ JLabel access$1100(SMTPPanel sMTPPanel) {
                return sMTPPanel.mUsernameLabel;
            }

            static /* synthetic */ JTextField access$1200(SMTPPanel sMTPPanel) {
                return sMTPPanel.mUsernameTextField;
            }

            static /* synthetic */ JLabel access$1300(SMTPPanel sMTPPanel) {
                return sMTPPanel.mPasswordLabel;
            }

            static /* synthetic */ JPasswordField access$1400(SMTPPanel sMTPPanel) {
                return sMTPPanel.mPasswordField;
            }
        }

        class HeaderRenderer
        extends DefaultTableCellRenderer {
            public HeaderRenderer() {
                this.setHorizontalAlignment(0);
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }

            public void updateUI() {
                super.updateUI();
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JTableHeader jTableHeader;
                if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                    this.setEnabled(jTableHeader.isEnabled());
                    this.setComponentOrientation(jTableHeader.getComponentOrientation());
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                } else {
                    this.setEnabled(true);
                    this.setComponentOrientation(ComponentOrientation.UNKNOWN);
                    this.setForeground(UIManager.getColor("TableHeader.foreground"));
                    this.setBackground(UIManager.getColor("TableHeader.background"));
                    this.setFont(UIManager.getFont("TableHeader.font"));
                }
                this.setValue(object);
                return this;
            }
        }

        class EmailAddressRenderer
        extends JPanel
        implements TableCellRenderer {
            AquaTableCellBorder border;
            JLabel label;

            public EmailAddressRenderer() {
                this.setLayout(new BoxLayout(this, 0));
                this.border = new AquaTableCellBorder();
                this.setBorder(this.border);
                this.label = new JLabel();
                this.label.setFont(GUIFactory.FONT_SMALL);
                this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                this.add(this.label);
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.border.setAttributes(bl, jTable.hasFocus(), n);
                this.label.setText((String)object);
                this.label.setForeground(bl ? Color.white : Color.black);
                return this;
            }
        }

        private class EmailTableModel
        extends AbstractTableModel {
            private ArrayList mEmailAddressList = new ArrayList();

            public void setEmailList(ArrayList arrayList) {
                if (arrayList.size() > 0) {
                    this.mEmailAddressList.addAll(arrayList);
                }
            }

            public ArrayList getEmailList() {
                return this.mEmailAddressList;
            }

            public void addEmailAddress(String string) {
                this.mEmailAddressList.add(string);
            }

            public void addEmailAddressAtIndex(String string, int n) {
                this.mEmailAddressList.add(n, string);
            }

            public Object removeEmailAddressAtIndex(int n) throws IndexOutOfBoundsException {
                return this.mEmailAddressList.remove(n);
            }

            public int getRowCount() {
                return this.mEmailAddressList.size();
            }

            public int getColumnCount() {
                return 1;
            }

            public Object getValueAt(int n, int n2) {
                return this.mEmailAddressList.get(n);
            }

            public void setValueAt(Object object, int n, int n2) {
                this.mEmailAddressList.set(n, object);
            }
        }
    }
}

