/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.Resources;
import com.apple.xsr.StatusIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

class ModuleSelectionPanel
extends JPanel {
    public static final int NOT_INSTALLED = -2;
    static final int NONE = -1;
    static final int BUTTONS_LEFT = 0;
    static final int BUTTONS_RIGHT = 1;
    static final int BATTERY_LEFT = 2;
    static final int BATTERY_RIGHT = 3;
    static final int POWER_LEFT = 4;
    static final int POWER_RIGHT = 5;
    static final int CONTROLLER_TOP = 6;
    static final int CONTROLLER_BOTTOM = 7;
    static final int BLOWER_TOP = 8;
    static final int BLOWER_BOTTOM = 9;
    boolean addNotifyCalled = false;
    int selectedModule = -1;
    boolean inDragSelect = false;
    boolean isActive = false;
    Color hiliteColor = new JTable().getSelectionBackground();
    Color blobColor = Color.black;
    Image[] baseImages;
    Image[] offscreenImages;
    JLabel[] moduleIcons;
    boolean[] modulePresent = new boolean[]{true, true, false, false, true, true, true, true, true, true};
    boolean[] moduleEnabled = new boolean[]{false, false, true, true, true, true, true, true, true, true};
    int[] moduleStatus = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    ModuleSelectionPanel() {
        this.baseImages = new Image[10];
        this.offscreenImages = new Image[10];
        this.moduleIcons = new JLabel[10];
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.addComponent(this.createModuleIcon(2, Resources.getImage("icon.backpanel.battery.left")), this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.addComponent(this.createModuleIcon(0, Resources.getImage("icon.backpanel.buttons.left")), this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.addComponent(this.createModuleIcon(6, Resources.getImage("icon.backpanel.controller.top")), this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.addComponent(this.createModuleIcon(1, Resources.getImage("icon.backpanel.buttons.right")), this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.addComponent(this.createModuleIcon(3, Resources.getImage("icon.backpanel.battery.right")), this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.addComponent(this.createModuleIcon(4, Resources.getImage("icon.backpanel.power.left")), this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.addComponent(this.createModuleIcon(5, Resources.getImage("icon.backpanel.power.right")), this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.addComponent(this.createModuleIcon(8, Resources.getImage("icon.backpanel.blower.top")), this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addComponent(this.createModuleIcon(9, Resources.getImage("icon.backpanel.blower.bottom")), this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addComponent(this.createModuleIcon(7, Resources.getImage("icon.backpanel.controller.bottom")), this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JLabel jLabel = new JLabel(new ImageIcon(Resources.getImage("icon.backpanel.bottom")));
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.addComponent(jLabel, this, gridBagLayout, gridBagConstraints);
    }

    private void addComponent(Component component, Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JLabel createModuleIcon(int n, Image image) {
        MediaTracker mediaTracker;
        MediaTracker mediaTracker2 = mediaTracker = new MediaTracker(this);
        synchronized (mediaTracker2) {
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0, 0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            mediaTracker.removeImage(image, 0);
        }
        this.baseImages[n] = image;
        this.moduleIcons[n] = new JLabel(new ImageIcon(this.baseImages[n]));
        this.moduleIcons[n].addMouseListener(new ModuleIconListener(n));
        return this.moduleIcons[n];
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyCalled = true;
        for (int i = 0; i < 10; ++i) {
            this.updateModuleIcon(i);
        }
    }

    private void selectModuleIcon(int n) {
        if (!this.isActive || !this.moduleEnabled[n]) {
            return;
        }
        if (this.selectedModule != -1) {
            int n2 = this.selectedModule;
            this.selectedModule = -1;
            this.updateModuleIcon(n2);
        }
        this.selectedModule = n;
        this.updateModuleIcon(this.selectedModule);
        this.firePropertyChange("module", -1, this.selectedModule);
    }

    private void updateModuleIcon(int n) {
        Image image = this.baseImages[n];
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        if (this.offscreenImages[n] == null) {
            this.offscreenImages[n] = this.createImage(n2, n3);
        }
        Graphics graphics = this.offscreenImages[n].getGraphics();
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isActive) {
            Composite composite;
            Object object;
            graphics.drawImage(image, 0, 0, null);
            if (!this.modulePresent[n]) {
                object = AlphaComposite.getInstance(3, 0.6f);
                composite = ((Graphics2D)graphics).getComposite();
                ((Graphics2D)graphics).setComposite((Composite)object);
                graphics.setColor(Color.black);
                graphics.fillRect(1, 1, n2 - 2, n3 - 2);
                ((Graphics2D)graphics).setComposite(composite);
            }
            if (n == this.selectedModule) {
                object = AlphaComposite.getInstance(3, 0.6f);
                composite = ((Graphics2D)graphics).getComposite();
                ((Graphics2D)graphics).setComposite((Composite)object);
                graphics.setColor(this.hiliteColor);
                graphics.fillRect(1, 1, n2 - 2, n3 - 2);
                ((Graphics2D)graphics).setComposite(composite);
                graphics.setColor(this.hiliteColor);
                graphics.drawRect(1, 1, n2 - 3, n3 - 3);
                graphics.drawRect(2, 2, n2 - 5, n3 - 5);
            }
            if (this.moduleStatus[n] != -1) {
                object = StatusIcon.getSmallStatusIconInstance(this.moduleStatus[n]);
                ((StatusIcon)object).paintIcon(this, graphics, 4, n3 / 2 - 5);
            }
        } else {
            graphics.drawImage(image, 0, 0, null);
        }
        this.moduleIcons[n].setIcon(new ImageIcon(this.offscreenImages[n]));
    }

    public void setModuleStatus(int n, boolean bl, int n2) {
        this.modulePresent[n] = bl;
        this.moduleStatus[n] = n2;
        if (this.addNotifyCalled) {
            this.updateModuleIcon(n);
        }
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
        if (this.addNotifyCalled) {
            for (int i = 0; i < 10; ++i) {
                this.updateModuleIcon(i);
            }
        }
    }

    class ModuleIconListener
    implements MouseListener {
        int module;

        ModuleIconListener(int n) {
            this.module = n;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ModuleSelectionPanel.this.selectModuleIcon(this.module);
            ModuleSelectionPanel.this.inDragSelect = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ModuleSelectionPanel.this.inDragSelect = false;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (ModuleSelectionPanel.this.inDragSelect) {
                ModuleSelectionPanel.this.selectModuleIcon(this.module);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

