/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.CreateArrayPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.DeleteArrayPane;
import com.apple.xsr.NotificationsPane;
import com.apple.xsr.SetupPane;
import com.apple.xsr.advanced.AdvancedPane;
import com.apple.xsr.firstaid.FirstAidChooserPane;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ManagementWindow
extends JFrame {
    public static final String SETUP_PANE = "setup_pane";
    public static final String CREATE_ARRAY_PANE = "create_array_pane";
    public static final String DELETE_ARRAY_PANE = "delete_array_pane";
    public static final String NOTIFICATIONS_PANE = "notifications_pane";
    public static final String FIRST_AID_CHOOSER_PANE = "first_aid";
    public static final String ADVANCED_PANE = "advanced_pane";
    private Action createArrayAction;
    private Action deleteArrayAction;
    private Action setupAction;
    private Action notificationsAction;
    private CardLayout layout;
    private JPanel contentPanel;
    AbstractManagementPane managementPane = null;
    String managementPaneType = null;

    public ManagementWindow(String string, String string2) {
        Component component = null;
        this.setTitle(string);
        super.setDefaultCloseOperation(0);
        this.managementPaneType = string2;
        if (this.managementPaneType == null) {
            throw new NullPointerException("paneType may not be null.");
        }
        if (this.managementPaneType.equals(CREATE_ARRAY_PANE)) {
            this.managementPane = new CreateArrayPane();
        } else if (this.managementPaneType.equals(DELETE_ARRAY_PANE)) {
            this.managementPane = new DeleteArrayPane();
        } else if (this.managementPaneType.equals(SETUP_PANE)) {
            this.managementPane = new SetupPane();
        } else if (this.managementPaneType.equals(NOTIFICATIONS_PANE)) {
            this.managementPane = new NotificationsPane();
        } else if (this.managementPaneType.equals(ADVANCED_PANE)) {
            this.managementPane = new AdvancedPane();
        } else if (this.managementPaneType.equals(FIRST_AID_CHOOSER_PANE)) {
            this.managementPane = new FirstAidChooserPane();
        } else {
            throw new IllegalArgumentException("Illegal pane type requested as being shown");
        }
        this.managementPane.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        Container container = this.getContentPane();
        if (component != null) {
            container.add(component, "North");
        }
        container.add((Component)this.managementPane, "Center");
        this.setSize(container.getPreferredSize());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (ManagementWindow.this.managementPane instanceof SetupPane) {
                    ((SetupPane)ManagementWindow.this.managementPane).confirmCancel();
                } else if (ManagementWindow.this.managementPane.allowAbort()) {
                    ManagementWindow.this.dispose();
                }
            }
        });
        GUIFactory.configureComponentForPlatform(this);
    }

    public void populateUI(String string, DataModel dataModel) throws IllegalArgumentException, UnsupportedOperationException, NullPointerException {
        if (string == null) {
            throw new NullPointerException("pane may not be null");
        }
        if (!string.equals(this.managementPaneType)) {
            throw new IllegalArgumentException(string + " is not currently being managed");
        }
        this.managementPane.populateUI(dataModel);
    }

    public void populateUI(String string, DataModel[] dataModelArray) throws IllegalArgumentException, UnsupportedOperationException, NullPointerException {
        if (string == null) {
            throw new NullPointerException("pane may not be null");
        }
        if (!string.equals(this.managementPaneType)) {
            throw new IllegalArgumentException(string + " is not currently being managed");
        }
        this.managementPane.populateUI(dataModelArray);
    }

    public void addActionListener(ActionListener actionListener, String string) throws IllegalArgumentException, NullPointerException {
        if (string == null) {
            throw new NullPointerException("pane may not be null");
        }
        if (!string.equals(this.managementPaneType)) {
            throw new IllegalArgumentException(string + " is not currently being managed");
        }
        this.managementPane.addActionListener(actionListener);
    }

    public boolean hasUnsavedChanges() {
        return false;
    }

    public String getManagementPaneType() {
        return this.managementPaneType;
    }

    public void setDefaultCloseOperation(int n) {
        throw new UnsupportedOperationException("ManagementWindow does not support a default close operation. WindowClosing events are handled internally.");
    }
}

